import { StudioLayouts } from '.';
import type { ItemsPerRow } from '../contentUtils';
import type { StudioLayoutPanelConfig } from './StudioPanelSchema';
export interface StudioLayoutPanelAssetsConfig extends StudioLayoutPanelConfig, Omit<AssetManagerBaseProps, 'content' | 'types' | 'providers' | 'close' | 'panelId'> {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.panelAssets}`;
    /**
     * A custom array of assets. Overrides any other configured onLoad or providers.
     * @examples
     * assets: [
     *  {
     *    type: 'image',
     *    url: 'https://example.com/image.jpg',
     *  }
     * ]
     */
    assets?: object[];
    /**
     * Callback when an asset is selected.
     * @examples
     * onSelect: ({ asset, editor }) => {
     *    editor.AssetManager.add(asset);
     * }
     */
    onSelect?: '__fn__';
    /**
     * Content configuration for the AssetManager.
     * @examples
     * {
     *  itemsPerRow: 4,
     *  header: {
     *   search: true,
     * },
     */
    content?: object;
    /**
     * Options that show up in the asset type filter.
     * The selected type filters providers in the asset provider filter by `assetProvider.type`.
     * This filter is required by default. To make it optional set `assetManagerProps.optionalType = true`.
     * Set to an empty array to hide the asset type filter.
     *
     * @default
     * [{ id: AssetType.image, label: 'Images'}]
     *
     * @example
     * types: [
     *   {
     *     id: AssetType.image,
     *     label: 'Images',
     *   },
     * ]
     */
    types?: object[];
    /**
     * The ids of providers that will be available in this assets panel layout.
     * These providers need to exist in {@link AssetsConfig.providers} first.
     * Defaults to the all providers specified in {@link AssetsConfig}.
     * Set to an empty array to hide the asset provider filter.
     * @example ['unsplash']
     */
    providers?: string[];
    /**
     * Define how to close your AssetManager. For the main AssetManager, it closes the dialog.
     * @examples () => AssetManager.close()
     */
    close?: '__fn__';
}
export interface AssetManagerBaseProps {
    /**
     * The id of the panel.
     * @example "panelAssets-1"
     */
    panelId: string;
    /**
     * Initial state of the asset type filter.
     * @default 'image'
     */
    typeId?: string;
    /**
     * Initial state of the asset provider filter.
     * @example 'unsplash'
     */
    providerId?: string;
    /**
     * When true, adds `{ id: undefined, label: 'All' }` as an extra option for the asset type filter at the beginning.
     * @default false
     */
    optionalType?: boolean;
    /**
     * When true, adds `{ id: undefined, label: 'Project assets' }` as an extra option for the asset provider filter at the beginning.
     * @default true
     */
    optionalProvider?: boolean;
    providers?: string | string[];
    content?: AssetManagerContentProps;
    types?: AssetTypeOption[] | string[];
    close?: () => void;
}
export interface AssetTypeOption {
    /**
     * Unique id that ties to one asset provider.
     * When this option is selected, that asset provider will be used.
     */
    id: string;
    /**
     * Label to display in the asset type filter.
     */
    label: string;
}
export interface AssetManagerContentProps {
    itemsPerRow?: ItemsPerRow;
    header?: boolean | {
        search?: boolean;
        addUrl?: boolean;
        upload?: boolean;
    };
}
