import { StudioLayouts } from '.';
import type { StudioPanelTemplatesProps } from '../../../types';
import type { StudioLayoutPanelPropsConfig } from './StudioPanelSchema';
export interface StudioLayoutPanelTemplatesConfig extends Omit<StudioPanelTemplatesProps, 'type' | 'onSelect' | 'id'>, StudioLayoutPanelPropsConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.panelTemplates}`;
    /**
     * Provide a custom handler for the select button.
     * @examples
     * ({ loadTemplate, template }) => {
     *   // loads the selected template to the current project
     *   loadTemplate(template);
     * }
     */
    onSelect?: '__fn__';
}
