import { StudioLayouts } from '.';
import type { StudioLayoutFieldBaseConfig } from './StudioBaseSchema';
export declare enum SelectSize {
    l = "l",
    m = "m",
    s = "s",
    xs = "xs",
    x2s = "x2s"
}
export interface StudioLayoutSelectFieldConfig extends StudioLayoutFieldBaseConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.selectField}`;
    /**
     * The size of the field.
     * @examples "l" | "m" | "s" | "xs" | "x2s"
     */
    size?: `${SelectSize}`;
    /**
     * The empty state for the field.
     * @example "Select your username"
     */
    emptyState?: string;
    /**
     * The options for the field.
     * @example [
     *   { id: "1", label: "Username 1", content: "Username 1" },
     *   { id: "2", label: "Username 2", content: "Username 2" }
     * ]
     */
    options: [];
}
