import { LocalSettingsData, ProjectData } from '../utils/types';
export declare enum ObjectStores {
    Projects = "projects",
    Settings = "settings"
}
export declare enum DBName {
    gjs = "gjs",
    gjsStudio = "gjs-studio"
}
type ObjectStoresReturnType = {
    [ObjectStores.Projects]: ProjectData;
    [ObjectStores.Settings]: LocalSettingsData;
};
export type DbOptions = {
    db?: DBName;
};
export declare const isLocalDbSupported: () => boolean;
export declare const setupLocalDb: (opts?: DbOptions) => Promise<void>;
export declare const getAllLocalData: <T extends ObjectStores>(objStoreName: T, opts?: DbOptions) => Promise<{
    key: IDBValidKey;
    data: ObjectStoresReturnType[T];
}[]>;
/**
 * Get app related data from the object store.
 */
export declare const getLocalAppData: <T extends ObjectStores, K extends keyof ObjectStoresReturnType[T]>(objStoreName: T, key: K, opts?: DbOptions) => Promise<ObjectStoresReturnType[T][K] | undefined>;
/**
 * Put app related data to the object store.
 */
export declare const setLocalAppData: <T extends ObjectStores, K extends keyof ObjectStoresReturnType[T]>(objStoreName: T, key: K, data: ObjectStoresReturnType[T][K], opts?: DbOptions) => Promise<void>;
/**
 * Delete app related data from the object store.
 */
export declare const deleteLocalData: <T extends ObjectStores>(objStoreName: T, key: string, opts?: DbOptions) => Promise<void>;
export {};
