import { ReqOptions } from '@studio/app/src/modules/http';
import type { ApiResponse } from '@studio/app/src/modules/utils/shared';
import { ProjectConfigType } from '../types';
import { ProjectItem } from '../utils/types';
export declare enum ProjectSource {
    Existing = "existing",
    Templates = "templates"
}
export type ProjectSourceConfig = ProjectSource | `${ProjectSource}`;
interface ListTemplatesResponse extends ApiResponse<ProjectItem[]> {
}
export declare const getPathTemplates: (type: ProjectConfigType) => string;
export declare const listTemplates: <T = ListTemplatesResponse>(type: ProjectConfigType, opts?: ReqOptions<T> | undefined) => Promise<T | undefined>;
export declare const loadAvailableTemplates: (type: ProjectConfigType) => Promise<ProjectItem[]>;
export declare const loadAvailableProjects: (projectType?: ProjectConfigType) => Promise<ProjectItem[]>;
export {};
