import type { BlockProperties, Block } from 'grapesjs';
import { WithEditorProps } from './common';
import { RootLayoutConfig } from './layout';
export interface BlocksConfig {
    /**
     * Provide an array of additional blocks to be added to the editor.
     * @example
     * default: [
     *  {
     *    id: 'image',
     *    label: 'Image',
     *    media: '<svg style="width:24px;height:24px" viewBox="0 0 24 24"><path d="M8.5,13.5L11,16.5L14.5,12L19,18H5M21,19V5C21,3.89 20.1,3 19,3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19Z" /></svg>',
     *    content: { type: 'image' },
     *    activate: true,
     *    select: true,
     *  },
     * ]
     */
    default?: BlockProperties[];
}
export declare enum BlockType {
    REGULAR = "regular",
    SYMBOLS = "symbols"
}
export type BlockItemLayout = (props: WithEditorProps & {
    block: Block;
    attributes: Record<string, any>;
}) => RootLayoutConfig | null;
