import { Icons } from '../components/public/StudioIcon';
import { ThemeValue } from './shared';
export { IconNames } from '../components/public/StudioIcon';
export { ThemeValue } from './shared';
export type ThemeOptions = `${ThemeValue}`;
export type CSSColor = string;
export type ThemeDefaultKey = Exclude<ThemeValue, ThemeValue.auto>;
export interface CustomThemeConfig {
    default?: CustomTheme;
    icons?: Partial<Icons>;
}
export interface CustomTheme {
    colors?: {
        /**
         * Global theme colors.
         */
        global?: GlobalThemeColor;
        /**
         * Theme colors for global components (eg. button color).
         */
        primary?: ThemeColor;
        /**
         * Colors for regular Components (eg. border color around selected component).
         */
        component?: ThemeColor;
        /**
         * Colors for Symbol Components.
         */
        symbol?: ThemeColor;
        /**
         * Colors for Selector module.
         */
        selector?: ThemeColor;
    };
}
export interface ThemeColor {
    /**
     * Background color for the first layer of the element.
     * Used to separate specific elements with an additional layer of color.
     * Usage example: background color of tabs.
     */
    background1?: CSSColor;
    /**
     * Background color for the second layer of the element.
     * Used to differentiate the element from its surroundings.
     * Example: The header container of an accordion.
     */
    background2?: CSSColor;
    /**
     * Background color for the third layer of the element.
     * Example: Main background color of cards, panels, dialogs, etc.
     */
    background3?: CSSColor;
    /**
     * Background color for the hover state of the element.
     */
    backgroundHover?: CSSColor;
    /**
     * Text color of the element.
     */
    text?: CSSColor;
}
export interface GlobalThemeColor extends ThemeColor {
    /**
     * Border color of the element.
     */
    border?: CSSColor;
    /**
     * Focus color of the element.
     */
    focus?: CSSColor;
    /**
     * Placeholder color of the element.
     */
    placeholder?: CSSColor;
}
