/// <reference types="react" />
import type { Editor, ObjectAny } from 'grapesjs';
export { LICENSE_CHECK_END, LICENSE_CHECK_START } from './constants';
export declare const getBaseApiUrl: ({ isDev, isStage }: {
    isDev: boolean;
    isStage: boolean;
}) => string;
export declare const getImagePlaceholder: (props?: {
    width?: number | undefined;
    height?: number | undefined;
    text?: string | undefined;
    bg?: string | undefined;
    fg?: string | undefined;
}) => string;
export declare const IMAGE_PLH: string;
export declare const isDomainWhitelisted: () => boolean;
export declare const isDomainProd: () => boolean;
export declare const capitalize: (str: string) => string;
export declare const kebabize: (str: string) => string;
export declare const noop: () => void;
export declare const SIDEBAR_LEFT_WIDTH = 240;
export declare const isDef: (value: any) => boolean;
export declare const isString: (value: any) => value is string;
export declare const isNumber: (value: any) => value is number;
export declare function isFunction(value: any): value is Function;
export declare function isObject(val: any): val is ObjectAny;
export declare const isEmptyObject: (obj: Record<string, any>) => boolean;
export declare const deepMerge: <A extends ObjectAny, B extends ObjectAny>(a: A, b: B) => A & B;
export declare const includesSearch: (value: string, search: string) => boolean;
export declare const parseParamsToObject: (params?: string) => {
    [k: string]: string;
};
export declare const createId: (length?: number) => string;
export declare const isProjectTypeEmail: (editor: Editor) => boolean;
export declare const slugify: (str?: string) => string;
/**
 * replaceJSX('Hello {PLH}!!', { PLH: <div /> })
 */
export declare const replaceJSX: (str: string, replacement: Record<string, JSX.Element>) => (string | JSX.Element)[];
