"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _export(target,all){for(var name in all)Object.defineProperty(target,name,{enumerable:true,get:all[name]})}_export(exports,{Drawer:function(){return Drawer},default:function(){return _default}});var _react=_interopRequireDefault(require("react"));var _propTypes=_interopRequireDefault(require("prop-types"));var _framerMotion=require("framer-motion");var _react1=require("@floating-ui/react");var _deepmerge=_interopRequireDefault(require("deepmerge"));var _classnames=_interopRequireDefault(require("classnames"));var _tailwindMerge=require("tailwind-merge");var _objectsToString=_interopRequireDefault(require("../../utils/objectsToString"));var _theme=require("../../context/theme");var _drawer=require("../../types/components/drawer");function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _objectSpread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable}))}ownKeys.forEach(function(key){_defineProperty(target,key,source[key])})}return target}function _objectWithoutProperties(source,excluded){if(source==null)return{};var target=_objectWithoutPropertiesLoose(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key]}}return target}function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}var Drawer=_react.default.forwardRef(function(_param,ref){var open=_param.open,size=_param.size,overlay=_param.overlay,children=_param.children,placement=_param.placement,overlayProps=_param.overlayProps,className=_param.className,onClose=_param.onClose,dismiss=_param.dismiss,transition=_param.transition,overlayRef=_param.overlayRef,rest=_objectWithoutProperties(_param,["open","size","overlay","children","placement","overlayProps","className","onClose","dismiss","transition","overlayRef"]);var drawer=(0,_theme.useTheme)().drawer;var defaultProps=drawer.defaultProps,base=drawer.styles.base;var constrols=(0,_framerMotion.useAnimation)();size=size!==null&&size!==void 0?size:defaultProps.size;overlay=overlay!==null&&overlay!==void 0?overlay:defaultProps.overlay;placement=placement!==null&&placement!==void 0?placement:defaultProps.placement;overlayProps=overlayProps!==null&&overlayProps!==void 0?overlayProps:defaultProps.overlayProps;onClose=onClose!==null&&onClose!==void 0?onClose:defaultProps.onClose;var _merge;dismiss=(_merge=(0,_deepmerge.default)(defaultProps.dismiss,dismiss||{}))!==null&&_merge!==void 0?_merge:defaultProps.dismiss;transition=transition!==null&&transition!==void 0?transition:defaultProps.transition;className=(0,_tailwindMerge.twMerge)(defaultProps.className||"",className);var drawerClasses=(0,_tailwindMerge.twMerge)((0,_classnames.default)((0,_objectsToString.default)(base.drawer),{"top-0 right-0":placement==="right","bottom-0 left-0":placement==="bottom","top-0 left-0":placement==="top"||placement==="left"}),className);var overlayClasses=(0,_tailwindMerge.twMerge)((0,_classnames.default)((0,_objectsToString.default)(base.overlay)),overlayProps===null||overlayProps===void 0?void 0:overlayProps.className);var context=(0,_react1.useFloating)({open:open,onOpenChange:onClose}).context;var getFloatingProps=(0,_react1.useInteractions)([(0,_react1.useDismiss)(context,dismiss)]).getFloatingProps;_react.default.useEffect(function(){constrols.start(open?"open":"close")},[open,constrols,placement]);var drawerAnimation={open:{x:0,y:0},close:{x:placement==="left"?-size:placement==="right"?size:0,y:placement==="top"?-size:placement==="bottom"?size:0}};var backdropAnimation={unmount:{opacity:0,transition:{delay:.3}},mount:{opacity:1}};return _react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_framerMotion.LazyMotion,{features:_framerMotion.domAnimation},_react.default.createElement(_framerMotion.AnimatePresence,null,overlay&&open&&_react.default.createElement(_framerMotion.m.div,{ref:overlayRef,className:overlayClasses,initial:"unmount",exit:"unmount",animate:open?"mount":"unmount",variants:backdropAnimation,transition:{duration:.3}})),_react.default.createElement(_framerMotion.m.div,_extends({},getFloatingProps(_objectSpread({ref:ref},rest)),{className:drawerClasses,style:{maxWidth:placement==="left"||placement==="right"?size:"100%",maxHeight:placement==="top"||placement==="bottom"?size:"100%",height:placement==="left"||placement==="right"?"100vh":"100%"},initial:"close",animate:constrols,variants:drawerAnimation,transition:transition}),children)))});Drawer.propTypes={open:_drawer.propTypesOpen,size:_drawer.propTypesSize,overlay:_drawer.propTypesOverlay,children:_drawer.propTypesChildren,placement:_propTypes.default.oneOf(_drawer.propTypesPlacement),overlayProps:_drawer.propTypesOverlayProps,className:_drawer.propTypesClassName,onClose:_drawer.propTypesOnClose,dismiss:_drawer.propTypesDismiss,transition:_drawer.propTypesTransition,overlayRef:_drawer.propTypesOverlayRef};Drawer.displayName="MaterialTailwind.Drawer";var _default=Drawer;