/*!
 * jodit - Jodit is an awesome and useful wysiwyg editor with filebrowser
 * Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/jodit/)
 * Version: v4.5.16
 * Url: https://xdsoft.net/jodit/
 * License(s): MIT
 */
	
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 140:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ FileBrowser; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63915);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(58597);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14961);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(70265);
/* harmony import */ var _fetch_load_items__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(9979);
/* harmony import */ var _fetch_load_tree__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(31859);
/* harmony import */ var _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(62994);
/* harmony import */ var _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(18043);
/* harmony import */ var _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80004);
/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(75889);
/* harmony import */ var _factories__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(83797);
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(10274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






















var FileBrowser = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__extends */ .C6)(FileBrowser, _super);
    function FileBrowser(options) {
        var _this = _super.call(this, options) || this;
        _this.browser = _this.c.div(_this.componentName);
        _this.status_line = _this.c.div(_this.getFullElName('status'));
        _this.tree = new _ui__WEBPACK_IMPORTED_MODULE_17__/* .FileBrowserTree */ .V(_this);
        _this.files = new _ui__WEBPACK_IMPORTED_MODULE_17__/* .FileBrowserFiles */ .Q(_this);
        _this.state = (0,jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_4__/* .observable */ .sH)({
            currentPath: '',
            currentSource: _data_provider__WEBPACK_IMPORTED_MODULE_15__/* .DEFAULT_SOURCE_NAME */ .o,
            currentBaseUrl: '',
            activeElements: [],
            elements: [],
            sources: [],
            view: 'tiles',
            sortBy: 'changed-desc',
            filterWord: '',
            onlyImages: false
        });
        _this.errorHandler = function (resp) {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(resp)) {
                return;
            }
            if (resp instanceof Error) {
                _this.status(_this.i18n(resp.message));
            }
            else {
                _this.status(_this.dataProvider.getMessage(resp));
            }
        };
        /**
         * Close dialog
         */
        _this.close = function () {
            _this._dialog.close();
        };
        _this.__prevButtons = [];
        _this.attachEvents(options);
        var self = _this;
        self.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_9__/* .Config */ .T.defaultOptions.filebrowser);
        self.browser.component = _this;
        self.container = self.browser;
        if (self.o.showFoldersPanel) {
            self.browser.appendChild(self.tree.container);
        }
        self.browser.appendChild(self.files.container);
        self.browser.appendChild(self.status_line);
        _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_13__/* .selfListeners */ .c.call(self);
        _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_12__/* .nativeListeners */ .nW.call(self);
        _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_14__/* .stateListeners */ .r.call(self);
        var keys = [
            'getLocalFileByUrl',
            'crop',
            'resize',
            'create',
            'fileMove',
            'folderMove',
            'fileRename',
            'folderRename',
            'fileRemove',
            'folderRemove',
            'folder',
            'items',
            'permissions'
        ];
        keys.forEach(function (key) {
            if (_this.options[key] != null) {
                _this.options[key] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(_this.options[key], _this.o.ajax);
            }
        });
        var _a = _this.o
            .saveStateInStorage || {
            storeLastOpenedFolder: false,
            storeView: false,
            storeSortBy: false
        }, storeView = _a.storeView, storeSortBy = _a.storeSortBy, storeLastOpenedFolder = _a.storeLastOpenedFolder;
        var view = storeView && _this.storage.get('view');
        if (view && _this.o.view == null) {
            self.state.view = view === 'list' ? 'list' : 'tiles';
        }
        else {
            self.state.view = self.o.view === 'list' ? 'list' : 'tiles';
        }
        self.files.setMod('view', self.state.view);
        var sortBy = storeSortBy && self.storage.get('sortBy');
        if (sortBy) {
            var parts = sortBy.split('-');
            self.state.sortBy = ['changed', 'name', 'size'].includes(parts[0])
                ? sortBy
                : 'changed-desc';
        }
        else {
            self.state.sortBy = self.o.sortBy || 'changed-desc';
        }
        if (storeLastOpenedFolder) {
            var currentPath = self.storage.get('currentPath'), currentSource = self.storage.get('currentSource');
            self.state.currentPath = currentPath !== null && currentPath !== void 0 ? currentPath : '';
            self.state.currentSource = currentSource !== null && currentSource !== void 0 ? currentSource : '';
        }
        self.initUploader(self);
        self.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready);
        return _this;
    }
    /** @override */
    FileBrowser.prototype.className = function () {
        return 'FileBrowser';
    };
    Object.defineProperty(FileBrowser.prototype, "dataProvider", {
        get: function () {
            return (0,_factories__WEBPACK_IMPORTED_MODULE_16__/* .makeDataProvider */ .S)(this, this.options);
        },
        enumerable: false,
        configurable: true
    });
    FileBrowser.prototype.onSelect = function (callback) {
        var _this = this;
        return function () {
            if (_this.state.activeElements.length) {
                var files_1 = [];
                var isImages_1 = [];
                _this.state.activeElements.forEach(function (elm) {
                    var url = elm.fileURL;
                    if (url) {
                        files_1.push(url);
                        isImages_1.push(elm.isImage || false);
                    }
                });
                _this.close();
                var data = {
                    baseurl: '',
                    files: files_1,
                    isImages: isImages_1
                };
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isFunction)(callback)) {
                    callback(data);
                }
                _this.close();
            }
            return false;
        };
    };
    Object.defineProperty(FileBrowser.prototype, "_dialog", {
        get: function () {
            var _this = this;
            var _a;
            var dialog = this.dlg({
                minWidth: Math.min(700, screen.width),
                minHeight: 300,
                buttons: (_a = this.o.headerButtons) !== null && _a !== void 0 ? _a : ['fullsize', 'dialog.close']
            });
            ['beforeClose', 'afterClose', 'beforeOpen'].forEach(function (proxyEvent) {
                return dialog.events.on(dialog, proxyEvent, function () { return _this.e.fire(proxyEvent); });
            });
            dialog.setSize(this.o.width, this.o.height);
            return dialog;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowser.prototype, "storage", {
        /**
         * Container for set/get value
         */
        get: function () {
            return jodit_core_storage__WEBPACK_IMPORTED_MODULE_6__/* .Storage */ .wc.makeStorage(Boolean(this.o.saveStateInStorage), this.componentName);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowser.prototype, "isOpened", {
        get: function () {
            return this._dialog.isOpened && this.browser.style.display !== 'none';
        },
        enumerable: false,
        configurable: true
    });
    /**
     * It displays a message in the status bar of filebrowser
     *
     * @param message - The message that will be displayed
     * @param success - true It will be shown a message light . If no option is specified ,
     * ßan error will be shown the red
     * @example
     * ```javascript
     * parent.filebrowser.status('There was an error uploading file', false);
     * ```
     */
    FileBrowser.prototype.status = function (message, success) {
        if (!message || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(message)) {
            return;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(message)) {
            message = message.message;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(message) || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.trim)(message).length) {
            return;
        }
        this.message.message(message, success ? 'success' : 'error', this.o.howLongShowMsg);
    };
    /**
     * It opens a web browser window
     *
     * @param callback - The function that will be called after the file selection in the browser
     * @param onlyImages - Show only images
     * @example
     * ```javascript
     * var fb = new Jodit.modules.FileBrowser(parent);
     * fb.open(function (data) {
     *     var i;
     *     for (i = 0;i < data.files.length; i += 1) {
     *         parent.s.insertImage(data.baseurl + data.files[i]);
     *     }
     * });
     * ```
     */
    FileBrowser.prototype.open = function (callback, onlyImages) {
        var _this = this;
        if (callback === void 0) { callback = this.o
            .defaultCallback; }
        if (onlyImages === void 0) { onlyImages = false; }
        this.state.onlyImages = onlyImages;
        return this.async
            .promise(function (resolve, reject) {
            var _a;
            if (!_this.o.items || !_this.o.items.url) {
                throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)('Need set options.filebrowser.ajax.url');
            }
            var localTimeout = 0;
            _this.e
                .off(_this.files.container, 'dblclick')
                .on(_this.files.container, 'dblclick', _this.onSelect(callback))
                .on(_this.files.container, 'touchstart', function () {
                var now = new Date().getTime();
                if (now - localTimeout <
                    jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.EMULATE_DBLCLICK_TIMEOUT) {
                    _this.onSelect(callback)();
                }
                localTimeout = now;
            })
                .off('select.filebrowser')
                .on('select.filebrowser', _this.onSelect(callback));
            var header = _this.c.div();
            (_a = _this.toolbar) === null || _a === void 0 ? void 0 : _a.appendTo(header);
            _this.__updateToolbarButtons();
            _this._dialog.open(_this.browser, header);
            _this.e.fire('sort.filebrowser', _this.state.sortBy);
            (0,_fetch_load_tree__WEBPACK_IMPORTED_MODULE_11__/* .loadTree */ .r)(_this)
                .then(resolve, reject)
                .finally(function () {
                var _a;
                if (_this.isInDestruct) {
                    return;
                }
                (_a = _this === null || _this === void 0 ? void 0 : _this.e) === null || _a === void 0 ? void 0 : _a.fire('fileBrowserReady.filebrowser');
            });
        })
            .catch(function (e) {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(e) && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                throw e;
            }
        });
    };
    FileBrowser.prototype.__getButtons = function () {
        var _this = this;
        var _a;
        var options = ((_a = this.o.buttons) !== null && _a !== void 0 ? _a : []);
        return options.filter(function (btn) {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(btn)) {
                return true;
            }
            switch (btn) {
                case 'filebrowser.upload':
                    return _this.dataProvider.canI('FileUpload');
                case 'filebrowser.edit':
                    return (_this.dataProvider.canI('ImageResize') ||
                        _this.dataProvider.canI('ImageCrop'));
                case 'filebrowser.remove':
                    return _this.dataProvider.canI('FileRemove');
            }
            return true;
        });
    };
    FileBrowser.prototype.initUploader = function (editor) {
        var _this = this;
        var _a;
        var self = this, options = (_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.uploader, uploaderOptions = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_9__/* .Config */ .T.defaultOptions.uploader);
        var uploadHandler = function () { return (0,_fetch_load_items__WEBPACK_IMPORTED_MODULE_19__/* .loadItems */ .f)(_this); };
        self.uploader = self.getInstance('Uploader', uploaderOptions);
        self.uploader
            .setPath(self.state.currentPath)
            .setSource(self.state.currentSource)
            .bind(self.browser, uploadHandler, self.errorHandler);
        this.state.on(['change.currentPath', 'change.currentSource'], function () {
            _this.uploader
                .setPath(_this.state.currentPath)
                .setSource(_this.state.currentSource);
        });
        self.e.on('bindUploader.filebrowser', function (button) {
            self.uploader.bind(button, uploadHandler, self.errorHandler);
        });
    };
    FileBrowser.prototype.destruct = function () {
        var _a;
        if (this.isInDestruct) {
            return;
        }
        (_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cached)(this, '_dialog')) === null || _a === void 0 ? void 0 : _a.destruct();
        _super.prototype.destruct.call(this);
        this.events && this.e.off('.filebrowser');
        this.uploader && this.uploader.destruct();
    };
    FileBrowser.prototype.__updateToolbarButtons = function () {
        var _a;
        var buttons = this.__getButtons();
        if (isEqualButtonList(this.__prevButtons, buttons)) {
            return;
        }
        this.__prevButtons = buttons;
        (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.build(buttons);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
    ], FileBrowser.prototype, "dataProvider", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
    ], FileBrowser.prototype, "_dialog", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
    ], FileBrowser.prototype, "storage", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
    ], FileBrowser.prototype, "status", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
    ], FileBrowser.prototype, "open", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_3__/* .watch */ .w)('dataProvider:changePermissions')
    ], FileBrowser.prototype, "__updateToolbarButtons", null);
    FileBrowser = (0,tslib__WEBPACK_IMPORTED_MODULE_18__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_7__/* .Dlgs */ .z)
    ], FileBrowser);
    return FileBrowser;
}(jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_8__/* .ViewWithToolbar */ .T));

function isEqualButtonList(prevButtons, buttons) {
    if (prevButtons.length !== buttons.length) {
        return false;
    }
    for (var i = 0; i < prevButtons.length; i++) {
        if (prevButtons[i] !== buttons[i]) {
            return false;
        }
    }
    return true;
}


/***/ }),

/***/ 223:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M5.09668 6.99707H7.17358L4.17358 3.99707L1.17358 6.99707H3.09668V17.0031H1.15881L4.15881 20.0031L7.15881 17.0031H5.09668V6.99707Z\"/> <path d=\"M22.8412 7H8.84119V5H22.8412V7Z\"/> <path d=\"M22.8412 11H8.84119V9H22.8412V11Z\"/> <path d=\"M8.84119 15H22.8412V13H8.84119V15Z\"/> <path d=\"M22.8412 19H8.84119V17H22.8412V19Z\"/> </svg>"

/***/ }),

/***/ 225:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony exports isEditorEmpty, placeholder */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71274);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(50248);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












/**
 * Check if root node is empty
 * @private
 */
function isEditorEmpty(root) {
    var _a;
    if (!root.firstChild) {
        return true;
    }
    var first = root.firstChild;
    if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS.has((_a = first.nodeName) === null || _a === void 0 ? void 0 : _a.toLowerCase()) ||
        /^(TABLE)$/i.test(first.nodeName)) {
        return false;
    }
    var next = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next(first, function (node) { return node && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(node); }, root);
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(first) && !next) {
        return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(first);
    }
    return (!next &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.each(first, function (elm) {
            return !(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isLeaf(elm) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isList(elm)) &&
                (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmpty(elm) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(elm, 'br'));
        }));
}
/**
 * Show placeholder inside empty editor
 */
var placeholder = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(placeholder, _super);
    function placeholder() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(arguments), false)) || this;
        _this.addNativeListeners = function () {
            _this.j.e
                .off(_this.j.editor, 'input.placeholder keydown.placeholder')
                .on(_this.j.editor, 'input.placeholder keydown.placeholder', _this.toggle);
        };
        _this.addEvents = function () {
            var editor = _this.j;
            if (editor.o.useInputsPlaceholder &&
                editor.element.hasAttribute('placeholder')) {
                _this.placeholderElm.innerHTML =
                    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_5__/* .attr */ .C)(editor.element, 'placeholder') || '';
            }
            editor.e.fire('placeholder', _this.placeholderElm.innerHTML);
            editor.e
                .off('.placeholder')
                .on('changePlace.placeholder', _this.addNativeListeners)
                .on('change.placeholder focus.placeholder keyup.placeholder mouseup.placeholder keydown.placeholder ' +
                'mousedown.placeholder afterSetMode.placeholder changePlace.placeholder', _this.toggle)
                .on(window, 'load', _this.toggle);
            _this.addNativeListeners();
            _this.toggle();
        };
        return _this;
    }
    placeholder.prototype.afterInit = function (editor) {
        var _this = this;
        if (!editor.o.showPlaceholder) {
            return;
        }
        this.placeholderElm = editor.c.fromHTML("<span data-ref=\"placeholder\" style=\"display: none;\" class=\"jodit-placeholder\">".concat(editor.i18n(editor.o.placeholder), "</span>"));
        if (editor.o.direction === 'rtl') {
            this.placeholderElm.style.right = '0px';
            this.placeholderElm.style.direction = 'rtl';
        }
        editor.e
            .on('readonly', function (isReadOnly) {
            if (isReadOnly) {
                _this.hide();
            }
            else {
                _this.toggle();
            }
        })
            .on('changePlace', this.addEvents);
        this.addEvents();
    };
    placeholder.prototype.show = function () {
        var editor = this.j;
        if (editor.o.readonly) {
            return;
        }
        var marginTop = 0, marginLeft = 0;
        var current = editor.s.current(), wrapper = (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isBlock, editor.editor)) ||
            editor.editor;
        var style = editor.ew.getComputedStyle(wrapper);
        var styleEditor = editor.ew.getComputedStyle(editor.editor);
        editor.workplace.appendChild(this.placeholderElm);
        var firstChild = editor.editor.firstChild;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement(firstChild) && !(0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_4__/* .isMarker */ .r)(firstChild)) {
            var style2 = editor.ew.getComputedStyle(firstChild);
            marginTop = parseInt(style2.getPropertyValue('margin-top'), 10);
            marginLeft = parseInt(style2.getPropertyValue('margin-left'), 10);
            this.placeholderElm.style.fontSize =
                parseInt(style2.getPropertyValue('font-size'), 10) + 'px';
            this.placeholderElm.style.lineHeight =
                style2.getPropertyValue('line-height');
        }
        else {
            this.placeholderElm.style.fontSize =
                parseInt(style.getPropertyValue('font-size'), 10) + 'px';
            this.placeholderElm.style.lineHeight =
                style.getPropertyValue('line-height');
        }
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(this.placeholderElm, {
            display: 'block',
            textAlign: style.getPropertyValue('text-align'),
            paddingTop: parseInt(styleEditor.paddingTop, 10) + 'px',
            paddingLeft: parseInt(styleEditor.paddingLeft, 10) + 'px',
            paddingRight: parseInt(styleEditor.paddingRight, 10) + 'px',
            marginTop: Math.max(parseInt(style.getPropertyValue('margin-top'), 10), marginTop),
            marginLeft: Math.max(parseInt(style.getPropertyValue('margin-left'), 10), marginLeft)
        });
    };
    placeholder.prototype.hide = function () {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.placeholderElm);
    };
    placeholder.prototype.toggle = function () {
        var editor = this.j;
        if (!editor.editor || editor.isInDestruct) {
            return;
        }
        if (editor.getRealMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
            this.hide();
            return;
        }
        if (!isEditorEmpty(editor.editor)) {
            this.hide();
        }
        else {
            this.show();
        }
    };
    placeholder.prototype.beforeDestruct = function (jodit) {
        this.hide();
        jodit.e.off('.placeholder').off(window, 'load', this.toggle);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.debounce)(function (ctx) { return ctx.defaultTimeout / 10; }, true)
    ], placeholder.prototype, "toggle", null);
    return placeholder;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_6__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('placeholder', placeholder);


/***/ }),

/***/ 449:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ CamelCaseToKebabCase; },
/* harmony export */   k: function() { return /* binding */ kebabCase; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
var kebabCase = function (key) {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .replace(/[\s_]+/g, '-')
        .toLowerCase();
};
var CamelCaseToKebabCase = function (key) {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .toLowerCase();
};


/***/ }),

/***/ 641:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ scrollIntoViewIfNeeded; },
/* harmony export */   l: function() { return /* binding */ inView; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module helpers/utils
 */
/**
 * Check if element is in view
 */
function inView(elm, root, doc) {
    var rect = elm.getBoundingClientRect(), el = elm;
    var top = rect.top, height = rect.height;
    while (el && el !== root && el.parentNode) {
        el = el.parentNode;
        rect = el.getBoundingClientRect();
        if (!(top <= rect.bottom)) {
            return false;
        }
        // Check if the element is out of view due to a container scrolling
        if (top + height <= rect.top) {
            return false;
        }
    }
    // Check it's within the document viewport
    return (top <= ((doc.documentElement && doc.documentElement.clientHeight) || 0));
}
/**
 * Scroll element into view if it is not in view
 */
function scrollIntoViewIfNeeded(elm, root, doc) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm) && !inView(elm, root, doc)) {
        if (root.clientHeight !== root.scrollHeight) {
            root.scrollTop = elm.offsetTop;
        }
        if (!inView(elm, root, doc)) {
            elm.scrollIntoView();
        }
    }
}


/***/ }),

/***/ 926:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ removeEmptyTextNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @private
 */
function removeEmptyTextNode(jodit, node, hadEffect, arg, argi, currentNode) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(node) && !node.nodeValue) {
        if (node === currentNode && jodit.s.isCollapsed()) {
            jodit.s.setCursorAfter(node);
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(node);
        return true;
    }
    return hadEffect;
}


/***/ }),

/***/ 928:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M621 1280h595v-595zm-45-45l595-595h-595v595zm1152 77v192q0 14-9 23t-23 9h-224v224q0 14-9 23t-23 9h-192q-14 0-23-9t-9-23v-224h-864q-14 0-23-9t-9-23v-864h-224q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h224v-224q0-14 9-23t23-9h192q14 0 23 9t9 23v224h851l246-247q10-9 23-9t23 9q9 10 9 23t-9 23l-247 246v851h224q14 0 23 9t9 23z\"/> </svg>"

/***/ }),

/***/ 931:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ Icon; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



var Icon = /** @class */ (function () {
    function Icon() {
    }
    Icon.getIcon = function (name) {
        if (/<svg/i.test(name)) {
            return name;
        }
        var icon = Icon.icons[name] ||
            Icon.icons[name.replace(/-/g, '_')] ||
            Icon.icons[name.replace(/_/g, '-')] ||
            Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.camelCase)(name)] ||
            Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.kebabCase)(name)] ||
            Icon.icons[name.toLowerCase()];
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !icon) {
            console.warn("Icon \"".concat(name, "\" not found"));
        }
        return icon;
    };
    /**
     * Check if icon exist in store
     */
    Icon.exists = function (name) {
        return this.getIcon(name) !== undefined;
    };
    /**
     * Return SVG icon
     */
    Icon.get = function (name, defaultValue) {
        if (defaultValue === void 0) { defaultValue = '<span></span>'; }
        return this.getIcon(name) || defaultValue;
    };
    /**
     * Set SVG in store
     */
    Icon.set = function (name, value) {
        this.icons[name.replace('_', '-')] = value;
        return this;
    };
    /**
     * Make icon html element
     */
    Icon.makeIcon = function (jodit, icon) {
        var _a, _b, _c, _d;
        if (!icon) {
            return;
        }
        var iconElement;
        var name = icon.name, iconURL = icon.iconURL, fill = icon.fill;
        var clearName = name.replace(/[^a-zA-Z0-9]/g, '_');
        var iconFromEvent;
        if (!/<svg/.test(name)) {
            iconFromEvent = (_b = (_a = jodit.o).getIcon) === null || _b === void 0 ? void 0 : _b.call(_a, name, clearName);
        }
        var cacheKey = "".concat(name).concat(iconURL).concat(fill).concat(iconFromEvent !== null && iconFromEvent !== void 0 ? iconFromEvent : '');
        if (jodit.o.cache && this.__cache.has(cacheKey)) {
            return (_c = this.__cache.get(cacheKey)) === null || _c === void 0 ? void 0 : _c.cloneNode(true);
        }
        if (iconURL) {
            iconElement = jodit.c.span();
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(iconElement, 'backgroundImage', 'url(' +
                iconURL.replace('{basePath}', (jodit === null || jodit === void 0 ? void 0 : jodit.basePath) || '') +
                ')');
        }
        else {
            var svg = iconFromEvent ||
                Icon.get(name, '') ||
                ((_d = jodit.o.extraIcons) === null || _d === void 0 ? void 0 : _d[name]);
            if (svg) {
                iconElement = jodit.c.fromHTML(svg.trim());
                if (!/^<svg/i.test(name)) {
                    iconElement.classList.add('jodit-icon_' + clearName);
                }
            }
        }
        if (iconElement) {
            iconElement.classList.add('jodit-icon');
            iconElement.style.fill = fill;
            jodit.o.cache &&
                this.__cache.set(cacheKey, iconElement.cloneNode(true));
        }
        return iconElement;
    };
    Icon.icons = {};
    Icon.__cache = new Map();
    return Icon;
}());



/***/ }),

/***/ 1239:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export orderedList */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20797);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Process commands insertOrderedList and insertUnOrderedList
 */
var orderedList = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__extends */ .C6)(orderedList, _super);
    function orderedList() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__read */ .zs)(arguments), false)) || this;
        _this.buttons = [
            {
                name: 'ul',
                group: 'list'
            },
            {
                name: 'ol',
                group: 'list'
            }
        ];
        return _this;
    }
    orderedList.prototype.afterInit = function (jodit) {
        jodit
            .registerCommand('insertUnorderedList', this.onCommand)
            .registerCommand('insertOrderedList', this.onCommand);
    };
    orderedList.prototype.onCommand = function (command, _, type) {
        this.jodit.s.commitStyle({
            element: command === 'insertunorderedlist' ? 'ul' : 'ol',
            attributes: {
                style: {
                    listStyleType: type !== null && type !== void 0 ? type : null
                }
            }
        });
        this.jodit.synchronizeValues();
        return false;
    };
    orderedList.prototype.beforeDestruct = function (jodit) { };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], orderedList.prototype, "onCommand", null);
    return orderedList;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_2__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('orderedList', orderedList);


/***/ }),

/***/ 1311:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'Symbolit'
};


/***/ }),

/***/ 1540:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ UISelect; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/* harmony import */ var jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84103);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






var UISelect = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__extends */ .C6)(UISelect, _super);
    function UISelect(jodit, state) {
        var _this = _super.call(this, jodit, state) || this;
        /** @override */
        _this.state = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)({}, UISelect_1.defaultState);
        Object.assign(_this.state, state);
        return _this;
    }
    UISelect_1 = UISelect;
    /** @override */
    UISelect.prototype.className = function () {
        return 'UISelect';
    };
    /** @override **/
    UISelect.prototype.createContainer = function (state) {
        var _a;
        var container = _super.prototype.createContainer.call(this, state);
        var j = this.j, nativeInput = this.nativeInput;
        var opt = function () { return j.create.element('option'); };
        if (state.placeholder !== undefined) {
            var option = opt();
            option.value = '';
            option.text = j.i18n(state.placeholder);
            nativeInput.add(option);
        }
        (_a = state.options) === null || _a === void 0 ? void 0 : _a.forEach(function (element) {
            var option = opt();
            option.value = element.value.toString();
            option.text = j.i18n(element.text);
            nativeInput.add(option);
        });
        if (state.size && state.size > 0) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(nativeInput, 'size', state.size);
        }
        if (state.multiple) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(nativeInput, 'multiple', '');
        }
        return container;
    };
    /** @override **/
    UISelect.prototype.createNativeInput = function () {
        return this.j.create.element('select');
    };
    /** @override **/
    UISelect.prototype.updateValidators = function () {
        _super.prototype.updateValidators.call(this);
        if (this.state.required) {
            this.validators.delete(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__/* .inputValidators.required */ .O.required);
            this.validators.add(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__/* .selectValidators.required */ .U.m);
        }
    };
    var UISelect_1;
    /** @override */
    UISelect.defaultState = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { options: [], size: 1, multiple: false });
    UISelect = UISelect_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
    ], UISelect);
    return UISelect;
}(jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t));



/***/ }),

/***/ 1663:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'Simbolo'
};


/***/ }),

/***/ 1677:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export sticky */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63400);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









var NEED_DUMMY_BOX = !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE;
var sticky = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(sticky, _super);
    function sticky() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__read */ .zs)(arguments), false)) || this;
        _this.__isToolbarStuck = false;
        _this.__createDummy = function (toolbar) {
            _this.__dummyBox = _this.j.c.div();
            _this.__dummyBox.classList.add('jodit_sticky-dummy_toolbar');
            _this.j.container.insertBefore(_this.__dummyBox, toolbar);
        };
        /**
         * Add sticky
         */
        _this.addSticky = function (toolbar) {
            if (!_this.__isToolbarStuck) {
                if (NEED_DUMMY_BOX && !_this.__dummyBox) {
                    _this.__createDummy(toolbar);
                }
                _this.j.container.classList.add('jodit_sticky');
                _this.__isToolbarStuck = true;
            }
            // on resize, it should work always
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(toolbar, {
                top: _this.j.o.toolbarStickyOffset || null,
                width: _this.j.container.offsetWidth - 2
            });
            _this.__dummyBox &&
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(_this.__dummyBox, {
                    height: toolbar.offsetHeight
                });
        };
        /**
         * Remove sticky behaviour
         */
        _this.removeSticky = function (toolbar) {
            if (!_this.__isToolbarStuck) {
                return;
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(toolbar, {
                width: '',
                top: ''
            });
            _this.j.container.classList.remove('jodit_sticky');
            _this.__isToolbarStuck = false;
        };
        return _this;
    }
    sticky.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit.e
            .on(jodit.ow, 'scroll.sticky wheel.sticky mousewheel.sticky resize.sticky', this.__onScroll)
            .on('getStickyState.sticky', function () { return _this.__isToolbarStuck; });
    };
    /**
     * Scroll handler
     */
    sticky.prototype.__onScroll = function () {
        var jodit = this.jodit;
        if (!jodit.o.toolbarSticky || !jodit.o.toolbar) {
            return;
        }
        var scrollWindowTop = jodit.ow.pageYOffset ||
            (jodit.od.documentElement && jodit.od.documentElement.scrollTop) ||
            0;
        var offsetEditor = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(jodit.container, jodit, jodit.od, true);
        var doSticky = jodit.getMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG &&
            scrollWindowTop + jodit.o.toolbarStickyOffset > offsetEditor.top &&
            scrollWindowTop + jodit.o.toolbarStickyOffset <
                offsetEditor.top + offsetEditor.height &&
            !(jodit.o.toolbarDisableStickyForMobile && this.__isMobile());
        if (this.__isToolbarStuck === doSticky) {
            return;
        }
        var container = jodit.toolbarContainer;
        if (container) {
            doSticky ? this.addSticky(container) : this.removeSticky(container);
        }
        jodit.e.fire('toggleSticky', doSticky);
    };
    /**
     * Is mobile device
     */
    sticky.prototype.__isMobile = function () {
        var j = this.j;
        return (j &&
            j.options &&
            j.container &&
            j.options.sizeSM >= j.container.offsetWidth);
    };
    sticky.prototype.beforeDestruct = function (jodit) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.__dummyBox);
        jodit.e
            .off(jodit.ow, 'scroll.sticky wheel.sticky mousewheel.sticky resize.sticky', this.__onScroll)
            .off('.sticky');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)()
    ], sticky.prototype, "__onScroll", null);
    return sticky;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('sticky', sticky);


/***/ }),

/***/ 1916:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <g transform=\"scale(1.2 1.2) translate(-2 -0.5)\"> <path d=\"M 22,12.5 A 1.49995,1.49995 0 0 0 20.50006,11 H 20 V 10 A 3,3 0 0 0 17,7 H 13 V 5.7226 a 2,2 0 1 0 -2,0 V 7 H 7 a 3,3 0 0 0 -3,3 v 1 H 3.49994 a 1.5,1.5 0 0 0 0,3 H 4 v 1 A 3.00128,3.00128 0 0 0 6.20251,17.89282 1.03113,1.03113 0 0 1 7,18.86975 v 0.716 a 0.99928,0.99928 0 0 0 1.00726,1.002 0.9792,0.9792 0 0 0 0.69983,-0.29486 l 2,-2 A 1,1 0 0 1 11.41425,18 H 17 a 3,3 0 0 0 3,-3 v -1 h 0.50006 A 1.49995,1.49995 0 0 0 22,12.5 Z M 19,15 a 2.00226,2.00226 0 0 1 -2,2 H 11.41425 A 1.987,1.987 0 0 0 10,17.58575 l -2,2 v -0.716 A 2.02082,2.02082 0 0 0 6.46771,16.92865 2.00439,2.00439 0 0 1 5,15 V 10 A 2.00226,2.00226 0 0 1 7,8 h 10 a 2.00222,2.00222 0 0 1 2,2 z M 10,12.5 A 1.5,1.5 0 1 1 8.5,11 1.5,1.5 0 0 1 10,12.5 Z m 7,0 A 1.5,1.5 0 1 1 15.5,11 1.5,1.5 0 0 1 17,12.5 Z\"/> </g> </svg>"

/***/ }),

/***/ 1963:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ derive; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * [[include:core/decorators/derive/README.md]]
 * @packageDocumentation
 * @module decorators/derive
 */

function derive() {
    var traits = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        traits[_i] = arguments[_i];
    }
    return function (target) {
        var origin = target.prototype;
        for (var i = 0; i < traits.length; i++) {
            var trait = traits[i];
            var keys = Object.getOwnPropertyNames(trait.prototype);
            var _loop_1 = function (j) {
                var key = keys[j], method = Object.getOwnPropertyDescriptor(trait.prototype, key);
                var canDerive = method != null &&
                    (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(method.value) &&
                    !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(origin[key]);
                if (canDerive) {
                    Object.defineProperty(origin, key, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: function () {
                            var _a;
                            var args = [];
                            for (var _i = 0; _i < arguments.length; _i++) {
                                args[_i] = arguments[_i];
                            }
                            return (_a = method.value).call.apply(_a, (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__spreadArray */ .fX)([this], (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__read */ .zs)(args), false));
                        }
                    });
                }
            };
            for (var j = 0; j < keys.length; j++) {
                _loop_1(j);
            }
        }
    };
}


/***/ }),

/***/ 1992:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ createSourceEditor; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var _engines__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76134);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function createSourceEditor(type, editor, container, toWYSIWYG, fromWYSIWYG) {
    var sourceEditor;
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(type)) {
        sourceEditor = type(editor);
    }
    else {
        switch (type) {
            case 'ace':
                if (!editor.o.shadowRoot) {
                    sourceEditor = new _engines__WEBPACK_IMPORTED_MODULE_1__/* .AceEditor */ .p(editor, container, toWYSIWYG, fromWYSIWYG);
                    break;
                }
            default:
                sourceEditor = new _engines__WEBPACK_IMPORTED_MODULE_1__/* .TextAreaEditor */ .S(editor, container, toWYSIWYG, fromWYSIWYG);
        }
    }
    sourceEditor.init(editor);
    sourceEditor.onReadyAlways(function () {
        sourceEditor.setReadOnly(editor.o.readonly);
    });
    return sourceEditor;
}


/***/ }),

/***/ 2461:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ isNumber; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is a number
 */
function isNumber(value) {
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}


/***/ }),

/***/ 2533:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export tableKeyboardNavigation */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11648);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






var WORK_KEYS = new Set([
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN
]);
/**
 * Process navigates key pressing in table cell
 */
function tableKeyboardNavigation(editor) {
    editor.e
        .off('.tableKeyboardNavigation')
        .on('keydown.tableKeyboardNavigation', function (event) {
        var key = event.key;
        var cell = findCell(editor, key);
        if (!cell) {
            return;
        }
        var tableModule = editor.getInstance(jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_4__/* .Table */ .X, editor.o);
        var table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(cell, 'table', editor.editor);
        var next = null;
        var isPrev = key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT || event.shiftKey;
        var getNextCell = function () {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(isPrev ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.next, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell, table);
        };
        switch (key) {
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB:
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT: {
                next = getNextCell();
                if (!next) {
                    tableModule.appendRow(table, !isPrev
                        ? false
                        : table.querySelector('tr'), !isPrev);
                    next = getNextCell();
                }
                break;
            }
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP:
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN:
                {
                    var matrix = tableModule.formalMatrix(table);
                    var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__read */ .zs)(tableModule.formalCoordinate(table, cell), 2), row = _a[0], column = _a[1];
                    if (key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP) {
                        if (matrix[row - 1] !== undefined) {
                            next = matrix[row - 1][column];
                        }
                    }
                    else {
                        if (matrix[row + 1] !== undefined) {
                            next = matrix[row + 1][column];
                        }
                    }
                }
                break;
        }
        if (!next) {
            return;
        }
        editor.e.fire('hidePopup hideResizer');
        if (!next.firstChild) {
            var first = editor.createInside.element('br');
            next.appendChild(first);
            editor.s.setCursorBefore(first);
        }
        else {
            if (key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB) {
                editor.s.select(next, true);
            }
            else {
                editor.s.setCursorIn(next, key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN);
            }
        }
        editor.synchronizeValues();
        return false;
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('tableKeyboardNavigation', tableKeyboardNavigation);
function findCell(editor, key) {
    if (!WORK_KEYS.has(key)) {
        return;
    }
    var current = editor.s.current();
    if (!current) {
        return;
    }
    var cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell, editor.editor);
    if (!cell) {
        return;
    }
    var range = editor.s.range;
    if (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB && current !== cell) {
        var isNextDirection = key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN;
        var hasNext = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(!isNextDirection ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.next, current, function (elm) {
            return key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN
                ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(elm, 'br')
                : Boolean(elm);
        }, cell);
        if ((!isNextDirection &&
            (hasNext ||
                (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP &&
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current) &&
                    range.startOffset !== 0))) ||
            (isNextDirection &&
                (hasNext ||
                    (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN &&
                        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current) &&
                        current.nodeValue &&
                        range.startOffset !== current.nodeValue.length)))) {
            return;
        }
    }
    return cell;
}


/***/ }),

/***/ 2788:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ MemoryStorageProvider; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var MemoryStorageProvider = /** @class */ (function () {
    function MemoryStorageProvider() {
        this.data = new Map();
    }
    MemoryStorageProvider.prototype.set = function (key, value) {
        this.data.set(key, value);
        return this;
    };
    MemoryStorageProvider.prototype.delete = function (key) {
        this.data.delete(key);
        return this;
    };
    MemoryStorageProvider.prototype.get = function (key) {
        return this.data.get(key);
    };
    MemoryStorageProvider.prototype.exists = function (key) {
        return this.data.has(key);
    };
    MemoryStorageProvider.prototype.clear = function () {
        this.data.clear();
        return this;
    };
    return MemoryStorageProvider;
}());



/***/ }),

/***/ 2805:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.wrapNodes = {
    exclude: new Set(['hr', 'style', 'br']),
    emptyBlockAfterInit: true
};


/***/ }),

/***/ 2928:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'גובה שורה'
};


/***/ }),

/***/ 3006:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ UICheckbox; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var UICheckbox = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__extends */ .C6)(UICheckbox, _super);
    /** @override **/
    function UICheckbox(jodit, options) {
        var _this = _super.call(this, jodit, (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)({}, options), { type: 'checkbox' })) || this;
        /** @override */
        _this.state = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)({}, UICheckbox_1.defaultState);
        Object.assign(_this.state, options);
        return _this;
    }
    UICheckbox_1 = UICheckbox;
    /** @override */
    UICheckbox.prototype.className = function () {
        return 'UICheckbox';
    };
    /** @override */
    UICheckbox.prototype.render = function () {
        return this.j.c.element('label', {
            className: this.componentName
        });
    };
    UICheckbox.prototype.onChangeChecked = function () {
        this.value = this.state.checked.toString();
        this.nativeInput.checked = this.state.checked;
        this.setMod('checked', this.state.checked);
    };
    UICheckbox.prototype.onChangeNativeCheckBox = function () {
        this.state.checked = this.nativeInput.checked;
    };
    UICheckbox.prototype.onChangeSwitch = function () {
        this.setMod('switch', this.state.switch);
        var slider = this.getElm('switch-slider');
        if (this.state.switch) {
            if (!slider) {
                slider = this.j.c.div(this.getFullElName('switch-slider'));
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(this.nativeInput, slider);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(slider);
        }
    };
    var UICheckbox_1;
    /** @override */
    UICheckbox.defaultState = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__assign */ .Cl)({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t.defaultState), { checked: false, switch: false });
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.checked'),
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
    ], UICheckbox.prototype, "onChangeChecked", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('nativeInput:change')
    ], UICheckbox.prototype, "onChangeNativeCheckBox", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.switch'),
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
    ], UICheckbox.prototype, "onChangeSwitch", null);
    UICheckbox = UICheckbox_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
    ], UICheckbox);
    return UICheckbox;
}(jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t));



/***/ }),

/***/ 3101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ wrap; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26150);
/* harmony import */ var _list_wrap_list__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61001);
/* harmony import */ var _wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80394);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Replaces the parent tag with the applicable one, or wraps the text and also replaces the tag
 * @private
 */
function wrap(commitStyle, font, jodit) {
    var wrapper = findOrCreateWrapper(commitStyle, font, jodit);
    return commitStyle.elementIsList
        ? (0,_list_wrap_list__WEBPACK_IMPORTED_MODULE_2__/* .wrapList */ .z)(commitStyle, wrapper, jodit)
        : jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.replace(wrapper, commitStyle.element, jodit.createInside, true);
}
var WRAP_NODES = new Set([
    'td',
    'th',
    'tr',
    'tbody',
    'table',
    'li',
    'ul',
    'ol'
]);
/**
 * If we apply a block element, then it finds the closest block parent (exclude table cell etc.),
 * otherwise it wraps free text in an element.
 */
function findOrCreateWrapper(commitStyle, font, jodit) {
    if (commitStyle.elementIsBlock) {
        var box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(font, function (node) { return jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(node) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(node, WRAP_NODES); }, jodit.editor);
        if (box) {
            return box;
        }
        return (0,_wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_3__/* .wrapUnwrappedText */ .Y)(commitStyle, font, jodit);
    }
    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(font, 'size', null);
    return font;
}


/***/ }),

/***/ 3258:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ ToolbarButton; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57023);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(931);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80071);
/* harmony import */ var jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(97394);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












var ToolbarButton = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__extends */ .C6)(ToolbarButton, _super);
    function ToolbarButton(jodit, control, target) {
        if (target === void 0) { target = null; }
        var _this = _super.call(this, jodit) || this;
        _this.control = control;
        _this.target = target;
        _this.state = (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)({}, (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButtonState */ .ue)()), { theme: 'toolbar', currentValue: '', hasTrigger: false });
        _this.openedPopup = null;
        var button = _this.getElm('button');
        void 0;
        _this.button = button;
        Object.defineProperty(button, 'component', {
            value: _this,
            configurable: true
        });
        var trigger = _this.getElm('trigger');
        void 0;
        _this.trigger = trigger;
        trigger.remove();
        // Prevent lost focus
        jodit.e.on([_this.button, _this.trigger], 'mousedown', function (e) {
            return e.preventDefault();
        });
        _this.onAction(_this.onClick);
        _this.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, function () {
            _this.__initFromControl();
            _this.update();
        });
        if (control.mods) {
            Object.keys(control.mods).forEach(function (mod) {
                control.mods && _this.setMod(mod, control.mods[mod]);
            });
        }
        return _this;
    }
    /** @override */
    ToolbarButton.prototype.className = function () {
        return 'ToolbarButton';
    };
    Object.defineProperty(ToolbarButton.prototype, "toolbar", {
        /**
         * Get parent toolbar
         */
        get: function () {
            return this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__/* .ToolbarCollection */ .Q);
        },
        enumerable: false,
        configurable: true
    });
    /** @override **/
    ToolbarButton.prototype.update = function () {
        var _a, _b;
        var _c = this, control = _c.control, state = _c.state, tc = this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__/* .ToolbarCollection */ .Q);
        if (!tc) {
            return;
        }
        var value = (_a = control.value) === null || _a === void 0 ? void 0 : _a.call(control, tc.jodit, this);
        if (value !== undefined) {
            state.value = value;
        }
        state.disabled = this.__calculateDisabledStatus(tc);
        state.activated = this.__calculateActivatedStatus(tc);
        (_b = control.update) === null || _b === void 0 ? void 0 : _b.call(control, tc.jodit, this);
    };
    /**
     * Calculates whether the button is active
     */
    ToolbarButton.prototype.__calculateActivatedStatus = function (tc) {
        var _a, _b;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(this.j) && !this.j.editorIsActive) {
            return false;
        }
        if ((_b = (_a = this.control).isActive) === null || _b === void 0 ? void 0 : _b.call(_a, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeActive(this));
    };
    /**
     * Calculates whether an element is blocked for the user
     */
    ToolbarButton.prototype.__calculateDisabledStatus = function (tc) {
        var _a, _b;
        if (this.j.o.disabled) {
            return true;
        }
        if (this.j.o.readonly &&
            (!this.j.o.activeButtonsInReadOnly ||
                !this.j.o.activeButtonsInReadOnly.includes(this.control.name))) {
            return true;
        }
        if ((_b = (_a = this.control).isDisabled) === null || _b === void 0 ? void 0 : _b.call(_a, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeDisabled(this));
    };
    /** @override */
    ToolbarButton.prototype.onChangeActivated = function () {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'aria-pressed', this.state.activated);
        _super.prototype.onChangeActivated.call(this);
    };
    /** @override */
    ToolbarButton.prototype.onChangeText = function () {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(this.control.template)) {
            this.text.innerHTML = this.control.template(this.j, this.control.name, this.j.i18n(this.state.text));
        }
        else {
            _super.prototype.onChangeText.call(this);
        }
        this.setMod('text-icons', Boolean(this.text.innerText.trim().length));
    };
    /** @override */
    ToolbarButton.prototype.onChangeTabIndex = function () {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'tabindex', this.state.tabIndex);
    };
    ToolbarButton.prototype.createContainer = function () {
        var cn = this.componentName;
        var container = this.j.c.span(cn);
        var button = _super.prototype.createContainer.call(this);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(container, 'role', 'listitem');
        button.classList.remove(cn);
        button.classList.add(cn + '__button');
        Object.defineProperty(button, 'component', {
            value: this
        });
        container.appendChild(button);
        var trigger = this.j.c.fromHTML("<span role=\"trigger\" class=\"".concat(cn, "__trigger\">").concat(jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.get('chevron'), "</span>"));
        // For caching
        button.appendChild(trigger);
        return container;
    };
    /** @override */
    ToolbarButton.prototype.focus = function () {
        var _a;
        (_a = this.container.querySelector('button')) === null || _a === void 0 ? void 0 : _a.focus();
    };
    ToolbarButton.prototype.onChangeHasTrigger = function () {
        if (this.state.hasTrigger) {
            this.container.appendChild(this.trigger);
        }
        else {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.trigger);
        }
        this.setMod('with-trigger', this.state.hasTrigger || null);
    };
    /** @override */
    ToolbarButton.prototype.onChangeDisabled = function () {
        var disabled = this.state.disabled ? 'disabled' : null;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.trigger, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'disabled', disabled);
    };
    /**
     * Init constant data from control
     */
    ToolbarButton.prototype.__initFromControl = function () {
        var _a;
        var _b = this, ctr = _b.control, state = _b.state;
        this.updateSize();
        state.name = ctr.name;
        var textIcons = this.j.o.textIcons;
        if (textIcons === true ||
            ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(textIcons) && textIcons(ctr.name)) ||
            ctr.template) {
            state.icon = (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButtonState */ .ue)().icon;
            state.text = ctr.text || ctr.name;
        }
        else {
            if (ctr.iconURL) {
                state.icon.iconURL = ctr.iconURL;
            }
            else {
                var name = ctr.icon || ctr.name;
                state.icon.name =
                    jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.exists(name) || ((_a = this.j.o.extraIcons) === null || _a === void 0 ? void 0 : _a[name])
                        ? name
                        : '';
            }
            if (!ctr.iconURL && !state.icon.name) {
                state.text = ctr.text || ctr.name;
            }
        }
        if (ctr.tooltip) {
            state.tooltip = this.j.i18n((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.tooltip)
                ? ctr.tooltip(this.j, ctr, this)
                : ctr.tooltip);
        }
        state.hasTrigger = Boolean(ctr.list || (ctr.popup && ctr.exec));
    };
    /**
     * Click on trigger button
     */
    ToolbarButton.prototype.onTriggerClick = function (e) {
        var _this = this;
        var _a, _b, _c;
        if (this.openedPopup) {
            this.__closePopup();
            return;
        }
        var ctr = this.control;
        e.buffer = {
            actionTrigger: this
        };
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.popup)) {
            var popup = this.openPopup();
            popup.parentElement = this;
            try {
                if (this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)("before-".concat(ctr.name, "-open-popup")), this.target, ctr, popup) !== false) {
                    var target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
                    var elm = ctr.popup(this.j, target, this.__closePopup, this);
                    if (elm) {
                        popup
                            .setContent((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? this.j.c.fromHTML(elm) : elm)
                            .open(function () { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(_this.container); }, false, this.j.o.allowTabNavigation
                            ? this.container
                            : undefined);
                    }
                    else {
                        this.__closePopup();
                    }
                }
            }
            catch (e) {
                this.__closePopup();
                throw e;
            }
            /**
             * Fired after the popup was opened for some control button
             */
            /**
             * Close all opened popups
             */
            this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)("after-".concat(ctr.name, "-open-popup")), popup.container);
        }
    };
    /**
     * Create an open popup list
     */
    ToolbarButton.prototype.__openControlList = function (control) {
        var _this = this;
        var _a;
        var controls = (_a = this.jodit.options.controls) !== null && _a !== void 0 ? _a : {}, getControl = function (key) {
            return (0,jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_5__/* .findControlType */ .x)(key, controls);
        };
        var list = control.list, menu = this.openPopup(), toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_9__/* .makeCollection */ .$K)(this.j);
        menu.parentElement = this;
        toolbar.parentElement = menu;
        toolbar.mode = 'vertical';
        var isListItem = function (key) {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(key) && 'title' in key && 'value' in key;
        };
        var getButton = function (key, value) {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value) && getControl(value)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)({ name: value.toString() }, getControl(value));
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(key) && getControl(key)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)({ name: key.toString() }, getControl(key)), (typeof value === 'object' ? value : {}));
            }
            if (isListItem(key)) {
                value = key.value;
                key = key.title;
            }
            var childTemplate = control.childTemplate;
            var childControl = {
                name: key.toString(),
                template: childTemplate &&
                    (function (j, k, v) { return childTemplate(j, k, v, _this); }),
                exec: control.childExec
                    ? function (view, current, options) {
                        var _a;
                        return (_a = control.childExec) === null || _a === void 0 ? void 0 : _a.call(control, view, current, (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__assign */ .Cl)({}, options), { parentControl: control }));
                    }
                    : control.exec,
                data: control.data,
                command: control.command,
                isActive: control.isChildActive,
                value: control.value,
                isDisabled: control.isChildDisabled,
                mode: control.mode,
                args: (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__spreadArray */ .fX)((0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__read */ .zs)((control.args ? control.args : [])), false), [key, value], false)
            };
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
                childControl.text = value;
            }
            return childControl;
        };
        toolbar.build((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(list)
            ? list.map(getButton)
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(list, false).map(function (key) { return getButton(key, list[key]); }), this.target);
        menu.setContent(toolbar).open(function () { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(_this.container); }, false, this.j.o.allowTabNavigation ? this.container : undefined);
        this.state.activated = true;
    };
    ToolbarButton.prototype.onOutsideClick = function (e) {
        if (!this.openedPopup) {
            return;
        }
        if (!e ||
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(e.target) ||
            (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.container, e.target) &&
                !this.openedPopup.isOwnClick(e))) {
            this.__closePopup();
        }
    };
    ToolbarButton.prototype.openPopup = function () {
        this.__closePopup();
        this.openedPopup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_7__/* .Popup */ .z(this.j, false);
        this.j.e
            .on(this.ow, 'mousedown touchstart', this.onOutsideClick)
            .on('escape closeAllPopups', this.onOutsideClick);
        return this.openedPopup;
    };
    ToolbarButton.prototype.__closePopup = function () {
        if (this.openedPopup) {
            this.j.e
                .off(this.ow, 'mousedown touchstart', this.onOutsideClick)
                .off('escape closeAllPopups', this.onOutsideClick);
            this.state.activated = false;
            this.openedPopup.close();
            this.openedPopup.destruct();
            this.openedPopup = null;
        }
    };
    /**
     * Click handler
     */
    ToolbarButton.prototype.onClick = function (originalEvent) {
        var _a, _b, _c, _d, _e, _f, _g;
        var ctr = this.control;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.exec)) {
            var target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
            var result = ctr.exec(this.j, target, {
                control: ctr,
                originalEvent: originalEvent,
                button: this
            });
            // For memorise exec
            if (result !== false && result !== true) {
                (_e = (_d = this.j) === null || _d === void 0 ? void 0 : _d.e) === null || _e === void 0 ? void 0 : _e.fire('synchro');
                if (this.parentElement) {
                    this.parentElement.update();
                }
                /**
                 * Fired after calling `button.exec` function
                 */
                (_g = (_f = this.j) === null || _f === void 0 ? void 0 : _f.e) === null || _g === void 0 ? void 0 : _g.fire('closeAllPopups afterExec');
            }
            if (result !== false) {
                return;
            }
        }
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.popup)) {
            return this.onTriggerClick(originalEvent);
        }
        if (ctr.command || ctr.name) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(this.j)
                ? this.j.execCommand.bind(this.j)
                : this.j.od.execCommand.bind(this.j.od), ctr.command || ctr.name, false, ctr.args && ctr.args[0]);
            this.j.e.fire('closeAllPopups');
        }
    };
    ToolbarButton.prototype.destruct = function () {
        this.__closePopup();
        return _super.prototype.destruct.call(this);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cacheHTML
    ], ToolbarButton.prototype, "createContainer", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.hasTrigger', { immediately: false })
    ], ToolbarButton.prototype, "onChangeHasTrigger", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('trigger:click')
    ], ToolbarButton.prototype, "onTriggerClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], ToolbarButton.prototype, "onOutsideClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], ToolbarButton.prototype, "__closePopup", null);
    ToolbarButton = (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
    ], ToolbarButton);
    return ToolbarButton;
}(jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButton */ .lD));



/***/ }),

/***/ 3268:
/***/ (function(module) {

module.exports["default"] = ["Begin met typen..","Over Jodit","Jodit Editor","Jodit gebruikershandleiding","bevat gedetailleerde informatie voor gebruik.","Voor informatie over de licentie, ga naar onze website:","Volledige versie kopen","Copyright © XDSoft.net - Chupurnov Valeriy. Alle rechten voorbehouden.","Anker","Open in nieuwe tab","Editor in volledig scherm openen","Opmaak verwijderen","Vulkleur of tekstkleur aanpassen","Opnieuw","Ongedaan maken","Vet","Cursief","Geordende list invoegen","Ongeordende lijst invoegen","Centreren","Uitlijnen op volledige breedte","Links uitlijnen","Rechts uitlijnen","Horizontale lijn invoegen","Afbeelding invoegen","Bestand invoegen","Youtube/Vimeo video invoegen","Link toevoegen","Tekstgrootte","Lettertype","Format blok invoegen","Normaal","Koptekst 1","Koptekst 2","Koptekst 3","Koptekst 4","Citaat","Code","Invoegen","Tabel invoegen","Inspringing verkleinen","Inspringing vergroten","Symbool selecteren","Symbool invoegen","Opmaak kopieren","Modus veranderen","Marges","Boven","Rechts","Onder","Links","CSS styles","CSS classes","Uitlijning","Rechts","Gecentreerd","Links","--Leeg--","Src","Titel","Alternatieve tekst","Link","Link in nieuwe tab openen","Afbeelding","Bestand","Geavanceerd","Afbeeldingseigenschappen","Annuleren","OK","Bestandsbrowser","Fout bij het laden van de lijst","Fout bij het laden van de mappenlijst","Weet je het zeker?","Geef de map een naam","Map aanmaken","Type naam","Sleep hier een afbeelding naartoe","Sleep hier een bestand naartoe","of klik","Alternatieve tekst","Uploaden","Bladeren","Achtergrond","Tekst","Boven","Midden","Onder","Kolom invoegen (voor)","Kolom invoegen (na)","Rij invoegen (boven)","Rij invoegen (onder)","Tabel verwijderen","Rij verwijderen","Kolom verwijderen","Cel leegmaken","Tekens: %d","Woorden: %d","Doorstrepen","Onderstrepen","Superscript","Subscript","Selectie knippen","Selecteer alles","Enter","Zoek naar","Vervangen door","Vervangen","Plakken","Kies content om te plakken","Broncode","vet","cursief","kwast","link","ongedaan maken","opnieuw","tabel","afbeelding","gum","paragraaf","lettergrootte","video","lettertype","over","afdrukken","onderstreept","doorgestreept","inspringen","minder inspringen","volledige grootte","kleiner maken","horizontale lijn","lijst","genummerde lijst","knip","alles selecteren","Embed code","Link openen","Link aanpassen","Niet volgen","link verwijderen","Updaten","Om te bewerken","Recensie"," URL","Bewerken","Horizontaal uitlijnen","Filteren","Sorteren op wijzigingsdatum","Sorteren op naam","Sorteren op grootte","Map toevoegen","Herstellen","Opslaan","Opslaan als ...","Grootte aanpassen","Bijknippen","Breedte","Hoogte","Verhouding behouden","Ja","Nee","Verwijderen","Selecteren","Selecteer: %s","Verticaal uitlijnen","Splitsen","Samenvoegen","Kolom toevoegen","Rij toevoegen",null,"Verwijderen","Verticaal splitsen","Horizontaal splitsen","Rand","Deze code lijkt op HTML. Als HTML behouden?","Invoegen als HTML","Origineel behouden","Als tekst invoegen","Als onopgemaakte tekst invoegen","Je kunt alleen je eigen afbeeldingen aanpassen. Deze afbeelding downloaden?","De afbeelding is succesvol geüploadet!","Palette","Er zijn geen bestanden in deze map.","Hernoemen","Voer een nieuwe naam in","Voorvertoning","Download","Plakken van klembord","Uw browser ondersteunt geen directe toegang tot het klembord.","Selectie kopiëren","kopiëren","Border radius","Toon alle","Toepassen","Vul dit veld in","Voer een webadres in","Standaard","Cirkel","Punt","Kwadraat","Zoeken","Vorige Zoeken","Volgende Zoeken","De geplakte tekst is afkomstig van een Microsoft Word/Excel document. Wil je de opmaak behouden of opschonen?","Word-tekst gedetecteerd","Opschonen","Voeg de klassenaam in","Druk op Alt voor aangepaste grootte"]

/***/ }),

/***/ 3392:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i: function() { return /* binding */ getKey; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/indent
 */

/**
 * Get style rule key for current direction
 * @internal
 */
var getKey = function (direction, box) {
    return "".concat(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isCell(box) ? 'padding' : 'margin').concat(direction === 'rtl' ? 'Right' : 'Left');
};


/***/ }),

/***/ 3459:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export inlinePopup */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_ui_popup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(96369);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8809);
/* harmony import */ var _config_config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











/**
 * Plugin for show inline popup dialog
 */
var inlinePopup = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__extends */ .C6)(inlinePopup, _super);
    function inlinePopup() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__read */ .zs)(arguments), false)) || this;
        _this.type = null;
        _this.snapRange = null;
        _this.elmsList = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(_this.j.o.popup, false).filter(function (s) { return !_this.isExcludedTarget(s); });
        return _this;
    }
    Object.defineProperty(inlinePopup.prototype, "popup", {
        get: function () {
            return new jodit_core_ui_popup__WEBPACK_IMPORTED_MODULE_6__/* .Popup */ .z(this.jodit, false);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(inlinePopup.prototype, "toolbar", {
        get: function () {
            return (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__/* .makeCollection */ .$K)(this.jodit, this.popup);
        },
        enumerable: false,
        configurable: true
    });
    inlinePopup.prototype.onClick = function (node) {
        var _this = this;
        var elements = this.elmsList, target = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(node, 'img')
            ? node
            : jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(node, elements, this.j.editor);
        if (target && this.canShowPopupForType(target.nodeName.toLowerCase())) {
            this.showPopup(function () { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(target, _this.j); }, target.nodeName.toLowerCase(), target);
            return false;
        }
    };
    /**
     * Show inline popup with some toolbar
     *
     * @param type - selection, img, a etc.
     */
    inlinePopup.prototype.showPopup = function (rect, type, target) {
        type = type.toLowerCase();
        if (!this.canShowPopupForType(type)) {
            return false;
        }
        if (this.type !== type || target !== this.previousTarget) {
            this.previousTarget = target;
            var data = this.j.o.popup[type];
            var content = void 0;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(data)) {
                content = data(this.j, target, this.popup.close);
            }
            else {
                content = data;
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(content)) {
                this.toolbar.build(content, target);
                this.toolbar.buttonSize = this.j.o.toolbarButtonSize;
                content = this.toolbar.container;
            }
            this.popup.setContent(content);
            this.type = type;
        }
        this.popup.open(rect);
        return true;
    };
    /**
     * Hide opened popup
     */
    inlinePopup.prototype.hidePopup = function (type) {
        if (this.popup.isOpened && (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(type) || type === this.type)) {
            this.popup.close();
        }
    };
    inlinePopup.prototype.onOutsideClick = function () {
        this.popup.close();
    };
    /**
     * Can show popup for this type
     */
    inlinePopup.prototype.canShowPopupForType = function (type) {
        var data = this.j.o.popup[type.toLowerCase()];
        if (this.j.o.readonly || !this.j.o.toolbarInline || !data) {
            return false;
        }
        return !this.isExcludedTarget(type);
    };
    /**
     * For some elements do not show popup
     */
    inlinePopup.prototype.isExcludedTarget = function (type) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.splitArray)(this.j.o.toolbarInlineDisableFor)
            .map(function (a) { return a.toLowerCase(); })
            .includes(type.toLowerCase());
    };
    /** @override **/
    inlinePopup.prototype.afterInit = function (jodit) {
        var _this = this;
        this.j.e
            .on('getDiffButtons.mobile', function (toolbar) {
            if (_this.toolbar === toolbar) {
                var names_1 = _this.toolbar.getButtonsNames();
                return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(jodit.registeredButtons)
                    .filter(function (btn) {
                    return !_this.j.o.toolbarInlineDisabledButtons.includes(btn.name);
                })
                    .filter(function (item) {
                    var name = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(item) ? item : item.name;
                    return (name &&
                        name !== '|' &&
                        name !== '\n' &&
                        !names_1.includes(name));
                });
            }
        })
            .on('hidePopup', this.hidePopup)
            .on('showInlineToolbar', this.showInlineToolbar)
            .on('showPopup', function (elm, rect, type) {
            _this.showPopup(rect, type || ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? elm : elm.nodeName), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? undefined : elm);
        })
            .on('mousedown keydown', this.onSelectionStart)
            .on('change', function () {
            if (_this.popup.isOpened &&
                _this.previousTarget &&
                !_this.previousTarget.parentNode) {
                _this.hidePopup();
                _this.previousTarget = undefined;
            }
        })
            .on([this.j.ew, this.j.ow], 'mouseup keyup', this.onSelectionEnd);
        this.addListenersForElements();
    };
    inlinePopup.prototype.onSelectionStart = function () {
        this.snapRange = this.j.s.range.cloneRange();
    };
    inlinePopup.prototype.onSelectionEnd = function (e) {
        if (e &&
            e.target &&
            jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D$.closestElement(e.target, jodit_core_ui_popup__WEBPACK_IMPORTED_MODULE_6__/* .Popup */ .z)) {
            return;
        }
        var snapRange = this.snapRange, range = this.j.s.range;
        if (!snapRange ||
            range.collapsed ||
            range.startContainer !== snapRange.startContainer ||
            range.startOffset !== snapRange.startOffset ||
            range.endContainer !== snapRange.endContainer ||
            range.endOffset !== snapRange.endOffset) {
            this.onSelectionChange();
        }
    };
    /**
     * Selection change handler
     */
    inlinePopup.prototype.onSelectionChange = function () {
        if (!this.j.o.toolbarInlineForSelection) {
            return;
        }
        var type = 'selection';
        var sel = this.j.s.sel;
        var range = this.j.s.range;
        if ((sel === null || sel === void 0 ? void 0 : sel.isCollapsed) || this.isSelectedTarget(range)) {
            if (this.type === type && this.popup.isOpened) {
                this.hidePopup();
            }
            return;
        }
        var node = this.j.s.current();
        if (!node) {
            return;
        }
        this.showPopup(function () { return range.getBoundingClientRect(); }, type);
    };
    /**
     * In not collapsed selection - only one image
     */
    inlinePopup.prototype.isSelectedTarget = function (r) {
        var sc = r.startContainer;
        return (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sc) &&
            sc === r.endContainer &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sc.childNodes[r.startOffset], new Set((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(this.j.o.popup, false))) &&
            r.startOffset === r.endOffset - 1);
    };
    /**
     * Shortcut for Table module
     */
    // private get tableModule(): Table {
    // 	return this.j.getInstance<Table>('Table', this.j.o);
    // }
    /** @override **/
    inlinePopup.prototype.beforeDestruct = function (jodit) {
        jodit.e
            .off('showPopup')
            .off([this.j.ew, this.j.ow], 'mouseup keyup', this.onSelectionEnd);
        this.removeListenersForElements();
    };
    inlinePopup.prototype._eventsList = function () {
        var el = this.elmsList;
        return el
            .map(function (e) { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)("click_".concat(e)); })
            .concat(el.map(function (e) { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)("touchstart_".concat(e)); }))
            .join(' ');
    };
    inlinePopup.prototype.addListenersForElements = function () {
        this.j.e.on(this._eventsList(), this.onClick);
    };
    inlinePopup.prototype.removeListenersForElements = function () {
        this.j.e.off(this._eventsList(), this.onClick);
    };
    /**
     * Show the inline WYSIWYG toolbar editor.
     */
    inlinePopup.prototype.showInlineToolbar = function (bound) {
        var _this = this;
        this.showPopup(function () {
            if (bound) {
                return bound;
            }
            var range = _this.j.s.range;
            return range.getBoundingClientRect();
        }, 'toolbar');
    };
    inlinePopup.requires = ['select'];
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
    ], inlinePopup.prototype, "popup", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
    ], inlinePopup.prototype, "toolbar", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], inlinePopup.prototype, "onClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.wait)(function (ctx) { return !ctx.j.isLocked; })
    ], inlinePopup.prototype, "showPopup", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':clickEditor', ':beforeCommandDelete', ':backSpaceAfterDelete']),
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], inlinePopup.prototype, "hidePopup", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':outsideClick')
    ], inlinePopup.prototype, "onOutsideClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], inlinePopup.prototype, "onSelectionStart", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], inlinePopup.prototype, "onSelectionEnd", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.debounce)(function (ctx) { return ctx.defaultTimeout; })
    ], inlinePopup.prototype, "onSelectionChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], inlinePopup.prototype, "showInlineToolbar", null);
    return inlinePopup;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('inlinePopup', inlinePopup);


/***/ }),

/***/ 3593:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   allowAttributes: function() { return /* reexport safe */ _allow_attributes__WEBPACK_IMPORTED_MODULE_0__.f; },
/* harmony export */   fillEmptyParagraph: function() { return /* reexport safe */ _fill_empty_paragraph__WEBPACK_IMPORTED_MODULE_1__.f; },
/* harmony export */   removeEmptyTextNode: function() { return /* reexport safe */ _remove_empty_text_node__WEBPACK_IMPORTED_MODULE_2__.r; },
/* harmony export */   removeInvTextNodes: function() { return /* reexport safe */ _remove_inv_text_nodes__WEBPACK_IMPORTED_MODULE_3__.u; },
/* harmony export */   replaceOldTags: function() { return /* reexport safe */ _replace_old_tags__WEBPACK_IMPORTED_MODULE_4__.H; },
/* harmony export */   sanitizeAttributes: function() { return /* reexport safe */ _sanitize_attributes__WEBPACK_IMPORTED_MODULE_5__.L; },
/* harmony export */   tryRemoveNode: function() { return /* reexport safe */ _try_remove_node__WEBPACK_IMPORTED_MODULE_6__.k; }
/* harmony export */ });
/* harmony import */ var _allow_attributes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5232);
/* harmony import */ var _fill_empty_paragraph__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63443);
/* harmony import */ var _remove_empty_text_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(926);
/* harmony import */ var _remove_inv_text_nodes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67431);
/* harmony import */ var _replace_old_tags__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81199);
/* harmony import */ var _sanitize_attributes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32782);
/* harmony import */ var _try_remove_node__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32014);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/clean-html
 */
/**
 * @private
 */









/***/ }),

/***/ 3843:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 16 16\"> <path stroke-width=\"0\" d=\"M16 9v-6h-3v-1c0-0.55-0.45-1-1-1h-11c-0.55 0-1 0.45-1 1v3c0 0.55 0.45 1 1 1h11c0.55 0 1-0.45 1-1v-1h2v4h-9v2h-0.5c-0.276 0-0.5 0.224-0.5 0.5v5c0 0.276 0.224 0.5 0.5 0.5h2c0.276 0 0.5-0.224 0.5-0.5v-5c0-0.276-0.224-0.5-0.5-0.5h-0.5v-1h9zM12 3h-11v-1h11v1z\"/> </svg>"

/***/ }),

/***/ 3947:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ isInt; }
/* harmony export */ });
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12461);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */


/**
 * Check value is Int
 */
function isInt(value) {
    if ((0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(value) && (0,_is_numeric__WEBPACK_IMPORTED_MODULE_1__/* .isNumeric */ .k)(value)) {
        value = parseFloat(value);
    }
    return typeof value === 'number' && Number.isFinite(value) && !(value % 1);
}


/***/ }),

/***/ 4410:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'ラインの高さ'
};


/***/ }),

/***/ 4679:
/***/ (function(module) {

module.exports["default"] = ["Ketik sesuatu","Tentang Jodit","Editor Jodit","Panduan Pengguna Jodit","mencakup detail bantuan penggunaan","Untuk informasi tentang lisensi, silakan kunjungi website:","Beli versi lengkap","Hak Cipta © XDSoft.net - Chupurnov Valeriy. Hak cipta dilindungi undang-undang.","Tautan","Buka di tab baru","Buka editor dalam ukuran penuh","Hapus Pemformatan","Isi warna atau atur warna teks","Ulangi","Batalkan","Tebal","Miring","Sisipkan Daftar Tidak Berurut","Sisipkan Daftar Berurut","Tengah","Penuh","Kiri","Kanan","Sisipkan Garis Horizontal","Sisipkan Gambar","Sisipkan Berkas","Sisipkan video youtube/vimeo","Sisipkan tautan","Ukuran font","Keluarga font","Sisipkan blok format","Normal","Heading 1","Heading 2","Heading 3","Heading 4","Kutip","Kode","Sisipkan","Sisipkan tabel","Kurangi Indentasi","Tambah Indentasi","Pilih Karakter Spesial","Sisipkan Karakter Spesial","Formar warna","Ubah mode","Batas","atas","kanan","bawah","kiri","Gaya","Class","Rata","Kanan","Tengah","Kiri","--Tidak diset--","Src","Judul","Teks alternatif","Tautan","Buka tautan di tab baru","Gambar","berkas","Lanjutan","Properti gambar","Batal","Ya","Penjelajah Berkas","Error ketika memuat list","Error ketika memuat folder","Apakah Anda yakin?","Masukkan nama Direktori","Buat direktori","ketik nama","Letakkan gambar","Letakkan berkas","atau klik","Teks alternatif","Unggah","Jelajahi","Latar Belakang","Teks","Atas","Tengah","Bawah","Sisipkan kolom sebelumnya","Sisipkan kolom setelahnya","Sisipkan baris di atasnya","Sisipkan baris di bawahnya","Hapus tabel","Hapus baris","Hapus kolom","Kosongkan cell","Karakter: %d","Kata: %d","Coret","Garis Bawah","Superskrip","Subskrip","Potong pilihan","Pilih semua","Berhenti","Mencari","Ganti dengan","Mengganti","Paste","Pilih konten untuk dipaste","sumber","tebal","miring","sikat","tautan","batalkan","ulangi","tabel","gambar","penghapus","paragraf","ukuran font","video","font","tentang","cetak","garis bawah","coret","menjorok ke dalam","menjorok ke luar","ukuran penuh","menyusut","hr","ul","ol","potong","Pilih semua","Kode embed","Buka tautan","Edit tautan","No follow","Hapus tautan","Perbarui","pensil","Mata","URL","Edit","Perataan horizontal","Filter","Urutkan berdasarkan perubahan","Urutkan berdasarkan nama","Urutkan berdasarkan ukuran","Tambah folder","Reset","Simpan","Simpan sebagai...","Ubah ukuran","Crop","Lebar","Tinggi","Jaga aspek rasio","Ya","Tidak","Copot","Pilih","Pilih %s","Rata vertikal","Bagi","Gabungkan","Tambah kolom","tambah baris","Lisensi: %s","Hapus","Bagi secara vertikal","Bagi secara horizontal","Bingkai","Kode Anda cenderung ke HTML. Biarkan sebagai HTML?","Paste sebagai HTML","Jaga","Sisipkan sebagai teks","Sisipkan hanya teks","Anda hanya dapat mengedit gambar Anda sendiri. Unduh gambar ini di host?","Gambar telah sukses diunggah ke host!","palet","Tidak ada berkas","ganti nama","Masukkan nama baru","pratinjau","Unduh","Paste dari clipboard","Browser anda tidak mendukung akses langsung ke clipboard.","Copy seleksi","copy","Border radius","Tampilkan semua","Menerapkan","Silahkan mengisi kolom ini","Silahkan masukkan alamat web","Default","Lingkaran","Dot","Kuadrat","Menemukan","Menemukan Sebelumnya","Menemukan Berikutnya","Konten dipaste dari dokumen Microsoft Word/Excel. Apakah Anda ingin tetap menjaga format atau membersihkannya?","Terdeteksi paste dari Word","Bersih","Masukkan nama kelas","Tekan Alt untuk mengubah ukuran kustom"]

/***/ }),

/***/ 4726:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 4909:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ TabsWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Build tabs system
 *
 * @param tabs - PlainObject where 'key' will be tab's Title and `value` is tab's content
 * @param state - You can use for this param any HTML element for remembering active tab
 *
 * @example
 * ```javascript
 * const editor = Jodit.make('#editor');
 * const tabs = Jodit.modules.TabsWidget(editor, [
 *  { name: 'Images', content: '<div>Images</div>' },
 *  {
 *    name: 'Title 2',
 *    content: editor.c.fromHTML('<div>Some content</div>')
 *  },
 *  {
 *    name: 'Color Picker',
 *    content: ColorPickerWidget(
 *      editor,
 *      function (color) {
 *        box.style.color = color;
 *      },
 *      box.style.color
 *    )
 *  }
 * ]);
 * ```
 */
var TabsWidget = function (jodit, tabs, state) {
    var box = jodit.c.div('jodit-tabs');
    var tabBox = jodit.c.div('jodit-tabs__wrapper');
    var buttons = jodit.c.div('jodit-tabs__buttons');
    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__/* .attr */ .C)(buttons, {
        role: 'tablist',
        'aria-orientation': 'horizontal'
    });
    var nameToTab = {};
    var buttonList = [];
    var firstTab = '';
    box.appendChild(buttons);
    box.appendChild(tabBox);
    var setActive = function (tab) {
        if (!nameToTab[tab]) {
            return;
        }
        buttonList.forEach(function (b) {
            b.state.activated = false;
        });
        Object.values(nameToTab).forEach(function (_a) {
            var tab = _a.tab;
            return tab.classList.remove('jodit-tab_active');
        });
        nameToTab[tab].button.state.activated = true;
        nameToTab[tab].tab.classList.add('jodit-tab_active');
    };
    tabs.forEach(function (_a) {
        var icon = _a.icon, name = _a.name, content = _a.content;
        var tab = jodit.c.div('jodit-tab');
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__/* .attr */ .C)(tab, {
            role: 'tabpanel'
        });
        var button = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__/* .Button */ .$n)(jodit, icon || name, name);
        button.state.role = 'tab';
        // Stop lose the focus
        jodit.e.on(button.container, 'pointerdown', function (e) {
            return e.preventDefault();
        });
        if (!firstTab) {
            firstTab = name;
        }
        buttons.appendChild(button.container);
        buttonList.push(button);
        button.container.classList.add('jodit-tabs__button', 'jodit-tabs__button_columns_' + tabs.length);
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .T)(content)) {
            tab.appendChild(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(content, jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__/* .UIElement */ .D$)
                ? content.container
                : content);
        }
        else {
            tab.appendChild(jodit.c.div('jodit-tab_empty'));
        }
        tabBox.appendChild(tab);
        button.onAction(function () {
            setActive(name);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .T)(content) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(content)) {
                content.call(jodit);
            }
            if (state) {
                state.activeTab = name;
            }
            return false;
        });
        nameToTab[name] = {
            button: button,
            tab: tab
        };
    });
    Object.values(nameToTab).forEach(function (_a) {
        var button = _a.button;
        button.container.style.width = (100 / tabs.length).toFixed(10) + '%';
    });
    var tab = !state || !state.activeTab || !nameToTab[state.activeTab]
        ? firstTab
        : state.activeTab;
    setActive(tab);
    if (state) {
        var activeTab_1 = state.activeTab;
        Object.defineProperty(state, 'activeTab', {
            configurable: true,
            enumerable: false,
            get: function () {
                return activeTab_1;
            },
            set: function (value) {
                activeTab_1 = value;
                setActive(value);
            }
        });
    }
    return box;
};


/***/ }),

/***/ 4960:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ htmlspecialchars; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */

/**
 * Convert special characters to HTML entities
 */
function htmlspecialchars(html) {
    var tmp = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('div');
    tmp.textContent = html;
    return tmp.innerHTML;
}


/***/ }),

/***/ 5232:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ allowAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @private
 */
function allowAttributes(jodit, nodeElm, hadEffect, allow) {
    if (allow && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(nodeElm) && allow[nodeElm.nodeName] !== true) {
        var attrs = nodeElm.attributes;
        if (attrs && attrs.length) {
            var removeAttrs = [];
            for (var i = 0; i < attrs.length; i += 1) {
                var attr = allow[nodeElm.nodeName][attrs[i].name];
                if (!attr || (attr !== true && attr !== attrs[i].value)) {
                    removeAttrs.push(attrs[i].name);
                }
            }
            if (removeAttrs.length) {
                hadEffect = true;
            }
            removeAttrs.forEach(function (attr) {
                nodeElm.removeAttribute(attr);
            });
        }
    }
    return hadEffect;
}


/***/ }),

/***/ 5298:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   W: function() { return /* binding */ moveNodeInsideStart; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Moves the fake node inside the adjacent element if it lies next to it but not inside.
 * When the cursor is positioned in its place, it must be inside the element and not outside its border.
 * @private
 */
function moveNodeInsideStart(j, node, start) {
    var sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(node, start), anotherSibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(node, !start);
    while (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sibling) &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sibling, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS) &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isContentEditable(sibling, j.editor) &&
        (!anotherSibling || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(node, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement, j.editor))) {
        if (start || !sibling.firstChild) {
            sibling.appendChild(node);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(sibling.firstChild, node);
        }
        sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.sibling(node, start);
        anotherSibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.sibling(node, !start);
    }
}


/***/ }),

/***/ 5454:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ UITextArea; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var UITextArea = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__extends */ .C6)(UITextArea, _super);
    function UITextArea(jodit, state) {
        var _this = _super.call(this, jodit, state) || this;
        /** @override */
        _this.state = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__assign */ .Cl)({}, UITextArea_1.defaultState);
        Object.assign(_this.state, state);
        if (_this.state.resizable === false) {
            _this.nativeInput.style.resize = 'none';
        }
        return _this;
    }
    UITextArea_1 = UITextArea;
    /** @override */
    UITextArea.prototype.className = function () {
        return 'UITextArea';
    };
    UITextArea.prototype.createNativeInput = function (options) {
        return this.j.create.element('textarea');
    };
    UITextArea.prototype.onChangeStateSize = function () {
        var _a = this.state, size = _a.size, resizable = _a.resizable;
        this.nativeInput.style.resize = resizable ? 'auto' : 'none';
        this.nativeInput.rows = size !== null && size !== void 0 ? size : 5;
    };
    var UITextArea_1;
    /** @override */
    UITextArea.defaultState = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__assign */ .Cl)({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { size: 5, resizable: true });
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(['state.size', 'state.resizable'])
    ], UITextArea.prototype, "onChangeStateSize", null);
    UITextArea = UITextArea_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
    ], UITextArea);
    return UITextArea;
}(jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t));



/***/ }),

/***/ 5533:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ AceEditor; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53380);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




var AceEditor = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__extends */ .C6)(AceEditor, _super);
    function AceEditor() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__read */ .zs)(arguments), false)) || this;
        _this.className = 'jodit_ace_editor';
        /**
         * Proxy Method
         */
        _this.proxyOnBlur = function (e) {
            _this.j.e.fire('blur', e);
        };
        _this.proxyOnFocus = function (e) {
            _this.j.e.fire('focus', e);
        };
        _this.proxyOnMouseDown = function (e) {
            _this.j.e.fire('mousedown', e);
        };
        return _this;
    }
    AceEditor.prototype.aceExists = function () {
        return this.j.ow.ace !== undefined;
    };
    AceEditor.prototype.getLastColumnIndex = function (row) {
        return this.instance.session.getLine(row).length;
    };
    AceEditor.prototype.getLastColumnIndices = function () {
        var rows = this.instance.session.getLength();
        var lastColumnIndices = [];
        var lastColIndex = 0;
        for (var i = 0; i < rows; i++) {
            lastColIndex += this.getLastColumnIndex(i);
            if (i > 0) {
                lastColIndex += 1;
            }
            lastColumnIndices[i] = lastColIndex;
        }
        return lastColumnIndices;
    };
    AceEditor.prototype.getRowColumnIndices = function (characterIndex) {
        var lastColumnIndices = this.getLastColumnIndices();
        if (characterIndex <= lastColumnIndices[0]) {
            return { row: 0, column: characterIndex };
        }
        var row = 1;
        for (var i = 1; i < lastColumnIndices.length; i++) {
            if (characterIndex > lastColumnIndices[i]) {
                row = i + 1;
            }
        }
        var column = characterIndex - lastColumnIndices[row - 1] - 1;
        return { row: row, column: column };
    };
    AceEditor.prototype.setSelectionRangeIndices = function (start, end) {
        var startRowColumn = this.getRowColumnIndices(start);
        var endRowColumn = this.getRowColumnIndices(end);
        this.instance.getSelection().setSelectionRange({
            start: startRowColumn,
            end: endRowColumn
        });
    };
    AceEditor.prototype.getIndexByRowColumn = function (row, column) {
        var lastColumnIndices = this.getLastColumnIndices();
        return lastColumnIndices[row] - this.getLastColumnIndex(row) + column;
    };
    AceEditor.prototype.init = function (editor) {
        var _this = this;
        var tryInitAceEditor = function () {
            if (_this.instance !== undefined || !_this.aceExists()) {
                return;
            }
            var fakeMirror = _this.j.c.div('jodit-source__mirror-fake');
            _this.container.appendChild(fakeMirror);
            var ace = editor.ow.ace;
            _this.instance = ace.edit(fakeMirror);
            if (editor.o.direction === 'rtl') {
                _this.instance.setOption('rtlText', true);
                _this.instance.setOption('rtl', true);
            }
            _this.instance.setTheme(editor.o.sourceEditorNativeOptions.theme);
            _this.instance.renderer.setShowGutter(editor.o.sourceEditorNativeOptions.showGutter);
            _this.instance
                .getSession()
                .setMode(editor.o.sourceEditorNativeOptions.mode);
            _this.instance.setHighlightActiveLine(editor.o.sourceEditorNativeOptions.highlightActiveLine);
            _this.instance.getSession().setUseWrapMode(true);
            _this.instance.setOption('indentedSoftWrap', false);
            _this.instance.setOption('wrap', editor.o.sourceEditorNativeOptions.wrap);
            _this.instance.getSession().setUseWorker(false);
            _this.instance.$blockScrolling = Infinity;
            _this.instance.on('change', _this.toWYSIWYG);
            _this.instance.on('focus', _this.proxyOnFocus);
            _this.instance.on('mousedown', _this.proxyOnMouseDown);
            _this.instance.on('blur', _this.proxyOnBlur);
            if (editor.getRealMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
                _this.setValue(_this.getValue());
            }
            var onResize = _this.j.async.throttle(function () {
                if (editor.isInDestruct ||
                    editor.getMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
                    return;
                }
                var hasFocus = _this.instance.isFocused();
                if (editor.o.height !== 'auto') {
                    _this.instance.setOption('maxLines', editor.workplace.offsetHeight /
                        _this.instance.renderer.lineHeight);
                }
                else {
                    _this.instance.setOption('maxLines', Infinity);
                }
                _this.instance.resize();
                hasFocus && _this.focus();
            }, _this.j.defaultTimeout * 2);
            editor.e
                .on(editor, 'resize', onResize)
                .on('afterResize afterSetMode', onResize);
            onResize();
            _this.onReady();
        };
        editor.e.on('afterSetMode', function () {
            if (editor.getRealMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE &&
                editor.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT) {
                return;
            }
            _this.fromWYSIWYG();
            tryInitAceEditor();
        });
        tryInitAceEditor();
        // global add ace editor in browser
        if (!this.aceExists()) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.loadNext)(editor, editor.o.sourceEditorCDNUrlsJS)
                .then(function () {
                if (!editor.isInDestruct) {
                    tryInitAceEditor();
                }
            })
                .catch(function () { return null; });
        }
    };
    AceEditor.prototype.destruct = function () {
        var _a, _b;
        this.instance.off('change', this.toWYSIWYG);
        this.instance.off('focus', this.proxyOnFocus);
        this.instance.off('mousedown', this.proxyOnMouseDown);
        this.instance.destroy();
        (_b = (_a = this.j) === null || _a === void 0 ? void 0 : _a.events) === null || _b === void 0 ? void 0 : _b.off('aceInited.source');
    };
    AceEditor.prototype.setValue = function (value) {
        if (!this.j.o.editHTMLDocumentMode && this.j.o.beautifyHTML) {
            var html = this.j.e.fire('beautifyHTML', value);
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isString)(html)) {
                value = html;
            }
        }
        this.instance.setValue(value);
        this.instance.clearSelection();
    };
    AceEditor.prototype.getValue = function () {
        return this.instance.getValue();
    };
    AceEditor.prototype.setReadOnly = function (isReadOnly) {
        this.instance.setReadOnly(isReadOnly);
    };
    Object.defineProperty(AceEditor.prototype, "isFocused", {
        get: function () {
            return this.instance.isFocused();
        },
        enumerable: false,
        configurable: true
    });
    AceEditor.prototype.focus = function () {
        this.instance.container.focus();
        this.instance.focus();
    };
    AceEditor.prototype.blur = function () {
        this.instance.blur();
    };
    AceEditor.prototype.getSelectionStart = function () {
        var range = this.instance.selection.getRange();
        return this.getIndexByRowColumn(range.start.row, range.start.column);
    };
    AceEditor.prototype.getSelectionEnd = function () {
        var range = this.instance.selection.getRange();
        return this.getIndexByRowColumn(range.end.row, range.end.column);
    };
    AceEditor.prototype.selectAll = function () {
        this.instance.selection.selectAll();
    };
    AceEditor.prototype.insertRaw = function (html) {
        var start = this.instance.selection.getCursor(), end = this.instance.session.insert(start, html);
        this.instance.selection.setRange({
            start: start,
            end: end
        }, false);
    };
    AceEditor.prototype.setSelectionRange = function (start, end) {
        this.setSelectionRangeIndices(start, end);
    };
    AceEditor.prototype.setPlaceHolder = function (title) {
        // ACE does not support placeholder
        // title
    };
    AceEditor.prototype.replaceUndoManager = function () {
        var history = this.jodit.history;
        this.instance.commands.addCommand({
            name: 'Undo',
            bindKey: { win: 'Ctrl-Z', mac: 'Command-Z' },
            exec: function () {
                history.undo();
            }
        });
        this.instance.commands.addCommand({
            name: 'Redo',
            bindKey: { win: 'Ctrl-Shift-Z', mac: 'Command-Shift-Z' },
            exec: function () {
                history.redo();
            }
        });
    };
    return AceEditor;
}(jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_2__/* .SourceEditor */ .F));



/***/ }),

/***/ 5549:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ readValuesFromImage; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var _align__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74260);
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33201);
/* harmony import */ var _margin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85079);
/* harmony import */ var _size__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17880);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Read values from image and set it to state
 * @private
 */
function readValuesFromImage(j, state) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
        var image, values;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__generator */ .YH)(this, function (_a) {
            image = state.sourceImage, values = state.values;
            (0,_align__WEBPACK_IMPORTED_MODULE_4__/* .readAlign */ .g)(image, values);
            // Border radius
            values.borderRadius = parseInt(image.style.borderRadius || '0', 10) || 0;
            // Id
            values.id = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'id') || '';
            // Title
            values.imageTitle = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'title') || '';
            // Alt
            values.imageAlt = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'alt') || '';
            // Style
            values.style = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'style') || '';
            // Classes
            values.classes = ((0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'class') || '').replace(/jodit_focused_image[\s]*/, '');
            // Margins
            (0,_margin__WEBPACK_IMPORTED_MODULE_5__/* .readMargins */ .E)(image, values, state);
            // Link
            (0,_link__WEBPACK_IMPORTED_MODULE_1__/* .readLink */ .X)(state, j, values);
            // Src
            values.imageSrc = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'src') || '';
            // Image size
            return [2 /*return*/, (0,_size__WEBPACK_IMPORTED_MODULE_2__/* .readSizes */ .P)(image, values, state)];
        });
    });
}


/***/ }),

/***/ 5832:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IB: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.I; },
/* harmony export */   P1: function() { return /* reexport safe */ _content__WEBPACK_IMPORTED_MODULE_1__.P; },
/* harmony export */   q4: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_2__.q; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3258);
/* harmony import */ var _content__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49405);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48053);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/toolbar/button
 */





/***/ }),

/***/ 5854:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ Alert; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_as_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82317);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Show `alert` dialog. Work without Jodit object
 * @example
 * ```javascript
 * Jodit.Alert("File was uploaded");
 * Jodit.Alert("File was uploaded", "Message");
 * Jodit.Alert("File was uploaded", function() {
 *    $('form').hide();
 * });
 * Jodit.Alert("File wasn't uploaded", "Error", function() {
 *    $('form').hide();
 * });
 * ```
 */
function Alert(msg, title, callback, className) {
    if (className === void 0) { className = 'jodit-dialog_alert'; }
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    var dialog = this instanceof _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l
        ? this
        : new _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l({ closeOnClickOverlay: true }), container = dialog.c.div(className), okButton = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(dialog, 'ok', 'Ok');
    (0,jodit_core_helpers_array_as_array__WEBPACK_IMPORTED_MODULE_4__/* .asArray */ ._)(msg).forEach(function (oneMessage) {
        container.appendChild(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(oneMessage) ? oneMessage : dialog.c.fromHTML(oneMessage));
    });
    okButton.onAction(function () {
        if (!callback || !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(callback) || callback(dialog) !== false) {
            dialog.close();
        }
    });
    dialog.setFooter([okButton]);
    dialog.open(container, title || '&nbsp;', true, true);
    okButton.focus();
    return dialog;
}


/***/ }),

/***/ 5878:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Kopyalama Biçimi'
};


/***/ }),

/***/ 5929:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export deleteCommand */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







var deleteCommand = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__extends */ .C6)(deleteCommand, _super);
    function deleteCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    deleteCommand.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit.e.on('afterCommand.delete', function (command) {
            if (command === 'delete') {
                _this.__afterDeleteCommand();
            }
        });
        jodit.registerCommand('delete', {
            exec: this.__onDeleteCommand.bind(this)
        }, {
            stopPropagation: false
        });
    };
    deleteCommand.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('afterCommand.delete');
    };
    /**
     * After Delete command remove extra BR
     */
    deleteCommand.prototype.__afterDeleteCommand = function () {
        var jodit = this.j;
        var current = jodit.s.current();
        if (current && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(current.firstChild, 'br')) {
            jodit.s.removeNode(current.firstChild);
        }
        if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)(jodit.editor.textContent || '') &&
            !jodit.editor.querySelector('img,table,jodit,iframe,hr') &&
            (!current || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(current, 'table', jodit.editor))) {
            jodit.editor.innerHTML = '';
            var node = jodit.s.setCursorIn(jodit.editor);
            jodit.s.removeNode(node);
        }
    };
    deleteCommand.prototype.__onDeleteCommand = function () {
        var jodit = this.jodit;
        if (jodit.s.isCollapsed()) {
            return;
        }
        jodit.s.expandSelection();
        var range = jodit.s.range;
        range.deleteContents();
        var fake = jodit.createInside.fake();
        range.insertNode(fake);
        var leftSibling = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(fake, true);
        var rightSibling = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(fake, false);
        this.__moveContentInLeftSibling(fake, leftSibling, rightSibling);
        range.setStartBefore(fake);
        range.collapse(true);
        this.__moveCursorInEditableSibling(jodit, leftSibling, fake, range);
        this.__addBrInEmptyBlock(fake, rightSibling, range);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(fake);
        jodit.s.selectRange(range);
        return false;
    };
    deleteCommand.prototype.__moveContentInLeftSibling = function (fake, leftSibling, rightSibling) {
        leftSibling = this.__defineRightLeftBox(leftSibling);
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isList(rightSibling) &&
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(rightSibling, 'table') &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(rightSibling) &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(leftSibling)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.append(leftSibling, fake);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.moveContent(rightSibling, leftSibling);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(rightSibling);
        }
        // Remove empty right LI
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isList(rightSibling) &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isLeaf(rightSibling.firstElementChild) &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmpty(rightSibling.firstElementChild)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(rightSibling.firstElementChild);
        }
    };
    /**
     * If left sibling is list - return last leaf
     */
    deleteCommand.prototype.__defineRightLeftBox = function (leftSibling) {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isList(leftSibling)) {
            return leftSibling;
        }
        var lastLeaf = leftSibling.lastElementChild;
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isLeaf(lastLeaf)) {
            lastLeaf = this.j.createInside.element('li');
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.append(leftSibling, lastLeaf);
        }
        return lastLeaf;
    };
    /**
     * Add BR in empty blocks left and right(for table cell)
     */
    deleteCommand.prototype.__addBrInEmptyBlock = function (fake, rightSibling, range) {
        var jodit = this.j;
        if (fake.isConnected &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(fake.parentNode) &&
            !fake.nextSibling &&
            !fake.previousSibling) {
            var br = jodit.createInside.element('br');
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(fake, br);
            range.setStartBefore(br);
            range.collapse(true);
        }
        // Add BR in the right empty table cell
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(rightSibling, 'table')) {
            var firstCell = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.$$)('td,th', rightSibling).shift();
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isCell(firstCell) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmpty(firstCell)) {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.append(firstCell, jodit.createInside.element('br'));
            }
        }
    };
    deleteCommand.prototype.__moveCursorInEditableSibling = function (jodit, leftSibling, fake, range) {
        var _a;
        if (!leftSibling || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(leftSibling)) {
            var root = (_a = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(fake, jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock, jodit.editor)) !== null && _a !== void 0 ? _a : jodit.editor;
            var leftText = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prev(fake, jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText, root);
            if (leftText) {
                range.setStartAfter(leftText);
                range.collapse(true);
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(fake);
            }
        }
    };
    deleteCommand.requires = ['backspace'];
    return deleteCommand;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('deleteCommand', deleteCommand);


/***/ }),

/***/ 6110:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ checkBR; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(641);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks the possibility and necessity of inserting a BR instead of a block
 * @private
 */
function checkBR(fake, jodit, shiftKeyPressed) {
    var isMultiLineBlock = Boolean(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(fake, ['pre', 'blockquote'], jodit.editor));
    var isCell = !isMultiLineBlock && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(fake, ['td', 'th'], jodit.editor);
    var isBRMode = jodit.o.enter.toLowerCase() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR.toLowerCase();
    // if you use <br> defaultTag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
    if (isBRMode ||
        isCell ||
        (shiftKeyPressed && !isMultiLineBlock) ||
        (!shiftKeyPressed && isMultiLineBlock)) {
        // 2 BR before
        if (isMultiLineBlock && checkSeveralBR(fake)) {
            return false;
        }
        var br = jodit.createInside.element('br');
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(fake, br);
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(br, false)) {
            var clone = br.cloneNode();
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(br, clone);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(clone, fake);
        }
        (0,jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_2__/* .scrollIntoViewIfNeeded */ .$)(br, jodit.editor, jodit.ed);
        return true;
    }
    return false;
}
function checkSeveralBR(fake) {
    // 2 BR before
    var preBr = brBefore(brBefore(fake));
    if (preBr) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(brBefore(fake));
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(preBr);
        return true;
    }
    return false;
}
function brBefore(start) {
    if (!start) {
        return false;
    }
    var prev = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(start, true);
    if (!prev || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(prev, 'br')) {
        return false;
    }
    return prev;
}


/***/ }),

/***/ 6295:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _img__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26396);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/* harmony default export */ __webpack_exports__.A = ([
    {
        name: 'bin',
        tooltip: 'Delete',
        exec: function (editor, image) {
            image && editor.s.removeNode(image);
        }
    },
    _img__WEBPACK_IMPORTED_MODULE_0__/* .align */ .M
]);


/***/ }),

/***/ 6455:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ UIGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








var UIGroup = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(UIGroup, _super);
    /**
     * @param elements - Items of group
     */
    function UIGroup(jodit, elements, options) {
        var _this = _super.call(this, jodit, options) || this;
        _this.options = options;
        /**
         * Synchronize mods to all children
         */
        _this.syncMod = false;
        _this.elements = [];
        _this.buttonSize = 'middle';
        elements === null || elements === void 0 ? void 0 : elements.forEach(function (elm) { return elm && _this.append(elm); });
        if (options === null || options === void 0 ? void 0 : options.name) {
            _this.name = options.name;
        }
        return _this;
    }
    UIGroup_1 = UIGroup;
    UIGroup.prototype.className = function () {
        return 'UIGroup';
    };
    Object.defineProperty(UIGroup.prototype, "allChildren", {
        /**
         * All group children
         */
        get: function () {
            var result = [];
            var stack = (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(this.elements), false);
            while (stack.length) {
                var elm = stack.shift();
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(elm)) {
                    stack.push.apply(stack, (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(elm), false));
                }
                else if (jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, UIGroup_1)) {
                    stack.push.apply(stack, (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(elm.elements), false));
                }
                else {
                    elm && result.push(elm);
                }
            }
            return result;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Update all children
     */
    UIGroup.prototype.update = function () {
        this.elements.forEach(function (elm) { return elm.update(); });
        this.setMod('size', this.buttonSize);
    };
    /**
     * Append new element into group
     */
    UIGroup.prototype.append = function (elm, distElement) {
        var _this = this;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(elm)) {
            elm.forEach(function (item) { return _this.append(item, distElement); });
            return this;
        }
        this.elements.push(elm);
        if (elm.name) {
            elm.container.classList.add(this.getFullElName(elm.name));
        }
        if (distElement) {
            var distElm = this.getElm(distElement);
            void 0;
            distElm.appendChild(elm.container);
        }
        else {
            this.appendChildToContainer(elm.container);
        }
        elm.parentElement = this;
        return this;
    };
    /** @override */
    UIGroup.prototype.afterSetMod = function (name, value) {
        if (this.syncMod) {
            this.elements.forEach(function (elm) { return elm.setMod(name, value); });
        }
    };
    /**
     * Allow set another container for the box of all children
     */
    UIGroup.prototype.appendChildToContainer = function (childContainer) {
        this.container.appendChild(childContainer);
    };
    /**
     * Remove element from group
     */
    UIGroup.prototype.remove = function (elm) {
        var index = this.elements.indexOf(elm);
        if (index !== -1) {
            this.elements.splice(index, 1);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(elm.container);
            elm.parentElement = null;
        }
        return this;
    };
    /**
     * Clear group
     */
    UIGroup.prototype.clear = function () {
        this.elements.forEach(function (elm) { return elm.destruct(); });
        this.elements.length = 0;
        return this;
    };
    /** @override */
    UIGroup.prototype.destruct = function () {
        this.clear();
        return _super.prototype.destruct.call(this);
    };
    var UIGroup_1;
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('buttonSize')
    ], UIGroup.prototype, "update", null);
    UIGroup = UIGroup_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
    ], UIGroup);
    return UIGroup;
}(jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D));



/***/ }),

/***/ 6589:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   As: function() { return /* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_4__.A; },
/* harmony export */   Bq: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.Bq; },
/* harmony export */   Gd: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.Gd; },
/* harmony export */   Hp: function() { return /* reexport safe */ _fuzzy_search_index__WEBPACK_IMPORTED_MODULE_1__.H; },
/* harmony export */   N: function() { return /* reexport safe */ _kebab_case__WEBPACK_IMPORTED_MODULE_3__.N; },
/* harmony export */   Ru: function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_2__.R; },
/* harmony export */   Z2: function() { return /* reexport safe */ _ucfirst__WEBPACK_IMPORTED_MODULE_6__.Z; },
/* harmony export */   gj: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.gj; },
/* harmony export */   kW: function() { return /* reexport safe */ _kebab_case__WEBPACK_IMPORTED_MODULE_3__.k; },
/* harmony export */   nv: function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_2__.n; },
/* harmony export */   xQ: function() { return /* reexport safe */ _camel_case__WEBPACK_IMPORTED_MODULE_0__.x; }
/* harmony export */ });
/* harmony import */ var _camel_case__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83260);
/* harmony import */ var _fuzzy_search_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67975);
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91093);
/* harmony import */ var _kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(449);
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28616);
/* harmony import */ var _trim__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59101);
/* harmony import */ var _ucfirst__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10467);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */









/***/ }),

/***/ 6857:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export resizer */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(69505);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










var keyBInd = '__jodit-resizer_binded';
/**
 * The module creates a supporting frame for resizing of the elements img and table
 */
var resizer = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(resizer, _super);
    function resizer() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__read */ .zs)(arguments), false)) || this;
        _this.LOCK_KEY = 'resizer';
        _this.element = null;
        _this.isResizeMode = false;
        _this.isShown = false;
        _this.startX = 0;
        _this.startY = 0;
        _this.width = 0;
        _this.height = 0;
        _this.ratio = 0;
        _this.rect = _this.j.c.fromHTML("<div title=\"".concat(_this.j.i18n('Press Alt for custom resizing'), "\" class=\"jodit-resizer\">\n\t\t\t\t<div class=\"jodit-resizer__top-left\"></div>\n\t\t\t\t<div class=\"jodit-resizer__top-right\"></div>\n\t\t\t\t<div class=\"jodit-resizer__bottom-right\"></div>\n\t\t\t\t<div class=\"jodit-resizer__bottom-left\"></div>\n\t\t\t\t<span>100x100</span>\n\t\t\t</div>"));
        _this.sizeViewer = _this.rect.getElementsByTagName('span')[0];
        _this.pointerX = 0;
        _this.pointerY = 0;
        _this.isAltMode = false;
        _this.onClickElement = function (element) {
            if (_this.isResizeMode) {
                return;
            }
            if (_this.element !== element || !_this.isShown) {
                _this.element = element;
                _this.show();
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(_this.element, 'img') && !_this.element.complete) {
                    _this.j.e.one(_this.element, 'load', _this.updateSize);
                }
            }
        };
        _this.updateSize = function () {
            if (_this.isInDestruct || !_this.isShown) {
                return;
            }
            if (_this.element && _this.rect) {
                var workplacePosition = _this.getWorkplacePosition();
                var pos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(_this.element, _this.j, _this.j.ed), left = parseInt(_this.rect.style.left || '0', 10), top = parseInt(_this.rect.style.top || '0', 10), w = _this.rect.offsetWidth, h = _this.rect.offsetHeight;
                var newTop = pos.top - workplacePosition.top, newLeft = pos.left - workplacePosition.left;
                if (top !== newTop ||
                    left !== newLeft ||
                    w !== _this.element.offsetWidth ||
                    h !== _this.element.offsetHeight) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(_this.rect, {
                        top: newTop,
                        left: newLeft,
                        width: _this.element.offsetWidth,
                        height: _this.element.offsetHeight
                    });
                    if (_this.j.events) {
                        _this.j.e.fire(_this.element, 'changesize');
                        // check for first init. Ex. inlinePopup hides when it was fired
                        if (!isNaN(left)) {
                            _this.j.e.fire('resize');
                        }
                    }
                }
            }
        };
        _this.hideSizeViewer = function () {
            _this.sizeViewer.style.opacity = '0';
        };
        return _this;
    }
    /** @override */
    resizer.prototype.afterInit = function (editor) {
        var _this = this;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('div', this.rect).forEach(function (resizeHandle) {
            editor.e.on(resizeHandle, 'mousedown.resizer touchstart.resizer', _this.onStartResizing.bind(_this, resizeHandle));
        });
        jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .eventEmitter */ .RR.on('hideHelpers', this.hide);
        editor.e
            .on('readonly', function (isReadOnly) {
            if (isReadOnly) {
                _this.hide();
            }
        })
            .on('afterInit changePlace', this.addEventListeners.bind(this))
            .on('afterGetValueFromEditor.resizer', function (data) {
            var rgx = /<jodit[^>]+data-jodit_iframe_wrapper[^>]+>(.*?<iframe[^>]*>.*?<\/iframe>.*?)<\/jodit>/gi;
            if (rgx.test(data.value)) {
                data.value = data.value.replace(rgx, '$1');
            }
        });
        this.addEventListeners();
        this.__onChangeEditor();
    };
    /**
     * Click in the editor area
     */
    resizer.prototype.onEditorClick = function (e) {
        var node = e.target;
        var _a = this.j, editor = _a.editor, allowResizeTags = _a.options.allowResizeTags;
        while (node && node !== editor) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(node, allowResizeTags)) {
                this.__bind(node);
                this.onClickElement(node);
                return;
            }
            node = node.parentNode;
        }
    };
    resizer.prototype.__afterInsertImage = function (image) {
        if (this.j.o.resizer.forImageChangeAttributes) {
            return;
        }
        var width = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(image, 'width');
        if (width && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(image, 'width', true)) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(image, 'width', width);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(image, 'width', null);
        }
    };
    resizer.prototype.addEventListeners = function () {
        var _this = this;
        var editor = this.j;
        editor.e
            .off(editor.editor, '.resizer')
            .off(editor.ow, '.resizer')
            .on(editor.editor, 'keydown.resizer', function (e) {
            if (_this.isShown &&
                e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DELETE &&
                _this.element &&
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(_this.element, 'table')) {
                _this.onDelete(e);
            }
        })
            .on(editor.ow, 'resize.resizer', this.updateSize)
            .on('resize.resizer', this.updateSize)
            .on([editor.ow, editor.editor], 'scroll.resizer', function () {
            if (_this.isShown && !_this.isResizeMode) {
                _this.hide();
            }
        })
            .on(editor.ow, 'keydown.resizer', this.onKeyDown)
            .on(editor.ow, 'keyup.resizer', this.onKeyUp)
            .on(editor.ow, 'mouseup.resizer touchend.resizer', this.onClickOutside);
    };
    resizer.prototype.onStartResizing = function (resizeHandle, e) {
        if (!this.element || !this.element.parentNode) {
            this.hide();
            return false;
        }
        this.handle = resizeHandle;
        if (e.cancelable) {
            e.preventDefault();
        }
        e.stopImmediatePropagation();
        this.width = this.element.offsetWidth;
        this.height = this.element.offsetHeight;
        this.ratio = this.width / this.height;
        this.isResizeMode = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.pointerX = e.clientX;
        this.pointerY = e.clientY;
        var j = this.j;
        j.e.fire('hidePopup');
        j.lock(this.LOCK_KEY);
        j.e.on(j.ow, 'mousemove.resizer touchmove.resizer', this.onResize);
    };
    resizer.prototype.onEndResizing = function () {
        var j = this.j;
        j.unlock();
        this.isResizeMode = false;
        this.isAltMode = false;
        j.synchronizeValues();
        j.e.off(j.ow, 'mousemove.resizer touchmove.resizer', this.onResize);
    };
    resizer.prototype.onResize = function (e) {
        if (this.isResizeMode) {
            if (!this.element) {
                return;
            }
            this.pointerX = e.clientX;
            this.pointerY = e.clientY;
            var diff_x = void 0, diff_y = void 0;
            if (this.j.options.iframe) {
                var workplacePosition = this.getWorkplacePosition();
                diff_x = e.clientX + workplacePosition.left - this.startX;
                diff_y = e.clientY + workplacePosition.top - this.startY;
            }
            else {
                diff_x = this.pointerX - this.startX;
                diff_y = this.pointerY - this.startY;
            }
            var className = this.handle.className;
            var new_w = 0, new_h = 0;
            var uar = this.j.o.resizer.useAspectRatio;
            if (!this.isAltMode &&
                (uar === true || (uar && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(this.element, uar)))) {
                if (diff_x) {
                    new_w =
                        this.width +
                            (className.match(/left/) ? -1 : 1) * diff_x;
                    new_h = Math.round(new_w / this.ratio);
                }
                else {
                    new_h =
                        this.height +
                            (className.match(/top/) ? -1 : 1) * diff_y;
                    new_w = Math.round(new_h * this.ratio);
                }
                if (new_w > (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.innerWidth)(this.j.editor, this.j.ow)) {
                    new_w = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.innerWidth)(this.j.editor, this.j.ow);
                    new_h = Math.round(new_w / this.ratio);
                }
            }
            else {
                new_w =
                    this.width + (className.match(/left/) ? -1 : 1) * diff_x;
                new_h =
                    this.height + (className.match(/top/) ? -1 : 1) * diff_y;
            }
            if (new_w > this.j.o.resizer.min_width) {
                if (new_w < this.rect.parentNode.offsetWidth) {
                    this.applySize(this.element, 'width', new_w);
                }
                else {
                    this.applySize(this.element, 'width', '100%');
                }
            }
            if (new_h > this.j.o.resizer.min_height) {
                this.applySize(this.element, 'height', new_h);
            }
            this.updateSize();
            this.showSizeViewer(this.element.offsetWidth, this.element.offsetHeight);
            e.stopImmediatePropagation();
        }
    };
    resizer.prototype.onKeyDown = function (e) {
        this.isAltMode = e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ALT;
        if (!this.isAltMode && this.isResizeMode) {
            this.onEndResizing();
        }
    };
    resizer.prototype.onKeyUp = function () {
        if (this.isAltMode && this.isResizeMode && this.element) {
            this.width = this.element.offsetWidth;
            this.height = this.element.offsetHeight;
            this.ratio = this.width / this.height;
            this.startX = this.pointerX;
            this.startY = this.pointerY;
        }
        this.isAltMode = false;
    };
    resizer.prototype.onClickOutside = function (e) {
        if (!this.isShown) {
            return;
        }
        if (!this.isResizeMode) {
            return this.hide();
        }
        e.stopImmediatePropagation();
        this.onEndResizing();
    };
    resizer.prototype.getWorkplacePosition = function () {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)((this.rect.parentNode || this.j.od.documentElement), this.j, this.j.od, true);
    };
    resizer.prototype.applySize = function (element, key, value) {
        var changeAttrs = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isImage(element) && this.j.o.resizer.forImageChangeAttributes;
        if (changeAttrs) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(element, key, value);
        }
        if (!changeAttrs || element.style[key]) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(element, key, value);
        }
    };
    resizer.prototype.onDelete = function (e) {
        if (!this.element) {
            return;
        }
        if (this.element.tagName !== 'JODIT') {
            this.j.s.select(this.element);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.element);
            this.hide();
            e.preventDefault();
        }
    };
    resizer.prototype.__onChangeEditor = function () {
        if (this.isShown) {
            if (!this.element || !this.element.parentNode) {
                this.hide();
            }
            else {
                this.updateSize();
            }
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('iframe', this.j.editor).forEach(this.__bind);
    };
    /**
     * Bind an edit element to element
     * @param element - The element that you want to add a function to resize
     */
    resizer.prototype.__bind = function (element) {
        var _this = this;
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(element) ||
            !this.j.o.allowResizeTags.has(element.tagName.toLowerCase()) ||
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(element, keyBInd)) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(element, keyBInd, true);
        var wrapper;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(element, 'iframe')) {
            var iframe_1 = element;
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(element.parentNode) &&
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(element.parentNode, '-jodit_iframe_wrapper')) {
                element = element.parentNode;
            }
            else {
                wrapper = this.j.createInside.element('jodit', {
                    'data-jodit-temp': 1,
                    contenteditable: false,
                    draggable: true,
                    'data-jodit_iframe_wrapper': 1
                });
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(wrapper, 'style', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(element, 'style'));
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(wrapper, {
                    display: element.style.display === 'inline-block'
                        ? 'inline-block'
                        : 'block',
                    width: element.offsetWidth,
                    height: element.offsetHeight
                });
                if (element.parentNode) {
                    element.parentNode.insertBefore(wrapper, element);
                }
                wrapper.appendChild(element);
                this.j.e.on(wrapper, 'click', function () {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(wrapper, 'data-jodit-wrapper_active', true);
                });
                element = wrapper;
            }
            this.j.e
                .off(element, 'mousedown.select touchstart.select')
                .on(element, 'mousedown.select touchstart.select', function () {
                _this.j.s.select(element);
            })
                .off(element, 'changesize')
                .on(element, 'changesize', function () {
                iframe_1.setAttribute('width', element.offsetWidth + 'px');
                iframe_1.setAttribute('height', element.offsetHeight + 'px');
            });
        }
        this.j.e.on(element, 'dragstart', this.hide);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE) {
            // for IE don't show native resizer
            this.j.e.on(element, 'mousedown', function (event) {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(element, 'img')) {
                    event.preventDefault();
                }
            });
        }
    };
    resizer.prototype.showSizeViewer = function (w, h) {
        if (!this.j.o.resizer.showSize) {
            return;
        }
        if (w < this.sizeViewer.offsetWidth ||
            h < this.sizeViewer.offsetHeight) {
            this.hideSizeViewer();
            return;
        }
        this.sizeViewer.style.opacity = '1';
        this.sizeViewer.textContent = "".concat(w, " x ").concat(h);
        this.j.async.setTimeout(this.hideSizeViewer, {
            timeout: this.j.o.resizer.hideSizeTimeout,
            label: 'hideSizeViewer'
        });
    };
    /**
     * Show resizer
     */
    resizer.prototype.show = function () {
        if (this.j.o.readonly || this.isShown) {
            return;
        }
        this.isShown = true;
        if (!this.rect.parentNode) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.markOwner)(this.j, this.rect);
            this.j.workplace.appendChild(this.rect);
        }
        if (this.j.isFullSize) {
            this.rect.style.zIndex = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(this.j.container, 'zIndex').toString();
        }
        this.updateSize();
    };
    /**
     * Hide resizer
     */
    resizer.prototype.hide = function () {
        if (!this.isResizeMode) {
            this.isResizeMode = false;
            this.isShown = false;
            this.element = null;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.rect);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)("[data-jodit-wrapper_active='true']", this.j.editor).forEach(function (elm) { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, 'data-jodit-wrapper_active', false); });
        }
    };
    resizer.prototype.beforeDestruct = function (jodit) {
        this.hide();
        jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .eventEmitter */ .RR.off('hideHelpers', this.hide);
        jodit.e.off(this.j.ow, '.resizer').off('.resizer');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':click')
    ], resizer.prototype, "onEditorClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':afterInsertImage')
    ], resizer.prototype, "__afterInsertImage", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "onStartResizing", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "onEndResizing", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "onResize", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "onKeyDown", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "onKeyUp", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "onClickOutside", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':change')
    ], resizer.prototype, "__onChangeEditor", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizer.prototype, "__bind", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind,
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':hideResizer')
    ], resizer.prototype, "hide", null);
    return resizer;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('resizer', resizer);


/***/ }),

/***/ 6939:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ isURL; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check if a string is an url
 */
function isURL(str) {
    if (str.includes(' ')) {
        return false;
    }
    if (typeof URL !== 'undefined') {
        try {
            var url = new URL(str);
            return ['https:', 'http:', 'ftp:', 'file:', 'rtmp:'].includes(url.protocol);
        }
        catch (e) {
            return false;
        }
    }
    var a = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('a');
    a.href = str;
    return Boolean(a.hostname);
}


/***/ }),

/***/ 7920:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ normalizeSize; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
/**
 * Normalize value to CSS meters
 */
var normalizeSize = function (value, units) {
    if (/^[0-9]+$/.test(value.toString())) {
        return value + units;
    }
    return value.toString();
};


/***/ }),

/***/ 7982:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: function() { return /* binding */ ViewComponent; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


var ViewComponent = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__extends */ .C6)(ViewComponent, _super);
    function ViewComponent(jodit) {
        var _this = _super.call(this) || this;
        _this.setParentView(jodit);
        return _this;
    }
    Object.defineProperty(ViewComponent.prototype, "j", {
        /**
         * Shortcut for `this.jodit`
         */
        get: function () {
            return this.jodit;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ViewComponent.prototype, "defaultTimeout", {
        get: function () {
            return this.j.defaultTimeout;
        },
        enumerable: false,
        configurable: true
    });
    ViewComponent.prototype.i18n = function (text) {
        var _a;
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        return (_a = this.j).i18n.apply(_a, (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__spreadArray */ .fX)([text], (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__read */ .zs)(params), false));
    };
    /**
     * Attach component to View
     */
    ViewComponent.prototype.setParentView = function (jodit) {
        this.jodit = jodit;
        jodit.components.add(this);
        return this;
    };
    /** @override */
    ViewComponent.prototype.destruct = function () {
        this.j.components.delete(this);
        return _super.prototype.destruct.call(this);
    };
    return ViewComponent;
}(_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u));



/***/ }),

/***/ 8136:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1280q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1280q26 0 45 19t19 45zm256-384v128q0 26-19 45t-45 19h-1536q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1536q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1152q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1152q26 0 45 19t19 45z\"/> </svg>"

/***/ }),

/***/ 8453:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ LazyWalker; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43431);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




var LazyWalker = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__extends */ .C6)(LazyWalker, _super);
    function LazyWalker(async, options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this) || this;
        _this.async = async;
        _this.options = options;
        _this.workNodes = null;
        _this.hadAffect = false;
        _this.isWorked = false;
        _this.isFinished = false;
        _this.idleId = 0;
        _this.__schedulerController = null;
        return _this;
    }
    LazyWalker.prototype.setWork = function (root) {
        if (this.isWorked) {
            this.break();
        }
        this.workNodes = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.eachGen(root, !this.options.reverse);
        this.isFinished = false;
        this._requestStarting();
        return this;
    };
    LazyWalker.prototype._requestStarting = function () {
        this.__schedulerController = new AbortController();
        this.async
            .schedulerPostTask(this.__workPerform, {
            delay: this.options.timeout,
            signal: this.__schedulerController.signal
        })
            .catch(function () { return null; });
    };
    LazyWalker.prototype.break = function (reason) {
        if (this.isWorked) {
            this.stop();
            this.emit('break', reason);
        }
    };
    LazyWalker.prototype.end = function () {
        if (this.isWorked) {
            this.stop();
            this.emit('end', this.hadAffect);
            this.hadAffect = false;
        }
    };
    LazyWalker.prototype.stop = function () {
        this.isWorked = false;
        this.isFinished = true;
        this.workNodes = null;
        this.async.cancelIdleCallback(this.idleId);
    };
    LazyWalker.prototype.destruct = function () {
        _super.prototype.destruct.call(this);
        this.stop();
    };
    LazyWalker.prototype.__workPerform = function () {
        var _a;
        if (this.workNodes) {
            this.isWorked = true;
            var count = 0;
            var chunkSize = (_a = this.options.timeoutChunkSize) !== null && _a !== void 0 ? _a : 50;
            while (!this.isFinished && count <= chunkSize) {
                var item = this.workNodes.next();
                count += 1;
                if (this.visitNode(item.value)) {
                    this.hadAffect = true;
                }
                if (item.done) {
                    this.end();
                    return;
                }
            }
        }
        else {
            this.end();
        }
        if (!this.isFinished) {
            this._requestStarting();
        }
    };
    LazyWalker.prototype.visitNode = function (nodeElm) {
        var _a;
        if (!nodeElm ||
            (this.options.whatToShow !== undefined &&
                nodeElm.nodeType !== this.options.whatToShow)) {
            return false;
        }
        return (_a = this.emit('visit', nodeElm)) !== null && _a !== void 0 ? _a : false;
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], LazyWalker.prototype, "__workPerform", null);
    return LazyWalker;
}(jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_2__/* .Eventify */ .h));



/***/ }),

/***/ 8757:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ CommitStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12043);
/* harmony import */ var _apply_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10494);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




var CommitStyle = /** @class */ (function () {
    function CommitStyle(options) {
        this.options = options;
        this.__applyMap = new WeakMap();
    }
    CommitStyle.prototype.isApplied = function (elm, key) {
        var data = this.__applyMap.get(elm);
        if (!data) {
            return false;
        }
        return data[key];
    };
    CommitStyle.prototype.setApplied = function (elm, key) {
        var _a;
        var data = (_a = this.__applyMap.get(elm)) !== null && _a !== void 0 ? _a : {};
        data[key] = true;
        this.__applyMap.set(elm, data);
    };
    Object.defineProperty(CommitStyle.prototype, "elementIsList", {
        get: function () {
            return Boolean(this.options.element && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS.has(this.options.element));
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommitStyle.prototype, "element", {
        get: function () {
            return this.options.element || this.defaultTag;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommitStyle.prototype, "elementIsBlock", {
        /**
         * New element is blocked
         */
        get: function () {
            return Boolean(this.options.element && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK.test(this.options.element));
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommitStyle.prototype, "isElementCommit", {
        /**
         * The commit applies the tag change
         */
        get: function () {
            return Boolean(this.options.element &&
                this.options.element !== this.options.defaultTag);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommitStyle.prototype, "defaultTag", {
        get: function () {
            if (this.options.defaultTag) {
                return this.options.defaultTag;
            }
            return this.elementIsBlock ? 'p' : 'span';
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommitStyle.prototype, "elementIsDefault", {
        get: function () {
            return this.element === this.defaultTag;
        },
        enumerable: false,
        configurable: true
    });
    CommitStyle.prototype.apply = function (jodit) {
        var hooks = this.options.hooks;
        var keys = (hooks ? Object.keys(hooks) : []);
        try {
            keys.forEach(function (key) {
                jodit.e.on((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__/* ._PREFIX */ .ar + '_' + key), hooks[key]);
            });
            (0,_apply_style__WEBPACK_IMPORTED_MODULE_1__/* .ApplyStyle */ .O)(jodit, this);
        }
        finally {
            keys.forEach(function (key) {
                jodit.e.off((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__/* ._PREFIX */ .ar + '_' + key), hooks[key]);
            });
            this.__applyMap = new WeakMap();
        }
        jodit.synchronizeValues();
        jodit.e.fire('afterCommitStyle', this);
    };
    return CommitStyle;
}());



/***/ }),

/***/ 8809:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $K: function() { return /* binding */ makeCollection; },
/* harmony export */   BJ: function() { return /* binding */ makeButton; },
/* harmony export */   RR: function() { return /* binding */ makeSelect; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3258);
/* harmony import */ var _button_content__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49405);
/* harmony import */ var _button_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48053);
/* harmony import */ var _collection_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97394);
/* harmony import */ var _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90428);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Collection factory
 */
function makeCollection(jodit, parentElement) {
    var collection = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(jodit)
        ? new _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__/* .ToolbarEditorCollection */ .b(jodit)
        : new _collection_collection__WEBPACK_IMPORTED_MODULE_4__/* .ToolbarCollection */ .Q(jodit);
    if (jodit.o.textIcons) {
        collection.container.classList.add('jodit_text_icons');
    }
    if (parentElement) {
        collection.parentElement = parentElement;
    }
    if (jodit.o.toolbarButtonSize) {
        collection.buttonSize = jodit.o.toolbarButtonSize;
    }
    return collection;
}
/**
 * Button factory
 */
function makeButton(jodit, control, target) {
    if (target === void 0) { target = null; }
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(control.getContent)) {
        return new _button_content__WEBPACK_IMPORTED_MODULE_2__/* .ToolbarContent */ .P(jodit, control, target);
    }
    var button = new _button_button__WEBPACK_IMPORTED_MODULE_1__/* .ToolbarButton */ .I(jodit, control, target);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    return button;
}
function makeSelect(view, control, target) {
    if (target === void 0) { target = null; }
    return new _button_select_select__WEBPACK_IMPORTED_MODULE_3__/* .ToolbarSelect */ .q(view, control, target);
}


/***/ }),

/***/ 8916:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Spellchecking'
};


/***/ }),

/***/ 9103:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M553 1399l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23t-10 23zm591-1067l-373 1291q-4 13-15.5 19.5t-23.5 2.5l-62-17q-13-4-19.5-15.5t-2.5-24.5l373-1291q4-13 15.5-19.5t23.5-2.5l62 17q13 4 19.5 15.5t2.5 24.5zm657 651l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23t-10 23z\"/> </svg>"

/***/ }),

/***/ 9117:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export limit */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87238);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Plugin control for chars or words count
 */
var limit = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__extends */ .C6)(limit, _super);
    function limit() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @override **/
    limit.prototype.afterInit = function (jodit) {
        var _this = this;
        var _a = jodit.o, limitWords = _a.limitWords, limitChars = _a.limitChars;
        if (jodit && (limitWords || limitChars)) {
            var snapshot_1 = null;
            jodit.e
                .off('.limit')
                .on('beforePaste.limit', function () {
                snapshot_1 = jodit.history.snapshot.make();
            })
                .on('keydown.limit keyup.limit beforeEnter.limit', this.checkPreventKeyPressOrPaste)
                .on('change.limit', this.checkPreventChanging)
                .on('afterPaste.limit', function () {
                if (_this.__shouldDenyInput(true) && snapshot_1) {
                    jodit.history.snapshot.restore(snapshot_1);
                    jodit.e.fire('denyPaste.limit');
                    return false;
                }
            });
        }
    };
    /**
     * Action should be prevented
     */
    limit.prototype.shouldPreventInsertHTML = function (event) {
        if (event &&
            (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.COMMAND_KEYS.includes(event.key) || event.ctrlKey || event.metaKey)) {
            return false;
        }
        return this.__shouldDenyInput(false);
    };
    limit.prototype.__shouldDenyInput = function (strict) {
        var jodit = this.jodit;
        var _a = jodit.o, limitWords = _a.limitWords, limitChars = _a.limitChars;
        var text = jodit.o.limitHTML ? jodit.value : jodit.text;
        var words = this.__splitWords(text);
        if (limitWords && isGt(words.length, limitWords, strict)) {
            jodit.e.fire('denyWords.limit limit.limit');
            return true;
        }
        var should = Boolean(limitChars && isGt(words.join('').length, limitChars, strict));
        if (should) {
            jodit.e.fire('denyChars.limit limit.limit');
        }
        return should;
    };
    /**
     * Check if some keypress or paste should be prevented
     */
    limit.prototype.checkPreventKeyPressOrPaste = function (event) {
        if (this.shouldPreventInsertHTML(event)) {
            return false;
        }
    };
    /**
     * Check if some external changing should be prevented
     */
    limit.prototype.checkPreventChanging = function (newValue, oldValue) {
        var jodit = this.jodit;
        if (this.__shouldDenyInput(true)) {
            jodit.value = oldValue;
        }
    };
    /**
     * Split text on words without technical characters
     */
    limit.prototype.__splitWords = function (text) {
        return text
            .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP)(), '')
            .split((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP)())
            .filter(function (e) { return e.length; });
    };
    /** @override **/
    limit.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('.limit');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], limit.prototype, "checkPreventKeyPressOrPaste", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], limit.prototype, "checkPreventChanging", null);
    return limit;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k));

function isGt(a, b, strict) {
    return strict ? a > b : a >= b;
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('limit', limit);


/***/ }),

/***/ 9407:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'символ'
};


/***/ }),

/***/ 9443:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export fullsize */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83044);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70061);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var fullsizeStack = new Set();
/**
 * Process `toggleFullSize` event, and behavior - set/unset fullsize mode
 */
function fullsize(editor) {
    editor.registerButton({
        name: 'fullsize'
    });
    var isEnabled = false, oldHeight = 0, oldWidth = 0, wasToggled = false;
    var resize = function () {
        var container = editor.container, events = editor.events;
        if (!events) {
            return;
        }
        if (isEnabled) {
            oldHeight = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, 'height', true);
            oldWidth = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, 'width', true);
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, {
                height: editor.ow.innerHeight,
                width: editor.ow.innerWidth
            });
            wasToggled = true;
        }
        else if (wasToggled) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, {
                height: oldHeight || 'auto',
                width: oldWidth || 'auto'
            });
        }
    }, 
    /**
     * Change editor's state between FullSize and normal
     */
    toggle = function (enable) {
        var _a;
        var container = editor.container, events = editor.events;
        if (!container) {
            return;
        }
        if (enable === undefined) {
            enable = !container.classList.contains('jodit_fullsize');
        }
        editor.setMod('fullsize', enable);
        editor.o.fullsize = enable;
        isEnabled = enable;
        container.classList.toggle('jodit_fullsize', enable);
        if (editor.toolbar) {
            (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__/* .isJoditObject */ .y)(editor) &&
                ((_a = editor.toolbarContainer) === null || _a === void 0 ? void 0 : _a.appendChild(editor.toolbar.container));
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(editor.toolbar.container, 'width', 'auto');
        }
        enable
            ? fullsizeStack.add(container)
            : fullsizeStack.delete(container);
        var shouldToggleGlobalFullsize = editor.o.globalFullSize &&
            ((fullsizeStack.size === 1 && enable) ||
                (fullsizeStack.size === 0 && !enable));
        if (shouldToggleGlobalFullsize) {
            var node = container.parentNode;
            while (node &&
                node.nodeType !== Node.DOCUMENT_NODE &&
                node.nodeType !== Node.DOCUMENT_FRAGMENT_NODE) {
                node.classList.toggle('jodit_fullsize-box_true', enable);
                node = node.parentNode;
            }
            resize();
        }
        events.fire('afterResize');
    };
    if (editor.o.globalFullSize) {
        editor.e.on(editor.ow, 'resize', resize);
    }
    editor.e
        .on('afterInit afterOpen', function () {
        var _a;
        editor.toggleFullSize((_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.fullsize);
    })
        .on('toggleFullSize', toggle)
        .on('beforeDestruct', function () {
        isEnabled && toggle(false);
    })
        .on('beforeDestruct', function () {
        editor.events && editor.e.off(editor.ow, 'resize', resize);
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('fullsize', fullsize);


/***/ }),

/***/ 9645:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ normalSizeFromString; },
/* harmony export */   n: function() { return /* binding */ normalSizeToString; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2461);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/image-properties
 */


/** @private */
var normalSizeFromString = function (value) {
    return /^[-+]?[0-9.]+(px)?$/.test(value.toString())
        ? parseFloat(value.toString())
        : value;
};
/** @private */
var normalSizeToString = function (value) {
    if ((0,jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_1__/* .isNumber */ .E)(value)) {
        return value ? value + 'px' : value.toString();
    }
    value = (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(value);
    return /^[0-9]+$/.test(value) ? value + 'px' : value;
};


/***/ }),

/***/ 9810:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ isBoolean; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
function isBoolean(elm) {
    return typeof elm === 'boolean';
}


/***/ }),

/***/ 9823:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AH: function() { return /* reexport safe */ _is_html__WEBPACK_IMPORTED_MODULE_6__.A; },
/* harmony export */   Bo: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.B; },
/* harmony export */   CE: function() { return /* reexport safe */ _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__.C; },
/* harmony export */   E6: function() { return /* reexport safe */ _is_int__WEBPACK_IMPORTED_MODULE_9__.E; },
/* harmony export */   Et: function() { return /* reexport safe */ _is_number__WEBPACK_IMPORTED_MODULE_14__.E; },
/* harmony export */   Gp: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.n4; },
/* harmony export */   Kg: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.K; },
/* harmony export */   Lm: function() { return /* reexport safe */ _is_boolean__WEBPACK_IMPORTED_MODULE_3__.L; },
/* harmony export */   Mj: function() { return /* reexport safe */ _is_license__WEBPACK_IMPORTED_MODULE_11__.M; },
/* harmony export */   P5: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.P; },
/* harmony export */   Qd: function() { return /* reexport safe */ _is_plain_object__WEBPACK_IMPORTED_MODULE_16__.Q; },
/* harmony export */   Rd: function() { return /* reexport safe */ _is_void__WEBPACK_IMPORTED_MODULE_23__.R; },
/* harmony export */   Tn: function() { return /* reexport safe */ _is_function__WEBPACK_IMPORTED_MODULE_5__.T; },
/* harmony export */   a3: function() { return /* reexport safe */ _is_native_function__WEBPACK_IMPORTED_MODULE_13__.a; },
/* harmony export */   cy: function() { return /* reexport safe */ _is_array__WEBPACK_IMPORTED_MODULE_2__.c; },
/* harmony export */   hH: function() { return /* reexport safe */ _is_view_object__WEBPACK_IMPORTED_MODULE_22__.h; },
/* harmony export */   kC: function() { return /* reexport safe */ _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__.k; },
/* harmony export */   kO: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.kO; },
/* harmony export */   kf: function() { return /* reexport safe */ _is_numeric__WEBPACK_IMPORTED_MODULE_15__.k; },
/* harmony export */   l6: function() { return /* reexport safe */ _is_window__WEBPACK_IMPORTED_MODULE_24__.l; },
/* harmony export */   mv: function() { return /* reexport safe */ _is_url__WEBPACK_IMPORTED_MODULE_20__.m; },
/* harmony export */   n4: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.n; },
/* harmony export */   pV: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.pV; },
/* harmony export */   rg: function() { return /* reexport safe */ _is_marker__WEBPACK_IMPORTED_MODULE_12__.r; },
/* harmony export */   uV: function() { return /* reexport safe */ _is_valid_name__WEBPACK_IMPORTED_MODULE_21__.u; },
/* harmony export */   vM: function() { return /* reexport safe */ _is_set__WEBPACK_IMPORTED_MODULE_18__.v; },
/* harmony export */   y0: function() { return /* reexport safe */ _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__.y; },
/* harmony export */   yL: function() { return /* reexport safe */ _is_promise__WEBPACK_IMPORTED_MODULE_17__.y; },
/* harmony export */   zf: function() { return /* reexport safe */ _is_abort_error__WEBPACK_IMPORTED_MODULE_1__.z; }
/* harmony export */ });
/* harmony import */ var _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(78479);
/* harmony import */ var _is_abort_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99951);
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37923);
/* harmony import */ var _is_boolean__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9810);
/* harmony import */ var _is_equal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69810);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69052);
/* harmony import */ var _is_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53701);
/* harmony import */ var _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(21811);
/* harmony import */ var _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10058);
/* harmony import */ var _is_int__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(3947);
/* harmony import */ var _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(83044);
/* harmony import */ var _is_license__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(82201);
/* harmony import */ var _is_marker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(71274);
/* harmony import */ var _is_native_function__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(34796);
/* harmony import */ var _is_number__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(2461);
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12461);
/* harmony import */ var _is_plain_object__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(25376);
/* harmony import */ var _is_promise__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(92039);
/* harmony import */ var _is_set__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(53470);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(98253);
/* harmony import */ var _is_url__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(6939);
/* harmony import */ var _is_valid_name__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(59082);
/* harmony import */ var _is_view_object__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(12041);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(35642);
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(76776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */



























/***/ }),

/***/ 9979:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ loadItems; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Loads a list of files and adds them to the state
 * @private
 */
function loadItems(fb) {
    fb.files.setMod('active', true);
    fb.files.setMod('loading', true);
    return fb.dataProvider
        .items(fb.state.currentPath, fb.state.currentSource, {
        sortBy: fb.state.sortBy,
        onlyImages: fb.state.onlyImages,
        filterWord: fb.state.filterWord
    })
        .then(function (resp) {
        if (resp) {
            fb.state.elements = resp;
            fb.state.activeElements = [];
        }
    })
        .catch(fb.status)
        .finally(function () { return fb.files.setMod('loading', false); });
}


/***/ }),

/***/ 10004:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ defaultNameSpace; },
/* harmony export */   d: function() { return /* binding */ EventHandlersStore; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


var defaultNameSpace = 'JoditEventDefaultNamespace';
var EventHandlersStore = /** @class */ (function () {
    function EventHandlersStore() {
        this.__store = new Map();
    }
    EventHandlersStore.prototype.get = function (event, namespace) {
        if (this.__store.has(namespace)) {
            var ns = this.__store.get(namespace);
            void 0;
            return ns[event];
        }
    };
    EventHandlersStore.prototype.indexOf = function (event, namespace, originalCallback) {
        var blocks = this.get(event, namespace);
        if (blocks) {
            for (var i = 0; i < blocks.length; i += 1) {
                if (blocks[i].originalCallback === originalCallback) {
                    return i;
                }
            }
        }
        return false;
    };
    EventHandlersStore.prototype.namespaces = function (withoutDefault) {
        if (withoutDefault === void 0) { withoutDefault = false; }
        var nss = (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__/* .toArray */ .$)(this.__store.keys());
        return withoutDefault ? nss.filter(function (ns) { return ns !== defaultNameSpace; }) : nss;
    };
    EventHandlersStore.prototype.events = function (namespace) {
        var ns = this.__store.get(namespace);
        return ns ? Object.keys(ns) : [];
    };
    EventHandlersStore.prototype.set = function (event, namespace, data, onTop) {
        if (onTop === void 0) { onTop = false; }
        var ns = this.__store.get(namespace);
        if (!ns) {
            ns = {};
            this.__store.set(namespace, ns);
        }
        if (ns[event] === undefined) {
            ns[event] = [];
        }
        if (!onTop) {
            ns[event].push(data);
        }
        else {
            ns[event].unshift(data);
        }
    };
    EventHandlersStore.prototype.clear = function () {
        this.__store.clear();
    };
    EventHandlersStore.prototype.clearEvents = function (namespace, event) {
        var ns = this.__store.get(namespace);
        if (ns && ns[event]) {
            delete ns[event];
            if (!Object.keys(ns).length) {
                this.__store.delete(namespace);
            }
        }
    };
    EventHandlersStore.prototype.isEmpty = function () {
        return this.__store.size === 0;
    };
    return EventHandlersStore;
}());



/***/ }),

/***/ 10025:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: function() { return /* binding */ nl2br; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */
/**
 *  Inserts HTML line breaks before all newlines in a string
 */
function nl2br(html) {
    return html.replace(/\r\n|\r|\n/g, '<br/>');
}


/***/ }),

/***/ 10058:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   kO: function() { return /* binding */ hasContainer; },
/* harmony export */   n4: function() { return /* binding */ isInitable; },
/* harmony export */   pV: function() { return /* binding */ isDestructable; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check value has method init
 */
function isInitable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(value.init);
}
/**
 * Check value has method destruct
 */
function isDestructable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(value.destruct);
}
/**
 * Check value is instant that implements IContainer
 */
function hasContainer(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(value.container);
}


/***/ }),

/***/ 10067:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ FileSelectorWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Generate 3 tabs
 * upload - Use Drag and Drop
 * url - By specifying the image url
 * filebrowser - After opening the file browser. In the absence of one of the parameters will be less tabs
 *
 * @param callbacks - Object with keys `url`, `upload` and `filebrowser`, values which are callback
 * functions with different parameters
 */
var FileSelectorWidget = function (editor, callbacks, elm, close, isImage) {
    if (isImage === void 0) { isImage = true; }
    var currentImage;
    var tabs = [];
    if (callbacks.upload &&
        editor.o.uploader &&
        (editor.o.uploader.url || editor.o.uploader.insertImageAsBase64URI)) {
        var dragBox = editor.c.fromHTML('<div class="jodit-drag-and-drop__file-box">' +
            "<strong>".concat(editor.i18n(isImage ? 'Drop image' : 'Drop file'), "</strong>") +
            "<span><br>".concat(editor.i18n('or click'), "</span>") +
            "<input type=\"file\" accept=\"".concat(isImage ? 'image/*' : '*', "\" tabindex=\"-1\" dir=\"auto\" multiple=\"\"/>") +
            '</div>');
        editor.uploader.bind(dragBox, function (resp) {
            var handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.upload)
                ? callbacks.upload
                : editor.o.uploader.defaultHandlerSuccess;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {
                handler.call(editor, resp);
            }
            editor.e.fire('closeAllPopups');
        }, function (error) {
            editor.message.error(error.message);
            editor.e.fire('closeAllPopups');
        });
        tabs.push({
            icon: 'upload',
            name: 'Upload',
            content: dragBox
        });
    }
    if (callbacks.filebrowser) {
        if (editor.o.filebrowser.ajax.url || editor.o.filebrowser.items.url) {
            tabs.push({
                icon: 'folder',
                name: 'Browse',
                content: function () {
                    close && close();
                    if (callbacks.filebrowser) {
                        editor.filebrowser.open(callbacks.filebrowser, isImage);
                    }
                }
            });
        }
    }
    if (callbacks.url) {
        var button = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIButton */ .lD(editor, {
            type: 'submit',
            variant: 'primary',
            text: 'Insert'
        }), form = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(editor, [
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(editor, {
                required: true,
                label: 'URL',
                name: 'url',
                type: 'text',
                placeholder: 'https://'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(editor, {
                name: 'text',
                label: 'Alternative text'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(editor, [button])
        ]);
        currentImage = null;
        if (elm &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(elm) &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isComment(elm) &&
            (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'img') || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm).length)) {
            currentImage = elm.tagName === 'IMG' ? elm : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm)[0];
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'src'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'alt'));
            button.state.text = 'Update';
        }
        if (elm && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'a')) {
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'title'));
            button.state.text = 'Update';
        }
        form.onSubmit(function (data) {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.url)) {
                callbacks.url.call(editor, data.url, data.text);
            }
        });
        tabs.push({
            icon: 'link',
            name: 'URL',
            content: form.container
        });
    }
    return (0,jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__/* .TabsWidget */ .Z)(editor, tabs);
};
function val(elm, selector, value) {
    var child = elm.querySelector(selector);
    if (!child) {
        return '';
    }
    if (value) {
        child.value = value;
    }
    return child.value;
}


/***/ }),

/***/ 10229:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Výška čáry'
};


/***/ }),

/***/ 10274:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* reexport safe */ _files_files__WEBPACK_IMPORTED_MODULE_0__.Q; },
/* harmony export */   V: function() { return /* reexport safe */ _tree_tree__WEBPACK_IMPORTED_MODULE_1__.V; }
/* harmony export */ });
/* harmony import */ var _files_files__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(96025);
/* harmony import */ var _tree_tree__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73307);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/file-browser
 */




/***/ }),

/***/ 10466:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ FiniteStateMachine; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * A state machine implementation for applying styles.
 */
var FiniteStateMachine = /** @class */ (function () {
    function FiniteStateMachine(state, transitions) {
        this.transitions = transitions;
        this.silent = true;
        this.__previewsStates = new Set();
        this.setState(state);
    }
    FiniteStateMachine.prototype.setState = function (state) {
        void 0;
        this.__previewsStates.add(state);
        this.__state = state;
    };
    FiniteStateMachine.prototype.getState = function () {
        return this.__state;
    };
    FiniteStateMachine.prototype.disableSilent = function () {
        this.silent = false;
    };
    FiniteStateMachine.prototype.dispatch = function (actionName, value) {
        var action = this.transitions[this.getState()][actionName];
        if (action) {
            var res = action.call(this, value);
            void 0;
            void 0;
            void 0;
            this.setState(res.next);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !this.silent) {
                // eslint-disable-next-line no-console
                console.log("State: ".concat(this.getState()));
            }
            return res;
        }
        throw new Error("invalid action: ".concat(this.getState(), ".").concat(actionName.toString()));
    };
    return FiniteStateMachine;
}());



/***/ }),

/***/ 10467:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ ucfirst; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
/**
 * Make a string's first character uppercase
 */
function ucfirst(value) {
    if (!value.length) {
        return '';
    }
    return value[0].toUpperCase() + value.substring(1);
}


/***/ }),

/***/ 10494:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   O: function() { return /* binding */ ApplyStyle; }
/* harmony export */ });
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97621);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12043);
/* harmony import */ var _transactions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37649);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/** @internal */
function ApplyStyle(jodit, cs) {
    var _a;
    var sel = jodit.s, editor = jodit.editor;
    // sel.save();
    (_a = editor.firstChild) === null || _a === void 0 ? void 0 : _a.normalize(); // FF fix for test "commandsTest - Exec command "bold"
    var fakes = sel.fakes();
    var gen = jodit.s.wrapInTagGen(fakes);
    var font = gen.next();
    if (font.done) {
        return;
    }
    var state = {
        collapsed: sel.isCollapsed(),
        mode: _constants__WEBPACK_IMPORTED_MODULE_2__/* .INITIAL */ .DI,
        element: font.value,
        next: _transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.START,
        jodit: jodit,
        style: cs
    };
    while (font && !font.done) {
        var machine = new _api__WEBPACK_IMPORTED_MODULE_0__/* .FiniteStateMachine */ .EF(_transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.START, _transactions__WEBPACK_IMPORTED_MODULE_1__/* .transactions */ .g);
        state.element = font.value;
        // machine.disableSilent();
        while (machine.getState() !== _transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.END) {
            // console.log(machine.getState(), state);
            state = machine.dispatch('exec', state);
        }
        // console.log('-------------------');
        font = gen.next();
    }
    // sel.restore();
    sel.restoreFakes(fakes);
}


/***/ }),

/***/ 10572:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Zeilenhöhe'
};


/***/ }),

/***/ 11012:
/***/ (function(module) {

module.exports["default"] = ["무엇이든 입력하세요","Jodit에 대하여","Jodit Editor","Jodit 사용자 안내서","자세한 도움말이 들어있어요","라이센스에 관해서는 Jodit 웹 사이트를 방문해주세요：","풀 버전 구입하기","© XDSoft.net - Chupurnov Valeriy. 에게 저작권과 모든 권리가 있습니다.","Anchor","새 탭에서 열기","전체 크기로 보기","서식 지우기","글씨 색상","재실행","실행 취소","굵게","기울임","글머리 목록","번호 목록","가운데 정렬","양쪽 정렬","왼쪽 정렬","오른쪽 정렬","수평 구분선 넣기","이미지 넣기","파일 넣기","Youtube/Vimeo 동영상","링크 넣기","글꼴 크기","글꼴","블록 요소 넣기","일반 텍스트","제목 1","제목 2","제목 3","제목 4","인용","코드","붙여 넣기","테이블","들여쓰기 감소","들여쓰기 증가","특수문자 선택","특수문자 입력","페인트 형식","편집모드 변경","마진","위","오른쪽","아래","왼쪽","스타일","클래스","정렬","오른쪽으로","가운데로","왼쪽으로","--지정 안 함--","경로(src)","제목","대체 텍스트(alt)","링크","새 탭에서 열기",null,"파일","고급","이미지 속성","취소","확인","파일 탐색기","목록 불러오기 에러","폴더 불러오기","정말 진행할까요?","디렉토리 이름 입력","디렉토리 생성","이름 입력","이미지 드래그","파일 드래그","혹은 클릭","대체 텍스트","업로드","탐색","배경","텍스트","위","중앙","아래","이전 열에 삽입","다음 열에 삽입","위 행에 삽입","아래 행에 삽입","테이블 삭제","행 삭제","열 삭제","빈 셀","문자수: %d","단어수: %d","취소선","밑줄","윗첨자","아래첨자","선택 잘라내기","모두 선택","구분자","검색","대체하기","대체","붙여넣기","붙여넣을 내용 선택","HTML 소스","볼드","이탤릭","브러시","링크","실행 취소","재실행","테이블","이미지","지우개","문단","글꼴 크기","비디오","글꼴","편집기 정보","프린트","밑줄","취소선","들여쓰기","내어쓰기","전체 화면","일반 화면","구분선","글머리 목록","번호 목록","잘라내기","모두 선택","Embed 코드","링크 열기","링크 편집","No follow","링크 제거","갱신","연필","사이트 확인","URL","편집","수평 정렬","필터","변경일 정렬","이름 정렬","크기 정렬","새 폴더","초기화","저장","새로 저장하기 ...","리사이즈","크롭","가로 길이","세로 높이","비율 유지하기","네","아니오","제거","선택","선택: %s","수직 정렬","분할","셀 병합","열 추가","행 추가","라이센스: %s","삭제","세로 셀 분할","가로 셀 분할","외곽선","HTML 코드로 감지했어요. 코드인채로 붙여넣을까요?","HTML로 붙여넣기","원본 유지","텍스트로 넣기","텍스트만 넣기","외부 이미지는 편집할 수 없어요. 외부 이미지를 다운로드 할까요?","이미지를 무사히 업로드 했어요!","팔레트","파일이 없어요","이름 변경","새 이름 입력","미리보기","다운로드","클립보드 붙여넣기","사용중인 브라우저가 클립보드 접근을 지원하지 않아요.","선택 복사","복사","둥근 테두리","모두 보기","적용","이 항목을 입력해주세요!","웹 URL을 입력해주세요.","기본","원","점","정사각형","찾기","이전 찾기","다음 찾기","Microsoft Word/Excel 문서로 감지했어요. 서식을 유지한채로 붙여넣을까요?","Word 붙여넣기 감지","지우기","className 입력","사용자 지정 크기 조정에 대 한 고도 누르십시오"]

/***/ }),

/***/ 11095:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Format kopierenт'
};


/***/ }),

/***/ 11131:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ generateCriticalCSS; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42448);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * @private
 */
function generateCriticalCSS(jodit) {
    var getMatchedCSSRules = function (el, css) {
        if (css === void 0) { css = el.ownerDocument.styleSheets; }
        var rules = (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__/* .toArray */ .$)(css)
            .map(function (s) {
            try {
                return (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__/* .toArray */ .$)(s.cssRules);
            }
            catch (_a) { }
            return [];
        })
            .flat();
        return rules.filter(function (r) {
            try {
                return Boolean(r && el.matches(r.selectorText));
            }
            catch (_a) { }
            return false;
        });
    };
    var CSSCriticalPath = /** @class */ (function () {
        function CSSCriticalPath(w, d, opts) {
            var _this = this;
            this.css = {};
            var opt = opts || {};
            var pushCSS = function (r) {
                var selectorText = r.selectorText
                    .split(',')
                    .map(function (a) { return a.trim(); })
                    .sort()
                    .join(',');
                if (Boolean(_this.css[selectorText]) === false) {
                    _this.css[selectorText] = {};
                }
                var styles = r.style.cssText.split(/;(?![A-Za-z0-9])/);
                for (var i = 0; i < styles.length; i++) {
                    if (!styles[i]) {
                        continue;
                    }
                    var pair = styles[i].split(':');
                    pair[0] = pair[0].trim();
                    pair[1] = pair[1].trim();
                    _this.css[selectorText][pair[0]] = pair[1].replace(/var\(([^)]+)\)/g, function (varValue, key) {
                        var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__read */ .zs)(key.split(','), 2), name = _a[0], def = _a[1];
                        return (jodit.ew
                            .getComputedStyle(jodit.editor)
                            .getPropertyValue(name.trim()) ||
                            def ||
                            varValue).trim();
                    });
                }
            };
            var parseTree = function () {
                // Get a list of all the elements in the view.
                var height = w.innerHeight;
                var walker = d.createTreeWalker(jodit.editor, NodeFilter.SHOW_ELEMENT, function () { return NodeFilter.FILTER_ACCEPT; });
                while (walker.nextNode()) {
                    var node = walker.currentNode;
                    var rect = node.getBoundingClientRect();
                    if (rect.top < height || opt.scanFullPage) {
                        var rules = getMatchedCSSRules(node);
                        if (rules) {
                            for (var r = 0; r < rules.length; r++) {
                                pushCSS(rules[r]);
                            }
                        }
                    }
                }
            };
            parseTree();
        }
        CSSCriticalPath.prototype.generateCSS = function () {
            var finalCSS = '';
            for (var k in this.css) {
                if (/:not\(/.test(k)) {
                    continue;
                }
                finalCSS += k + ' { ';
                for (var j in this.css[k]) {
                    finalCSS += j + ': ' + this.css[k][j] + '; ';
                }
                finalCSS += '}\n';
            }
            return finalCSS;
        };
        return CSSCriticalPath;
    }());
    try {
        var cp = new CSSCriticalPath(jodit.ew, jodit.ed, {
            scanFullPage: true
        });
        return cp.generateCSS();
    }
    catch (_a) { }
    return '';
}


/***/ }),

/***/ 11133:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ FileBrowserItem; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

var FileBrowserItem = /** @class */ (function () {
    function FileBrowserItem(data) {
        var _this = this;
        this.data = data;
        // TODO Check with Object.assign
        Object.keys(data).forEach(function (key) {
            _this[key] = data[key];
        });
    }
    FileBrowserItem.create = function (data) {
        if (data instanceof FileBrowserItem) {
            return data;
        }
        return new FileBrowserItem(data);
    };
    Object.defineProperty(FileBrowserItem.prototype, "path", {
        get: function () {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(this.data.source.path ? this.data.source.path + '/' : '/');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "imageURL", {
        get: function () {
            var timestamp = this.time || new Date().getTime().toString(), _a = this.data, thumbIsAbsolute = _a.thumbIsAbsolute, source = _a.source, thumb = _a.thumb, file = _a.file, path = thumb || file;
            return thumbIsAbsolute && path
                ? path
                : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizeUrl)(source.baseurl, source.path, path || '') +
                    '?_tmst=' +
                    encodeURIComponent(timestamp);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "fileURL", {
        get: function () {
            var name = this.data.name;
            var _a = this.data, file = _a.file, fileIsAbsolute = _a.fileIsAbsolute, source = _a.source;
            if (file !== undefined) {
                name = file;
            }
            return fileIsAbsolute && name
                ? name
                : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizeUrl)(source.baseurl, source.path, name || '');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "time", {
        get: function () {
            var changed = this.data.changed;
            return ((changed &&
                (typeof changed === 'number'
                    ? new Date(changed).toLocaleString()
                    : changed)) ||
                '');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "uniqueHashKey", {
        get: function () {
            var data = this.data;
            var key = [
                data.sourceName,
                data.name,
                data.file,
                this.time,
                data.thumb
            ].join('_');
            key = key.toLowerCase().replace(/[^0-9a-z\-.]/g, '-');
            return key;
        },
        enumerable: false,
        configurable: true
    });
    FileBrowserItem.prototype.toJSON = function () {
        return this.data;
    };
    return FileBrowserItem;
}());



/***/ }),

/***/ 11395:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Formátum másolás'
};


/***/ }),

/***/ 11648:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ Table; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







var markedValue = new WeakMap();
var Table = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(Table, _super);
    function Table() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(arguments), false)) || this;
        _this.selected = new Set();
        return _this;
    }
    /** @override */
    Table.prototype.className = function () {
        return 'Table';
    };
    Table.prototype.__recalculateStyles = function () {
        var style = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .getContainer */ .My)(this.j, Table, 'style', true);
        var selectors = [];
        this.selected.forEach(function (td) {
            var selector = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.cssPath)(td);
            selector && selectors.push(selector);
        });
        style.innerHTML = selectors.length
            ? selectors.join(',') +
                "{".concat(this.jodit.options.table.selectionCellStyle, "}")
            : '';
    };
    Table.prototype.addSelection = function (td) {
        this.selected.add(td);
        this.__recalculateStyles();
        var table = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(td, 'table', this.j.editor);
        if (table) {
            var cells = Table.__selectedByTable.get(table) || new Set();
            cells.add(td);
            Table.__selectedByTable.set(table, cells);
        }
    };
    Table.prototype.removeSelection = function (td) {
        this.selected.delete(td);
        this.__recalculateStyles();
        var table = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(td, 'table', this.j.editor);
        if (table) {
            var cells = Table.__selectedByTable.get(table);
            if (cells) {
                cells.delete(td);
                if (!cells.size) {
                    Table.__selectedByTable.delete(table);
                }
            }
        }
    };
    /**
     * Returns array of selected cells
     */
    Table.prototype.getAllSelectedCells = function () {
        return (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(this.selected);
    };
    Table.__getSelectedCellsByTable = function (table) {
        var cells = Table.__selectedByTable.get(table);
        return cells ? (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(cells) : [];
    };
    /** @override **/
    Table.prototype.destruct = function () {
        this.selected.clear();
        return _super.prototype.destruct.call(this);
    };
    Table.__getRowsCount = function (table) {
        return table.rows.length;
    };
    /**
     * Returns rows count in the table
     */
    Table.prototype.getRowsCount = function (table) {
        return Table.__getRowsCount(table);
    };
    Table.__getColumnsCount = function (table) {
        var matrix = Table.__formalMatrix(table);
        return matrix.reduce(function (max_count, cells) { return Math.max(max_count, cells.length); }, 0);
    };
    /**
     * Returns columns count in the table
     */
    Table.prototype.getColumnsCount = function (table) {
        return Table.__getColumnsCount(table);
    };
    Table.__formalMatrix = function (table, callback) {
        var matrix = [[]];
        var rows = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(table.rows);
        var setCell = function (cell, i) {
            if (matrix[i] === undefined) {
                matrix[i] = [];
            }
            var colSpan = cell.colSpan, rowSpan = cell.rowSpan;
            var column, row, currentColumn = 0;
            while (matrix[i][currentColumn]) {
                currentColumn += 1;
            }
            for (row = 0; row < rowSpan; row += 1) {
                for (column = 0; column < colSpan; column += 1) {
                    if (matrix[i + row] === undefined) {
                        matrix[i + row] = [];
                    }
                    if (callback &&
                        callback(cell, i + row, currentColumn + column, colSpan, rowSpan) === false) {
                        return false;
                    }
                    matrix[i + row][currentColumn + column] = cell;
                }
            }
        };
        for (var i = 0; i < rows.length; i += 1) {
            var cells = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(rows[i].cells);
            for (var j = 0; j < cells.length; j += 1) {
                if (setCell(cells[j], i) === false) {
                    return matrix;
                }
            }
        }
        return matrix;
    };
    /**
     * Generate formal table martix columns*rows
     * @param table - Working table
     * @param callback - if return false cycle break
     */
    Table.prototype.formalMatrix = function (table, callback) {
        return Table.__formalMatrix(table, callback);
    };
    Table.__formalCoordinate = function (table, cell, max) {
        if (max === void 0) { max = false; }
        var i = 0, j = 0, width = 1, height = 1;
        Table.__formalMatrix(table, function (td, ii, jj, colSpan, rowSpan) {
            if (cell === td) {
                i = ii;
                j = jj;
                width = colSpan || 1;
                height = rowSpan || 1;
                if (max) {
                    j += (colSpan || 1) - 1;
                    i += (rowSpan || 1) - 1;
                }
                return false;
            }
        });
        return [i, j, width, height];
    };
    /**
     * Get cell coordinate in formal table (without colspan and rowspan)
     */
    Table.prototype.formalCoordinate = function (table, cell, max) {
        if (max === void 0) { max = false; }
        return Table.__formalCoordinate(table, cell, max);
    };
    Table.__appendRow = function (table, line, after, create) {
        var _a;
        var row;
        if (!line) {
            var columnsCount = Table.__getColumnsCount(table);
            row = create.element('tr');
            for (var j = 0; j < columnsCount; j += 1) {
                row.appendChild(create.element('td'));
            }
        }
        else {
            row = line.cloneNode(true);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.$$)('td,th', line).forEach(function (cell) {
                var rowspan = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan');
                if (rowspan && parseInt(rowspan, 10) > 1) {
                    var newRowSpan = parseInt(rowspan, 10) - 1;
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', newRowSpan > 1 ? newRowSpan : null);
                }
            });
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.$$)('td,th', row).forEach(function (cell) {
                cell.innerHTML = '';
            });
        }
        if (after && line && line.nextSibling) {
            line.parentNode &&
                line.parentNode.insertBefore(row, line.nextSibling);
        }
        else if (!after && line) {
            line.parentNode && line.parentNode.insertBefore(row, line);
        }
        else {
            (((_a = table.getElementsByTagName('tbody')) === null || _a === void 0 ? void 0 : _a[0]) || table).appendChild(row);
        }
    };
    /**
     * Inserts a new line after row what contains the selected cell
     *
     * @param table - Working table
     * @param line - Insert a new line after/before this
     * line contains the selected cell
     * @param after - Insert a new line after line contains the selected cell
     */
    Table.prototype.appendRow = function (table, line, after) {
        return Table.__appendRow(table, line, after, this.j.createInside);
    };
    Table.__removeRow = function (table, rowIndex) {
        var box = Table.__formalMatrix(table);
        var dec;
        var row = table.rows[rowIndex];
        box[rowIndex].forEach(function (cell, j) {
            dec = false;
            if (rowIndex - 1 >= 0 && box[rowIndex - 1][j] === cell) {
                dec = true;
            }
            else if (box[rowIndex + 1] && box[rowIndex + 1][j] === cell) {
                if (cell.parentNode === row && cell.parentNode.nextSibling) {
                    dec = true;
                    var nextCell = j + 1;
                    while (box[rowIndex + 1][nextCell] === cell) {
                        nextCell += 1;
                    }
                    var nextRow = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.next(cell.parentNode, function (elm) { return jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.isTag(elm, 'tr'); }, table);
                    if (nextRow) {
                        if (box[rowIndex + 1][nextCell]) {
                            nextRow.insertBefore(cell, box[rowIndex + 1][nextCell]);
                        }
                        else {
                            nextRow.appendChild(cell);
                        }
                    }
                }
            }
            else {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(cell);
            }
            if (dec &&
                (cell.parentNode === row || cell !== box[rowIndex][j - 1])) {
                var rowSpan = cell.rowSpan;
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', rowSpan - 1 > 1 ? rowSpan - 1 : null);
            }
        });
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(row);
    };
    /**
     * Remove row
     */
    Table.prototype.removeRow = function (table, rowIndex) {
        return Table.__removeRow(table, rowIndex);
    };
    /**
     * Insert column before / after all the columns containing the selected cells
     */
    Table.prototype.appendColumn = function (table, selectedCell, insertAfter) {
        if (insertAfter === void 0) { insertAfter = true; }
        var box = Table.__formalMatrix(table);
        if (!insertAfter && jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.isCell(selectedCell.previousElementSibling)) {
            return this.appendColumn(table, selectedCell.previousElementSibling, true);
        }
        var columnIndex = insertAfter
            ? selectedCell.cellIndex + ((selectedCell.colSpan || 1) - 1)
            : selectedCell.cellIndex;
        var newColumnIndex = insertAfter ? columnIndex + 1 : columnIndex;
        for (var i = 0; i < box.length;) {
            var cells = box[i];
            if (cells[columnIndex] !== cells[newColumnIndex] ||
                columnIndex === newColumnIndex) {
                var cell = this.j.createInside.element('td');
                if (insertAfter) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(cells[columnIndex], cell);
                }
                else {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.before(cells[columnIndex], cell);
                }
                if (cells[columnIndex].rowSpan > 1) {
                    cell.rowSpan = cells[columnIndex].rowSpan;
                }
            }
            else {
                cells[columnIndex].colSpan += 1;
            }
            i += cells[columnIndex].rowSpan || 1;
        }
    };
    Table.__removeColumn = function (table, j) {
        var box = Table.__formalMatrix(table);
        var dec;
        box.forEach(function (cells, i) {
            var td = cells[j];
            dec = false;
            if (j - 1 >= 0 && box[i][j - 1] === td) {
                dec = true;
            }
            else if (j + 1 < cells.length && box[i][j + 1] === td) {
                dec = true;
            }
            else {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(td);
            }
            if (dec && (i - 1 < 0 || td !== box[i - 1][j])) {
                var colSpan = td.colSpan;
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(td, 'colspan', colSpan - 1 > 1 ? (colSpan - 1).toString() : null);
            }
        });
    };
    /**
     * Remove column by index
     */
    Table.prototype.removeColumn = function (table, j) {
        return Table.__removeColumn(table, j);
    };
    Table.__getSelectedBound = function (table, selectedCells) {
        var bound = [
            [Infinity, Infinity],
            [0, 0]
        ];
        var box = Table.__formalMatrix(table);
        var i, j, k;
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; box[i] && j < box[i].length; j += 1) {
                if (selectedCells.includes(box[i][j])) {
                    bound[0][0] = Math.min(i, bound[0][0]);
                    bound[0][1] = Math.min(j, bound[0][1]);
                    bound[1][0] = Math.max(i, bound[1][0]);
                    bound[1][1] = Math.max(j, bound[1][1]);
                }
            }
        }
        for (i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (k = 1, j = bound[0][1]; j <= bound[1][1]; j += 1) {
                while (box[i] && box[i][j - k] && box[i][j] === box[i][j - k]) {
                    bound[0][1] = Math.min(j - k, bound[0][1]);
                    bound[1][1] = Math.max(j - k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i] && box[i][j + k] && box[i][j] === box[i][j + k]) {
                    bound[0][1] = Math.min(j + k, bound[0][1]);
                    bound[1][1] = Math.max(j + k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i - k] && box[i][j] === box[i - k][j]) {
                    bound[0][0] = Math.min(i - k, bound[0][0]);
                    bound[1][0] = Math.max(i - k, bound[1][0]);
                    k += 1;
                }
                k = 1;
                while (box[i + k] && box[i][j] === box[i + k][j]) {
                    bound[0][0] = Math.min(i + k, bound[0][0]);
                    bound[1][0] = Math.max(i + k, bound[1][0]);
                    k += 1;
                }
            }
        }
        return bound;
    };
    /**
     * Define bound for selected cells
     */
    Table.prototype.getSelectedBound = function (table, selectedCells) {
        return Table.__getSelectedBound(table, selectedCells);
    };
    Table.__normalizeTable = function (table) {
        var __marked = [], box = Table.__formalMatrix(table);
        Table.__removeExtraColspans(box, __marked);
        Table.__removeExtraRowspans(box, __marked);
        // remove rowspans and colspans equal 1 and empty class
        for (var i = 0; i < box.length; i += 1) {
            for (var j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].hasAttribute('rowspan') &&
                    box[i][j].rowSpan === 1) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'rowspan', null);
                }
                if (box[i][j].hasAttribute('colspan') &&
                    box[i][j].colSpan === 1) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'colspan', null);
                }
                if (box[i][j].hasAttribute('class') &&
                    !(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'class')) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'class', null);
                }
            }
        }
        Table.__unmark(__marked);
    };
    Table.__removeExtraColspans = function (box, __marked) {
        for (var j = 0; j < box[0].length; j += 1) {
            var min = 1000000;
            var not = false;
            for (var i = 0; i < box.length; i += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].colSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].colSpan);
            }
            if (!not) {
                for (var i = 0; i < box.length; i += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'colspan', box[i][j].colSpan - min + 1, __marked);
                }
            }
        }
    };
    Table.__removeExtraRowspans = function (box, marked) {
        var i = 0;
        var j = 0;
        for (i = 0; i < box.length; i += 1) {
            var min = 1000000;
            var not = false;
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].rowSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].rowSpan);
            }
            if (!not) {
                for (j = 0; j < box[i].length; j += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'rowspan', box[i][j].rowSpan - min + 1, marked);
                }
            }
        }
    };
    /**
     * Try recalculate all coluns and rows after change
     */
    Table.prototype.normalizeTable = function (table) {
        return Table.__normalizeTable(table);
    };
    Table.__mergeSelected = function (table, jodit) {
        var html = [], bound = Table.__getSelectedBound(table, Table.__getSelectedCellsByTable(table));
        var w = 0, first = null, first_j = 0, td, cols = 0, rows = 0;
        var alreadyMerged = new Set(), __marked = [];
        if (bound && (bound[0][0] - bound[1][0] || bound[0][1] - bound[1][1])) {
            Table.__formalMatrix(table, function (cell, i, j, cs, rs) {
                if (i >= bound[0][0] && i <= bound[1][0]) {
                    if (j >= bound[0][1] && j <= bound[1][1]) {
                        td = cell;
                        if (alreadyMerged.has(td)) {
                            return;
                        }
                        alreadyMerged.add(td);
                        if (i === bound[0][0] && td.style.width) {
                            w += td.offsetWidth;
                        }
                        if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.trim)(cell.innerHTML.replace(/<br(\/)?>/g, '')) !== '') {
                            html.push(cell.innerHTML);
                        }
                        if (cs > 1) {
                            cols += cs - 1;
                        }
                        if (rs > 1) {
                            rows += rs - 1;
                        }
                        if (!first) {
                            first = cell;
                            first_j = j;
                        }
                        else {
                            Table.__mark(td, 'remove', 1, __marked);
                            instance(jodit).removeSelection(td);
                        }
                    }
                }
            });
            cols = bound[1][1] - bound[0][1] + 1;
            rows = bound[1][0] - bound[0][0] + 1;
            if (first) {
                if (cols > 1) {
                    Table.__mark(first, 'colspan', cols, __marked);
                }
                if (rows > 1) {
                    Table.__mark(first, 'rowspan', rows, __marked);
                }
                if (w) {
                    Table.__mark(first, 'width', ((w / table.offsetWidth) * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
                    if (first_j) {
                        Table.__setColumnWidthByDelta(table, first_j, 0, true, __marked);
                    }
                }
                first.innerHTML = html.join('<br/>');
                instance(jodit).addSelection(first);
                alreadyMerged.delete(first);
                Table.__unmark(__marked);
                Table.__normalizeTable(table);
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(table.rows).forEach(function (tr) {
                    if (!tr.cells.length) {
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(tr);
                    }
                });
            }
        }
    };
    /**
     * It combines all the selected cells into one. The contents of the cells will also be combined
     */
    Table.prototype.mergeSelected = function (table) {
        return Table.__mergeSelected(table, this.j);
    };
    Table.__splitHorizontal = function (table, jodit) {
        var coord, td, tr, parent, after;
        var __marked = [];
        Table.__getSelectedCellsByTable(table).forEach(function (cell) {
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            tr = jodit.createInside.element('tr');
            coord = Table.__formalCoordinate(table, cell);
            if (cell.rowSpan < 2) {
                Table.__formalMatrix(table, function (tdElm, i, j) {
                    if (coord[0] === i &&
                        coord[1] !== j &&
                        tdElm !== cell) {
                        Table.__mark(tdElm, 'rowspan', tdElm.rowSpan + 1, __marked);
                    }
                });
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(cell, 'tr', table), tr);
                tr.appendChild(td);
            }
            else {
                Table.__mark(cell, 'rowspan', cell.rowSpan - 1, __marked);
                Table.__formalMatrix(table, function (tdElm, i, j) {
                    if (i > coord[0] &&
                        i < coord[0] + cell.rowSpan &&
                        coord[1] > j &&
                        tdElm.parentNode
                            .rowIndex === i) {
                        after = tdElm;
                    }
                    if (coord[0] < i && tdElm === cell) {
                        parent = table.rows[i];
                    }
                });
                if (after) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(after, td);
                }
                else {
                    parent.insertBefore(td, parent.firstChild);
                }
            }
            if (cell.colSpan > 1) {
                Table.__mark(td, 'colspan', cell.colSpan, __marked);
            }
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        this.__normalizeTable(table);
    };
    /**
     * Divides all selected by `jodit_focused_cell` class table cell in 2 parts vertical. Those division into 2 columns
     */
    Table.prototype.splitHorizontal = function (table) {
        return Table.__splitHorizontal(table, this.j);
    };
    Table.__splitVertical = function (table, jodit) {
        var coord, td, percentage;
        var __marked = [];
        Table.__getSelectedCellsByTable(table).forEach(function (cell) {
            coord = Table.__formalCoordinate(table, cell);
            if (cell.colSpan < 2) {
                Table.__formalMatrix(table, function (tdElm, i, j) {
                    if (coord[1] === j && coord[0] !== i && tdElm !== cell) {
                        Table.__mark(tdElm, 'colspan', tdElm.colSpan + 1, __marked);
                    }
                });
            }
            else {
                Table.__mark(cell, 'colspan', cell.colSpan - 1, __marked);
            }
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            if (cell.rowSpan > 1) {
                Table.__mark(td, 'rowspan', cell.rowSpan, __marked);
            }
            var oldWidth = cell.offsetWidth; // get old width
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(cell, td);
            percentage = oldWidth / table.offsetWidth / 2;
            Table.__mark(cell, 'width', (percentage * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
            Table.__mark(td, 'width', (percentage * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        Table.__normalizeTable(table);
    };
    /**
     * It splits all the selected cells into 2 parts horizontally. Those. are added new row
     */
    Table.prototype.splitVertical = function (table) {
        return Table.__splitVertical(table, this.j);
    };
    Table.__setColumnWidthByDelta = function (table, column, delta, noUnmark, marked) {
        var box = Table.__formalMatrix(table);
        var clearWidthIndex = 0;
        for (var i = 0; i < box.length; i += 1) {
            var cell = box[i][column];
            if (cell.colSpan > 1 && box.length > 1) {
                continue;
            }
            var w = cell.offsetWidth;
            var percent = ((w + delta) / table.offsetWidth) * 100;
            Table.__mark(cell, 'width', percent.toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', marked);
            clearWidthIndex = i;
            break;
        }
        for (var i = clearWidthIndex + 1; i < box.length; i += 1) {
            var cell = box[i][column];
            Table.__mark(cell, 'width', null, marked);
        }
        if (!noUnmark) {
            Table.__unmark(marked);
        }
    };
    /**
     * Set column width used delta value
     */
    Table.prototype.setColumnWidthByDelta = function (table, column, delta, noUnmark, marked) {
        return Table.__setColumnWidthByDelta(table, column, delta, noUnmark, marked);
    };
    Table.__mark = function (cell, key, value, marked) {
        var _a;
        marked.push(cell);
        var dict = (_a = markedValue.get(cell)) !== null && _a !== void 0 ? _a : {};
        dict[key] = value === undefined ? 1 : value;
        markedValue.set(cell, dict);
    };
    Table.__unmark = function (marked) {
        marked.forEach(function (cell) {
            var dict = markedValue.get(cell);
            if (dict) {
                Object.keys(dict).forEach(function (key) {
                    var value = dict[key];
                    switch (key) {
                        case 'remove':
                            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(cell);
                            break;
                        case 'rowspan':
                            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.isNumber)(value) && value > 1 ? value : null);
                            break;
                        case 'colspan':
                            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'colspan', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.isNumber)(value) && value > 1 ? value : null);
                            break;
                        case 'width':
                            if (value == null) {
                                cell.style.removeProperty('width');
                                if (!(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'style')) {
                                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'style', null);
                                }
                            }
                            else {
                                cell.style.width = value.toString();
                            }
                            break;
                    }
                    delete dict[key];
                });
                markedValue.delete(cell);
            }
        });
    };
    Table.__selectedByTable = new WeakMap();
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.debounce)()
    ], Table.prototype, "__recalculateStyles", null);
    return Table;
}(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG));

var instance = function (j) { return j.getInstance('Table', j.o); };


/***/ }),

/***/ 11799:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'سمبل'
};


/***/ }),

/***/ 11961:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* reexport safe */ autobind_decorator__WEBPACK_IMPORTED_MODULE_0__.Ay; }
/* harmony export */ });
/* harmony import */ var autobind_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52201);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/autobind/README.md]]
 * @packageDocumentation
 * @module decorators/autobind
 */



/***/ }),

/***/ 11968:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'スペルチェック'
};


/***/ }),

/***/ 11995:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ar: function() { return /* reexport module object */ _ar_js__WEBPACK_IMPORTED_MODULE_0__; },
/* harmony export */   cs_cz: function() { return /* reexport module object */ _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   de: function() { return /* reexport module object */ _de_js__WEBPACK_IMPORTED_MODULE_2__; },
/* harmony export */   es: function() { return /* reexport module object */ _es_js__WEBPACK_IMPORTED_MODULE_3__; },
/* harmony export */   fa: function() { return /* reexport module object */ _fa_js__WEBPACK_IMPORTED_MODULE_4__; },
/* harmony export */   fi: function() { return /* reexport module object */ _fi_js__WEBPACK_IMPORTED_MODULE_5__; },
/* harmony export */   fr: function() { return /* reexport module object */ _fr_js__WEBPACK_IMPORTED_MODULE_6__; },
/* harmony export */   he: function() { return /* reexport module object */ _he_js__WEBPACK_IMPORTED_MODULE_7__; },
/* harmony export */   hu: function() { return /* reexport module object */ _hu_js__WEBPACK_IMPORTED_MODULE_8__; },
/* harmony export */   id: function() { return /* reexport module object */ _id_js__WEBPACK_IMPORTED_MODULE_9__; },
/* harmony export */   it: function() { return /* reexport module object */ _it_js__WEBPACK_IMPORTED_MODULE_10__; },
/* harmony export */   ja: function() { return /* reexport module object */ _ja_js__WEBPACK_IMPORTED_MODULE_11__; },
/* harmony export */   ko: function() { return /* reexport module object */ _ko_js__WEBPACK_IMPORTED_MODULE_12__; },
/* harmony export */   mn: function() { return /* reexport module object */ _mn_js__WEBPACK_IMPORTED_MODULE_13__; },
/* harmony export */   nl: function() { return /* reexport module object */ _nl_js__WEBPACK_IMPORTED_MODULE_14__; },
/* harmony export */   pl: function() { return /* reexport module object */ _pl_js__WEBPACK_IMPORTED_MODULE_15__; },
/* harmony export */   pt_br: function() { return /* reexport module object */ _pt_br_js__WEBPACK_IMPORTED_MODULE_16__; },
/* harmony export */   ru: function() { return /* reexport module object */ _ru_js__WEBPACK_IMPORTED_MODULE_17__; },
/* harmony export */   tr: function() { return /* reexport module object */ _tr_js__WEBPACK_IMPORTED_MODULE_18__; },
/* harmony export */   ua: function() { return /* reexport module object */ _ua_js__WEBPACK_IMPORTED_MODULE_19__; },
/* harmony export */   zh_cn: function() { return /* reexport module object */ _zh_cn_js__WEBPACK_IMPORTED_MODULE_20__; },
/* harmony export */   zh_tw: function() { return /* reexport module object */ _zh_tw_js__WEBPACK_IMPORTED_MODULE_21__; }
/* harmony export */ });
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82602);
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_ar_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24575);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_cs_cz_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37414);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_de_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82333);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_es_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _fa_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80124);
/* harmony import */ var _fa_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_fa_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _fi_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96516);
/* harmony import */ var _fi_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_fi_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(30965);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_fr_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _he_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80194);
/* harmony import */ var _he_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_he_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49458);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_hu_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _id_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8916);
/* harmony import */ var _id_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_id_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(43268);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_it_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(11968);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_ja_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _ko_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(12715);
/* harmony import */ var _ko_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_ko_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _mn_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(45698);
/* harmony import */ var _mn_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_mn_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(40119);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_nl_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(92657);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_pl_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(68648);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_pt_br_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _ru_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(70420);
/* harmony import */ var _ru_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_ru_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(98439);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_tr_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _ua_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(65115);
/* harmony import */ var _ua_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_ua_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(55835);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(_zh_cn_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(34747);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(_zh_tw_js__WEBPACK_IMPORTED_MODULE_21__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

























/***/ }),

/***/ 12041:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ isViewObject; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if an element is instance of View
 */
function isViewObject(jodit) {
    return Boolean(jodit &&
        jodit instanceof Object &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(jodit.constructor) &&
        jodit.isView);
}


/***/ }),

/***/ 12043:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ag: function() { return /* binding */ UNSET; },
/* harmony export */   DI: function() { return /* binding */ INITIAL; },
/* harmony export */   OJ: function() { return /* binding */ UNWRAP; },
/* harmony export */   PL: function() { return /* binding */ CHANGE; },
/* harmony export */   Zk: function() { return /* binding */ WRAP; },
/* harmony export */   ar: function() { return /* binding */ _PREFIX; },
/* harmony export */   dj: function() { return /* binding */ REPLACE; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */
/** @internal */
var WRAP = 'wrap';
/** @internal */
var UNWRAP = 'unwrap';
/** @internal */
var CHANGE = 'change';
/** @internal */
var UNSET = 'unset';
/** @internal */
var INITIAL = 'initial';
/** @internal */
var REPLACE = 'replace';
/** @internal */
var _PREFIX = 'commitStyle';


/***/ }),

/***/ 12333:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'тэмдэгт'
};


/***/ }),

/***/ 12461:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ isNumeric; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check value has numeric format
 */
function isNumeric(value) {
    if ((0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(value)) {
        if (!value.match(/^([+-])?[0-9]+(\.?)([0-9]+)?(e[0-9]+)?$/)) {
            return false;
        }
        value = parseFloat(value);
    }
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}


/***/ }),

/***/ 12715:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: '맞춤법 검사'
};


/***/ }),

/***/ 13265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ normalizeRelativePath; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
var normalizeRelativePath = function (path) {
    var sections = path.split('/'), builder = sections.reduce(function (builder, section) {
        switch (section) {
            case '': {
                break;
            }
            case '.': {
                break;
            }
            case '..': {
                builder.pop();
                break;
            }
            default: {
                builder.push(section);
                break;
            }
        }
        return builder;
    }, []);
    return builder.join('/') + (path.endsWith('/') ? '/' : '');
};


/***/ }),

/***/ 13405:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export enter */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9810);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29866);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81781);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * One of most important core plugins. It is responsible for all the browsers to have the same effect when the Enter
 * button is pressed. By default, it should insert the <p>
 */
var enter = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(enter, _super);
    function enter() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @override */
    enter.prototype.afterInit = function (editor) {
        var _this = this;
        // use 'enter' option if no set
        var defaultTag = editor.o.enter.toLowerCase();
        var brMode = defaultTag === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR.toLowerCase();
        if (!editor.o.enterBlock) {
            editor.o.enterBlock = brMode
                ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH
                : defaultTag;
        }
        editor.registerCommand('enter', function (command, value, event) {
            if (event === void 0) { event = {}; }
            return _this.onEnter(event);
        });
    };
    enter.prototype.onEnterKeyDown = function (event) {
        if (event.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ENTER) {
            var editor = this.j;
            var beforeEnter = editor.e.fire('beforeEnter', event);
            if (beforeEnter !== undefined) {
                return beforeEnter;
            }
            if (!editor.s.isCollapsed()) {
                editor.execCommand('Delete');
            }
            editor.s.focus();
            this.onEnter(event);
            editor.e.fire('afterEnter', event);
            editor.synchronizeValues(); // fire change
            return false;
        }
    };
    enter.prototype.onEnter = function (event) {
        var jodit = this.jodit;
        var fake = jodit.createInside.fake();
        try {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(jodit.s.range, fake);
            (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .moveCursorOutFromSpecialTags */ .Mt)(jodit, fake, ['a']);
            var block = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .getBlockWrapper */ .Dk)(fake, jodit);
            var isLi = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isLeaf(block);
            // if use <br> defaultTag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
            if ((!isLi || (event === null || event === void 0 ? void 0 : event.shiftKey)) &&
                (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .checkBR */ .lN)(fake, jodit, event === null || event === void 0 ? void 0 : event.shiftKey)) {
                return false;
            }
            // wrap no wrapped element
            if (!block && !(0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .hasPreviousBlock */ .tX)(fake, jodit)) {
                block = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .wrapText */ .C1)(fake, jodit);
            }
            if (!block) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .insertParagraph */ .yh)(fake, jodit, isLi ? 'li' : jodit.o.enter);
                return false;
            }
            if (!(0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .checkUnsplittableBox */ .bD)(fake, jodit, block)) {
                return false;
            }
            if (isLi && this.__isEmptyListLeaf(block)) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .processEmptyLILeaf */ .cf)(fake, jodit, block);
                return false;
            }
            (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .splitFragment */ .HS)(fake, jodit, block);
        }
        finally {
            fake.isConnected && jodit.s.setCursorBefore(fake);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(fake);
        }
    };
    enter.prototype.__isEmptyListLeaf = function (li) {
        var result = this.j.e.fire('enterIsEmptyListLeaf', li);
        return (0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_7__/* .isBoolean */ .L)(result) ? result : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmpty(li);
    };
    /** @override */
    enter.prototype.beforeDestruct = function (editor) {
        editor.e.off('keydown.enter');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':keydown.enter')
    ], enter.prototype, "onEnterKeyDown", null);
    return enter;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('enter', enter);


/***/ }),

/***/ 13642:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ UISpacer; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module ui/group
 */


var UISpacer = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__extends */ .C6)(UISpacer, _super);
    function UISpacer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UISpacer.prototype.className = function () {
        return 'UISpacer';
    };
    UISpacer = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__/* .component */ .s
    ], UISpacer);
    return UISpacer;
}(jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__/* .UIElement */ .D));



/***/ }),

/***/ 13676:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ elementsEqualAttributes; },
/* harmony export */   M: function() { return /* binding */ isSameAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95350);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _has_same_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70592);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Compares whether the given attributes match the element's own attributes
 * @private
 */
function isSameAttributes(elm, attrs) {
    if (!elm.attributes.length && !(0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__/* .size */ .E)(attrs)) {
        return true;
    }
    if (!(0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__/* .size */ .E)(attrs)) {
        return true;
    }
    void 0;
    return Object.keys(attrs).every(function (key) {
        if (key === 'class' || key === 'className') {
            return elm.classList.contains(attrs[key]);
        }
        if (key === 'style') {
            return (0,_has_same_style__WEBPACK_IMPORTED_MODULE_3__/* .hasSameStyle */ .g)(elm, attrs[key]);
        }
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, key) === attrs[key];
    });
}
function elementsEqualAttributes(elm1, elm2) {
    return (elm1.attributes.length === elm2.attributes.length &&
        Array.from(elm1.attributes).every(function (attr) {
            return elm2.hasAttribute(attr.name) &&
                elm2.getAttribute(attr.name) === attr.value;
        }));
}


/***/ }),

/***/ 13861:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export paste */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(70674);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(90823);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * Ask before paste HTML source
 */
var paste = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(paste, _super);
    function paste() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(arguments), false)) || this;
        _this.pasteStack = new jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.LimitedStack(20);
        /**
         * The dialog box was already open
         */
        _this._isDialogOpened = false;
        return _this;
    }
    /** @override **/
    paste.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit.e
            .on('paste.paste', this.onPaste)
            .on('pasteStack.paste', function (item) {
            return _this.pasteStack.push(item);
        });
        if (jodit.o.nl2brInPlainText) {
            this.j.e.on('processPaste.paste', this.onProcessPasteReplaceNl2Br);
        }
    };
    /** @override **/
    paste.prototype.beforeDestruct = function (jodit) {
        jodit.e
            .off('paste.paste', this.onPaste)
            .off('processPaste.paste', this.onProcessPasteReplaceNl2Br)
            .off('.paste');
    };
    /**
     * Paste event handler
     */
    paste.prototype.onPaste = function (e) {
        try {
            if (this.customPasteProcess(e) === false ||
                this.j.e.fire('beforePaste', e) === false) {
                e.preventDefault();
                return false;
            }
            this.defaultPasteProcess(e);
        }
        finally {
            this.j.e.fire('afterPaste', e);
        }
    };
    /**
     * Process before paste
     */
    paste.prototype.customPasteProcess = function (e) {
        var e_1, _a;
        if (!this.j.o.processPasteHTML) {
            return;
        }
        var dt = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.getDataTransfer)(e), texts = [
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN),
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_HTML),
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_RTF)
        ];
        try {
            for (var texts_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__values */ .Ju)(texts), texts_1_1 = texts_1.next(); !texts_1_1.done; texts_1_1 = texts_1.next()) {
                var value = texts_1_1.value;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isHTML)(value) &&
                    (this.j.e.fire('processHTML', e, value, {
                        plain: texts[0],
                        html: texts[1],
                        rtf: texts[2]
                    }) ||
                        this.processHTML(e, value))) {
                    return false;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (texts_1_1 && !texts_1_1.done && (_a = texts_1.return)) _a.call(texts_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    /**
     * Default paster process
     */
    paste.prototype.defaultPasteProcess = function (e) {
        var dt = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.getDataTransfer)(e);
        var text = (dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_HTML)) || (dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN));
        if (dt && text && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.trim)(text) !== '') {
            var result = this.j.e.fire('processPaste', e, text, (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getAllTypes */ .DI)(dt));
            if (result !== undefined) {
                text = result;
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(text) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(text)) {
                this.__insertByType(e, text, this.j.o.defaultActionOnPaste);
            }
            e.preventDefault();
            e.stopPropagation();
        }
    };
    /**
     * Process usual HTML text fragment
     */
    paste.prototype.processHTML = function (e, html) {
        var _this = this;
        if (!this.j.o.askBeforePasteHTML) {
            return false;
        }
        if (this.j.o.memorizeChoiceWhenPasteFragment) {
            var cached = this.pasteStack.find(function (cachedItem) { return cachedItem.html === html; });
            if (cached) {
                this.__insertByType(e, html, cached.action || this.j.o.defaultActionOnPaste);
                return true;
            }
        }
        if (this._isDialogOpened) {
            return true;
        }
        var dialog = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .askInsertTypeDialog */ .PU)(this.j, 'Your code is similar to HTML. Keep as HTML?', 'Paste as HTML', function (insertType) {
            _this._isDialogOpened = false;
            _this.__insertByType(e, html, insertType);
        }, this.j.o.pasteHTMLActionList);
        if (dialog) {
            this._isDialogOpened = true;
            dialog.e.on('beforeClose', function () {
                _this._isDialogOpened = false;
            });
        }
        return true;
    };
    /**
     * Insert HTML by option type
     */
    paste.prototype.__insertByType = function (e, html, action) {
        this.pasteStack.push({ html: html, action: action });
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(html)) {
            this.j.buffer.set(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID, html);
            switch (action) {
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_CLEAR_HTML:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.cleanFromWord)(html);
                    break;
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_ONLY_TEXT:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.stripTags)(html, this.j.ed, new Set(this.j.o.pasteExcludeStripTags));
                    break;
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_TEXT:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.htmlspecialchars)(html);
                    break;
                default: {
                    var newHTML = this.j.e.fire('onCustomPasteHTMLOption', action, html, e);
                    if (typeof newHTML === 'string') {
                        html = newHTML;
                    }
                }
            }
        }
        (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .pasteInsertHtml */ .sX)(e, this.j, html);
    };
    /**
     * Replace all \\n chars in plain text to br
     */
    paste.prototype.onProcessPasteReplaceNl2Br = function (ignore, text, type) {
        if (type === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN + ';' && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isHTML)(text)) {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.nl2br)(text);
        }
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], paste.prototype, "onPaste", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], paste.prototype, "onProcessPasteReplaceNl2Br", null);
    return paste;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('paste', paste);


/***/ }),

/***/ 13917:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export backspace */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46602);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81982);
/* harmony import */ var _cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(90084);
/* harmony import */ var _cases__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(89832);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










var backspace = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(backspace, _super);
    function backspace() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    backspace.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit
            .registerCommand('deleteButton', {
            exec: function () { return _this.onDelete(false); },
            hotkeys: jodit.o.delete.hotkeys.delete
        }, {
            stopPropagation: false
        })
            .registerCommand('backspaceButton', {
            exec: function () { return _this.onDelete(true); },
            hotkeys: jodit.o.delete.hotkeys.backspace
        }, {
            stopPropagation: false
        })
            .registerCommand('deleteWordButton', {
            exec: function () { return _this.onDelete(false, 'word'); },
            hotkeys: jodit.o.delete.hotkeys.deleteWord
        })
            .registerCommand('backspaceWordButton', {
            exec: function () { return _this.onDelete(true, 'word'); },
            hotkeys: jodit.o.delete.hotkeys.backspaceWord
        })
            .registerCommand('deleteSentenceButton', {
            exec: function () { return _this.onDelete(false, 'sentence'); },
            hotkeys: jodit.o.delete.hotkeys.deleteSentence
        })
            .registerCommand('backspaceSentenceButton', {
            exec: function () { return _this.onDelete(true, 'sentence'); },
            hotkeys: jodit.o.delete.hotkeys.backspaceSentence
        });
    };
    backspace.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('afterCommand.delete');
    };
    /**
     * Listener BackSpace or Delete button
     */
    backspace.prototype.onDelete = function (backspace, mode) {
        if (mode === void 0) { mode = 'char'; }
        var jodit = this.j;
        var sel = jodit.selection;
        if (!sel.isFocused()) {
            sel.focus();
        }
        if ((0,_cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_8__/* .checkNotCollapsed */ .L)(jodit)) {
            return false;
        }
        var range = sel.range;
        var fakeNode = jodit.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
        try {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeInsertNode(range, fakeNode);
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(jodit.editor, fakeNode)) {
                return;
            }
            if (jodit.e.fire('backSpaceBeforeCases', backspace, fakeNode)) {
                return false;
            }
            (0,jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_4__/* .moveNodeInsideStart */ .W8)(jodit, fakeNode, backspace);
            if (_cases__WEBPACK_IMPORTED_MODULE_6__/* .cases */ .C.some(function (func) {
                if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_9__/* .isFunction */ .T)(func) &&
                    func(jodit, fakeNode, backspace, mode)) {
                    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                        console.info('Remove case:', func.name);
                    }
                    return true;
                }
            })) {
                return false;
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                console.error(e);
            }
            throw e;
        }
        finally {
            jodit.e.fire('backSpaceAfterDelete', backspace, fakeNode);
            this.safeRemoveEmptyNode(fakeNode);
        }
        return false;
    };
    /**
     * Remove node and replace cursor position out of it
     */
    backspace.prototype.safeRemoveEmptyNode = function (fakeNode) {
        var _a, _b;
        var range = this.j.s.range;
        if (range.startContainer === fakeNode) {
            if (fakeNode.previousSibling) {
                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(fakeNode.previousSibling)) {
                    range.setStart(fakeNode.previousSibling, (_b = (_a = fakeNode.previousSibling.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
                }
                else {
                    range.setStartAfter(fakeNode.previousSibling);
                }
            }
            else if (fakeNode.nextSibling) {
                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(fakeNode.nextSibling)) {
                    range.setStart(fakeNode.nextSibling, 0);
                }
                else {
                    range.setStartBefore(fakeNode.nextSibling);
                }
            }
            range.collapse(true);
            this.j.s.selectRange(range);
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(fakeNode);
    };
    backspace.requires = ['hotkeys'];
    return backspace;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('backspace', backspace);


/***/ }),

/***/ 14006:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1216 320q0 26-19 45t-45 19h-128v1024h128q26 0 45 19t19 45-19 45l-256 256q-19 19-45 19t-45-19l-256-256q-19-19-19-45t19-45 45-19h128v-1024h-128q-26 0-45-19t-19-45 19-45l256-256q19-19 45-19t45 19l256 256q19 19 19 45z\"/> </svg>"

/***/ }),

/***/ 14017:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M384 544v576q0 13-9.5 22.5t-22.5 9.5q-14 0-23-9l-288-288q-9-9-9-23t9-23l288-288q9-9 23-9 13 0 22.5 9.5t9.5 22.5zm1408 768v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5z\"/> </svg>"

/***/ }),

/***/ 14100:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'ارتفاع الخط'
};


/***/ }),

/***/ 14221:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36115);
/* harmony import */ var _about_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(17995);
/* harmony import */ var _about_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_about_svg__WEBPACK_IMPORTED_MODULE_5__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.controls.about = {
    exec: function (editor) {
        var dialog = editor.dlg({ closeOnClickOverlay: true }), i = editor.i18n.bind(editor);
        dialog
            .setMod('theme', editor.o.theme)
            .setHeader(i('About Jodit'))
            .setContent("<div class=\"jodit-about\">\n\t\t\t\t\t<div>".concat(i('Jodit Editor'), " v.").concat(editor.getVersion(), "</div>\n\t\t\t\t\t<div>").concat(i('License: %s', !(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_2__.isLicense)(editor.o.license)
            ? 'MIT'
            : (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_2__.normalizeLicense)(editor.o.license)), "</div>\n\t\t\t\t\t<div>\n\t\t\t\t\t\t<a href=\"").concat(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.HOMEPAGE, "\" target=\"_blank\">").concat(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.HOMEPAGE, "</a>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div>\n\t\t\t\t\t\t<a href=\"https://xdsoft.net/jodit/docs/\" target=\"_blank\">").concat(i("Jodit User's Guide"), "</a>\n\t\t\t\t\t\t").concat(i('contains detailed help for using'), "\n\t\t\t\t\t</div>\n\t\t\t\t\t<div>").concat(i('Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.'), "</div>\n\t\t\t\t</div>"));
        (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_2__.css)(dialog.dialog, {
            minHeight: 200,
            minWidth: 420
        });
        dialog.open(true, true);
    },
    tooltip: 'About Jodit',
    mode: jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG
};
function about(editor) {
    editor.registerButton({
        name: 'about',
        group: 'info'
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('about', about);
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.set('about', (_about_svg__WEBPACK_IMPORTED_MODULE_5___default()));


/***/ }),

/***/ 14305:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1171 960q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23z\"/> </svg>"

/***/ }),

/***/ 14367:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2805);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * Wrap single text nodes in block wrapper
 */
var wrapNodes = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__extends */ .C6)(wrapNodes, _super);
    function wrapNodes() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__read */ .zs)(arguments), false)) || this;
        /**
         * Found Node which should be wrapped
         */
        _this.isSuitableStart = function (n) {
            var _a;
            return (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(n) &&
                (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__/* .isString */ .K)(n.nodeValue) &&
                (/[^\s]/.test(n.nodeValue) ||
                    (((_a = n.parentNode) === null || _a === void 0 ? void 0 : _a.firstChild) === n &&
                        _this.isSuitable(n.nextSibling)))) ||
                (_this.isNotWrapped(n) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTemporary(n));
        };
        /**
         * Node should add in a block element
         */
        _this.isSuitable = function (n) {
            return jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(n) || _this.isNotWrapped(n);
        };
        /**
         * Some element which needs to append in block
         */
        _this.isNotWrapped = function (n) {
            return jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(n) &&
                !(jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isBlock(n) || jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(n, _this.j.o.wrapNodes.exclude));
        };
        return _this;
    }
    /** @override **/
    wrapNodes.prototype.afterInit = function (jodit) {
        if (jodit.o.enter.toLowerCase() === 'br') {
            return;
        }
        jodit.e
            .on('drop.wtn focus.wtn keydown.wtn mousedown.wtn afterInit.wtn backSpaceAfterDelete.wtn', this.preprocessInput, {
            top: true
        })
            .on('afterInit.wtn postProcessSetEditorValue.wtn afterCommitStyle.wtn backSpaceAfterDelete.wtn', this.postProcessSetEditorValue);
    };
    /** @override **/
    wrapNodes.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('.wtn');
    };
    /**
     * Process changed value
     */
    wrapNodes.prototype.postProcessSetEditorValue = function () {
        var jodit = this.jodit;
        if (!jodit.isEditorMode()) {
            return;
        }
        var child = jodit.editor.firstChild, isChanged = false;
        while (child) {
            child = checkAloneListLeaf(child, jodit);
            if (this.isSuitableStart(child)) {
                if (!isChanged) {
                    jodit.s.save();
                }
                isChanged = true;
                var box = jodit.createInside.element(jodit.o.enter);
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(child, box);
                while (child && this.isSuitable(child)) {
                    var next = child.nextSibling;
                    box.appendChild(child);
                    child = next;
                }
                box.normalize();
                child = box;
            }
            child = child && child.nextSibling;
        }
        if (isChanged) {
            jodit.s.restore();
            if (jodit.e.current === 'afterInit') {
                jodit.e.fire('internalChange');
            }
        }
    };
    /**
     * Process input without parent box
     */
    wrapNodes.prototype.preprocessInput = function () {
        var jodit = this.jodit, isAfterInitEvent = jodit.e.current === 'afterInit';
        if (!jodit.isEditorMode() ||
            jodit.editor.firstChild ||
            (!jodit.o.wrapNodes.emptyBlockAfterInit && isAfterInitEvent)) {
            return;
        }
        var box = jodit.createInside.element(jodit.o.enter);
        var br = jodit.createInside.element('br');
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.append(box, br);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.append(jodit.editor, box);
        jodit.s.isFocused() && jodit.s.setCursorBefore(br);
        jodit.e.fire('internalChange');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], wrapNodes.prototype, "postProcessSetEditorValue", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], wrapNodes.prototype, "preprocessInput", null);
    return wrapNodes;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k));
function checkAloneListLeaf(child, jodit) {
    var result = child;
    var next = child;
    do {
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(next) &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isLeaf(next) &&
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isList(next.parentElement)) {
            var nextChild = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(next, false);
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(result, 'ul')) {
                result.appendChild(next);
            }
            else {
                result = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrap(next, 'ul', jodit.createInside);
            }
            next = nextChild;
        }
        else {
            break;
        }
    } while (next);
    return result;
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('wrapNodes', wrapNodes);


/***/ }),

/***/ 14950:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Rivin korkeus'
};


/***/ }),

/***/ 14961:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ ViewWithToolbar; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(52201);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32709);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58720);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(39611);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(77782);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */













var ViewWithToolbar = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(ViewWithToolbar, _super);
    /** @override **/
    function ViewWithToolbar(options, isJodit) {
        if (isJodit === void 0) { isJodit = false; }
        var _this = _super.call(this, options, isJodit) || this;
        _this.toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__/* .makeCollection */ .$K)(_this);
        _this.__defaultToolbarContainer = _this.c.div('jodit-toolbar__box');
        _this.registeredButtons = new Set();
        _this.groupToButtons = {};
        _this.isJodit = false;
        _this.__tooltip = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__/* .UITooltip */ .SB(_this);
        _this.isJodit = isJodit;
        _this.e.on('beforeToolbarBuild', _this.beforeToolbarBuild);
        return _this;
    }
    Object.defineProperty(ViewWithToolbar.prototype, "toolbarContainer", {
        /**
         * Container for toolbar
         */
        get: function () {
            if (!this.o.fullsize &&
                ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_9__/* .isString */ .K)(this.o.toolbar) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(this.o.toolbar))) {
                return (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_4__/* .resolveElement */ .tI)(this.o.toolbar, this.o.shadowRoot || this.od);
            }
            this.o.toolbar &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.appendChildFirst(this.container, this.__defaultToolbarContainer);
            return this.__defaultToolbarContainer;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Change panel container
     */
    ViewWithToolbar.prototype.setPanel = function (element) {
        this.o.toolbar = element;
        this.buildToolbar();
    };
    /**
     * Helper for appended toolbar in its place
     */
    ViewWithToolbar.prototype.buildToolbar = function () {
        var _a;
        if (!this.o.toolbar) {
            return;
        }
        var buttons = this.o.buttons
            ? (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_3__/* .splitArray */ .uM)(this.o.buttons)
            : [];
        (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.setRemoveButtons(this.o.removeButtons).build(buttons.concat(this.o.extraButtons || [])).appendTo(this.toolbarContainer);
    };
    ViewWithToolbar.prototype.getRegisteredButtonGroups = function () {
        return this.groupToButtons;
    };
    /**
     * Register button for a group
     */
    ViewWithToolbar.prototype.registerButton = function (btn) {
        var _a;
        this.registeredButtons.add(btn);
        var group = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other';
        if (!this.groupToButtons[group]) {
            this.groupToButtons[group] = [];
        }
        if (btn.position != null) {
            this.groupToButtons[group][btn.position] = btn.name;
        }
        else {
            this.groupToButtons[group].push(btn.name);
        }
        return this;
    };
    /**
     * Remove button from a group
     */
    ViewWithToolbar.prototype.unregisterButton = function (btn) {
        var _a;
        this.registeredButtons.delete(btn);
        var groupName = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other', group = this.groupToButtons[groupName];
        if (group) {
            var index = group.indexOf(btn.name);
            if (index !== -1) {
                group.splice(index, 1);
            }
            if (group.length === 0) {
                delete this.groupToButtons[groupName];
            }
        }
        return this;
    };
    /**
     * Prepare toolbar items and append buttons in groups
     */
    ViewWithToolbar.prototype.beforeToolbarBuild = function (items) {
        var _this = this;
        if (Object.keys(this.groupToButtons).length) {
            return items.map(function (item) {
                if ((0,jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_10__/* .isButtonGroup */ .i)(item) &&
                    item.group &&
                    _this.groupToButtons[item.group]) {
                    return {
                        group: item.group,
                        buttons: (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)((0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(item.buttons), false), (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(_this.groupToButtons[item.group]), false)
                    };
                }
                return item;
            });
        }
    };
    ViewWithToolbar.prototype.destruct = function () {
        if (this.isDestructed) {
            return;
        }
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        this.e.off('beforeToolbarBuild', this.beforeToolbarBuild);
        this.__tooltip.destruct();
        this.toolbar.destruct();
        // @ts-ignore After destruct, we are not responsible for anything
        this.toolbar = undefined;
        _super.prototype.destruct.call(this);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)(':rebuildToolbar')
    ], ViewWithToolbar.prototype, "buildToolbar", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Ay
    ], ViewWithToolbar.prototype, "beforeToolbarBuild", null);
    return ViewWithToolbar;
}(jodit_core_view_view__WEBPACK_IMPORTED_MODULE_6__/* .View */ .S));



/***/ }),

/***/ 15396:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Zd: function() { return /* reexport safe */ _get_hash__WEBPACK_IMPORTED_MODULE_0__.Z; },
/* harmony export */   eZ: function() { return /* reexport safe */ _visitor_visit_node_walker__WEBPACK_IMPORTED_MODULE_3__.e; },
/* harmony export */   hk: function() { return /* reexport safe */ _remove_format_remove_format_for_selection__WEBPACK_IMPORTED_MODULE_2__.h; },
/* harmony export */   w5: function() { return /* reexport safe */ _remove_format_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_1__.w; }
/* harmony export */ });
/* harmony import */ var _get_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(60549);
/* harmony import */ var _remove_format_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30526);
/* harmony import */ var _remove_format_remove_format_for_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20646);
/* harmony import */ var _visitor_visit_node_walker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(52306);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/clean-html
 */






/***/ }),

/***/ 15776:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _items_a__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97836);
/* harmony import */ var _items_cells__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82558);
/* harmony import */ var _items_iframe__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6295);
/* harmony import */ var _items_img__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26396);
/* harmony import */ var _items_toolbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(58540);
/* harmony import */ var jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38681);
/* harmony import */ var jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(64637);
/* harmony import */ var jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(94190);
/* harmony import */ var jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(51957);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71940);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(43218);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(48007);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */














jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInline = true;
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInlineForSelection = false;
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInlineDisableFor = [];
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInlineDisabledButtons = ['source'];
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .I.set('addcolumn', (jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6___default()))
    .set('addrow', (jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7___default()))
    .set('merge', (jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8___default()))
    .set('th', (jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11___default()))
    .set('splitg', (jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9___default()))
    .set('splitv', (jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10___default()))
    .set('th-list', (jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.popup = {
    a: _items_a__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A,
    img: _items_img__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A,
    cells: _items_cells__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A,
    toolbar: _items_toolbar__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A,
    jodit: _items_iframe__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A,
    iframe: _items_iframe__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A,
    'jodit-media': _items_iframe__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A,
    selection: [
        'bold',
        'underline',
        'italic',
        'ul',
        'ol',
        '\n',
        'outdent',
        'indent',
        'fontsize',
        'brush',
        'cut',
        '\n',
        'paragraph',
        'link',
        'align',
        'dots'
    ]
};


/***/ }),

/***/ 15966:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Высота линии'
};


/***/ }),

/***/ 16113:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Gq: function() { return /* reexport safe */ _htmlspecialchars__WEBPACK_IMPORTED_MODULE_2__.G; },
/* harmony export */   HA: function() { return /* reexport safe */ _nl2br__WEBPACK_IMPORTED_MODULE_3__.H; },
/* harmony export */   Kq: function() { return /* reexport safe */ _strip_tags__WEBPACK_IMPORTED_MODULE_5__.K; },
/* harmony export */   ZM: function() { return /* reexport safe */ _apply_styles__WEBPACK_IMPORTED_MODULE_0__.Z; },
/* harmony export */   t_: function() { return /* reexport safe */ _safe_html__WEBPACK_IMPORTED_MODULE_4__.t; },
/* harmony export */   vn: function() { return /* reexport safe */ _safe_html__WEBPACK_IMPORTED_MODULE_4__.v; },
/* harmony export */   wE: function() { return /* reexport safe */ _clean_from_word__WEBPACK_IMPORTED_MODULE_1__.w; }
/* harmony export */ });
/* harmony import */ var _apply_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56176);
/* harmony import */ var _clean_from_word__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94450);
/* harmony import */ var _htmlspecialchars__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4960);
/* harmony import */ var _nl2br__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10025);
/* harmony import */ var _safe_html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26328);
/* harmony import */ var _strip_tags__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61793);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */








/***/ }),

/***/ 16116:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kn: function() { return /* reexport safe */ _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__.K; },
/* harmony export */   Zg: function() { return /* reexport safe */ _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__.Z; },
/* harmony export */   kG: function() { return /* reexport safe */ _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__.k; }
/* harmony export */ });
/* harmony import */ var _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19633);
/* harmony import */ var _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10067);
/* harmony import */ var _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/widget/README.md]]
 * @packageDocumentation
 * @module modules/widget
 */





/***/ }),

/***/ 16841:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: function() { return /* binding */ get; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const obj = {
 *   a: {
 *     b: {
 *       c: {
 *         e: false
 *       }
 *     }
 *   }
 * };
 *
 * console.log(Jodit.modules.Helpers.get('a.b.c.d.e', obj) === false); // true
 * console.log(Jodit.modules.Helpers.get('a.b.a.d.e', obj) === null); // false
 * ```
 */
function get(chain, obj) {
    var e_1, _a;
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(chain) || !chain.length) {
        return null;
    }
    var parts = chain.split('.');
    var result = obj;
    try {
        try {
            for (var parts_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__values */ .Ju)(parts), parts_1_1 = parts_1.next(); !parts_1_1.done; parts_1_1 = parts_1.next()) {
                var part = parts_1_1.value;
                if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .R)(result[part])) {
                    return null;
                }
                result = result[part];
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (parts_1_1 && !parts_1_1.done && (_a = parts_1.return)) _a.call(parts_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    catch (_b) {
        return null; // permission denied ore another access exception
    }
    if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .R)(result)) {
        return null;
    }
    return result;
}


/***/ }),

/***/ 17343:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export search */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(78593);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(78817);
/* harmony import */ var jodit_plugins_search_ui_search__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63064);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










/**
 * Search plugin. it is used for custom search in text
 * ![search](https://user-images.githubusercontent.com/794318/34545433-cd0a9220-f10e-11e7-8d26-7e22f66e266d.gif)
 *
 * @example
 * ```typescript
 * const jodit = Jodit.make('#editor', {
 *  useSearch: false
 * });
 * // or
 * const jodit = Jodit.make('#editor', {
 *  disablePlugins: 'search'
 * });
 * ```
 */
var search = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__extends */ .C6)(search, _super);
    function search() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__read */ .zs)(arguments), false)) || this;
        _this.buttons = [
            {
                name: 'find',
                group: 'search'
            }
        ];
        _this.previousQuery = '';
        _this.drawPromise = null;
        _this.walker = null;
        _this.walkerCount = null;
        _this.cache = {};
        _this.wrapFrameRequest = 0;
        return _this;
    }
    Object.defineProperty(search.prototype, "ui", {
        get: function () {
            return new jodit_plugins_search_ui_search__WEBPACK_IMPORTED_MODULE_8__/* .UISearch */ .F(this.j);
        },
        enumerable: false,
        configurable: true
    });
    search.prototype.updateCounters = function () {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var _a;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this.ui.isOpened) {
                            return [2 /*return*/];
                        }
                        _a = this.ui;
                        return [4 /*yield*/, this.calcCounts(this.ui.query)];
                    case 1:
                        _a.count = _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    search.prototype.onPressReplaceButton = function () {
        this.findAndReplace(this.ui.query);
        this.updateCounters();
    };
    search.prototype.tryScrollToElement = function (startContainer) {
        // find scrollable element
        var parentBox = jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(startContainer, jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement, this.j.editor);
        if (!parentBox) {
            parentBox = jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev(startContainer, jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement, this.j.editor);
        }
        parentBox &&
            parentBox !== this.j.editor &&
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.scrollIntoViewIfNeeded)(parentBox, this.j.editor, this.j.ed);
    };
    search.prototype.calcCounts = function (query) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.findQueryBounds(query, 'walkerCount')];
                    case 1: return [2 /*return*/, (_a.sent()).length];
                }
            });
        });
    };
    search.prototype.findQueryBounds = function (query, walkerKey) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var walker;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_a) {
                walker = this[walkerKey];
                if (walker) {
                    walker.break();
                }
                walker = new jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .LazyWalker */ .p(this.j.async, {
                    timeout: this.j.o.search.lazyIdleTimeout
                });
                this[walkerKey] = walker;
                return [2 /*return*/, this.find(walker, query).catch(function (e) {
                        !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error(e);
                        return [];
                    })];
            });
        });
    };
    search.prototype.findAndReplace = function (query) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var bounds, currentIndex, bound, rng, textNode;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.findQueryBounds(query, 'walker')];
                    case 1:
                        bounds = _a.sent();
                        if (!bounds.length) {
                            return [2 /*return*/, false];
                        }
                        currentIndex = this.findCurrentIndexInRanges(bounds, this.j.s.range);
                        if (currentIndex === -1) {
                            currentIndex = 0;
                        }
                        bound = bounds[currentIndex];
                        if (!bound) return [3 /*break*/, 6];
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, , 4, 5]);
                        rng = this.j.ed.createRange();
                        rng.setStart(bound.startContainer, bound.startOffset);
                        rng.setEnd(bound.endContainer, bound.endOffset);
                        rng.deleteContents();
                        textNode = this.j.createInside.text(this.ui.replace);
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(rng, textNode);
                        (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .clearSelectionWrappers */ .IJ)(this.j);
                        this.j.s.setCursorAfter(textNode);
                        this.tryScrollToElement(textNode);
                        this.cache = {};
                        this.ui.currentIndex = currentIndex;
                        return [4 /*yield*/, this.findAndSelect(query, true).catch(function (e) {
                                !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error(e);
                                return null;
                            })];
                    case 3:
                        _a.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        this.j.synchronizeValues();
                        return [7 /*endfinally*/];
                    case 5:
                        this.j.e.fire('afterFindAndReplace');
                        return [2 /*return*/, true];
                    case 6: return [2 /*return*/, false];
                }
            });
        });
    };
    search.prototype.findAndSelect = function (query, next) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var bounds, currentIndex, bound, rng;
            var _a;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.findQueryBounds(query, 'walker')];
                    case 1:
                        bounds = _b.sent();
                        if (!bounds.length) {
                            return [2 /*return*/, false];
                        }
                        if (this.previousQuery !== query ||
                            !(0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getSelectionWrappers */ .zy)(this.j.editor).length) {
                            (_a = this.drawPromise) === null || _a === void 0 ? void 0 : _a.rejectCallback();
                            this.j.async.cancelAnimationFrame(this.wrapFrameRequest);
                            (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .clearSelectionWrappers */ .IJ)(this.j);
                            this.drawPromise = this.__drawSelectionRanges(bounds);
                        }
                        this.previousQuery = query;
                        currentIndex = this.ui.currentIndex - 1;
                        if (currentIndex === -1) {
                            currentIndex = 0;
                        }
                        else if (next) {
                            currentIndex =
                                currentIndex === bounds.length - 1 ? 0 : currentIndex + 1;
                        }
                        else {
                            currentIndex =
                                currentIndex === 0 ? bounds.length - 1 : currentIndex - 1;
                        }
                        this.ui.currentIndex = currentIndex + 1;
                        bound = bounds[currentIndex];
                        if (!bound) return [3 /*break*/, 4];
                        rng = this.j.ed.createRange();
                        try {
                            rng.setStart(bound.startContainer, bound.startOffset);
                            rng.setEnd(bound.endContainer, bound.endOffset);
                            this.j.s.selectRange(rng);
                        }
                        catch (e) {
                            !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error(e);
                        }
                        this.tryScrollToElement(bound.startContainer);
                        return [4 /*yield*/, this.updateCounters()];
                    case 2:
                        _b.sent();
                        return [4 /*yield*/, this.drawPromise];
                    case 3:
                        _b.sent();
                        this.j.e.fire('afterFindAndSelect');
                        return [2 /*return*/, true];
                    case 4: return [2 /*return*/, false];
                }
            });
        });
    };
    search.prototype.findCurrentIndexInRanges = function (bounds, range) {
        return bounds.findIndex(function (bound) {
            return bound.startContainer === range.startContainer &&
                bound.startOffset === range.startOffset &&
                bound.endContainer === range.startContainer &&
                bound.endOffset === range.endOffset;
        });
    };
    search.prototype.isValidCache = function (promise) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var res;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, promise];
                    case 1:
                        res = _a.sent();
                        return [2 /*return*/, res.every(function (r) {
                                var _a, _b, _c, _d;
                                return r.startContainer.isConnected &&
                                    r.startOffset <= ((_b = (_a = r.startContainer.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) &&
                                    r.endContainer.isConnected &&
                                    r.endOffset <= ((_d = (_c = r.endContainer.nodeValue) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0);
                            })];
                }
            });
        });
    };
    search.prototype.find = function (walker, query) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var cache, _a;
            var _this = this;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__generator */ .YH)(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!query.length) {
                            return [2 /*return*/, []];
                        }
                        cache = this.cache[query];
                        _a = cache;
                        if (!_a) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.isValidCache(cache)];
                    case 1:
                        _a = (_b.sent());
                        _b.label = 2;
                    case 2:
                        if (_a) {
                            return [2 /*return*/, cache];
                        }
                        this.cache[query] = this.j.async.promise(function (resolve) {
                            var sentence = new _helpers__WEBPACK_IMPORTED_MODULE_7__/* .SentenceFinder */ .QN(_this.j.o.search.fuzzySearch);
                            walker
                                .on('break', function () {
                                resolve([]);
                            })
                                .on('visit', function (elm) {
                                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elm)) {
                                    sentence.add(elm);
                                }
                                return false;
                            })
                                .on('end', function () {
                                var _a;
                                resolve((_a = sentence.ranges(query)) !== null && _a !== void 0 ? _a : []);
                            })
                                .setWork(_this.j.editor);
                        });
                        return [2 /*return*/, this.cache[query]];
                }
            });
        });
    };
    search.prototype.__drawSelectionRanges = function (ranges) {
        var _this = this;
        var _a = this.j, async = _a.async, ci = _a.createInside, editor = _a.editor;
        async.cancelAnimationFrame(this.wrapFrameRequest);
        var parts = (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__read */ .zs)(ranges), false);
        var sRange, total = 0;
        return async.promise(function (resolve) {
            var drawParts = function () {
                do {
                    sRange = parts.shift();
                    if (sRange) {
                        (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .highlightTextRanges */ ._B)(_this.j, sRange, parts, ci, editor);
                    }
                    total += 1;
                } while (sRange && total <= 5);
                if (parts.length) {
                    _this.wrapFrameRequest =
                        async.requestAnimationFrame(drawParts);
                }
                else {
                    resolve();
                }
            };
            drawParts();
        });
    };
    search.prototype.onAfterGetValueFromEditor = function (data) {
        data.value = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .clearSelectionWrappersFromHTML */ .Tz)(data.value);
    };
    /** @override */
    search.prototype.afterInit = function (editor) {
        var _this = this;
        if (editor.o.useSearch) {
            var self_1 = this;
            editor.e
                .on('beforeSetMode.search', function () {
                _this.ui.close();
            })
                .on(this.ui, 'afterClose', function () {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .clearSelectionWrappers */ .IJ)(editor);
                _this.ui.currentIndex = 0;
                _this.ui.count = 0;
                _this.cache = {};
                editor.focus();
            })
                .on('click', function () {
                _this.ui.currentIndex = 0;
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .clearSelectionWrappers */ .IJ)(editor);
            })
                .on('change.search', function () {
                _this.cache = {};
            })
                .on('keydown.search mousedown.search', editor.async.debounce(function () {
                if (_this.ui.selInfo) {
                    editor.s.removeMarkers();
                    _this.ui.selInfo = null;
                }
                if (_this.ui.isOpened) {
                    void _this.updateCounters();
                }
            }, editor.defaultTimeout))
                .on('searchNext.search searchPrevious.search', function () {
                if (!_this.ui.isOpened) {
                    _this.ui.open();
                }
                return self_1
                    .findAndSelect(self_1.ui.query, editor.e.current === 'searchNext')
                    .catch(function (e) {
                    !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error('Search error', e);
                });
            })
                .on('search.search', function (value, next) {
                if (next === void 0) { next = true; }
                _this.ui.currentIndex = 0;
                return self_1.findAndSelect(value || '', next).catch(function (e) {
                    !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error('Search error', e);
                });
            });
            editor
                .registerCommand('search', {
                exec: function (command, value, next) {
                    if (next === void 0) { next = true; }
                    value &&
                        self_1.findAndSelect(value, next).catch(function (e) {
                            !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error('Search error', e);
                        });
                    return false;
                }
            })
                .registerCommand('openSearchDialog', {
                exec: function (command, value) {
                    self_1.ui.open(value);
                    return false;
                },
                hotkeys: ['ctrl+f', 'cmd+f']
            })
                .registerCommand('openReplaceDialog', {
                exec: function (command, query, replace) {
                    if (!editor.o.readonly) {
                        self_1.ui.open(query, replace, true);
                    }
                    return false;
                },
                hotkeys: ['ctrl+h', 'cmd+h']
            });
        }
    };
    /** @override */
    search.prototype.beforeDestruct = function (jodit) {
        var _a;
        (_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cached)(this, 'ui')) === null || _a === void 0 ? void 0 : _a.destruct();
        jodit.e.off('.search');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
    ], search.prototype, "ui", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('ui:needUpdateCounters')
    ], search.prototype, "updateCounters", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('ui:pressReplaceButton')
    ], search.prototype, "onPressReplaceButton", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], search.prototype, "findQueryBounds", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], search.prototype, "findAndReplace", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], search.prototype, "findAndSelect", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], search.prototype, "find", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':afterGetValueFromEditor')
    ], search.prototype, "onAfterGetValueFromEditor", null);
    return search;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('search', search);


/***/ }),

/***/ 17352:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCURACY: function() { return /* binding */ ACCURACY; },
/* harmony export */   APP_VERSION: function() { return /* binding */ APP_VERSION; },
/* harmony export */   BASE_PATH: function() { return /* binding */ BASE_PATH; },
/* harmony export */   BR: function() { return /* binding */ BR; },
/* harmony export */   CLIPBOARD_ID: function() { return /* binding */ CLIPBOARD_ID; },
/* harmony export */   COMMAND_KEYS: function() { return /* binding */ COMMAND_KEYS; },
/* harmony export */   EMULATE_DBLCLICK_TIMEOUT: function() { return /* binding */ EMULATE_DBLCLICK_TIMEOUT; },
/* harmony export */   ES: function() { return /* binding */ ES; },
/* harmony export */   FAT_MODE: function() { return /* binding */ FAT_MODE; },
/* harmony export */   HOMEPAGE: function() { return /* binding */ HOMEPAGE; },
/* harmony export */   INSEPARABLE_TAGS: function() { return /* binding */ INSEPARABLE_TAGS; },
/* harmony export */   INSERT_AS_HTML: function() { return /* binding */ INSERT_AS_HTML; },
/* harmony export */   INSERT_AS_TEXT: function() { return /* binding */ INSERT_AS_TEXT; },
/* harmony export */   INSERT_CLEAR_HTML: function() { return /* binding */ INSERT_CLEAR_HTML; },
/* harmony export */   INSERT_ONLY_TEXT: function() { return /* binding */ INSERT_ONLY_TEXT; },
/* harmony export */   INVISIBLE_SPACE: function() { return /* binding */ INVISIBLE_SPACE; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP_END: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP_END; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP_START: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP_START; },
/* harmony export */   IS_BLOCK: function() { return /* binding */ IS_BLOCK; },
/* harmony export */   IS_ES_MODERN: function() { return /* binding */ IS_ES_MODERN; },
/* harmony export */   IS_ES_NEXT: function() { return /* binding */ IS_ES_NEXT; },
/* harmony export */   IS_IE: function() { return /* binding */ IS_IE; },
/* harmony export */   IS_INLINE: function() { return /* binding */ IS_INLINE; },
/* harmony export */   IS_MAC: function() { return /* binding */ IS_MAC; },
/* harmony export */   IS_PROD: function() { return /* binding */ IS_PROD; },
/* harmony export */   IS_TEST: function() { return /* binding */ IS_TEST; },
/* harmony export */   KEY_ALIASES: function() { return /* binding */ KEY_ALIASES; },
/* harmony export */   KEY_ALT: function() { return /* binding */ KEY_ALT; },
/* harmony export */   KEY_BACKSPACE: function() { return /* binding */ KEY_BACKSPACE; },
/* harmony export */   KEY_DELETE: function() { return /* binding */ KEY_DELETE; },
/* harmony export */   KEY_DOWN: function() { return /* binding */ KEY_DOWN; },
/* harmony export */   KEY_ENTER: function() { return /* binding */ KEY_ENTER; },
/* harmony export */   KEY_ESC: function() { return /* binding */ KEY_ESC; },
/* harmony export */   KEY_F3: function() { return /* binding */ KEY_F3; },
/* harmony export */   KEY_LEFT: function() { return /* binding */ KEY_LEFT; },
/* harmony export */   KEY_META: function() { return /* binding */ KEY_META; },
/* harmony export */   KEY_RIGHT: function() { return /* binding */ KEY_RIGHT; },
/* harmony export */   KEY_SPACE: function() { return /* binding */ KEY_SPACE; },
/* harmony export */   KEY_TAB: function() { return /* binding */ KEY_TAB; },
/* harmony export */   KEY_UP: function() { return /* binding */ KEY_UP; },
/* harmony export */   LIST_TAGS: function() { return /* binding */ LIST_TAGS; },
/* harmony export */   MARKER_CLASS: function() { return /* binding */ MARKER_CLASS; },
/* harmony export */   MODE_SOURCE: function() { return /* binding */ MODE_SOURCE; },
/* harmony export */   MODE_SPLIT: function() { return /* binding */ MODE_SPLIT; },
/* harmony export */   MODE_WYSIWYG: function() { return /* binding */ MODE_WYSIWYG; },
/* harmony export */   NBSP_SPACE: function() { return /* binding */ NBSP_SPACE; },
/* harmony export */   NEARBY: function() { return /* binding */ NEARBY; },
/* harmony export */   NO_EMPTY_TAGS: function() { return /* binding */ NO_EMPTY_TAGS; },
/* harmony export */   PARAGRAPH: function() { return /* binding */ PARAGRAPH; },
/* harmony export */   PASSIVE_EVENTS: function() { return /* binding */ PASSIVE_EVENTS; },
/* harmony export */   SAFE_COUNT_CHANGE_CALL: function() { return /* binding */ SAFE_COUNT_CHANGE_CALL; },
/* harmony export */   SET_TEST: function() { return /* binding */ SET_TEST; },
/* harmony export */   SOURCE_CONSUMER: function() { return /* binding */ SOURCE_CONSUMER; },
/* harmony export */   SPACE_REG_EXP: function() { return /* binding */ SPACE_REG_EXP; },
/* harmony export */   SPACE_REG_EXP_END: function() { return /* binding */ SPACE_REG_EXP_END; },
/* harmony export */   SPACE_REG_EXP_START: function() { return /* binding */ SPACE_REG_EXP_START; },
/* harmony export */   TEMP_ATTR: function() { return /* binding */ TEMP_ATTR; },
/* harmony export */   TEXT_HTML: function() { return /* binding */ TEXT_HTML; },
/* harmony export */   TEXT_PLAIN: function() { return /* binding */ TEXT_PLAIN; },
/* harmony export */   TEXT_RTF: function() { return /* binding */ TEXT_RTF; },
/* harmony export */   TOKENS: function() { return /* binding */ TOKENS; },
/* harmony export */   globalDocument: function() { return /* binding */ globalDocument; },
/* harmony export */   globalWindow: function() { return /* binding */ globalWindow; },
/* harmony export */   lang: function() { return /* binding */ lang; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

var APP_VERSION = "4.5.16";
// prettier-ignore
var ES = "es5";
var IS_ES_MODERN = false;
var IS_ES_NEXT = false;
var IS_PROD = true;
var IS_TEST = false;
var FAT_MODE = false;
var HOMEPAGE = "https://xdsoft.net/jodit/";
var SET_TEST = function () { return (IS_TEST = true); };
var TOKENS = {};
var INVISIBLE_SPACE = '\uFEFF';
var NBSP_SPACE = '\u00A0';
var INVISIBLE_SPACE_REG_EXP = function () { return /[\uFEFF]/g; };
var INVISIBLE_SPACE_REG_EXP_END = function () { return /[\uFEFF]+$/g; };
var INVISIBLE_SPACE_REG_EXP_START = function () { return /^[\uFEFF]+/g; };
var SPACE_REG_EXP = function () { return /[\s\n\t\r\uFEFF\u200b]+/g; };
var SPACE_REG_EXP_START = function () { return /^[\s\n\t\r\uFEFF\u200b]+/g; };
var SPACE_REG_EXP_END = function () { return /[\s\n\t\r\uFEFF\u200b]+$/g; };
var globalWindow = typeof window !== 'undefined' ? window : undefined;
var globalDocument = typeof document !== 'undefined'
    ? document
    : undefined;
var IS_BLOCK = /^(ADDRESS|ARTICLE|ASIDE|BLOCKQUOTE|CANVAS|DD|DFN|DIV|DL|DT|FIELDSET|FIGCAPTION|FIGURE|FOOTER|FORM|H[1-6]|HEADER|HGROUP|HR|LI|MAIN|NAV|NOSCRIPT|OUTPUT|P|PRE|RUBY|SCRIPT|STYLE|OBJECT|OL|SECTION|IFRAME|JODIT|JODIT-MEDIA|UL|TR|TD|TH|TBODY|THEAD|TFOOT|TABLE|BODY|HTML|VIDEO)$/i;
var IS_INLINE = /^(STRONG|SPAN|I|EM|B|SUP|SUB|A|U)$/i;
var LIST_TAGS = new Set(['ul', 'ol']);
var __UNSEPARABLE_TAGS = [
    'img',
    'video',
    'svg',
    'iframe',
    'script',
    'input',
    'textarea',
    'link',
    'jodit',
    'jodit-media'
];
var INSEPARABLE_TAGS = new Set((0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__spreadArray */ .fX)((0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__read */ .zs)(__UNSEPARABLE_TAGS), false), [
    'br',
    'hr'
], false));
var NO_EMPTY_TAGS = new Set(__UNSEPARABLE_TAGS);
var KEY_META = 'Meta';
var KEY_BACKSPACE = 'Backspace';
var KEY_TAB = 'Tab';
var KEY_ENTER = 'Enter';
var KEY_ESC = 'Escape';
var KEY_ALT = 'Alt';
var KEY_LEFT = 'ArrowLeft';
var KEY_UP = 'ArrowUp';
var KEY_RIGHT = 'ArrowRight';
var KEY_DOWN = 'ArrowDown';
var KEY_SPACE = 'Space';
var KEY_DELETE = 'Delete';
var KEY_F3 = 'F3';
var NEARBY = 5;
var ACCURACY = 10;
var COMMAND_KEYS = [
    KEY_META,
    KEY_BACKSPACE,
    KEY_DELETE,
    KEY_UP,
    KEY_DOWN,
    KEY_RIGHT,
    KEY_LEFT,
    KEY_ENTER,
    KEY_ESC,
    KEY_F3,
    KEY_TAB
];
var BR = 'br';
var PARAGRAPH = 'p';
/**
 * WYSIWYG editor mode
 */
var MODE_WYSIWYG = 1;
/**
 * html editor mode
 */
var MODE_SOURCE = 2;
/**
 * Source code editor and HTML editor both like
 * @see http://getuikit.com/docs/htmleditor.html|this
 */
var MODE_SPLIT = 3;
/**
 * Is Internet Explorer
 */
var IS_IE = typeof navigator !== 'undefined' &&
    (navigator.userAgent.indexOf('MSIE') !== -1 ||
        /rv:11.0/i.test(navigator.userAgent));
/**
 * For IE11 it will be 'text'. Need for dataTransfer.setData
 */
var TEXT_PLAIN = IS_IE ? 'text' : 'text/plain';
var TEXT_HTML = IS_IE ? 'html' : 'text/html';
var TEXT_RTF = IS_IE ? 'rtf' : 'text/rtf';
var MARKER_CLASS = 'jodit-selection_marker';
var EMULATE_DBLCLICK_TIMEOUT = 300;
/**
 * Paste the copied text as HTML, all content will be pasted exactly as it was on the clipboard.
 * So how would you copy its code directly into the source document.
 * ```
 * <h1 style="color:red">test</h1>
 * ```
 * Will be inserted into the document as
 * ```
 * <h1 style="color:red">test</h1>
 * ```
 */
var INSERT_AS_HTML = 'insert_as_html';
/**
 * Same as [[INSERT_AS_HTML]], but content will be stripped of extra styles and empty tags
 * ```html
 * <h1 style="color:red">test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * <h1>test</h1>
 * ```
 */
var INSERT_CLEAR_HTML = 'insert_clear_html';
/**
 * The contents of the clipboard will be pasted into the document as plain text, i.e. all tags will be displayed as text.
 * ```html
 * <h1>test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * &gt;&lt;h1&gt;test&lt;/h1&gt;
 * ```
 */
var INSERT_AS_TEXT = 'insert_as_text';
/**
 * All tags will be stripped:
 * ```html
 * <h1>test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * test
 * ```
 */
var INSERT_ONLY_TEXT = 'insert_only_text';
var SAFE_COUNT_CHANGE_CALL = 10;
var IS_MAC = typeof globalWindow !== 'undefined' &&
    /Mac|iPod|iPhone|iPad/.test(globalWindow.navigator.platform);
var KEY_ALIASES = {
    add: '+',
    break: 'pause',
    cmd: 'meta',
    command: 'meta',
    ctl: 'control',
    ctrl: 'control',
    del: 'delete',
    down: 'arrowdown',
    esc: 'escape',
    ins: 'insert',
    left: 'arrowleft',
    mod: IS_MAC ? 'meta' : 'control',
    opt: 'alt',
    option: 'alt',
    return: 'enter',
    right: 'arrowright',
    space: 'space',
    spacebar: 'space',
    up: 'arrowup',
    win: 'meta',
    windows: 'meta'
};
var BASE_PATH = (function () {
    if (typeof document === 'undefined') {
        return '';
    }
    var script = globalDocument.currentScript, removeScriptName = function (s) {
        var parts = s.split('/');
        if (/\.js/.test(parts[parts.length - 1])) {
            return parts.slice(0, parts.length - 1).join('/') + '/';
        }
        return s;
    };
    if (script) {
        return removeScriptName(script.src);
    }
    var scripts = globalDocument.querySelectorAll('script[src]');
    if (scripts && scripts.length) {
        return removeScriptName(scripts[scripts.length - 1].src);
    }
    return globalWindow.location.href;
})();
var TEMP_ATTR = 'data-jodit-temp';
var lang = {};
var CLIPBOARD_ID = 'clipboard';
var SOURCE_CONSUMER = 'source-consumer';
var PASSIVE_EVENTS = new Set([
    'touchstart',
    'touchend',
    'scroll',
    'mousewheel',
    'mousemove',
    'touchmove'
]);


/***/ }),

/***/ 17527:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   e: function() { return /* binding */ defaultLanguage; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */


/**
 * Try define user language
 */
var defaultLanguage = function (language, defaultLanguage) {
    if (defaultLanguage === void 0) { defaultLanguage = 'en'; }
    if (language !== 'auto' && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .K)(language)) {
        return language;
    }
    if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.documentElement && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.documentElement.lang) {
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.documentElement.lang;
    }
    if (navigator.language) {
        return navigator.language.substring(0, 2);
    }
    return defaultLanguage;
};


/***/ }),

/***/ 17800:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ canUsePersistentStorage; },
/* harmony export */   O: function() { return /* binding */ LocalStorageProvider; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Check if user disable local storages/cookie etc.
 */
var canUsePersistentStorage = (function () {
    var canUse = function () {
        var tmpKey = '___Jodit___' + Math.random().toString();
        try {
            localStorage.setItem(tmpKey, '1');
            var result_1 = localStorage.getItem(tmpKey) === '1';
            localStorage.removeItem(tmpKey);
            return result_1;
        }
        catch (_a) { }
        return false;
    };
    var result;
    return function () {
        if (result === undefined) {
            result = canUse();
        }
        return result;
    };
})();
/**
 * Persistent storage in localStorage
 */
var LocalStorageProvider = /** @class */ (function () {
    function LocalStorageProvider(rootKey) {
        this.rootKey = rootKey;
    }
    LocalStorageProvider.prototype.set = function (key, value) {
        try {
            var buffer = localStorage.getItem(this.rootKey);
            var json = buffer ? JSON.parse(buffer) : {};
            json[key] = value;
            localStorage.setItem(this.rootKey, JSON.stringify(json));
        }
        catch (_a) { }
        return this;
    };
    LocalStorageProvider.prototype.delete = function (key) {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
        return this;
    };
    LocalStorageProvider.prototype.get = function (key) {
        try {
            var buffer = localStorage.getItem(this.rootKey);
            var json = buffer ? JSON.parse(buffer) : {};
            return json[key] !== undefined ? json[key] : null;
        }
        catch (_a) { }
    };
    LocalStorageProvider.prototype.exists = function (key) {
        return this.get(key) != null;
    };
    LocalStorageProvider.prototype.clear = function () {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
        return this;
    };
    return LocalStorageProvider;
}());



/***/ }),

/***/ 17880:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: function() { return /* binding */ readSizes; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38322);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9645);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module plugins/image-properties
 */




/** @private */
function readSizes(image, values, state) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
        var width, height, imageWidth, imageHeight, w, h;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__generator */ .YH)(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, image.decode()];
                case 1:
                    _a.sent();
                    width = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(image, 'width', true) || (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'width') || false;
                    height = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(image, 'height', true) || (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'height') || false;
                    values.imageWidth =
                        width !== false
                            ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .normalSizeFromString */ .G)(width)
                            : image.offsetWidth || image.naturalWidth;
                    if ((0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__/* .isNumeric */ .k)(values.imageWidth)) {
                        values.imageHeight =
                            height !== false
                                ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .normalSizeFromString */ .G)(height)
                                : image.offsetHeight || image.naturalHeight;
                    }
                    else {
                        values.imageHeight = height || '';
                    }
                    imageWidth = values.imageWidth, imageHeight = values.imageHeight;
                    w = parseFloat(imageWidth.toString());
                    if (!(0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__/* .isNumeric */ .k)(imageWidth) || !(0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__/* .isNumeric */ .k)(imageHeight)) {
                        state.sizeIsLocked = false;
                        return [2 /*return*/];
                    }
                    if (height === false) {
                        values.imageHeight = Math.round(w / state.ratio);
                        state.sizeIsLocked = true;
                        return [2 /*return*/];
                    }
                    h = parseFloat(imageHeight.toString());
                    state.sizeIsLocked = Math.abs(w - h * state.ratio) < 1;
                    return [2 /*return*/];
            }
        });
    });
}


/***/ }),

/***/ 17995:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 1792 1792\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M1088 1256v240q0 16-12 28t-28 12h-240q-16 0-28-12t-12-28v-240q0-16 12-28t28-12h240q16 0 28 12t12 28zm316-600q0 54-15.5 101t-35 76.5-55 59.5-57.5 43.5-61 35.5q-41 23-68.5 65t-27.5 67q0 17-12 32.5t-28 15.5h-240q-15 0-25.5-18.5t-10.5-37.5v-45q0-83 65-156.5t143-108.5q59-27 84-56t25-76q0-42-46.5-74t-107.5-32q-65 0-108 29-35 25-107 115-13 16-31 16-12 0-25-8l-164-125q-13-10-15.5-25t5.5-28q160-266 464-266 80 0 161 31t146 83 106 127.5 41 158.5z\"/> </svg>"

/***/ }),

/***/ 18043:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ selfListeners; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75889);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(97324);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9979);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31859);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53804);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








/**
 * @private
 */
function selfListeners() {
    var _this = this;
    var state = this.state, dp = this.dataProvider, self = this;
    self.e
        .on('view.filebrowser', function (view) {
        if (view !== state.view) {
            state.view = view;
        }
    })
        .on('sort.filebrowser', function (value) {
        if (value !== state.sortBy) {
            state.sortBy = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
        }
    })
        .on('filter.filebrowser', function (value) {
        if (value !== state.filterWord) {
            state.filterWord = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
        }
    })
        .on('openFolder.filebrowser', function (data) {
        var path;
        if (data.name === '..') {
            path = data.path
                .split('/')
                .filter(function (p) { return p.length; })
                .slice(0, -1)
                .join('/');
        }
        else {
            path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(data.path, data.name);
        }
        self.state.currentPath = path;
        self.state.currentSource =
            data.name === '.' ? jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__/* .DEFAULT_SOURCE_NAME */ .o : data.source;
    })
        .on('removeFolder.filebrowser', function (data) {
        self.confirm('Are you sure?', 'Delete', function (yes) {
            if (yes) {
                dp.folderRemove(data.path, data.name, data.source)
                    .then(function (message) {
                    self.status(message, true);
                    return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self);
                })
                    .catch(self.status);
            }
        });
    })
        .on('renameFolder.filebrowser', function (data) {
        self.prompt('Enter new name', 'Rename', function (newName) {
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isValidName */ .uV)(newName)) {
                self.status(self.i18n('Enter new name'));
                return false;
            }
            dp.folderRename(data.path, data.name, newName, data.source)
                .then(function (message) {
                self.state.activeElements = [];
                self.status(message, true);
                return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self);
            })
                .catch(self.status);
            return;
        }, 'type name', data.name);
    })
        .on('addFolder.filebrowser', function (data) {
        self.prompt('Enter Directory name', 'Create directory', function (name) {
            dp.createFolder(name, data.path, data.source)
                .then(function () { return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self); })
                .catch(self.status);
        }, 'type name');
    })
        .on('fileRemove.filebrowser', function () {
        if (self.state.activeElements.length) {
            self.confirm('Are you sure?', '', function (yes) {
                if (yes) {
                    var promises_1 = [];
                    self.state.activeElements.forEach(function (item) {
                        promises_1.push((0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__/* .deleteFile */ .W)(self, item.file || item.name || '', item.sourceName));
                    });
                    self.state.activeElements = [];
                    Promise.all(promises_1).then(function () { return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self).catch(self.status); }, self.status);
                }
            });
        }
    })
        .on('edit.filebrowser', function () {
        if (self.state.activeElements.length === 1) {
            var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__read */ .zs)(_this.state.activeElements, 1), file = _a[0];
            jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_4__/* .openImageEditor */ .B.call(self, file.fileURL, file.file || '', file.path, file.sourceName);
        }
    })
        .on('fileRename.filebrowser', function (name, path, source) {
        if (self.state.activeElements.length === 1) {
            self.prompt('Enter new name', 'Rename', function (newName) {
                if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isValidName */ .uV)(newName)) {
                    self.status(self.i18n('Enter new name'));
                    return false;
                }
                dp.fileRename(path, name, newName, source)
                    .then(function (message) {
                    self.state.activeElements = [];
                    self.status(message, true);
                    (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
                })
                    .catch(self.status);
                return;
            }, 'type name', name);
        }
    })
        .on('update.filebrowser', function () {
        (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(_this).then(_this.status, _this.status);
    });
}


/***/ }),

/***/ 18605:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm637-679v206h-514l-3-27q-4-28-4-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 83-65 188-65 110 0 178 59.5t68 158.5q0 56-24.5 103t-62 76.5-81.5 58.5-82 50.5-65.5 51.5-30.5 63h232v-80h126z\"/> </svg>"

/***/ }),

/***/ 19085:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export imageProperties */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29866);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(35265);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24654);
/* harmony import */ var _ui_ui_image_form__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31970);
/* harmony import */ var _utils_open_image_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80778);
/* harmony import */ var _utils_open_image_popup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(33733);
/* harmony import */ var _readers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(5549);
/* harmony import */ var _writers__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(30393);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */













/**
 * Plug-in for image editing window
 *
 * @example
 * ```javascript
 * const editor = Jodit.make('#editor', {
 *     image: {
 *         editSrc: false,
 *         editLink: false
 *     }
 * });
 * ```
 */
/**
 * Show dialog with image's options
 */
var imageProperties = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__extends */ .C6)(imageProperties, _super);
    function imageProperties() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__read */ .zs)(arguments), false)) || this;
        _this.state = {
            image: new Image(),
            sourceImage: new Image(),
            get ratio() {
                var _a = this.image, naturalWidth = _a.naturalWidth, naturalHeight = _a.naturalHeight;
                return naturalWidth / naturalHeight || 1;
            },
            sizeIsLocked: true,
            marginIsLocked: true,
            values: {
                style: '',
                imageSrc: '',
                borderRadius: 0,
                imageTitle: '',
                imageAlt: '',
                imageLink: '',
                imageLinkOpenInNewTab: false,
                imageWidth: 0,
                imageHeight: 0,
                marginTop: 0,
                marginRight: 0,
                marginBottom: 0,
                marginLeft: 0,
                classes: '',
                id: '',
                align: ''
            }
        };
        _this.activeTabState = {
            activeTab: 'Image'
        };
        return _this;
    }
    Object.defineProperty(imageProperties.prototype, "form", {
        get: function () {
            var _this = this;
            return new _ui_ui_image_form__WEBPACK_IMPORTED_MODULE_7__/* .UIImagePropertiesForm */ .l(this.j, this.state, this.activeTabState, {
                openImageEditor: function () {
                    return (0,_utils_open_image_editor__WEBPACK_IMPORTED_MODULE_8__/* .openImageEditorDialog */ .v)(_this.j, _this.state);
                },
                openImagePopup: function (target) {
                    return (0,_utils_open_image_popup__WEBPACK_IMPORTED_MODULE_9__/* .openImagePopup */ .q)(_this.j, _this.dialog, _this.state, target);
                }
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(imageProperties.prototype, "dialog", {
        /**
         * Dialog for form
         */
        get: function () {
            var _this = this;
            var j = this.j;
            var dialog = j.dlg({
                minWidth: Math.min(400, screen.width),
                minHeight: 590,
                buttons: ['fullsize', 'dialog.close']
            });
            var buttons = this.__buttons;
            buttons.check.onAction(function () {
                (0,_writers__WEBPACK_IMPORTED_MODULE_11__/* .applyValuesToImage */ .j)(j, _this.state, _this.state.sourceImage);
                j.synchronizeValues();
                dialog.close();
            });
            buttons.remove.onAction(function () {
                j.s.removeNode(_this.state.sourceImage);
                dialog.close();
            });
            buttons.cancel.onAction(function () {
                dialog.close();
            });
            dialog.setHeader(j.i18n('Image properties'));
            dialog.setContent(this.form);
            dialog.setFooter([[buttons.cancel, buttons.remove], buttons.check]);
            j.e.on(dialog, 'afterClose', function () {
                if (_this.state.image.parentNode &&
                    j.o.image.selectImageAfterClose) {
                    j.s.select(_this.state.sourceImage);
                }
            });
            dialog.setSize(j.o.image.dialogWidth);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.markOwner)(j, dialog.container);
            return dialog;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(imageProperties.prototype, "__buttons", {
        get: function () {
            var j = this.j;
            return {
                check: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__/* .Button */ .$n)(j, 'ok', 'Apply', 'primary'),
                remove: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__/* .Button */ .$n)(j, 'bin', 'Delete'),
                cancel: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__/* .Button */ .$n)(j, 'cancel', 'Cancel')
            };
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Open dialog editing image properties
     *
     * @example
     * ```javascript
     * const editor = Jodit.makeJodit('#editor');
     *     img = editor.createInside.element('img');
     *
     * img.setAttribute('src', 'images/some-image.png');
     * editor.s.insertImage(img);
     * // open the properties of the editing window
     * editor.events.fire('openImageProperties', img);
     * ```
     */
    imageProperties.prototype.open = function () {
        var _this = this;
        this.activeTabState.activeTab = 'Image';
        this.__lock();
        this.dialog.open().setModal(true).setPosition();
        this.async
            .promise(function (resolve, reject) {
            return (0,_readers__WEBPACK_IMPORTED_MODULE_10__/* .readValuesFromImage */ .U)(_this.j, _this.state).then(resolve, reject);
        })
            .catch(function (e) {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isAbortError)(e)) {
                _this.dialog.message.error(e.message);
            }
        })
            .finally(function () { return _this.__unlock(); });
        return false;
    };
    imageProperties.prototype.__lock = function () {
        this.dialog.lock();
        this.form.setMod('lock', true);
        Object.values(this.__buttons).forEach(function (b) { return (b.state.disabled = true); });
    };
    imageProperties.prototype.__unlock = function () {
        this.dialog.unlock();
        this.form.setMod('lock', false);
        Object.values(this.__buttons).forEach(function (b) { return (b.state.disabled = false); });
    };
    /** @override **/
    imageProperties.prototype.afterInit = function (editor) {
        var _this = this;
        var self = this;
        editor.e
            .on('afterConstructor changePlace', function () {
            editor.e
                .off(editor.editor, '.imageproperties')
                .on(editor.editor, 'dblclick.imageproperties', function (e) {
                var image = e.target;
                if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(image, 'img')) {
                    return;
                }
                if (editor.o.image.openOnDblClick) {
                    if (_this.j.e.fire('openOnDblClick', image) ===
                        false) {
                        return;
                    }
                    self.state.sourceImage = image;
                    self.state.image = image.cloneNode(true);
                    if (!editor.o.readonly) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        self.open();
                    }
                }
                else {
                    e.stopImmediatePropagation();
                    editor.s.select(image);
                }
            });
        })
            .on('openImageProperties.imageproperties', function (image) {
            self.state.sourceImage = image;
            _this.state.image = image.cloneNode(true);
            _this.open();
        });
    };
    imageProperties.prototype.onStateValuesImageSrcChange = function () {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var _a, image, values, w, e_1;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__generator */ .YH)(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.state, image = _a.image, values = _a.values;
                        if (!image.src) {
                            return [2 /*return*/];
                        }
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, 4, 5]);
                        this.__lock();
                        return [4 /*yield*/, image.decode()];
                    case 2:
                        _b.sent();
                        if (this.state.sizeIsLocked && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isNumeric)(values.imageWidth)) {
                            w = parseFloat(values.imageWidth.toString());
                            values.imageHeight = Math.round(w / this.state.ratio);
                        }
                        this.j.e.fire('updateImageProperties.imageproperties', image);
                        return [3 /*break*/, 5];
                    case 3:
                        e_1 = _b.sent();
                        this.j.alert(e_1.message);
                        return [3 /*break*/, 5];
                    case 4:
                        this.__unlock();
                        return [7 /*endfinally*/];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    /** @override */
    imageProperties.prototype.beforeDestruct = function (editor) {
        var _a, _b, _c;
        Object.values((_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cached)(this, '__buttons')) !== null && _a !== void 0 ? _a : {}).forEach(function (b) { return b.destruct(); });
        (_b = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cached)(this, 'dialog')) === null || _b === void 0 ? void 0 : _b.destruct();
        (_c = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cached)(this, 'form')) === null || _c === void 0 ? void 0 : _c.destruct();
        editor.e.off(editor.editor, '.imageproperties').off('.imageproperties');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
    ], imageProperties.prototype, "form", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
    ], imageProperties.prototype, "dialog", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
    ], imageProperties.prototype, "__buttons", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.image')
    ], imageProperties.prototype, "onStateValuesImageSrcChange", null);
    return imageProperties;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('imageProperties', imageProperties);


/***/ }),

/***/ 19627:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_0__.V; }
/* harmony export */ });
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(140);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/file-browser/README.md]]
 * @packageDocumentation
 * @module modules/file-browser
 */



/***/ }),

/***/ 19633:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   K: function() { return /* binding */ ColorPickerWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var _palette_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(54522);
/* harmony import */ var _palette_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_palette_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .In.set('palette', (_palette_svg__WEBPACK_IMPORTED_MODULE_3___default()));
/**
 * Build color picker
 *
 * @param callback - Callback 'function (color) \{\}'
 * @param coldColor - Color value ex. #fff or rgb(123, 123, 123) or rgba(123, 123, 123, 1)
 * @example
 * ```javascript
 * const tabs = TabsWidget(editor, {
 *    'Text': ColorPickerWidget(editor, function (color) {
 *         box.style.color = color;
 *     }, box.style.color),
 *     'Background': ColorPickerWidget(editor, function (color) {
 *         box.style.backgroundColor = color;
 *     }, box.style.backgroundColor),
 * });
 * ```
 */
var ColorPickerWidget = function (editor, callback, coldColor) {
    var cn = 'jodit-color-picker', valueHex = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeColor)(coldColor), form = editor.c.div(cn), iconPalette = editor.o.textIcons
        ? "<span>".concat(editor.i18n('palette'), "</span>")
        : jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .In.get('palette'), eachColor = function (colors) {
        var stack = [];
        if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(colors)) {
            Object.keys(colors).forEach(function (key) {
                stack.push("<div class=\"".concat(cn, "__group ").concat(cn, "__group-").concat(key, "\">"));
                stack.push(eachColor(colors[key]));
                stack.push('</div>');
            });
        }
        else if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isArray)(colors)) {
            colors.forEach(function (color) {
                stack.push("<span class='".concat(cn, "__color-item ").concat(valueHex === color
                    ? cn + '__color-item_active_true'
                    : '', "' title=\"").concat(color, "\" style=\"background-color:").concat(color, "\" data-color=\"").concat(color, "\"></span>"));
            });
        }
        return stack.join('');
    };
    form.appendChild(editor.c.fromHTML("<div class=\"".concat(cn, "__groups\">").concat(eachColor(editor.o.colors), "</div>")));
    form.appendChild(editor.c.fromHTML("<div data-ref=\"extra\" class=\"".concat(cn, "__extra\"></div>")));
    var extra = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.refs)(form).extra;
    if (editor.o.showBrowserColorPicker && (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.hasBrowserColorPicker)()) {
        extra.appendChild(editor.c.fromHTML("<div class=\"".concat(cn, "__native\">").concat(iconPalette, "<input type=\"color\" value=\"#ffffff\"/></div>")));
        editor.e.on(form, 'change', function (e) {
            e.stopPropagation();
            var target = e.target;
            if (!target || !target.tagName || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'input')) {
                return;
            }
            var color = target.value || '';
            if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isFunction)(callback)) {
                callback(color);
            }
            e.preventDefault();
        });
    }
    editor.e.on(form, 'mousedown touchend', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var target = e.target;
        if ((!target ||
            !target.tagName ||
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'svg') ||
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'path')) &&
            target.parentNode) {
            target = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(target.parentNode, 'span', editor.editor);
        }
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'span') ||
            !target.classList.contains(cn + '__color-item')) {
            return;
        }
        var color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.attr)(target, '-color') || '';
        if (callback && (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isFunction)(callback)) {
            callback(color);
        }
    });
    editor.e.fire('afterGenerateColorPicker', form, extra, callback, valueHex);
    return form;
};


/***/ }),

/***/ 20222:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Rc: function() { return /* reexport safe */ _connection_error__WEBPACK_IMPORTED_MODULE_1__.R; },
/* harmony export */   ZW: function() { return /* reexport safe */ _options_error__WEBPACK_IMPORTED_MODULE_2__.Z; },
/* harmony export */   h2: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.h; },
/* harmony export */   rV: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.r; }
/* harmony export */ });
/* harmony import */ var _abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21567);
/* harmony import */ var _connection_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30495);
/* harmony import */ var _options_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34899);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */





/***/ }),

/***/ 20384:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ extractSelectedPart; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84976);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * If the selection area is inside an element that matches the commit (suitable relative),
 * but does not completely fill it.
 * Then the method cuts the parent and leaves itself in a copy of the parent (suitable relative) in the middle.
 *
 * @example
 * Apply strong to
 * ```html
 * 	<strong><span>some<font>SELECTED</font>text</span></strong>
 * ```
 * Should extract selection from parent `strong`
 * ```html
 * `<strong><span>some</span></strong><strong><span><font>SELECTED</font></span></strong><strong><span>test</span></strong>
 * ```
 * @private
 */
function extractSelectedPart(wrapper, font, jodit) {
    var range = jodit.s.createRange();
    // Left part
    var leftEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(font.previousSibling)
        ? font.previousSibling
        : font;
    range.setStartBefore(wrapper);
    range.setEndBefore(leftEdge);
    extractAndMove(wrapper, range, true);
    // Right part
    var rightEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(font.nextSibling) ? font.nextSibling : font;
    range.setStartAfter(rightEdge);
    range.setEndAfter(wrapper);
    extractAndMove(wrapper, range, false);
}
/**
 * Retrieves content before after the selected area, clears it if it is empty, and inserts before after the framed selection
 * @private
 */
function extractAndMove(wrapper, range, left) {
    var fragment = range.extractContents();
    if ((!fragment.textContent || !(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(fragment.textContent).length) &&
        fragment.firstChild) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(fragment.firstChild);
    }
    if (wrapper.parentNode) {
        (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__/* .call */ .T1)(left ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after, wrapper, fragment);
    }
}


/***/ }),

/***/ 20646:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ removeFormatForSelection; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var _remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(30526);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Remove formatting for all selected elements
 * @private
 */
function removeFormatForSelection(jodit) {
    var s = jodit.s, editor = jodit.editor, createInside = jodit.createInside, range = s.range, left = range.cloneRange(), right = range.cloneRange(), fakeLeft = createInside.fake(), fakeRight = createInside.fake();
    left.collapse(true);
    right.collapse(false);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeInsertNode(left, fakeLeft);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeInsertNode(right, fakeRight);
    range.setStartBefore(fakeLeft);
    range.collapse(true);
    s.selectRange(range);
    (0,_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__/* .removeFormatForCollapsedSelection */ .w)(jodit, fakeLeft);
    range.setEndAfter(fakeRight);
    range.collapse(false);
    s.selectRange(range);
    (0,_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__/* .removeFormatForCollapsedSelection */ .w)(jodit, fakeRight);
    var shouldUnwrap = [];
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.between(fakeLeft, fakeRight, function (node) {
        if ((0,_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__/* .isInlineBlock */ .D)(node) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(node, 'a')) {
            shouldUnwrap.push(node);
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(node) && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(node, 'style')) {
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(node, 'style', null);
        }
    });
    shouldUnwrap.forEach(function (node) { return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(node); });
    var clearParent = function (node, left) {
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findNotEmptySibling(node, left)) {
            var pn = node.parentNode;
            if (pn && pn !== editor && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(pn, 'style')) {
                (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(pn, 'style', null);
                clearParent(pn, left);
                return true;
            }
        }
    };
    clearParent(fakeLeft, true) && clearParent(fakeRight, false);
    range.setStartAfter(fakeLeft);
    range.setEndBefore(fakeRight);
    s.selectRange(range);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(fakeLeft);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(fakeRight);
}


/***/ }),

/***/ 20703:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.$6; },
/* harmony export */   F0: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.F0; },
/* harmony export */   XV: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_1__.X; },
/* harmony export */   Yh: function() { return /* reexport safe */ _block_block__WEBPACK_IMPORTED_MODULE_0__.Y; },
/* harmony export */   cY: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.cY; },
/* harmony export */   nE: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.nE; },
/* harmony export */   tS: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.tS; }
/* harmony export */ });
/* harmony import */ var _block_block__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68752);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28709);
/* harmony import */ var _inputs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47165);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */





/***/ }),

/***/ 20784:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 48 48\" xmlns=\"http://www.w3.org/2000/svg\"> <path stroke=\"null\" d=\"m42.276011,26.302547c0.098397,-0.76605 0.172194,-1.54407 0.172194,-2.33406s-0.073797,-1.56801 -0.172194,-2.33406l5.202718,-3.961917c0.467384,-0.359086 0.602679,-1.005441 0.29519,-1.532101l-4.919828,-8.29489c-0.307489,-0.51469 -0.947067,-0.730142 -1.500548,-0.51469l-6.125186,2.405877c-1.266856,-0.945594 -2.656707,-1.747553 -4.157255,-2.357999l-0.922468,-6.343855c-0.110696,-0.562568 -0.614979,-1.005441 -1.229957,-1.005441l-9.839656,0c-0.614979,0 -1.119261,0.442873 -1.217657,1.005441l-0.922468,6.343855c-1.500548,0.610446 -2.890399,1.400436 -4.157255,2.357999l-6.125186,-2.405877c-0.553481,-0.203482 -1.193058,0 -1.500548,0.51469l-4.919828,8.29489c-0.307489,0.51469 -0.172194,1.161045 0.29519,1.532101l5.190419,3.961917c-0.098397,0.76605 -0.172194,1.54407 -0.172194,2.33406s0.073797,1.56801 0.172194,2.33406l-5.190419,3.961917c-0.467384,0.359086 -0.602679,1.005441 -0.29519,1.532101l4.919828,8.29489c0.307489,0.51469 0.947067,0.730142 1.500548,0.51469l6.125186,-2.405877c1.266856,0.945594 2.656707,1.747553 4.157255,2.357999l0.922468,6.343855c0.098397,0.562568 0.602679,1.005441 1.217657,1.005441l9.839656,0c0.614979,0 1.119261,-0.442873 1.217657,-1.005441l0.922468,-6.343855c1.500548,-0.610446 2.890399,-1.400436 4.157255,-2.357999l6.125186,2.405877c0.553481,0.203482 1.193058,0 1.500548,-0.51469l4.919828,-8.29489c0.307489,-0.51469 0.172194,-1.161045 -0.29519,-1.532101l-5.190419,-3.961917zm-18.277162,6.044617c-4.759934,0 -8.609699,-3.746465 -8.609699,-8.378677s3.849766,-8.378677 8.609699,-8.378677s8.609699,3.746465 8.609699,8.378677s-3.849766,8.378677 -8.609699,8.378677z\"/> </svg>"

/***/ }),

/***/ 20785:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ UiAiAssistant; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








var UiAiAssistant = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__extends */ .C6)(UiAiAssistant, _super);
    function UiAiAssistant(jodit, _a) {
        var onInsert = _a.onInsert, onInsertAfter = _a.onInsertAfter;
        var _this = _super.call(this, jodit) || this;
        _this.__aiResult = '';
        _this.__error = _this.getElm('error');
        _this.__body = _this.getElm('body');
        _this.__buttons = _this.getElm('buttons');
        _this.__results = _this.getElm('results');
        _this.__spinner = _this.getElm('spinner');
        _this.__insertButton = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(jodit, '', 'Insert', 'primary').onAction(function () { return onInsert(_this.__aiResult); });
        _this.__insertAfterButton = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(jodit, '', 'Insert After', 'initial').onAction(function () { return onInsertAfter(_this.__aiResult); });
        var onSubmit = function () {
            if (_this.__formAiAssistant.validate()) {
                _this.__formAiAssistant.submit();
                _this.__toggleInsertButton(true);
                _this.__toggleSubmitButton(true);
            }
        };
        _this.__submitButton = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(jodit, 'ai-assistant', '').onAction(onSubmit);
        _this.__tryAgainButton = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(jodit, 'update', '', 'initial').onAction(onSubmit);
        _this.promptInput = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UITextArea */ .F0(jodit, {
            name: 'prompt',
            required: true,
            label: 'Prompt',
            placeholder: 'Ask AI to improve generated text',
            className: _this.getFullElName('prompt-row-input')
        });
        var buttonsBLock = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
            _this.__insertButton,
            _this.__insertAfterButton,
            _this.__tryAgainButton
        ], {
            className: _this.getFullElName('prompt-row')
        });
        _this.__formAiAssistant = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(jodit, [
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [_this.promptInput, _this.__submitButton], {
                className: _this.getFullElName('prompt-row')
            })
        ]).onSubmit(function (data) {
            _this.__error.textContent = '';
            _this.setMod('loading', true);
            jodit.e.fire('invokeAiAssistant', data.prompt);
            var hideMod = _this.getFullElName('', 'hide', 'true');
            _this.__results.classList.remove(hideMod);
            _this.__buttons.classList.remove(hideMod);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.detach(_this.__results);
            _this.__results.appendChild(_this.__spinner);
            _this.__insertButton.focus();
        });
        _this.__buttons.appendChild(buttonsBLock.container);
        _this.__body.appendChild(_this.__formAiAssistant.container);
        _this.onChangePromptValue();
        return _this;
    }
    UiAiAssistant.prototype.className = function () {
        return 'UIAiAssistant';
    };
    UiAiAssistant.prototype.render = function () {
        return "<div>\n\t\t\t\t<div class=\"&__container\">\n\t\t\t\t\t\t<div class=\"&__error\"></div>\n\t\t\t\t\t\t<div class=\"&__body\"></div>\n\t\t\t\t\t\t<div class=\"&__buttons &_hide_true\"></div>\n\t\t\t\t\t\t<div class=\"&__results &_hide_true\">\n\t\t\t\t\t\t\t\t<div class=\"&__spinner\"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t</div>";
    };
    UiAiAssistant.prototype.setPrompt = function (prompt) {
        if (prompt) {
            var jodit = this.jodit;
            var promptOpt = jodit.o.aiAssistant[prompt];
            var _a = jodit.o.aiAssistant, aiCommonPrefixPrompt = _a.aiCommonPrefixPrompt, aiCommonSuffixPrompt = _a.aiCommonSuffixPrompt;
            this.promptInput.value = [
                aiCommonPrefixPrompt,
                (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_5__/* .isString */ .K)(promptOpt) ? promptOpt : '',
                aiCommonSuffixPrompt
            ]
                .filter(Boolean)
                .join(' ');
            this.__toggleInsertButton(true);
            if (this.promptInput.value) {
                this.__formAiAssistant.submit();
                this.__toggleSubmitButton(true);
            }
        }
        this.promptInput.focus();
    };
    UiAiAssistant.prototype.onAiAssistentResponse = function (result) {
        this.setMod('loading', false);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.detach(this.__results);
        this.__aiResult = result;
        this.__results.appendChild(this.jodit.c.fromHTML(result));
        this.__toggleSubmitButton(false);
        this.__toggleInsertButton(false);
    };
    UiAiAssistant.prototype.onAiAssistentError = function (error) {
        this.__aiResult = '';
        this.setMod('loading', false);
        this.__error.textContent = error;
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.detach(this.__results);
        this.__toggleSubmitButton(false);
        var hideMod = this.getFullElName('', 'hide', 'true');
        this.__results.classList.add(hideMod);
        this.__toggleInsertButton(true);
    };
    UiAiAssistant.prototype.onChangePromptValue = function () {
        this.__toggleSubmitButton(!this.promptInput.value);
    };
    UiAiAssistant.prototype.__toggleSubmitButton = function (value) {
        this.__submitButton.state.disabled = value;
        this.__tryAgainButton.state.disabled = value;
    };
    UiAiAssistant.prototype.__toggleInsertButton = function (value) {
        this.__insertButton.state.disabled = value;
        this.__insertAfterButton.state.disabled = value;
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .watch */ .w)(':ai-assistant-response')
    ], UiAiAssistant.prototype, "onAiAssistentResponse", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .watch */ .w)(':ai-assistant-error')
    ], UiAiAssistant.prototype, "onAiAssistentError", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .watch */ .w)('promptInput:change')
    ], UiAiAssistant.prototype, "onChangePromptValue", null);
    UiAiAssistant = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__/* .component */ .s
    ], UiAiAssistant);
    return UiAiAssistant;
}(jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_3__/* .UIElement */ .D));



/***/ }),

/***/ 20797:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72197);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36115);
/* harmony import */ var _icons_ol_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40037);
/* harmony import */ var _icons_ol_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_icons_ol_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _icons_ul_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83207);
/* harmony import */ var _icons_ul_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_icons_ul_svg__WEBPACK_IMPORTED_MODULE_4__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var memoExec = function (jodit, _, _a) {
    var _b;
    var control = _a.control;
    var key = "button".concat(control.command);
    var value = (_b = (control.args && control.args[0])) !== null && _b !== void 0 ? _b : (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__/* .dataBind */ .m)(jodit, key);
    (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__/* .dataBind */ .m)(jodit, key, value);
    jodit.execCommand(control.command, false, value === 'default' ? null : value);
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__/* .Icon */ .I.set('ol', (_icons_ol_svg__WEBPACK_IMPORTED_MODULE_3___default())).set('ul', (_icons_ul_svg__WEBPACK_IMPORTED_MODULE_4___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.controls.ul = {
    command: 'insertUnorderedList',
    tags: ['ul'],
    tooltip: 'Insert Unordered List',
    list: {
        default: 'Default',
        circle: 'Circle',
        disc: 'Dot',
        square: 'Quadrate'
    },
    exec: memoExec
};
jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.controls.ol = {
    command: 'insertOrderedList',
    tags: ['ol'],
    tooltip: 'Insert Ordered List',
    list: {
        default: 'Default',
        'lower-alpha': 'Lower Alpha',
        'lower-greek': 'Lower Greek',
        'lower-roman': 'Lower Roman',
        'upper-alpha': 'Upper Alpha',
        'upper-roman': 'Upper Roman'
    },
    exec: memoExec
};


/***/ }),

/***/ 21195:
/***/ (function(module) {

module.exports["default"] = ["なにかタイプしてください","Joditについて","Jodit Editor","Jodit ユーザーズ・ガイド","詳しい使い方","ライセンス詳細についてはJodit Webサイトを確認ください：","フルバージョンを購入","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","Anchor","新しいタブで開く","エディターのサイズ（フル/ノーマル）","書式をクリア","テキストの色","やり直し","元に戻す","太字","斜体","箇条書き","番号付きリスト","中央揃え","両端揃え","左揃え","右揃え","区切り線を挿入","画像を挿入","ファイルを挿入","Youtube/Vimeo 動画","リンクを挿入","フォントサイズ","フォント","テキストのスタイル","指定なし","タイトル1","タイトル2","タイトル3","タイトル4","引用","コード","挿入","表を挿入","インデント減","インデント増","特殊文字を選択","特殊文字を挿入","書式を貼付け","編集モード切替え","マージン","上","右","下","左","スタイル","クラス","配置","右寄せ","中央寄せ","左寄せ","指定なし","ソース","タイトル","代替テキスト","リンク","新しいタブで開く","画像","ファイル","高度な設定","画像のプロパティー","キャンセル","確定","File Browser","Error on load list","Error on load folders","Are you sure?","Enter Directory name","Create directory","type name","ここに画像をドロップ","ここにファイルをドロップ","or クリック","代替テキスト","アップロード","ブラウズ","背景","文字","上","中央","下","左に列を挿入","右に列を挿入","上に行を挿入","下に行を挿入","表を削除","行を削除","列を削除","セルを空にする","文字数: %d","単語数: %d","取り消し線","下線","上付き文字","下付き文字","切り取り","すべて選択","Pause","検索","置換","交換","貼付け","選択した内容を貼付け","source","bold","italic","brush","link","undo","redo","table","image","eraser","paragraph","fontsize","video","font","about","print","underline","strikethrough","indent","outdent","fullsize","shrink","分割線","箇条書き","番号付きリスト","切り取り","すべて選択","埋め込みコード","リンクを開く","リンクを編集","No follow","リンク解除","更新","鉛筆","サイトを確認","URL","編集","水平方向の配置","Filter","Sort by changed","Sort by name","Sort by size","Add folder","リセット","保存","Save as ...","リサイズ","Crop","幅","高さ","縦横比を保持","はい","いいえ","移除","選択","選択: %s","垂直方向の配置","分割","セルの結合","列を追加","行を追加",null,"削除","セルの分割（垂直方向）","セルの分割（水平方向）","境界線","HTMLコードを保持しますか？","HTMLで貼付け","HTMLを保持","HTMLをテキストにする","テキストだけ","You can only edit your own images. Download this image on the host?","The image has been successfully uploaded to the host!","パレット","There are no files","Rename","Enter new name","プレビュー","ダウンロード","貼り付け","お使いのブラウザはクリップボードを使用できません","コピー","copy","角の丸み","全て表示","適用","まだこの分野","を入力してくださいウェブアドレス","デフォルト","白丸","黒丸","四角","見","探前","由来","The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?","Word Paste Detected","Clean","クラス名を挿入","カスタムサイズ変更のためのAltキーを押します"]

/***/ }),

/***/ 21329:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ formTemplate; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20703);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


var formTemplate = function (editor) {
    var _a = editor.o.link, openInNewTabCheckbox = _a.openInNewTabCheckbox, noFollowCheckbox = _a.noFollowCheckbox, modeClassName = _a.modeClassName, selectSizeClassName = _a.selectSizeClassName, selectMultipleClassName = _a.selectMultipleClassName, selectOptionsClassName = _a.selectOptionsClassName;
    return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIForm */ .XV(editor, [
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .tS(editor, {
                name: 'url',
                type: 'text',
                ref: 'url_input',
                label: 'URL',
                placeholder: 'http://',
                required: true
            })
        ]),
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .tS(editor, {
                name: 'content',
                ref: 'content_input',
                label: 'Text'
            })
        ], {
            ref: 'content_input_box'
        }),
        modeClassName
            ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
                (function () {
                    if (modeClassName === 'input') {
                        return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .tS(editor, {
                            name: 'className',
                            ref: 'className_input',
                            label: 'Class name'
                        });
                    }
                    if (modeClassName === 'select') {
                        return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UISelect */ .$6(editor, {
                            name: 'className',
                            ref: 'className_select',
                            label: 'Class name',
                            size: selectSizeClassName,
                            multiple: selectMultipleClassName,
                            options: selectOptionsClassName
                        });
                    }
                    return null;
                })()
            ])
            : null,
        openInNewTabCheckbox
            ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UICheckbox */ .cY(editor, {
                name: 'target',
                ref: 'target_checkbox',
                label: 'Open in new tab'
            })
            : null,
        noFollowCheckbox
            ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UICheckbox */ .cY(editor, {
                name: 'nofollow',
                ref: 'nofollow_checkbox',
                label: 'No follow'
            })
            : null,
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
            new jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(editor, {
                name: 'unlink',
                variant: 'default',
                text: 'Unlink'
            }),
            new jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(editor, {
                name: 'insert',
                type: 'submit',
                variant: 'primary',
                text: 'Insert'
            })
        ], {
            align: 'full'
        })
    ]);
};


/***/ }),

/***/ 21567:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ abort; },
/* harmony export */   r: function() { return /* binding */ isAbort; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99951);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

function abort(message) {
    if (message === void 0) { message = 'Aborted'; }
    return new DOMException(message, 'AbortError');
}
/**
 * @deprecated use `isAbortError` instead
 */
var isAbort = jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__/* .isAbortError */ .z;


/***/ }),

/***/ 21811:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ isHtmlFromWord; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Detect if string is HTML from MS Word or Excel
 */
function isHtmlFromWord(data) {
    return (data.search(/<meta.*?Microsoft Excel\s[\d].*?>/) !== -1 ||
        data.search(/<meta.*?Microsoft Word\s[\d].*?>/) !== -1 ||
        (data.search(/style="[^"]*mso-/) !== -1 && data.search(/<font/) !== -1));
}


/***/ }),

/***/ 21917:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 500 500\" xmlns=\"http://www.w3.org/2000/svg\"> <path clip-rule=\"evenodd\" d=\"M306.39,154.09c19.628,4.543,35.244,21.259,39.787,39.523 c1.551,8.54,8.998,14.989,17.904,14.989c9.991,0,18.168-8.175,18.168-18.17c0-13.083-10.991-32.98-25.985-47.881 c-14.719-14.537-32.252-24.802-46.695-24.802c-9.991,0-18.172,8.45-18.172,18.446C291.396,145.094,297.847,152.546,306.39,154.09z M56.629,392.312c-14.09,14.08-14.09,36.979,0,51.059c14.08,14.092,36.981,14.092,50.965,0l104.392-104.303 c24.347,15.181,53.062,23.991,83.953,23.991c87.857,0,158.995-71.142,158.995-158.999c0-87.854-71.138-158.995-158.995-158.995 c-87.856,0-158.995,71.141-158.995,158.995c0,30.802,8.819,59.606,23.992,83.953L56.629,392.312z M182.371,204.06 c0-62.687,50.875-113.568,113.568-113.568s113.569,50.881,113.569,113.568c0,62.694-50.876,113.569-113.569,113.569 S182.371,266.754,182.371,204.06z\" fill-rule=\"evenodd\"/> </svg>"

/***/ }),

/***/ 22664:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autobind: function() { return /* reexport safe */ _autobind_autobind__WEBPACK_IMPORTED_MODULE_0__.d; },
/* harmony export */   cache: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.PP; },
/* harmony export */   cacheHTML: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.OK; },
/* harmony export */   cached: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.PO; },
/* harmony export */   component: function() { return /* reexport safe */ _component_component__WEBPACK_IMPORTED_MODULE_2__.s; },
/* harmony export */   debounce: function() { return /* reexport safe */ _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__.s; },
/* harmony export */   derive: function() { return /* reexport safe */ _derive_derive__WEBPACK_IMPORTED_MODULE_4__.C; },
/* harmony export */   getPropertyDescriptor: function() { return /* reexport safe */ _watch_watch__WEBPACK_IMPORTED_MODULE_10__.N; },
/* harmony export */   hook: function() { return /* reexport safe */ _hook_hook__WEBPACK_IMPORTED_MODULE_5__.A; },
/* harmony export */   idle: function() { return /* reexport safe */ _idle_idle__WEBPACK_IMPORTED_MODULE_6__.N; },
/* harmony export */   nonenumerable: function() { return /* reexport safe */ _nonenumerable_nonenumerable__WEBPACK_IMPORTED_MODULE_7__.m; },
/* harmony export */   persistent: function() { return /* reexport safe */ _persistent_persistent__WEBPACK_IMPORTED_MODULE_8__.y; },
/* harmony export */   throttle: function() { return /* reexport safe */ _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__.n; },
/* harmony export */   wait: function() { return /* reexport safe */ _wait_wait__WEBPACK_IMPORTED_MODULE_9__.u; },
/* harmony export */   watch: function() { return /* reexport safe */ _watch_watch__WEBPACK_IMPORTED_MODULE_10__.w; }
/* harmony export */ });
/* harmony import */ var _autobind_autobind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11961);
/* harmony import */ var _cache_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87875);
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37075);
/* harmony import */ var _derive_derive__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1963);
/* harmony import */ var _hook_hook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71151);
/* harmony import */ var _idle_idle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86285);
/* harmony import */ var _nonenumerable_nonenumerable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(48791);
/* harmony import */ var _persistent_persistent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33087);
/* harmony import */ var _wait_wait__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(48647);
/* harmony import */ var _watch_watch__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(66927);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/README.md]]
 * @packageDocumentation
 * @module decorators
 */













/***/ }),

/***/ 23132:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ Confirm; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Show `confirm` dialog. Work without Jodit object
 *
 * @param title - Title or callback
 * @param callback - callback. The first argument is the value entered
 * @example
 * ```javascript
 * Jodit.Confirm("Are you sure?", "Confirm Dialog", function (yes) {
 *     if (yes) {
 *         // do something
 *     }
 * });
 * ```
 */
function Confirm(msg, title, callback) {
    var dialog = this instanceof jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__/* .Dialog */ .l
        ? this
        : new jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__/* .Dialog */ .l({ closeOnClickOverlay: true }), $div = dialog.c.fromHTML('<form class="jodit-dialog_prompt"></form>'), $label = dialog.c.element('label');
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    $label.appendChild(dialog.c.fromHTML(msg));
    $div.appendChild($label);
    var action = function (yes) { return function () {
        if (!callback || callback(yes) !== false) {
            dialog.close();
        }
    }; };
    var $cancel = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(dialog, 'cancel', 'Cancel');
    var $ok = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(dialog, 'ok', 'Yes');
    $cancel.onAction(action(false));
    $ok.onAction(action(true));
    dialog.e.on($div, 'submit', function () {
        action(true)();
        return false;
    });
    dialog.setFooter([$ok, $cancel]);
    dialog.open($div, title || '&nbsp;', true, true);
    $ok.focus();
    return dialog;
}


/***/ }),

/***/ 23602:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M960 896q26 0 45 19t19 45-19 45-45 19-45-19-19-45 19-45 45-19zm300 64l507 398q28 20 25 56-5 35-35 51l-128 64q-13 7-29 7-17 0-31-8l-690-387-110 66q-8 4-12 5 14 49 10 97-7 77-56 147.5t-132 123.5q-132 84-277 84-136 0-222-78-90-84-79-207 7-76 56-147t131-124q132-84 278-84 83 0 151 31 9-13 22-22l122-73-122-73q-13-9-22-22-68 31-151 31-146 0-278-84-82-53-131-124t-56-147q-5-59 15.5-113t63.5-93q85-79 222-79 145 0 277 84 83 52 132 123t56 148q4 48-10 97 4 1 12 5l110 66 690-387q14-8 31-8 16 0 29 7l128 64q30 16 35 51 3 36-25 56zm-681-260q46-42 21-108t-106-117q-92-59-192-59-74 0-113 36-46 42-21 108t106 117q92 59 192 59 74 0 113-36zm-85 745q81-51 106-117t-21-108q-39-36-113-36-100 0-192 59-81 51-106 117t21 108q39 36 113 36 100 0 192-59zm178-613l96 58v-11q0-36 33-56l14-8-79-47-26 26q-3 3-10 11t-12 12q-2 2-4 3.5t-3 2.5zm224 224l96 32 736-576-128-64-768 431v113l-160 96 9 8q2 2 7 6 4 4 11 12t11 12l26 26zm704 416l128-64-520-408-177 138q-2 3-13 7z\"/> </svg>"

/***/ }),

/***/ 24103:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/media
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.mediaFakeTag = 'jodit-media';
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.mediaInFakeBlock = true;
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.mediaBlocks = ['video', 'audio'];


/***/ }),

/***/ 24575:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Kontrola pravopisu'
};


/***/ }),

/***/ 24593:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export clipboard */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87875);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(51329);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Clipboard plugin - cut and copy functionality
 */
var clipboard = /** @class */ (function () {
    function clipboard() {
        /** @override */
        this.buttons = [
            {
                name: 'cut',
                group: 'clipboard'
            },
            {
                name: 'copy',
                group: 'clipboard'
            },
            {
                name: 'paste',
                group: 'clipboard'
            },
            {
                name: 'selectall',
                group: 'clipboard'
            }
        ];
    }
    clipboard.prototype.init = function (editor) {
        var _a;
        (_a = this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(function (btn) { return editor.registerButton(btn); });
        editor.e
            .off("copy.".concat(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID, " cut.").concat(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID))
            .on("copy.".concat(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID, " cut.").concat(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID), function (event) {
            var _a;
            var selectedText = editor.s.html;
            var clipboardData = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getDataTransfer)(event) ||
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getDataTransfer)(editor.ew) ||
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getDataTransfer)(event.originalEvent);
            if (clipboardData) {
                clipboardData.setData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.stripTags)(selectedText));
                clipboardData.setData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_HTML, selectedText);
            }
            editor.buffer.set(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID, selectedText);
            editor.e.fire('pasteStack', {
                html: selectedText,
                action: editor.o.defaultActionOnPaste ||
                    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_HTML
            });
            if (event.type === 'cut') {
                editor.s.remove();
                editor.s.focus();
            }
            event.preventDefault();
            (_a = editor === null || editor === void 0 ? void 0 : editor.events) === null || _a === void 0 ? void 0 : _a.fire('afterCopy', selectedText);
        });
    };
    /** @override */
    clipboard.prototype.destruct = function (editor) {
        var _a, _b;
        (_a = (0,jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_1__/* .cached */ .PO)(editor, 'buffer')) === null || _a === void 0 ? void 0 : _a.set(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID, '');
        (_b = editor === null || editor === void 0 ? void 0 : editor.events) === null || _b === void 0 ? void 0 : _b.off('.' + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID);
    };
    return clipboard;
}());

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('clipboard', clipboard);


/***/ }),

/***/ 24654:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.image = {
    dialogWidth: 600,
    openOnDblClick: true,
    editSrc: true,
    useImageEditor: true,
    editTitle: true,
    editAlt: true,
    editLink: true,
    editSize: true,
    editBorderRadius: true,
    editMargins: true,
    editClass: true,
    availableClasses: [],
    editStyle: true,
    editId: true,
    editAlign: true,
    showPreview: true,
    selectImageAfterClose: true
};


/***/ }),

/***/ 24767:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ component; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Decorate components and set status isReady after constructor
 * @param constructorFunction - Component constructor class
 */
function component(constructorFunction) {
    var newConstructorFunction = /** @class */ (function (_super) {
        (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__extends */ .C6)(newConstructorFunction, _super);
        function newConstructorFunction() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__read */ .zs)(args), false)) || this;
            var isRootConstructor = _this.constructor === newConstructorFunction;
            // We can add a decorator to multiple classes in a chain.
            // Status should be set only as root
            if (isRootConstructor) {
                // In some es/minimizer builds, JS instantiates the original class rather than the new constructor
                if (!(_this instanceof newConstructorFunction)) {
                    Object.setPrototypeOf(_this, newConstructorFunction.prototype);
                }
                _this.setStatus('ready');
            }
            return _this;
        }
        return newConstructorFunction;
    }(constructorFunction));
    return newConstructorFunction;
}


/***/ }),

/***/ 24772:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <path stroke-width=\"0\" d=\"M22,20.6L3.4,2H8V0H0v8h2V3.4L20.6,22H16v2h8v-8h-2V20.6z M16,0v2h4.7l-6.3,6.3l1.4,1.4L22,3.5V8h2V0H16z M8.3,14.3L2,20.6V16H0v8h8v-2H3.5l6.3-6.3L8.3,14.3z\"/> </svg>"

/***/ }),

/***/ 24834:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   w: function() { return /* binding */ Storage; }
/* harmony export */ });
/* unused harmony export StorageKey */
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83260);
/* harmony import */ var _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17800);
/* harmony import */ var _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2788);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



var StorageKey = 'Jodit_';
var Storage = /** @class */ (function () {
    function Storage(provider, suffix) {
        this.provider = provider;
        this.prefix = StorageKey;
        if (suffix) {
            this.prefix += suffix;
        }
    }
    Storage.prototype.set = function (key, value) {
        this.provider.set((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(this.prefix + key), value);
        return this;
    };
    Storage.prototype.delete = function (key) {
        this.provider.delete((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(this.prefix + key));
        return this;
    };
    Storage.prototype.get = function (key) {
        return this.provider.get((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(this.prefix + key));
    };
    Storage.prototype.exists = function (key) {
        return this.provider.exists((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(this.prefix + key));
    };
    Storage.prototype.clear = function () {
        this.provider.clear();
        return this;
    };
    Storage.makeStorage = function (persistent, suffix) {
        if (persistent === void 0) { persistent = false; }
        var provider;
        if (persistent && (0,_engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__/* .canUsePersistentStorage */ .I)()) {
            provider = new _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__/* .LocalStorageProvider */ .O(StorageKey + suffix);
        }
        if (!provider) {
            provider = new _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_1__/* .MemoryStorageProvider */ .M();
        }
        return new Storage(provider, suffix);
    };
    return Storage;
}());



/***/ }),

/***/ 24863:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ form; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

var jie = 'jodit-image-editor';
var gi = jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .In.get.bind(jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .In);
var act = function (el, className) {
    if (className === void 0) { className = 'jodti-image-editor_active'; }
    return el ? className : '';
};
var form = function (editor, o) {
    var i = editor.i18n.bind(editor);
    var switcher = function (label, ref, active) {
        if (active === void 0) { active = true; }
        return "<div class=\"jodit-form__group\">\n\t\t\t<label class=\"jodit-switcher-wrapper\">\n\t\t\t\t<span class='jodit-switcher'>\n\t\t\t\t\t<input ".concat(act(active, 'checked'), " data-ref=\"").concat(ref, "\" type=\"checkbox\"/>\n\t\t\t\t\t<span class=\"jodit-switcher__slider\"></span>\n\t\t\t\t</span>\n\t\t\t\t<span>").concat(i(label), "</span>\n\t\t\t</label>\n\t</div>");
    };
    return editor.create.fromHTML("<form class=\"".concat(jie, " jodit-properties\">\n\t\t<div class=\"jodit-grid jodit-grid_xs-column\">\n\t\t\t<div class=\"jodit_col-lg-3-4 jodit_col-sm-5-5\">\n\t\t\t").concat(o.resize
        ? "<div class=\"".concat(jie, "__area ").concat(jie, "__area_resize ").concat(jie, "_active\">\n\t\t\t\t\t\t\t<div data-ref=\"resizeBox\" class=\"").concat(jie, "__box\"></div>\n\t\t\t\t\t\t\t<div class=\"").concat(jie, "__resizer\">\n\t\t\t\t\t\t\t\t<i class=\"jodit_bottomright\"></i>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>")
        : '', "\n\t\t\t").concat(o.crop
        ? "<div class=\"".concat(jie, "__area ").concat(jie, "__area_crop ").concat(act(!o.resize), "\">\n\t\t\t\t\t\t\t<div data-ref=\"cropBox\" class=\"").concat(jie, "__box\">\n\t\t\t\t\t\t\t\t<div class=\"").concat(jie, "__croper\">\n\t\t\t\t\t\t\t\t\t<i class=\"jodit_bottomright\"></i>\n\t\t\t\t\t\t\t\t\t<i class=\"").concat(jie, "__sizes\"></i>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>")
        : '', "\n\t\t\t</div>\n\t\t\t<div class=\"jodit_col-lg-1-4 jodit_col-sm-5-5\">\n\t\t\t").concat(o.resize
        ? "<div data-area=\"resize\" class=\"".concat(jie, "__slider ").concat(jie, "_active\">\n\t\t\t\t\t\t\t<div class=\"").concat(jie, "__slider-title\">\n\t\t\t\t\t\t\t\t").concat(gi('resize'), "\n\t\t\t\t\t\t\t\t").concat(i('Resize'), "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"").concat(jie, "__slider-content\">\n\t\t\t\t\t\t\t\t<div class=\"jodit-form__group\">\n\t\t\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t\t\t").concat(i('Width'), "\n\t\t\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t\t\t\t<input type=\"number\" data-ref=\"widthInput\" class=\"jodit-input\"/>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t<div class=\"jodit-form__group\">\n\t\t\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t\t\t").concat(i('Height'), "\n\t\t\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t\t\t\t<input type=\"number\" data-ref=\"heightInput\" class=\"jodit-input\"/>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t").concat(switcher('Keep Aspect Ratio', 'keepAspectRatioResize'), "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>")
        : '', "\n\t\t\t").concat(o.crop
        ? "<div data-area=\"crop\" class=\"".concat(jie, "__slider ").concat(act(!o.resize), "'\">\n\t\t\t\t\t\t\t<div class=\"").concat(jie, "__slider-title\">\n\t\t\t\t\t\t\t\t").concat(gi('crop'), "\n\t\t\t\t\t\t\t\t").concat(i('Crop'), "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"").concat(jie, "__slider-content\">\n\t\t\t\t\t\t\t\t").concat(switcher('Keep Aspect Ratio', 'keepAspectRatioCrop'), "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>")
        : '', "\n\t\t\t</div>\n\t\t</div>\n\t</form>"));
};


/***/ }),

/***/ 25090:
/***/ (function(module) {

module.exports["default"] = ["Ecrivez ici","A propos de Jodit","Editeur Jodit","Guide de l'utilisateur","Aide détaillée à l'utilisation","Consulter la licence sur notre site web:","Acheter la version complète","Copyright © XDSoft.net - Chupurnov Valeriy. Tous droits réservés.","Ancre","Ouvrir dans un nouvel onglet","Ouvrir l'éditeur en pleine page","Supprimer le formattage","Modifier la couleur du fond ou du texte","Refaire","Défaire","Gras","Italique","Liste non ordonnée","Liste ordonnée","Centrer","Justifier","Aligner à gauche ","Aligner à droite","Insérer une ligne horizontale","Insérer une image","Insérer un fichier","Insérer une vidéo","Insérer un lien","Taille des caractères","Famille des caractères","Bloc formatté","Normal","Titre 1","Titre 2","Titre 3","Titre 4","Citation","Code","Insérer","Insérer un tableau","Diminuer le retrait","Retrait plus","Sélectionnez un caractère spécial","Insérer un caractère spécial","Cloner le format","Mode wysiwyg <-> code html","Marges","haut","droite","Bas","gauche","Styles","Classes","Alignement","Droite","Centre","Gauche","--Non disponible--","Source","Titre","Alternative","Lien","Ouvrir le lien dans un nouvel onglet","Image","fichier","Avancé","Propriétés de l'image","Annuler","OK","Explorateur de fichiers","Erreur de liste de chargement","Erreur de dossier de chargement","Etes-vous sûrs ?","Entrer le nom de dossier","Créer un dossier","type de fichier","Coller une image","Déposer un fichier","ou cliquer","Texte de remplacemement","Charger","Chercher","Arrière-plan","Texte","Haut","Milieu","Bas","Insérer une colonne avant","Insérer une colonne après","Insérer une ligne au dessus","Insérer une ligne en dessous","Supprimer le tableau","Supprimer la ligne","Supprimer la colonne","Vider la cellule","Symboles: %d","Mots: %d","Barrer","Souligner","exposant","indice","Couper la sélection","Tout sélectionner","Pause","Rechercher","Remplacer par","Remplacer","Coller","Choisissez le contenu à coller","la source","gras","italique","pinceau","lien","annuler","refaire","tableau","image","gomme","clause","taille de police","Video","police","à propos de l'éditeur","impression","souligné","barré","indentation","retrait","taille réelle","taille conventionnelle","la ligne","Liste","Liste numérotée","Couper","Sélectionner tout",null,"Ouvrir le lien","Modifier le lien","Attribut Nofollow","Supprimer le lien","Mettre à jour","Pour éditer","Voir","URL",null,"Alignement horizontal","Filtre","Trier par modification","Trier par nom","Trier par taille","Créer le dossier","Restaurer","Sauvegarder","Enregistrer sous","Changer la taille","Taille de garniture","Largeur","Hauteur","Garder les proportions","Oui","Non","Supprimer","Mettre en évidence","Mettre en évidence: %s","Alignement vertical","Split","aller","Ajouter une colonne","Ajouter une rangée",null,"Effacer","Split vertical","Split horizontal","Bordure","Votre texte que vous essayez de coller est similaire au HTML. Collez-le en HTML?","Coller en HTML?","Sauvegarder l'original","Coller en tant que texte","Coller le texte seulement","Vous ne pouvez éditer que vos propres images. Téléchargez cette image sur l'hôte?","L'image a été téléchargée avec succès sur le serveur!","Palette","Il n'y a aucun fichier dans ce répertoire.","renommer","Entrez un nouveau nom","Aperçu","Télécharger","Coller à partir du presse-papiers","Votre navigateur ne prend pas en charge l'accès direct au presse-papiers.","Copier la sélection","copie","Rayon des bordures","Afficher tous","Appliquer","Veuillez remplir ce champ","Veuillez entrer une adresse web","Par défaut","Cercle","Point","Quadratique","Trouver","Précédent","Suivant","Le contenu que vous insérez provient d'un document Microsoft Word / Excel. Voulez-vous enregistrer le format ou l'effacer?","C'est peut-être un fragment de Word ou Excel","Nettoyer","Insérer un nom de classe","Appuyez sur Alt pour un redimensionnement personnalisé"]

/***/ }),

/***/ 25182:
/***/ (function(module) {

module.exports["default"] = ["输入一些内容","关于Jodit","Jodit Editor","开发者指南","使用帮助","有关许可证的信息，请访问我们的网站：","购买完整版本","Copyright © XDSoft.net - Chupurnov Valeriy. 版权所有","Anchor","在新窗口打开","全屏编辑","清除样式","颜色","重做","撤销","粗体","斜体","符号列表","编号","居中","对齐文本","左对齐","右对齐","分割线","图片","文件","视频","链接","字号","字体","格式块","默认","标题1","标题2","标题3","标题4","引用","代码","插入","表格","减少缩进","增加缩进","选择特殊符号","特殊符号","格式复制","改变模式","外边距（Margins）","top","right","bottom","left","样式","Classes","对齐方式","居右","居中","居左","无","Src","Title","Alternative","Link","在新窗口打开链接","图片","file","高级","图片属性","取消","确定","文件管理","加载list错误","加载folders错误","你确定吗？","输入路径","创建路径","type name","拖动图片到此","拖动文件到此","或点击","Alternative text","上传","浏览","背景色","文字","顶部","中间","底部","在之前插入列","在之后插入列","在之前插入行","在之后插入行","删除表格","删除行","删除列","清除内容","字符数: %d","单词数: %d","删除线","下划线","上标","下标","剪切","全选","Break","查找","替换为","替换","粘贴","选择内容并粘贴","源码","粗体","斜体","颜色","链接","撤销","重做","表格","图片","橡皮擦","段落","字号","视频","字体","关于","打印","下划线","上出现","增加缩进","减少缩进","全屏","收缩","分割线","无序列表","顺序列表","剪切","全选","嵌入代码","打开链接","编辑链接","No follow","取消链接","更新","铅笔","预览","URL","编辑","水平对齐","筛选","修改时间排序","名称排序","大小排序","新建文件夹","重置","保存","保存为","调整大小","剪切","宽","高","保持长宽比","是","不","移除","选择","选择: %s","垂直对齐","拆分","合并","添加列","添加行",null,"删除","垂直拆分","水平拆分","边框","你粘贴的文本是一段html代码，是否保留源格式","html粘贴","保留源格式","把html代码视为普通文本","只保留文本","你只能编辑你自己的图片。Download this image on the host?","图片上传成功","调色板","此目录中沒有文件。","重命名","输入新名称","预览","下载","粘贴从剪贴板","你浏览器不支持直接访问的剪贴板。","复制选中内容","复制","边界半径","显示所有","应用","请填写这个字段","请输入一个网址","默认","圆圈","点","方形","搜索","查找上一个","查找下一个","正在粘贴 Word/Excel 的文本，是否保留源格式？","文本粘贴","匹配目标格式","插入班级名称","按Alt自定义调整大小"]

/***/ }),

/***/ 25376:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ isPlainObject; }
/* harmony export */ });
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if element is simple plaint object
 */
function isPlainObject(obj) {
    if (!obj || typeof obj !== 'object' || obj.nodeType || (0,_is_window__WEBPACK_IMPORTED_MODULE_0__/* .isWindow */ .l)(obj)) {
        return false;
    }
    return !(obj.constructor &&
        !{}.hasOwnProperty.call(obj.constructor.prototype, 'isPrototypeOf'));
}


/***/ }),

/***/ 25459:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'העתק עיצוב'
};


/***/ }),

/***/ 25501:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1744 1408q33 0 42 18.5t-11 44.5l-126 162q-20 26-49 26t-49-26l-126-162q-20-26-11-44.5t42-18.5h80v-1024h-80q-33 0-42-18.5t11-44.5l126-162q20-26 49-26t49 26l126 162q20 26 11 44.5t-42 18.5h-80v1024h80zm-1663-1279l54 27q12 5 211 5 44 0 132-2t132-2q36 0 107.5.5t107.5.5h293q6 0 21 .5t20.5 0 16-3 17.5-9 15-17.5l42-1q4 0 14 .5t14 .5q2 112 2 336 0 80-5 109-39 14-68 18-25-44-54-128-3-9-11-48t-14.5-73.5-7.5-35.5q-6-8-12-12.5t-15.5-6-13-2.5-18-.5-16.5.5q-17 0-66.5-.5t-74.5-.5-64 2-71 6q-9 81-8 136 0 94 2 388t2 455q0 16-2.5 71.5t0 91.5 12.5 69q40 21 124 42.5t120 37.5q5 40 5 50 0 14-3 29l-34 1q-76 2-218-8t-207-10q-50 0-151 9t-152 9q-3-51-3-52v-9q17-27 61.5-43t98.5-29 78-27q19-42 19-383 0-101-3-303t-3-303v-117q0-2 .5-15.5t.5-25-1-25.5-3-24-5-14q-11-12-162-12-33 0-93 12t-80 26q-19 13-34 72.5t-31.5 111-42.5 53.5q-42-26-56-44v-383z\"/> </svg>"

/***/ }),

/***/ 25884:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Зураасны өндөр'
};


/***/ }),

/***/ 26150:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ attr; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(449);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Alias for `elm.getAttribute` but if set second argument `-{key}`
 * it will also check `data-{key}` attribute
 * if set `value` it is alias for setAttribute with the same logic
 */
function attr(elm, keyOrAttributes, value) {
    if (!elm || !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .Tn)(elm.getAttribute)) {
        return null;
    }
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .Kg)(keyOrAttributes)) {
        Object.keys(keyOrAttributes).forEach(function (key) {
            var value = keyOrAttributes[key];
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isPlainObject */ .Qd)(value) && key === 'style') {
                (0,_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(elm, value);
            }
            else {
                if (key === 'className') {
                    key = 'class';
                }
                attr(elm, key, value);
            }
        });
        return null;
    }
    var key = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__/* .CamelCaseToKebabCase */ .N)(keyOrAttributes);
    if (/^-/.test(key)) {
        var res = attr(elm, "data".concat(key));
        if (res) {
            return res;
        }
        key = key.substr(1);
    }
    if (value !== undefined) {
        if (value == null) {
            elm.hasAttribute(key) && elm.removeAttribute(key);
        }
        else {
            var replaceValue = value.toString();
            if (elm.nodeName === 'IMG' &&
                (key === 'width' || key === 'height')) {
                replaceValue = replaceValue.replace('px', '');
            }
            elm.setAttribute(key, replaceValue);
            return replaceValue;
        }
    }
    return elm.getAttribute(key);
}


/***/ }),

/***/ 26328:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ safeHTML; },
/* harmony export */   v: function() { return /* binding */ sanitizeHTMLElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */


/**
 * Removes dangerous constructs from HTML
 */
function safeHTML(box, options) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(box) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isFragment(box)) {
        return;
    }
    if (options.removeOnError) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('[onerror]', box).forEach(function (elm) { return sanitizeHTMLElement(elm, options); });
    }
    if (options.safeJavaScriptLink) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('a[href^="javascript"]', box).forEach(function (elm) {
            return sanitizeHTMLElement(elm, options);
        });
    }
}
function sanitizeHTMLElement(elm, _a) {
    var _b = _a === void 0 ? {
        safeJavaScriptLink: true,
        removeOnError: true
    } : _a, safeJavaScriptLink = _b.safeJavaScriptLink, removeOnError = _b.removeOnError;
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(elm)) {
        return false;
    }
    var effected = false;
    if (removeOnError && elm.hasAttribute('onerror')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'onerror', null);
        effected = true;
    }
    var href = elm.getAttribute('href');
    if (safeJavaScriptLink && href && href.trim().indexOf('javascript') === 0) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href', location.protocol + '//' + href);
        effected = true;
    }
    return effected;
}


/***/ }),

/***/ 26396:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ align; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40080);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




var align = {
    name: 'left',
    childTemplate: function (_, __, value) { return value; },
    list: ['Left', 'Right', 'Center', 'Normal'],
    exec: function (editor, elm, _a) {
        var control = _a.control;
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, new Set(['img', 'jodit', 'jodit-media']))) {
            return;
        }
        var command = control.args && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(control.args[0])
            ? control.args[0].toLowerCase()
            : '';
        if (!command) {
            return false;
        }
        (0,jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_1__/* .hAlignElement */ .Mr)(elm, command);
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, new Set(['jodit', 'jodit-media'])) &&
            elm.firstElementChild) {
            (0,jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_1__/* .hAlignElement */ .Mr)(elm.firstElementChild, command);
        }
        editor.synchronizeValues();
        editor.e.fire('recalcPositionPopup');
    },
    tooltip: 'Horizontal align'
};
/* harmony default export */ __webpack_exports__.A = ([
    {
        name: 'delete',
        icon: 'bin',
        tooltip: 'Delete',
        exec: function (editor, image) {
            image && editor.s.removeNode(image);
        }
    },
    {
        name: 'pencil',
        exec: function (editor, current) {
            var tagName = current.tagName.toLowerCase();
            if (tagName === 'img') {
                editor.e.fire('openImageProperties', current);
            }
        },
        tooltip: 'Edit'
    },
    {
        name: 'valign',
        list: ['Top', 'Middle', 'Bottom', 'Normal'],
        tooltip: 'Vertical align',
        exec: function (editor, image, _a) {
            var control = _a.control;
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(image, 'img')) {
                return;
            }
            var command = control.args && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(control.args[0])
                ? control.args[0].toLowerCase()
                : '';
            if (!command) {
                return false;
            }
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(image, 'vertical-align', command === 'normal' ? '' : command);
            editor.e.fire('recalcPositionPopup');
        }
    },
    align
]);


/***/ }),

/***/ 26421:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export media */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97369);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24103);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Process `video` and `audio`
 */
function media(editor) {
    var keyFake = 'jodit_fake_wrapper';
    var _a = editor.options, mediaFakeTag = _a.mediaFakeTag, mediaBlocks = _a.mediaBlocks, mediaInFakeBlock = _a.mediaInFakeBlock;
    var wrap = function (element) {
        var _a;
        if (element.parentNode &&
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.attr)(element.parentNode, 'data-jodit_iframe_wrapper')) {
            element = element.parentNode;
        }
        else {
            var wrapper = editor.createInside.element(mediaFakeTag, (_a = {
                    'data-jodit-temp': 1,
                    contenteditable: false,
                    draggable: true
                },
                _a["data-".concat(keyFake)] = 1,
                _a));
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.attr)(wrapper, 'style', (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.attr)(element, 'style'));
            wrapper.style.display =
                element.style.display === 'inline-block'
                    ? 'inline-block'
                    : 'block';
            wrapper.style.width = element.offsetWidth + 'px';
            wrapper.style.height = element.offsetHeight + 'px';
            if (element.parentNode) {
                element.parentNode.insertBefore(wrapper, element);
            }
            wrapper.appendChild(element);
            element = wrapper;
        }
        editor.e
            .off(element, 'mousedown.select touchstart.select')
            .on(element, 'mousedown.select touchstart.select', function () {
            editor.s.setCursorAfter(element);
        });
    };
    if (mediaInFakeBlock) {
        editor.e
            .on('afterGetValueFromEditor', function (data) {
            var rxp = new RegExp("<".concat(mediaFakeTag, "[^>]+data-").concat(keyFake, "[^>]+>([^]+?)</").concat(mediaFakeTag, ">"), 'ig');
            if (rxp.test(data.value)) {
                data.value = data.value.replace(rxp, '$1');
            }
        })
            .on('change afterInit afterSetMode changePlace', editor.async.debounce(function () {
            if (!editor.isDestructed &&
                editor.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE) {
                (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.$$)(mediaBlocks.join(','), editor.editor).forEach(function (elm) {
                    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.dataBind)(elm, keyFake)) {
                        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.dataBind)(elm, keyFake, true);
                        wrap(elm);
                    }
                });
            }
        }, editor.defaultTimeout));
    }
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('media', media);


/***/ }),

/***/ 26495:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export iframe */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(99689);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Iframe plugin - use `iframe` instead of DIV in editor. It can be need when you want to attach custom styles in editor
 * in backend of you system
 */
function iframe(editor) {
    var opt = editor.options;
    editor.e
        .on('afterSetMode', function () {
        if (editor.isEditorMode()) {
            editor.s.focus();
        }
    })
        .on('generateDocumentStructure.iframe', function (__doc, jodit) {
        var doc = __doc ||
            jodit.iframe
                .contentWindow.document;
        doc.open();
        doc.write(opt.iframeDoctype +
            "<html dir=\"".concat(opt.direction, "\" class=\"jodit\" lang=\"").concat((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.defaultLanguage)(opt.language), "\">") +
            '<head>' +
            "<title>".concat(opt.iframeTitle, "</title>") +
            (opt.iframeBaseUrl
                ? "<base href=\"".concat(opt.iframeBaseUrl, "\"/>")
                : '') +
            '</head>' +
            '<body class="jodit-wysiwyg"></body>' +
            '</html>');
        doc.close();
        if (opt.iframeCSSLinks) {
            opt.iframeCSSLinks.forEach(function (href) {
                var link = doc.createElement('link');
                link.setAttribute('rel', 'stylesheet');
                link.setAttribute('href', href);
                doc.head && doc.head.appendChild(link);
            });
        }
        if (opt.iframeStyle) {
            var style = doc.createElement('style');
            style.innerHTML = opt.iframeStyle;
            doc.head && doc.head.appendChild(style);
        }
    })
        .on('createEditor', function () {
        if (!opt.iframe) {
            return;
        }
        var iframe = editor.c.element('iframe');
        iframe.style.display = 'block';
        iframe.src = 'about:blank';
        iframe.className = 'jodit-wysiwyg_iframe';
        iframe.setAttribute('allowtransparency', 'true');
        iframe.setAttribute('tabindex', opt.tabIndex.toString());
        iframe.setAttribute('frameborder', '0');
        if (opt.iframeSandbox != null) {
            iframe.setAttribute('sandbox', opt.iframeSandbox);
        }
        editor.workplace.appendChild(iframe);
        editor.iframe = iframe;
        var result = editor.e.fire('generateDocumentStructure.iframe', null, editor);
        var init = function () {
            if (!editor.iframe) {
                return false;
            }
            var doc = editor.iframe.contentWindow.document;
            editor.editorWindow = editor.iframe.contentWindow;
            var docMode = opt.editHTMLDocumentMode;
            var toggleEditable = function () {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.attr)(doc.body, 'contenteditable', (editor.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE &&
                    !editor.getReadOnly()) ||
                    null);
            };
            var clearMarkers = function (html) {
                var bodyReg = /<body.*<\/body>/im, bodyMarker = '{%%BODY%%}', body = bodyReg.exec(html);
                if (body) {
                    // remove markers
                    html = html
                        .replace(bodyReg, bodyMarker)
                        .replace(/<span([^>]*?)>(.*?)<\/span>/gim, '')
                        .replace(/&lt;span([^&]*?)&gt;(.*?)&lt;\/span&gt;/gim, '')
                        .replace(bodyMarker, body[0]
                        .replace(/(<body[^>]+?)min-height["'\s]*:[\s"']*[0-9]+(px|%)/im, '$1')
                        .replace(/(<body[^>]+?)([\s]*["'])?contenteditable["'\s]*=[\s"']*true["']?/im, '$1')
                        .replace(/<(style|script|span)[^>]+jodit[^>]+>.*?<\/\1>/g, ''))
                        .replace(/(class\s*=\s*)(['"])([^"']*)(jodit-wysiwyg|jodit)([^"']*\2)/g, '$1$2$3$5')
                        .replace(/(<[^<]+?)\sclass="[\s]*"/gim, '$1')
                        .replace(/(<[^<]+?)\sstyle="[\s;]*"/gim, '$1')
                        .replace(/(<[^<]+?)\sdir="[\s]*"/gim, '$1');
                }
                return html;
            };
            if (docMode) {
                var tag = editor.element.tagName;
                if (tag !== 'TEXTAREA' && tag !== 'INPUT') {
                    throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)('If enable `editHTMLDocumentMode` - source element should be INPUT or TEXTAREA');
                }
                editor.e
                    .on('beforeGetNativeEditorValue', function () {
                    return clearMarkers(editor.o.iframeDoctype +
                        doc.documentElement.outerHTML);
                })
                    .on('beforeSetNativeEditorValue', function (_a) {
                    var value = _a.value;
                    if (editor.isLocked) {
                        return false;
                    }
                    if (/<(html|body)/i.test(value)) {
                        var old = doc.documentElement.outerHTML;
                        if (clearMarkers(old) !==
                            clearMarkers(value)) {
                            doc.open();
                            doc.write(editor.o.iframeDoctype +
                                clearMarkers(value));
                            doc.close();
                            editor.editor = doc.body;
                            editor.e.fire('safeHTML', editor.editor);
                            toggleEditable();
                            editor.e.fire('prepareWYSIWYGEditor');
                            editor.e.stopPropagation('beforeSetNativeEditorValue');
                        }
                    }
                    else {
                        doc.body.innerHTML = value;
                    }
                    return true;
                }, { top: true });
            }
            editor.editor = doc.body;
            editor.e.on('afterSetMode afterInit afterAddPlace', toggleEditable);
            if (opt.height === 'auto') {
                doc.documentElement &&
                    (doc.documentElement.style.overflowY = 'hidden');
                var resizeIframe = editor.async.throttle(function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    editor.async.requestAnimationFrame(function () {
                        if (editor.editor &&
                            editor.iframe &&
                            opt.height === 'auto') {
                            var style = editor.ew.getComputedStyle(editor.editor), marginOffset = parseInt(style.marginTop || '0', 10) +
                                parseInt(style.marginBottom || '0', 10);
                            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(editor.iframe, 'height', editor.editor.offsetHeight + marginOffset);
                        }
                    });
                }, editor.defaultTimeout / 2);
                editor.e
                    .on('change afterInit afterSetMode resize', resizeIframe)
                    .on([editor.iframe, editor.ew, doc.documentElement], 'load', resizeIframe)
                    .on(doc, 'readystatechange DOMContentLoaded', resizeIframe);
                if (typeof ResizeObserver === 'function') {
                    var resizeObserver_1 = new ResizeObserver(resizeIframe);
                    resizeObserver_1.observe(doc.body);
                    editor.e.on('beforeDestruct', function () {
                        resizeObserver_1.disconnect();
                    });
                }
            }
            // throw events in our world
            if (doc.documentElement) {
                editor.e
                    .on(doc.documentElement, 'mousedown touchend', function () {
                    if (!editor.s.isFocused()) {
                        editor.s.focus();
                        if (editor.editor === doc.body) {
                            editor.s.setCursorIn(doc.body);
                        }
                    }
                })
                    .on(editor.ew, 'mousedown touchstart keydown keyup touchend click mouseup mousemove scroll', function (e) {
                    var _a;
                    (_a = editor.events) === null || _a === void 0 ? void 0 : _a.fire(editor.ow, e);
                });
            }
            return false;
        };
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.callPromise)(result, init);
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('iframe', iframe);


/***/ }),

/***/ 26538:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ Uploader; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74340);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77334);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








var Uploader = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(Uploader, _super);
    function Uploader(editor, options) {
        var _this = _super.call(this, editor) || this;
        _this.path = '';
        _this.source = 'default';
        _this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(options || {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.defaultOptions.uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isJoditObject)(editor) ? editor.o.uploader : {}));
        return _this;
    }
    Object.defineProperty(Uploader.prototype, "j", {
        get: function () {
            return this.jodit;
        },
        enumerable: false,
        configurable: true
    });
    /** @override */
    Uploader.prototype.className = function () {
        return 'Uploader';
    };
    Object.defineProperty(Uploader.prototype, "o", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * It sets the path for uploading files
     */
    Uploader.prototype.setPath = function (path) {
        this.path = path;
        return this;
    };
    /**
     * It sets the source for connector
     */
    Uploader.prototype.setSource = function (source) {
        this.source = source;
        return this;
    };
    /**
     * Set the handlers Drag and Drop to `$form`
     *
     * @param form - Form or any Node on which you can drag and drop the file. In addition will be processed
     * <code>&lt;input type="file" &gt;</code>
     * @param handlerSuccess - The function be called when a successful uploading files
     * to the server
     * @param handlerError - The function that will be called during a failed download files a server
     * @example
     * ```javascript
     * var $form = jQuery('<form><input type="text" typpe="file"></form>');
     * jQuery('body').append($form);
     * Jodit.editors.someidfoeditor.uploader.bind($form[0], function (files) {
     *     var i;
     *     for (i = 0; i < data.files.length; i += 1) {
     *         parent.s.insertImage(data.files[i])
     *     }
     * });
     * ```
     */
    Uploader.prototype.bind = function (form, handlerSuccess, handlerError) {
        var onFinally = function () {
            form.classList.remove('jodit_drag_hover');
        };
        var self = this, onPaste = function (e) {
            var i, file, extension;
            var cData = e.clipboardData;
            var processData = function (formdata) {
                if (file) {
                    formdata.append('extension', extension);
                    formdata.append('mimetype', file.type);
                }
            };
            // send data on server
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_IE && (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(cData)) {
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, cData.files, handlerSuccess, handlerError).finally(onFinally);
                return false;
            }
            if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_IE && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_ES_NEXT) {
                return (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .processOldBrowserDrag */ .dT)(self, cData, handlerSuccess, handlerError, onFinally);
            }
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasItems */ .Pb)(cData)) {
                var items = cData.items;
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].kind === 'file' &&
                        items[i].type === 'image/png') {
                        file = items[i].getAsFile();
                        if (file) {
                            var mime = file.type.match(/\/([a-z0-9]+)/i);
                            extension = mime[1]
                                ? mime[1].toLowerCase()
                                : '';
                            (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, [file], handlerSuccess, handlerError, processData).finally(onFinally);
                        }
                        e.preventDefault();
                        break;
                    }
                }
            }
        };
        if (self.j && self.j.editor !== form) {
            self.j.e.on(form, 'paste', onPaste);
        }
        else {
            self.j.e.on('beforePaste', onPaste);
        }
        this.attachEvents(form, handlerSuccess, handlerError, onFinally);
    };
    Uploader.prototype.attachEvents = function (form, handlerSuccess, handlerError, onFinally) {
        var self = this;
        self.j.e
            .on(form, 'dragend dragover dragenter dragleave drop', function (e) {
            e.preventDefault();
        })
            .on(form, 'dragover', function (event) {
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer) ||
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasItems */ .Pb)(event.dataTransfer)) {
                form.classList.add('jodit_drag_hover');
                event.preventDefault();
            }
        })
            .on(form, 'dragend dragleave', function (event) {
            form.classList.remove('jodit_drag_hover');
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer)) {
                event.preventDefault();
            }
        })
            .on(form, 'drop', function (event) {
            form.classList.remove('jodit_drag_hover');
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer)) {
                event.preventDefault();
                event.stopImmediatePropagation();
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, event.dataTransfer.files, handlerSuccess, handlerError).finally(onFinally);
            }
        });
        var inputFile = form.querySelector('input[type=file]');
        if (inputFile) {
            self.j.e.on(inputFile, 'change', function () {
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, inputFile.files, handlerSuccess, handlerError)
                    .then(function () {
                    inputFile.value = '';
                    if (!/safari/i.test(navigator.userAgent)) {
                        inputFile.type = '';
                        inputFile.type = 'file';
                    }
                })
                    .finally(onFinally);
            });
        }
    };
    /**
     * Upload images to a server by its URL, making it through the connector server.
     */
    Uploader.prototype.uploadRemoteImage = function (url, handlerSuccess, handlerError) {
        var uploader = this, o = uploader.o;
        var handlerE = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(handlerError)
            ? handlerError
            : o.defaultHandlerError;
        (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .send */ .tN)(uploader, {
            action: 'fileUploadRemote',
            url: url
        })
            .then(function (resp) {
            if (o.isSuccess.call(uploader, resp)) {
                var handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(handlerSuccess)
                    ? handlerSuccess
                    : o.defaultHandlerSuccess;
                handler.call(uploader, o.process.call(uploader, resp));
                return;
            }
            handlerE.call(uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(o.getMessage.call(uploader, resp)));
        })
            .catch(function (e) { return handlerE.call(uploader, e); });
    };
    Uploader.prototype.destruct = function () {
        this.setStatus(jodit_core_component___WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        var instances = jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .ajaxInstances */ .$j.get(this);
        if (instances) {
            instances.forEach(function (ajax) {
                try {
                    ajax.destruct();
                }
                catch (_a) { }
            });
            instances.clear();
        }
        _super.prototype.destruct.call(this);
    };
    return Uploader;
}(jodit_core_component___WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG));



/***/ }),

/***/ 26725:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36115);
/* harmony import */ var _line_height_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(223);
/* harmony import */ var _line_height_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_line_height_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.defaultLineHeight = null;
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__/* .Icon */ .I.set('line-height', (_line_height_svg__WEBPACK_IMPORTED_MODULE_3___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.controls.lineHeight = {
    command: 'applyLineHeight',
    tags: ['ol'],
    tooltip: 'Line height',
    list: [1, 1.1, 1.2, 1.3, 1.4, 1.5, 2],
    exec: function (editor, event, _a) {
        var control = _a.control;
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.memorizeExec)(editor, event, { control: control }, function (value) { return value; });
    }
};


/***/ }),

/***/ 27195:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/stat
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.showCharsCounter = true;
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.countHTMLChars = false;
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.countTextSpaces = false;
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.showWordsCounter = true;


/***/ }),

/***/ 27301:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EW: function() { return /* binding */ alreadyLoadedList; },
/* harmony export */   Qt: function() { return /* binding */ loadNext; },
/* harmony export */   S5: function() { return /* binding */ appendStyleAsync; },
/* harmony export */   w4: function() { return /* binding */ appendScriptAsync; },
/* harmony export */   x_: function() { return /* binding */ loadNextStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98253);
/* harmony import */ var _complete_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(60346);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


var alreadyLoadedList = new Map();
var cacheLoaders = function (loader) {
    return function (jodit, url) {
        if (alreadyLoadedList.has(url)) {
            return alreadyLoadedList.get(url);
        }
        var promise = loader(jodit, url);
        alreadyLoadedList.set(url, promise);
        return promise;
    };
};
/**
 * Load script and return promise
 */
var appendScriptAsync = cacheLoaders(function (jodit, url) {
    return jodit.async.promise(function (resolve, reject) {
        if (jodit.isInDestruct) {
            return reject();
        }
        var script = jodit.c.element('script', {
            type: 'text/javascript',
            crossorigin: 'anonymous',
            referrerpolicy: 'no-referrer',
            async: true,
            src: (0,_complete_url__WEBPACK_IMPORTED_MODULE_0__/* .completeUrl */ .X)(url)
        });
        jodit.od.body.appendChild(script);
        jodit.e.on(script, 'error', reject).on(script, 'load', resolve);
    });
});
/**
 * Download CSS style script
 */
var appendStyleAsync = cacheLoaders(function (jodit, url) {
    return jodit.async.promise(function (resolve, reject) {
        if (jodit.isInDestruct) {
            return reject();
        }
        var link = jodit.c.element('link');
        link.rel = 'stylesheet';
        link.media = 'all';
        link.crossOrigin = 'anonymous';
        var callback = function () { return resolve(link); };
        !jodit.isInDestruct &&
            jodit.e.on(link, 'load', callback).on(link, 'error', reject);
        link.href = (0,_complete_url__WEBPACK_IMPORTED_MODULE_0__/* .completeUrl */ .X)(url);
        if (jodit.o.shadowRoot) {
            jodit.o.shadowRoot.appendChild(link);
        }
        else {
            jodit.od.body.appendChild(link);
        }
    });
});
function loadNext(jodit, urls, i) {
    if (i === void 0) { i = 0; }
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .K)(urls[i])) {
        return Promise.resolve();
    }
    return appendScriptAsync(jodit, urls[i]).then(function () {
        return loadNext(jodit, urls, i + 1);
    });
}
function loadNextStyle(jodit, urls, i) {
    if (i === void 0) { i = 0; }
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .K)(urls[i])) {
        return Promise.resolve();
    }
    return appendStyleAsync(jodit, urls[i]).then(function () {
        return loadNextStyle(jodit, urls, i + 1);
    });
}


/***/ }),

/***/ 27337:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.defaultAjaxOptions = {
    successStatuses: [200, 201, 202],
    method: 'GET',
    url: '',
    data: null,
    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
    headers: {
        'X-REQUESTED-WITH': 'XMLHttpRequest' // compatible with jQuery
    },
    withCredentials: false,
    xhr: function () {
        return new XMLHttpRequest();
    }
};


/***/ }),

/***/ 27509:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export dragAndDropElement */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96900);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







var DragState;
(function (DragState) {
    DragState[DragState["IDLE"] = 0] = "IDLE";
    DragState[DragState["WAIT_DRAGGING"] = 1] = "WAIT_DRAGGING";
    DragState[DragState["DRAGGING"] = 2] = "DRAGGING";
})(DragState || (DragState = {}));
/**
 * Process drag and drop image or another element inside the editor
 */
var dragAndDropElement = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(dragAndDropElement, _super);
    function dragAndDropElement() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(arguments), false)) || this;
        _this.dragList = [];
        _this.draggable = null;
        _this.isCopyMode = false;
        /**
         * Shift in pixels after which we consider that the transfer of the element has begun
         */
        _this.diffStep = 10;
        _this.startX = 0;
        _this.startY = 0;
        _this.state = DragState.IDLE;
        return _this;
    }
    /** @override */
    dragAndDropElement.prototype.afterInit = function () {
        this.dragList = this.j.o.draggableTags
            ? (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.splitArray)(this.j.o.draggableTags)
                .filter(Boolean)
                .map(function (item) { return item.toLowerCase(); })
            : [];
        if (!this.dragList.length) {
            return;
        }
        this.j.e.on('mousedown dragstart', this.onDragStart);
    };
    /**
     * Drag start handler
     */
    dragAndDropElement.prototype.onDragStart = function (event) {
        var _this = this;
        if (event.type === 'dragstart' && this.draggable) {
            return false;
        }
        if (this.state > DragState.IDLE) {
            return;
        }
        var target = event.target;
        if (!this.dragList.length || !target) {
            return;
        }
        var matched = function (node) {
            return Boolean(node && _this.dragList.includes(node.nodeName.toLowerCase()));
        };
        var lastTarget = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.furthest(target, matched, this.j.editor) ||
            (matched(target) ? target : null);
        if (!lastTarget) {
            return;
        }
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(lastTarget.parentElement, 'a') &&
            lastTarget.parentElement.firstChild === lastTarget &&
            lastTarget.parentElement.lastChild === lastTarget) {
            lastTarget = lastTarget.parentElement;
        }
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.isCopyMode = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ctrlKey)(event); // we can move only element from editor
        this.draggable = lastTarget.cloneNode(true);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.dataBind)(this.draggable, 'target', lastTarget);
        this.state = DragState.WAIT_DRAGGING;
        this.addDragListeners();
    };
    /**
     * Mouse move handler handler
     */
    dragAndDropElement.prototype.onDrag = function (event) {
        var _a, _b;
        if (!this.draggable || this.state === DragState.IDLE) {
            return;
        }
        var x = event.clientX, y = event.clientY;
        if (this.state === DragState.WAIT_DRAGGING &&
            Math.sqrt(Math.pow(x - this.startX, 2) + Math.pow(y - this.startY, 2)) < this.diffStep) {
            return;
        }
        if (this.state === DragState.WAIT_DRAGGING) {
            this.j.lock('drag-and-drop-element');
            this.state = DragState.DRAGGING;
        }
        this.j.e.fire('hidePopup hideResizer');
        if (!this.draggable.parentNode) {
            var target = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.dataBind)(this.draggable, 'target');
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.draggable, {
                zIndex: 10000000000000,
                pointerEvents: 'none',
                pointer: 'drag',
                position: 'fixed',
                opacity: 0.7,
                display: 'inline-block',
                left: event.clientX,
                top: event.clientY,
                width: (_a = target === null || target === void 0 ? void 0 : target.offsetWidth) !== null && _a !== void 0 ? _a : 100,
                height: (_b = target === null || target === void 0 ? void 0 : target.offsetHeight) !== null && _b !== void 0 ? _b : 100
            });
            (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .getContainer */ .My)(this.j, dragAndDropElement).appendChild(this.draggable);
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.draggable, {
            left: event.clientX,
            top: event.clientY
        });
        this.j.s.insertCursorAtPoint(event.clientX, event.clientY);
    };
    /**
     * Mouseup handler in any place
     */
    dragAndDropElement.prototype.onDragEnd = function () {
        if (this.isInDestruct) {
            return;
        }
        this.removeDragListeners();
        this.j.unlock();
        this.state = DragState.IDLE;
        if (this.draggable) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.draggable);
            this.draggable = null;
        }
    };
    /**
     * Mouseup handler inside editor
     */
    dragAndDropElement.prototype.onDrop = function () {
        if (!this.draggable || this.state < DragState.DRAGGING) {
            this.onDragEnd();
            return;
        }
        var fragment = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.dataBind)(this.draggable, 'target');
        this.onDragEnd();
        if (this.isCopyMode) {
            fragment = fragment.cloneNode(true);
        }
        var parentElement = fragment.parentElement;
        this.j.s.insertNode(fragment, true, false);
        if (parentElement &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(parentElement) &&
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell(parentElement)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(parentElement);
        }
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(fragment, 'img') && this.j.e) {
            this.j.e.fire('afterInsertImage', fragment);
        }
        this.j.e.fire('synchro');
    };
    /**
     * Add global event listener after drag start
     */
    dragAndDropElement.prototype.addDragListeners = function () {
        this.j.e
            .on(this.j.editor, 'mousemove', this.onDrag)
            .on('mouseup', this.onDrop)
            .on([this.j.ew, this.ow], 'mouseup', this.onDragEnd);
    };
    /**
     * Remove global event listener after drag start
     */
    dragAndDropElement.prototype.removeDragListeners = function () {
        this.j.e
            .off(this.j.editor, 'mousemove', this.onDrag)
            .off('mouseup', this.onDrop)
            .off([this.j.ew, this.ow], 'mouseup', this.onDragEnd);
    };
    /** @override */
    dragAndDropElement.prototype.beforeDestruct = function () {
        this.onDragEnd();
        this.j.e.off('mousedown dragstart', this.onDragStart);
        this.removeDragListeners();
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], dragAndDropElement.prototype, "onDragStart", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.throttle)(function (ctx) { return ctx.defaultTimeout / 10; })
    ], dragAndDropElement.prototype, "onDrag", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], dragAndDropElement.prototype, "onDragEnd", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], dragAndDropElement.prototype, "onDrop", null);
    return dragAndDropElement;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('dragAndDropElement', dragAndDropElement);


/***/ }),

/***/ 27594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ position; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83044);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Calculate screen element position
 */
function position(elm, jodit, recurse) {
    var _a, _b;
    if (recurse === void 0) { recurse = false; }
    var rect = elm.getBoundingClientRect();
    var xPos = rect.left, yPos = rect.top;
    if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__/* .isJoditObject */ .y)(jodit) &&
        jodit.iframe &&
        jodit.ed.body.contains(elm) &&
        !recurse) {
        var _c = position(jodit.iframe, jodit, true), left = _c.left, top = _c.top;
        xPos += left;
        yPos += top;
    }
    return {
        left: Math.round(xPos),
        top: Math.round(yPos),
        width: Math.round((_a = elm.offsetWidth) !== null && _a !== void 0 ? _a : rect.width),
        height: Math.round((_b = elm.offsetHeight) !== null && _b !== void 0 ? _b : rect.height)
    };
}


/***/ }),

/***/ 27671:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Altura de la línea'
};


/***/ }),

/***/ 27835:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Формат хуулах'
};


/***/ }),

/***/ 27912:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ ajaxInstances; },
/* harmony export */   t: function() { return /* binding */ send; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53883);
/* harmony import */ var jodit_modules_uploader_helpers_build_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89929);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



var ajaxInstances = new WeakMap();
function send(uploader, data) {
    var requestData = (0,jodit_modules_uploader_helpers_build_data__WEBPACK_IMPORTED_MODULE_2__/* .buildData */ .$)(uploader, data);
    var sendData = function (request) {
        var ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_1__/* .Ajax */ .d({
            xhr: function () {
                var xhr = new XMLHttpRequest();
                if (uploader.j.ow.FormData !== undefined &&
                    xhr.upload) {
                    uploader.j.progressbar.show().progress(10);
                    xhr.upload.addEventListener('progress', function (evt) {
                        if (evt.lengthComputable) {
                            var percentComplete = evt.loaded / evt.total;
                            percentComplete *= 100;
                            uploader.j.progressbar
                                .show()
                                .progress(percentComplete);
                            if (percentComplete >= 100) {
                                uploader.j.progressbar.hide();
                            }
                        }
                    }, false);
                }
                else {
                    uploader.j.progressbar.hide();
                }
                return xhr;
            },
            method: uploader.o.method || 'POST',
            data: request,
            url: (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(uploader.o.url)
                ? uploader.o.url(request)
                : uploader.o.url,
            headers: uploader.o.headers,
            queryBuild: uploader.o.queryBuild,
            contentType: uploader.o.contentType.call(uploader, request),
            withCredentials: uploader.o.withCredentials || false
        });
        var instances = ajaxInstances.get(uploader);
        if (!instances) {
            instances = new Set();
            ajaxInstances.set(uploader, instances);
        }
        instances.add(ajax);
        uploader.j.e.one('beforeDestruct', ajax.destruct);
        return ajax
            .send()
            .then(function (resp) { return resp.json(); })
            .catch(function (error) {
            return {
                success: false,
                data: {
                    messages: [error]
                }
            };
        })
            .finally(function () {
            ajax.destruct();
            instances === null || instances === void 0 ? void 0 : instances.delete(ajax);
        });
    };
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isPromise)(requestData)) {
        return requestData.then(sendData).catch(function (error) {
            uploader.o.error.call(uploader, error);
        });
    }
    return sendData(requestData);
}


/***/ }),

/***/ 28313:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkBlockNesting: function() { return /* reexport safe */ _check_block_nesting__WEBPACK_IMPORTED_MODULE_0__.o; }
/* harmony export */ });
/* harmony import */ var _check_block_nesting__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(30958);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/dtd
 * @internal
 */



/***/ }),

/***/ 28359:
/***/ (function(module) {

module.exports["default"] = ["Напишите что-либо","О Jodit","Редактор Jodit","Jodit Руководство пользователя","содержит детальную информацию по использованию","Для получения сведений о лицензии , пожалуйста, перейдите на наш сайт:","Купить полную версию","Авторские права © XDSoft.net - Чупурнов Валерий. Все права защищены.","Анкор","Открывать ссылку в новой вкладке","Открыть редактор в полном размере","Очистить форматирование","Цвет заливки или цвет текста","Повтор","Отмена","Жирный","Наклонный","Вставка маркированного списка","Вставить нумерованный список","Выровнять по центру","Выровнять по ширине","Выровнять по левому краю","Выровнять по правому краю","Вставить горизонтальную линию","Вставить изображение","Вставить файл","Вставьте видео","Вставить ссылку","Размер шрифта","Шрифт","Вставить блочный элемент","Нормальный текст","Заголовок 1","Заголовок 2","Заголовок 3","Заголовок 4","Цитата","Код","Вставить","Вставить таблицу","Уменьшить отступ","Увеличить отступ","Выберите специальный символ","Вставить специальный символ","Формат краски","Источник","Отступы","сверху","справа","снизу","слева","Стили","Классы","Выравнивание","По правому краю","По центру","По левому краю","--не устанавливать--","src","Заголовок","Альтернативный текст (alt)","Ссылка","Открывать ссылку в новом окне",null,"Файл","Расширенные","Свойства изображения","Отмена","Ок","Браузер файлов","Ошибка при загрузке списка изображений","Ошибка при загрузке списка директорий","Вы уверены?","Введите название директории","Создать директорию","введите название","Перетащите сюда изображение","Перетащите сюда файл","или нажмите","Альтернативный текст","Загрузка","Сервер","Фон","Текст"," К верху","По середине","К низу","Вставить столбец до","Вставить столбец после","Вставить ряд выше","Вставить ряд ниже","Удалить таблицу","Удалять ряд","Удалить столбец","Очистить ячейку","Символов: %d","Слов: %d","Перечеркнуть","Подчеркивание","верхний индекс","индекс","Вырезать","Выделить все","Разделитель","Найти","Заменить на","Заменить","Вставить","Выбрать контент для вставки","HTML","жирный","курсив","заливка","ссылка","отменить","повторить","таблица","Изображение","очистить","параграф","размер шрифта","видео","шрифт","о редакторе","печать","подчеркнутый","перечеркнутый","отступ","выступ","во весь экран","обычный размер","линия","Список","Нумерованный список","Вырезать","Выделить все","Код","Открыть ссылку","Редактировать ссылку","Атрибут nofollow","Убрать ссылку","Обновить","Редактировать","Просмотр","URL","Редактировать","Горизонтальное выравнивание","Фильтр","По изменению","По имени","По размеру","Добавить папку","Восстановить","Сохранить","Сохранить как","Изменить размер","Обрезать размер","Ширина","Высота","Сохранять пропорции","Да","Нет","Удалить","Выделить","Выделить: %s","Вертикальное выравнивание","Разделить","Объединить в одну","Добавить столбец","Добавить строку","Лицензия: %s","Удалить","Разделить по вертикали","Разделить по горизонтали","Рамка","Ваш текст, который вы пытаетесь вставить похож на HTML. Вставить его как HTML?","Вставить как HTML?","Сохранить оригинал","Вставить как текст","Вставить только текст","Вы можете редактировать только свои собственные изображения. Загрузить это изображение на ваш сервер?","Изображение успешно загружено на сервер!","палитра","В данном каталоге нет файлов","Переименовать","Введите новое имя","Предпросмотр","Скачать","Вставить из буфера обмена","Ваш браузер не поддерживает прямой доступ к буферу обмена.","Скопировать выделенное","копия","Радиус границы","Показать все","Применить","Пожалуйста, заполните это поле","Пожалуйста, введите веб-адрес","По умолчанию","Круг","Точка","Квадрат","Найти","Найти Предыдущие","Найти Далее","Контент который вы вставляете поступает из документа Microsoft Word / Excel. Вы хотите сохранить формат или очистить его?","Возможно это фрагмент Word или Excel","Почистить","Вставить название класса","Нажмите Alt для изменения пользовательского размера"]

/***/ }),

/***/ 28616:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ stringify; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Safe stringify circular object
 */
function stringify(value, options) {
    if (options === void 0) { options = {}; }
    if (typeof value !== 'object') {
        return String(value);
    }
    var excludeKeys = new Set(options.excludeKeys);
    var map = new WeakMap();
    var r = function (k, v) {
        if (excludeKeys.has(k)) {
            return;
        }
        if (typeof v === 'object' && v != null) {
            if (map.get(v)) {
                return '[refObject]';
            }
            map.set(v, true);
        }
        return v;
    };
    return JSON.stringify(value, r, options.prettify);
}


/***/ }),

/***/ 28709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ UIForm; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69198);
/* harmony import */ var jodit_core_ui_form_inputs_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1540);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







var UIForm = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__extends */ .C6)(UIForm, _super);
    function UIForm() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var _a, _b;
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__read */ .zs)(args), false)) || this;
        if ((_a = _this.options) === null || _a === void 0 ? void 0 : _a.className) {
            _this.container.classList.add((_b = _this.options) === null || _b === void 0 ? void 0 : _b.className);
        }
        return _this;
    }
    /** @override */
    UIForm.prototype.className = function () {
        return 'UIForm';
    };
    UIForm.prototype.submit = function () {
        this.j.e.fire(this.container, 'submit');
    };
    UIForm.prototype.validate = function () {
        var e_1, _a, e_2, _b;
        var inputs = this.allChildren.filter(function (elm) {
            return jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t);
        });
        try {
            for (var inputs_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__values */ .Ju)(inputs), inputs_1_1 = inputs_1.next(); !inputs_1_1.done; inputs_1_1 = inputs_1.next()) {
                var input = inputs_1_1.value;
                if (!input.validate()) {
                    return false;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (inputs_1_1 && !inputs_1_1.done && (_a = inputs_1.return)) _a.call(inputs_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var selects = this.allChildren.filter(function (elm) {
            return jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_select_select__WEBPACK_IMPORTED_MODULE_3__/* .UISelect */ .$);
        });
        try {
            for (var selects_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__values */ .Ju)(selects), selects_1_1 = selects_1.next(); !selects_1_1.done; selects_1_1 = selects_1.next()) {
                var select = selects_1_1.value;
                if (!select.validate()) {
                    return false;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (selects_1_1 && !selects_1_1.done && (_b = selects_1.return)) _b.call(selects_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return true;
    };
    UIForm.prototype.onSubmit = function (handler) {
        var _this = this;
        this.j.e.on(this.container, 'submit', function () {
            var inputs = _this.allChildren.filter(function (elm) {
                return jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t);
            });
            if (!_this.validate()) {
                return false;
            }
            handler(inputs.reduce(function (res, item) {
                res[item.state.name] = item.value;
                return res;
            }, {}));
            return false;
        });
        return this;
    };
    /** @override */
    UIForm.prototype.createContainer = function () {
        var form = this.j.c.element('form');
        form.classList.add(this.componentName);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(form, 'dir', this.j.o.direction || 'auto');
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(form, 'novalidate', '');
        return form;
    };
    UIForm = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__/* .component */ .s
    ], UIForm);
    return UIForm;
}(jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__/* .UIGroup */ .U));



/***/ }),

/***/ 28712:
/***/ (function(module) {

"use strict";
module.exports = {assert(){}};;

/***/ }),

/***/ 28776:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'символ'
};


/***/ }),

/***/ 29012:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CP: function() { return /* reexport safe */ _separator__WEBPACK_IMPORTED_MODULE_2__.C; },
/* harmony export */   Ue: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_0__.U; },
/* harmony export */   bk: function() { return /* reexport safe */ _spacer__WEBPACK_IMPORTED_MODULE_3__.b; },
/* harmony export */   z4: function() { return /* reexport safe */ _list__WEBPACK_IMPORTED_MODULE_1__.z; }
/* harmony export */ });
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6455);
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94070);
/* harmony import */ var _separator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86283);
/* harmony import */ var _spacer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/group
 */






/***/ }),

/***/ 29348:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M1534 189v73q0 29-18.5 61t-42.5 32q-50 0-54 1-26 6-32 31-3 11-3 64v1152q0 25-18 43t-43 18h-108q-25 0-43-18t-18-43v-1218h-143v1218q0 25-17.5 43t-43.5 18h-108q-26 0-43.5-18t-17.5-43v-496q-147-12-245-59-126-58-192-179-64-117-64-259 0-166 88-286 88-118 209-159 111-37 417-37h479q25 0 43 18t18 43z\"/></svg>"

/***/ }),

/***/ 29581:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/select-cells
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.tableAllowCellSelection = true;


/***/ }),

/***/ 29780:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ UIElement; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1963);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87906);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(75758);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(931);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








var UIElement = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__extends */ .C6)(UIElement, _super);
    /** @override */
    function UIElement(jodit, options) {
        var _this = _super.call(this, jodit) || this;
        _this.name = '';
        _this.__parentElement = null;
        _this.mods = {};
        _this.container = _this.createContainer(options);
        Object.defineProperty(_this.container, 'component', {
            value: _this,
            configurable: true
        });
        return _this;
    }
    UIElement_1 = UIElement;
    Object.defineProperty(UIElement.prototype, "parentElement", {
        get: function () {
            return this.__parentElement;
        },
        set: function (parentElement) {
            var _this = this;
            this.__parentElement = parentElement;
            if (parentElement) {
                parentElement.hookStatus('beforeDestruct', function () { return _this.destruct(); });
            }
            this.updateParentElement(this);
        },
        enumerable: false,
        configurable: true
    });
    UIElement.prototype.bubble = function (callback) {
        var parent = this.parentElement;
        while (parent) {
            callback(parent);
            parent = parent.parentElement;
        }
        return this;
    };
    UIElement.prototype.updateParentElement = function (target) {
        var _a;
        (_a = this.__parentElement) === null || _a === void 0 ? void 0 : _a.updateParentElement(target);
        return this;
    };
    /** @override */
    UIElement.prototype.get = function (chain, obj) {
        return _super.prototype.get.call(this, chain, obj) || this.getElm(chain);
    };
    /**
     * Find match parent
     */
    UIElement.prototype.closest = function (type) {
        var c = typeof type === 'object'
            ? function (pe) { return pe === type; }
            : function (pe) { return jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(pe, type); };
        var pe = this.__parentElement;
        while (pe) {
            if (c(pe)) {
                return pe;
            }
            if (!pe.parentElement && pe.container.parentElement) {
                pe = UIElement_1.closestElement(pe.container.parentElement, UIElement_1);
            }
            else {
                pe = pe.parentElement;
            }
        }
        return null;
    };
    /**
     * Find closest UIElement in DOM
     */
    UIElement.closestElement = function (node, type) {
        var elm = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(node, function (elm) {
            if (elm) {
                var component = elm.component;
                return component && jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(component, type);
            }
            return false;
        });
        return elm ? elm === null || elm === void 0 ? void 0 : elm.component : null;
    };
    /**
     * Update UI from state
     */
    UIElement.prototype.update = function () {
        // empty
    };
    /**
     * Append container to element
     */
    UIElement.prototype.appendTo = function (element) {
        element.appendChild(this.container);
        return this;
    };
    /**
     * Valid name only with valid chars
     */
    UIElement.prototype.clearName = function (name) {
        return name.replace(/[^a-zA-Z0-9]/g, '_');
    };
    /**
     * Method create only box
     */
    UIElement.prototype.render = function (options) {
        return this.j.c.div(this.componentName);
    };
    /**
     * Create main HTML container
     */
    UIElement.prototype.createContainer = function (options) {
        var result = this.render(options);
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__/* .isString */ .K)(result)) {
            var elm = this.parseTemplate(result);
            elm.classList.add(this.componentName);
            return elm;
        }
        return result;
    };
    UIElement.prototype.parseTemplate = function (result) {
        var _this = this;
        return this.j.c.fromHTML(result
            .replace(/\*([^*]+?)\*/g, function (_, name) { return jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_4__/* .Icon */ .I.get(name) || ''; })
            .replace(/&_/g, this.componentName + '_')
            .replace(/~([^~]+?)~/g, function (_, s) { return _this.i18n(s); }));
    };
    /** @override */
    UIElement.prototype.destruct = function () {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.container);
        this.parentElement = null;
        return _super.prototype.destruct.call(this);
    };
    var UIElement_1;
    UIElement = UIElement_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_7__/* .derive */ .C)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_3__/* .Mods */ .K, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_2__/* .Elms */ .O)
    ], UIElement);
    return UIElement;
}(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG));



/***/ }),

/***/ 29822:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ checkRemoveContentNotEditable; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46602);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks if a non-editable element can be deleted
 * @private
 */
function checkRemoveContentNotEditable(jodit, fakeNode, backspace) {
    var neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(fakeNode, backspace);
    if (!neighbor &&
        fakeNode.parentElement &&
        fakeNode.parentElement !== jodit.editor) {
        neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(fakeNode.parentElement, backspace);
    }
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(neighbor) &&
        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isContentEditable(neighbor, jodit.editor)) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.call)(backspace ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before : jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after, neighbor, fakeNode);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(neighbor);
        (0,jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_2__/* .moveNodeInsideStart */ .W8)(jodit, fakeNode, backspace);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.call)(backspace ? jodit.s.setCursorBefore : jodit.s.setCursorAfter, fakeNode);
        return true;
    }
    return false;
}


/***/ }),

/***/ 29866:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ Plugin; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83044);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




var Plugin = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__extends */ .C6)(Plugin, _super);
    function Plugin(jodit) {
        var _this = _super.call(this, jodit) || this;
        /** @override */
        _this.buttons = [];
        /**
         * Plugin have CSS style and it should be loaded
         */
        _this.hasStyle = false;
        _this.__inited = false;
        jodit.e
            .on('afterPluginSystemInit', _this.__afterPluginSystemInit)
            .on('afterInit', _this.__afterInit)
            .on('beforeDestruct', _this.__beforeDestruct);
        return _this;
    }
    /** @override */
    Plugin.prototype.className = function () {
        return 'Plugin';
    };
    Plugin.prototype.__afterPluginSystemInit = function () {
        var _a = this, j = _a.j, buttons = _a.buttons;
        if (buttons && (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__/* .isJoditObject */ .y)(j)) {
            buttons.forEach(function (btn) {
                j.registerButton(btn);
            });
        }
    };
    Plugin.prototype.__afterInit = function () {
        this.__inited = true;
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready);
        this.afterInit(this.jodit);
    };
    Plugin.prototype.init = function (jodit) {
        if (this.jodit.isReady) {
            this.afterInit(this.jodit);
            this.__afterPluginSystemInit();
            this.jodit.e.fire('rebuildToolbar');
        }
    };
    Plugin.prototype.__beforeDestruct = function () {
        var _a;
        if (this.isInDestruct) {
            return;
        }
        var j = this.j;
        j.e
            .off('afterPluginSystemInit', this.__afterPluginSystemInit)
            .off('afterInit', this.__afterInit)
            .off('beforeDestruct', this.destruct);
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        if (!this.__inited) {
            return _super.prototype.destruct.call(this);
        }
        if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__/* .isJoditObject */ .y)(j)) {
            (_a = this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(function (btn) {
                j === null || j === void 0 ? void 0 : j.unregisterButton(btn);
            });
        }
        this.beforeDestruct(this.j);
        _super.prototype.destruct.call(this);
    };
    Plugin.requires = [];
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], Plugin.prototype, "__afterPluginSystemInit", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], Plugin.prototype, "__afterInit", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], Plugin.prototype, "__beforeDestruct", null);
    return Plugin;
}(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG));



/***/ }),

/***/ 29920:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Vonal magassága'
};


/***/ }),

/***/ 30382:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'ارتفاع خط'
};


/***/ }),

/***/ 30393:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: function() { return /* binding */ applyValuesToImage; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88269);
/* harmony import */ var _margin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(78139);
/* harmony import */ var _size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58972);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Apply form's values to image
 * @private
 */
function applyValuesToImage(j, state, image) {
    var _a = state.values, style = _a.style, imageSrc = _a.imageSrc, borderRadius = _a.borderRadius, imageTitle = _a.imageTitle, imageAlt = _a.imageAlt, imageLink = _a.imageLink, imageWidth = _a.imageWidth, imageHeight = _a.imageHeight, marginTop = _a.marginTop, marginRight = _a.marginRight, marginBottom = _a.marginBottom, marginLeft = _a.marginLeft, imageLinkOpenInNewTab = _a.imageLinkOpenInNewTab, align = _a.align, classes = _a.classes, id = _a.id;
    var opt = j.o;
    // styles
    if (opt.image.editStyle) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'style', style || null);
    }
    // Src
    if (imageSrc) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'src', imageSrc);
    }
    else {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(image);
        return;
    }
    // Border radius
    image.style.borderRadius = borderRadius ? borderRadius + 'px' : '';
    // Title
    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'title', imageTitle || null);
    // Alt
    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'alt', imageAlt || null);
    // Link
    (0,_link__WEBPACK_IMPORTED_MODULE_2__/* .applyLink */ .j)(j, image, imageLink, imageLinkOpenInNewTab);
    // Size
    (0,_size__WEBPACK_IMPORTED_MODULE_4__/* .applySize */ .q)(image, imageWidth, imageHeight, state.sizeIsLocked);
    // Margin
    if (j.o.image.editMargins) {
        (0,_margin__WEBPACK_IMPORTED_MODULE_3__/* .applyMargin */ .N)(j, marginTop, marginRight, marginBottom, marginLeft, image, state.marginIsLocked);
    }
    if (opt.image.editClass) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'class', classes || null);
    }
    if (opt.image.editId) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'id', id || null);
    }
    if (opt.image.editAlign) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.hAlignElement)(image, align);
    }
}


/***/ }),

/***/ 30405:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export hotkeys */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81522);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Allow set hotkey for command or button
 */
var hotkeys = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__extends */ .C6)(hotkeys, _super);
    function hotkeys() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__read */ .zs)(arguments), false)) || this;
        _this.onKeyPress = function (event) {
            var special = _this.specialKeys[event.which];
            var character = (event.key || String.fromCharCode(event.which)).toLowerCase();
            var modif = [special || character];
            ['alt', 'ctrl', 'shift', 'meta'].forEach(function (specialKey) {
                if (event[specialKey + 'Key'] && special !== specialKey) {
                    modif.push(specialKey);
                }
            });
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.normalizeKeyAliases)(modif.join('+'));
        };
        _this.specialKeys = {
            8: 'backspace',
            9: 'tab',
            10: 'return',
            13: 'return',
            16: 'shift',
            17: 'ctrl',
            18: 'alt',
            19: 'pause',
            20: 'capslock',
            27: 'esc',
            32: 'space',
            33: 'pageup',
            34: 'pagedown',
            35: 'end',
            36: 'home',
            37: 'left',
            38: 'up',
            39: 'right',
            40: 'down',
            45: 'insert',
            46: 'del',
            59: ';',
            61: '=',
            91: 'meta',
            96: '0',
            97: '1',
            98: '2',
            99: '3',
            100: '4',
            101: '5',
            102: '6',
            103: '7',
            104: '8',
            105: '9',
            106: '*',
            107: '+',
            109: '-',
            110: '.',
            111: '/',
            112: 'f1',
            113: 'f2',
            114: 'f3',
            115: 'f4',
            116: 'f5',
            117: 'f6',
            118: 'f7',
            119: 'f8',
            120: 'f9',
            121: 'f10',
            122: 'f11',
            123: 'f12',
            144: 'numlock',
            145: 'scroll',
            173: '-',
            186: ';',
            187: '=',
            188: ',',
            189: '-',
            190: '.',
            191: '/',
            192: '`',
            219: '[',
            220: '\\',
            221: ']',
            222: "'"
        };
        return _this;
    }
    /** @override */
    hotkeys.prototype.afterInit = function (editor) {
        var _this = this;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.keys)(editor.o.commandToHotkeys, false).forEach(function (commandName) {
            var shortcuts = editor.o.commandToHotkeys[commandName];
            if (shortcuts && ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isArray)(shortcuts) || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(shortcuts))) {
                editor.registerHotkeyToCommand(shortcuts, commandName);
            }
        });
        var itIsHotkey = false;
        editor.e
            .off('.hotkeys')
            .on([editor.ow, editor.ew], 'keydown.hotkeys', function (e) {
            if (e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ESC) {
                return _this.j.e.fire('escape', e);
            }
        })
            .on('keydown.hotkeys', function (event) {
            var shortcut = _this.onKeyPress(event);
            var stop = {
                shouldStop: true
            };
            var resultOfFire = _this.j.e.fire(shortcut + '.hotkey', event.type, stop);
            if (resultOfFire === false) {
                if (stop.shouldStop) {
                    itIsHotkey = true;
                    editor.e.stopPropagation('keydown');
                    return false;
                }
                else {
                    event.preventDefault();
                }
            }
        }, { top: true })
            .on('keyup.hotkeys', function () {
            if (itIsHotkey) {
                itIsHotkey = false;
                editor.e.stopPropagation('keyup');
                return false;
            }
        }, { top: true });
    };
    /** @override */
    hotkeys.prototype.beforeDestruct = function (jodit) {
        if (jodit.events) {
            jodit.e.off('.hotkeys');
        }
    };
    return hotkeys;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('hotkeys', hotkeys);


/***/ }),

/***/ 30495:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ ConnectionError; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module helpers/utils
 */
var ConnectionError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__extends */ .C6)(ConnectionError, _super);
    function ConnectionError(m) {
        var _this = _super.call(this, m) || this;
        Object.setPrototypeOf(_this, ConnectionError.prototype);
        return _this;
    }
    return ConnectionError;
}(Error));



/***/ }),

/***/ 30526:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ isInlineBlock; },
/* harmony export */   w: function() { return /* binding */ removeFormatForCollapsedSelection; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * For collapsed selection move cursor outside or split inline block
 * @private
 */
function removeFormatForCollapsedSelection(jodit, fake) {
    var s = jodit.s;
    var fakeNode = fake;
    if (!fakeNode) {
        fakeNode = jodit.createInside.fake();
        var range = s.range;
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeInsertNode(range, fakeNode);
        range.collapse();
    }
    var mainInline = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.furthest(fakeNode, isInlineBlock, jodit.editor);
    if (mainInline) {
        if (s.cursorOnTheLeft(mainInline)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(mainInline, fakeNode);
        }
        else if (s.cursorOnTheRight(mainInline)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(mainInline, fakeNode);
        }
        else {
            var leftHand = s.splitSelection(mainInline);
            leftHand && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(leftHand, fakeNode);
        }
    }
    if (!fake) {
        s.setCursorBefore(fakeNode);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(fakeNode);
    }
}
/**
 * Element has inline display mode
 * @private
 */
function isInlineBlock(node) {
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isInlineBlock(node) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(node, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS);
}


/***/ }),

/***/ 30621:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ SentenceFinder; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_string_fuzzy_search_index__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67975);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


var SentenceFinder = /** @class */ (function () {
    function SentenceFinder(searchIndex) {
        if (searchIndex === void 0) { searchIndex = jodit_core_helpers_string_fuzzy_search_index__WEBPACK_IMPORTED_MODULE_0__/* .fuzzySearchIndex */ .H; }
        this.searchIndex = searchIndex;
        this.queue = [];
        this.value = '';
    }
    SentenceFinder.prototype.add = function (node) {
        var _a;
        var value = ((_a = node.nodeValue) !== null && _a !== void 0 ? _a : '').toLowerCase();
        if (!value.length) {
            return;
        }
        var index = this.value.length;
        this.queue.push({
            startIndex: index,
            endIndex: index + value.length,
            node: node
        });
        this.value += value;
    };
    SentenceFinder.prototype.ranges = function (needle, position) {
        var _a;
        if (position === void 0) { position = 0; }
        var results = [];
        var index = position, len = 0, startQueueIndex = 0;
        // Find all ranges in substring
        do {
            _a = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__read */ .zs)(this.searchIndex(needle, this.value, index), 2), index = _a[0], len = _a[1];
            if (index !== -1) {
                var startContainer = void 0, startOffset = 0, endContainer = void 0, endOffset = 0;
                for (var i = startQueueIndex; i < this.queue.length; i += 1) {
                    if (!startContainer && this.queue[i].endIndex > index) {
                        startContainer = this.queue[i].node;
                        startOffset = index - this.queue[i].startIndex;
                    }
                    if (startContainer &&
                        this.queue[i].endIndex >= index + len) {
                        endContainer = this.queue[i].node;
                        endOffset = index + len - this.queue[i].startIndex;
                        startQueueIndex = i;
                        break;
                    }
                }
                if (startContainer && endContainer) {
                    results.push({
                        startContainer: startContainer,
                        startOffset: startOffset,
                        endContainer: endContainer,
                        endOffset: endOffset
                    });
                }
                index += len;
            }
        } while (index !== -1);
        return results.length === 0 ? null : results;
    };
    return SentenceFinder;
}());



/***/ }),

/***/ 30687:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ processEmptyLILeaf; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58720);
/* harmony import */ var _insert_paragraph__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41159);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Handles pressing the Enter key inside an empty LI inside a list
 * @private
 */
function processEmptyLILeaf(fake, jodit, li) {
    var list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(li, ['ol', 'ul'], jodit.editor);
    if (!list) {
        return;
    }
    var parentLi = list.parentElement, listInsideLeaf = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isLeaf(parentLi);
    var container = listInsideLeaf ? parentLi : list;
    // Empty element in the middle of the list
    var leftRange = jodit.s.createRange();
    leftRange.setStartAfter(li);
    leftRange.setEndAfter(list);
    var rightPart = leftRange.extractContents();
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(container, fake);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(li);
    if (!(0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_1__.$$)('li', list).length) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(list);
    }
    var newLi = (0,_insert_paragraph__WEBPACK_IMPORTED_MODULE_2__/* .insertParagraph */ .y)(fake, jodit, listInsideLeaf ? 'li' : jodit.o.enter);
    if (!rightPart.querySelector('li')) {
        return;
    }
    if (listInsideLeaf) {
        newLi.appendChild(rightPart);
    }
    else {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(newLi, rightPart);
    }
}


/***/ }),

/***/ 30958:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   o: function() { return /* binding */ checkBlockNesting; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Checks whether the insertion of an element at the current location is allowed,
 * if it is not allowed, it deletes an empty block element or moves the cursor after it
 * @internal
 */
function checkBlockNesting(jodit, node) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isFragment(node)) {
        node = node.firstChild;
    }
    if (jodit.o.dtd.checkBlockNesting && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(node)) {
        var parent = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.furthest(jodit.s.current(), jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock, jodit.editor);
        if (parent && !jodit.o.dtd.blockLimits[parent.tagName.toLowerCase()]) {
            jodit.s.setCursorAfter(parent);
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmpty(parent)) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(parent);
            }
        }
    }
}


/***/ }),

/***/ 30965:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Vérification Orthographique'
};


/***/ }),

/***/ 31138:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ normalizeLicense; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
var normalizeLicense = function (license, count) {
    if (count === void 0) { count = 8; }
    var parts = [];
    while (license.length) {
        parts.push(license.substr(0, count));
        license = license.substr(count);
    }
    parts[1] = parts[1].replace(/./g, '*');
    parts[2] = parts[2].replace(/./g, '*');
    return parts.join('-');
};


/***/ }),

/***/ 31202:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ UIButtonGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






var UIButtonGroup = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__extends */ .C6)(UIButtonGroup, _super);
    function UIButtonGroup(jodit, options) {
        if (options === void 0) { options = {
            radio: true
        }; }
        var _a, _b;
        var _this = _super.call(this, jodit, (_a = options.options) === null || _a === void 0 ? void 0 : _a.map(function (opt) {
            var btn = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .UIButton */ .lD(jodit, {
                text: opt.text,
                value: opt.value,
                variant: 'primary'
            });
            btn.onAction(function () {
                _this.select(opt.value);
            });
            return btn;
        }), options) || this;
        _this.options = options;
        _this.select((_b = options.value) !== null && _b !== void 0 ? _b : 0);
        return _this;
    }
    /** @override */
    UIButtonGroup.prototype.className = function () {
        return 'UIButtonGroup';
    };
    /** @override */
    UIButtonGroup.prototype.render = function (options) {
        return "<div>\n\t\t\t<div class=\"&__label\">~".concat(options.label, "~</div>\n\t\t\t<div class=\"&__options\"></div>\n\t\t</div>");
    };
    /** @override */
    UIButtonGroup.prototype.appendChildToContainer = function (childContainer) {
        var options = this.getElm('options');
        void 0;
        options.appendChild(childContainer);
    };
    UIButtonGroup.prototype.select = function (indexOrValue) {
        var _this = this;
        var _a, _b;
        this.elements.forEach(function (elm, index) {
            if (index === indexOrValue || elm.state.value === indexOrValue) {
                elm.state.activated = true;
            }
            else if (_this.options.radio) {
                elm.state.activated = false;
            }
        });
        var result = this.elements
            .filter(function (elm) { return elm.state.activated; })
            .map(function (elm) { return ({
            text: elm.state.text,
            value: elm.state.value
        }); });
        this.jodit.e.fire(this, 'select', result);
        (_b = (_a = this.options).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, result);
    };
    UIButtonGroup = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
    ], UIButtonGroup);
    return UIButtonGroup;
}(jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__/* .UIGroup */ .U));



/***/ }),

/***/ 31230:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <g transform=\"translate(-251.000000, -443.000000)\"> <g transform=\"translate(215.000000, 119.000000)\"/> <path d=\"M252,448 L256,448 L256,444 L252,444 L252,448 Z M257,448 L269,448 L269,446 L257,446 L257,448 Z M257,464 L269,464 L269,462 L257,462 L257,464 Z M270,444 L270,448 L274,448 L274,444 L270,444 Z M252,462 L252,466 L256,466 L256,462 L252,462 Z M270,462 L270,466 L274,466 L274,462 L270,462 Z M254,461 L256,461 L256,449 L254,449 L254,461 Z M270,461 L272,461 L272,449 L270,449 L270,461 Z\"/> </g> </svg>"

/***/ }),

/***/ 31365:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 32 32\"> <path d=\"M27 4l-15 15-7-7-5 5 12 12 20-20z\"/> </svg>"

/***/ }),

/***/ 31635:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C6: function() { return /* binding */ __extends; },
/* harmony export */   Cg: function() { return /* binding */ __decorate; },
/* harmony export */   Cl: function() { return /* binding */ __assign; },
/* harmony export */   Ju: function() { return /* binding */ __values; },
/* harmony export */   YH: function() { return /* binding */ __generator; },
/* harmony export */   fX: function() { return /* binding */ __spreadArray; },
/* harmony export */   sH: function() { return /* binding */ __awaiter; },
/* harmony export */   zs: function() { return /* binding */ __read; }
/* harmony export */ });
/* unused harmony exports __rest, __param, __esDecorate, __runInitializers, __propKey, __setFunctionName, __metadata, __createBinding, __exportStar, __spread, __spreadArrays, __await, __asyncGenerator, __asyncDelegator, __asyncValues, __makeTemplateObject, __importStar, __importDefault, __classPrivateFieldGet, __classPrivateFieldSet, __classPrivateFieldIn, __addDisposableResource, __disposeResources, __rewriteRelativeImportExtension */
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  }
  return __assign.apply(this, arguments);
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};

function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};

function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

var ownKeys = function(o) {
  ownKeys = Object.getOwnPropertyNames || function (o) {
    var ar = [];
    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
    return ar;
  };
  return ownKeys(o);
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ({
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
});


/***/ }),

/***/ 31686:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20703);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16116);
/* harmony import */ var _video_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36339);
/* harmony import */ var _video_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_video_svg__WEBPACK_IMPORTED_MODULE_6__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.video = {
    parseUrlToVideoEmbed: jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.convertMediaUrlToVideoEmbed,
    defaultWidth: 400,
    defaultHeight: 345
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.set('video', (_video_svg__WEBPACK_IMPORTED_MODULE_6___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.controls.video = {
    popup: function (jodit, current, close) {
        var formLink = new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(jodit, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(jodit, {
                    name: 'url',
                    required: true,
                    label: 'URL',
                    placeholder: 'https://',
                    validators: ['url']
                })
            ]),
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(jodit, '', 'Insert', 'primary').onAction(function () {
                    return formLink.submit();
                })
            ])
        ]), formCode = new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(jodit, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UITextArea */ .F0(jodit, {
                    name: 'code',
                    required: true,
                    label: 'Embed code'
                })
            ]),
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(jodit, '', 'Insert', 'primary').onAction(function () {
                    return formCode.submit();
                })
            ])
        ]), tabs = [], insertCode = function (code) {
            jodit.s.restore();
            jodit.s.insertHTML(code);
            close();
        };
        jodit.s.save();
        tabs.push({
            icon: 'link',
            name: 'Link',
            content: formLink.container
        }, {
            icon: 'source',
            name: 'Code',
            content: formCode.container
        });
        formLink.onSubmit(function (data) {
            var _a, _b, _c, _d;
            insertCode((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.call)((_b = (_a = jodit.o.video) === null || _a === void 0 ? void 0 : _a.parseUrlToVideoEmbed) !== null && _b !== void 0 ? _b : jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.convertMediaUrlToVideoEmbed, data.url, {
                width: (_c = jodit.o.video) === null || _c === void 0 ? void 0 : _c.defaultWidth,
                height: (_d = jodit.o.video) === null || _d === void 0 ? void 0 : _d.defaultHeight
            }));
        });
        formCode.onSubmit(function (data) {
            insertCode(data.code);
        });
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__/* .TabsWidget */ .Zg)(jodit, tabs);
    },
    tags: ['iframe'],
    tooltip: 'Insert youtube/vimeo video'
};


/***/ }),

/***/ 31859:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ loadTree; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9979);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Loads a list of directories
 * @private
 */
function loadTree(fb) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
        var items, tree;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__generator */ .YH)(this, function (_a) {
            fb.tree.setMod('active', true);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(fb.tree.container);
            items = (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__/* .loadItems */ .f)(fb);
            if (fb.o.showFoldersPanel) {
                fb.tree.setMod('loading', true);
                tree = fb.dataProvider
                    .tree(fb.state.currentPath, fb.state.currentSource)
                    .then(function (resp) {
                    fb.state.sources = resp;
                })
                    .catch(fb.status)
                    .finally(function () { return fb.tree.setMod('loading', false); });
                return [2 /*return*/, Promise.all([tree, items])];
            }
            fb.tree.setMod('active', false);
            return [2 /*return*/, items];
        });
    });
}


/***/ }),

/***/ 31927:
/***/ (function(module) {

module.exports["default"] = ["Scrivi qualcosa...","A proposito di Jodit","Jodit Editor","Guida utente di Jodit","contiene una guida dettagliata per l'uso.","Per informazioni sulla licenza, si prega di visitare il nostro sito web:","Acquista la versione completa","Copyright © XDSoft.net - Chupurnov Valeriy. Tutti i diritti riservati.","Link","Apri in una nuova scheda","Apri l'editor a schermo intero","Pulisci Formattazione","Colore di sfondo o del testo","Ripristina","Annulla","Grassetto","Corsivo","Inserisci lista non ordinata","Inserisci lista ordinata","Allinea al centro","Allineamento Giustificato","Allinea a Sinistra","Allinea a Destra","Inserisci una linea orizzontale","Inserisci immagine","Inserisci un file","Inserisci video Youtube/Vimeo","Inserisci link","Dimensione carattere","Tipo di font","Inserisci blocco","Normale","Intestazione 1","Intestazione 2","Intestazione 3","Intestazione 4","Citazione","Codice","Inserisci","Inserisci tabella","Riduci il rientro","Aumenta il rientro","Seleziona un carattere speciale","Inserisci un carattere speciale","Copia formato","Cambia modalita'","Margini","su","destra","giù","sinistra","Stili CSS","Classi CSS","Allinea","Destra","Centro","Sinistra","--Non Impostato--","Fonte","Titolo","Testo Alternativo","Link","Apri il link in una nuova scheda","Immagine","Archivio","Avanzato","Proprietà dell'immagine","Annulla","Accetta","Cerca file","Errore durante il caricamento dell'elenco","Errore durante il caricamento delle cartelle","Sei sicuro?","Inserisci il nome della cartella","Crea cartella","Digita il nome","Cancella immagine","Cancella file","o clicca","Testo alternativo","Carica","Sfoglia","Sfondo","Testo","Su","Centro","Sotto","Inserisci la colonna prima","Inserisci la colonna dopo","Inserisci la riga sopra","Inserisci la riga sotto","Elimina tabella","Elimina riga","Elimina colonna","Cella vuota","Caratteri: %d","Parole: %d","Barrato","Sottolineato","indice","pedice","Taglia selezione","Seleziona tutto","Pausa","Cerca per","Sostituisci con","Sostituisci","Incolla","Seleziona il contenuto da incollare","risorsa","Grassetto","Corsivo","Pennello","Link","Annulla","Ripristina","Tabella","Immagine","Gomma","Paragrafo","Dimensione del carattere","Video","Font","Approposito di","Stampa","Sottolineato","Barrato","aumenta rientro","riduci rientro","espandi","comprimi","linea orizzontale","lista non ordinata","lista ordinata","Taglia","Seleziona tutto","Includi codice","Apri link","Modifica link","Non seguire","Rimuovi link","Aggiorna","Per modificare","Recensione"," URL","Modifica","Allineamento orizzontale","Filtro","Ordina per data di modifica","Ordina per nome","Ordina per dimensione","Aggiungi cartella","Reset","Salva","Salva con nome...","Ridimensiona","Ritaglia","Larghezza","Altezza","Mantieni le proporzioni","Si","No","Rimuovi","Seleziona","Seleziona: %s","Allineamento verticala","Dividi","Fondi","Aggiungi colonna","Aggiungi riga",null,"Cancella","Dividi verticalmente","Dividi orizzontale","Bordo","Il codice è simile all'HTML. Mantieni come HTML?","Incolla come HTML","Mantieni","Inserisci come testo","Inserisci solo il testo","Puoi modificare solo le tue immagini. Vuoi scaricare questa immagine dal server?","L'immagine è stata caricata correttamente sul server!","tavolozza","Non ci sono file in questa directory.","Rinomina","Inserisci un nuovo nome","anteprima","Scarica","Incolla dagli appunti","Il tuo browser non supporta l'accesso diretto agli appunti.","Copia selezione","copia","Border radius","Mostra tutti","Applica","Si prega di compilare questo campo","Si prega di inserire un indirizzo web","Default","Cerchio","Punto","Quadrato","Trova","Trova Precedente","Trova Successivo","Il contenuto incollato proviene da un documento Microsoft Word / Excel. Vuoi mantenere il formato o pulirlo?","Incolla testo da Word rilevato","Pulisci","Inserisci il nome della classe","Premere Alt per il ridimensionamento personalizzato"]

/***/ }),

/***/ 31970:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ UIImagePropertiesForm; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6455);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16116);
/* harmony import */ var _ui_image_main_tab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33403);
/* harmony import */ var _ui_image_position_tab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46681);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










/** @private */
var UIImagePropertiesForm = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(UIImagePropertiesForm, _super);
    function UIImagePropertiesForm(jodit, state, activeTabState, handlers) {
        var _this = _super.call(this, jodit) || this;
        _this.state = state;
        _this.handlers = handlers;
        _this.__mainTab = new _ui_image_main_tab__WEBPACK_IMPORTED_MODULE_5__/* .UIImageMainTab */ .k(_this.jodit, _this.state, _this.handlers);
        _this.__positionTab = new _ui_image_position_tab__WEBPACK_IMPORTED_MODULE_6__/* .UIImagePositionTab */ ._(_this.jodit, _this.state, _this.handlers);
        _this.getElm('tabsBox').appendChild((0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .TabsWidget */ .Zg)(jodit, [
            { name: 'Image', content: _this.__mainTab },
            { name: 'Advanced', content: _this.__positionTab }
        ], activeTabState));
        _this.setMod('lock-size', _this.state.sizeIsLocked);
        _this.append(_this.__mainTab).append(_this.__positionTab);
        return _this;
    }
    UIImagePropertiesForm.prototype.className = function () {
        return 'UIImagePropertiesForm';
    };
    UIImagePropertiesForm.prototype.appendChildToContainer = function () { };
    UIImagePropertiesForm.prototype.getElm = function (elementName) {
        var e_1, _a;
        var selfElm = _super.prototype.getElm.call(this, elementName);
        if (selfElm) {
            return selfElm;
        }
        try {
            for (var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__values */ .Ju)(this.elements), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                var elm = child.getElm(elementName);
                if (elm) {
                    return elm;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return null;
    };
    UIImagePropertiesForm.prototype.render = function () {
        return "<form>\n\t\t<div class=\"jodit-grid jodit-grid_xs-column\">\n\t\t\t<div class=\"jodit_col-lg-2-5 jodit_col-xs-5-5\">\n\t\t\t\t<div class=\"&__view-box\">\n\t\t\t\t\t<div class=\"&__imageView\">\n\t\t\t\t\t\t<img class=\"&__imageViewSrc\" src=\"\" alt=\"\"/>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"jodit-form__group &__imageSizes\">\n\t\t\t\t\t\t<input type=\"text\" class=\"jodit-input &__imageWidth\"/>\n\t\t\t\t\t\t<a class=\"&__lockSize\">".concat(jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.get('lock'), "</a>\n\t\t\t\t\t\t<input type=\"text\" class=\"&__imageHeight jodit-input\"/>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"jodit_col-lg-3-5 jodit_col-xs-5-5 &__tabsBox\"></div>\n\t\t</div>\n\t</form>");
    };
    UIImagePropertiesForm.prototype.onChangeSizeIsLocked = function () {
        var lockSize = this.getElm('lockSize');
        var imageWidth = this.getElm('imageWidth');
        lockSize.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.get(this.state.sizeIsLocked ? 'lock' : 'unlock');
        this.setMod('lock-size', this.state.sizeIsLocked);
        this.j.e.fire(imageWidth, 'change');
    };
    UIImagePropertiesForm.prototype.onLockSizeClick = function () {
        this.state.sizeIsLocked = !this.state.sizeIsLocked;
    };
    UIImagePropertiesForm.prototype.onStateValuesSizeChange = function () {
        var imageWidth = this.getElm('imageWidth');
        var imageHeight = this.getElm('imageHeight');
        if (imageWidth !== this.j.od.activeElement) {
            imageWidth.value = this.state.values.imageWidth.toString();
        }
        if (imageHeight !== this.j.od.activeElement) {
            imageHeight.value = this.state.values.imageHeight.toString();
        }
    };
    UIImagePropertiesForm.prototype.onImageWidthChange = function (e) {
        var imageWidth = this.getElm('imageWidth');
        var imageHeight = this.getElm('imageHeight');
        if (!this.state.sizeIsLocked ||
            !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(imageWidth.value) ||
            !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(imageHeight.value)) {
            this.state.values.imageWidth = imageWidth.value;
            this.state.values.imageHeight = imageHeight.value;
            return;
        }
        var w = parseFloat(imageWidth.value), h = parseFloat(imageHeight.value);
        if (e.target === imageWidth) {
            this.state.values.imageWidth = w;
            this.state.values.imageHeight = Math.round(w / this.state.ratio);
        }
        else {
            this.state.values.imageWidth = Math.round(h * this.state.ratio);
            this.state.values.imageHeight = h;
        }
    };
    UIImagePropertiesForm.prototype.onStateValuesImageSrcChange = function () {
        var imageSrc = this.state.values.imageSrc;
        if (!imageSrc) {
            return;
        }
        var imageViewSrc = this.getElm('imageViewSrc');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(imageViewSrc, 'src', imageSrc);
        var image = new Image();
        image.src = imageSrc;
        this.state.image = image;
    };
    UIImagePropertiesForm.prototype.hideFieldByOptions = function () {
        var _this = this;
        var opt = this.j.o.image;
        [
            ['editSize', 'imageSizes'],
            ['showPreview', 'imageView']
        ].forEach(function (_a) {
            var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__read */ .zs)(_a, 2), optKey = _b[0], elmKey = _b[1];
            var elm = _this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready'),
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.sizeIsLocked')
    ], UIImagePropertiesForm.prototype, "onChangeSizeIsLocked", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('lockSize:click')
    ], UIImagePropertiesForm.prototype, "onLockSizeClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready'),
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(['state.values.imageWidth', 'state.values.imageHeight'])
    ], UIImagePropertiesForm.prototype, "onStateValuesSizeChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([
            'imageWidth:change',
            'imageHeight:change',
            'imageWidth:keydown',
            'imageHeight:keydown',
            'imageWidth:mousedown',
            'imageHeight:mousedown',
            'imageWidth:paste',
            'imageHeight:paste'
        ]),
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.debounce)()
    ], UIImagePropertiesForm.prototype, "onImageWidthChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready'),
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.values.imageSrc')
    ], UIImagePropertiesForm.prototype, "onStateValuesImageSrcChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
    ], UIImagePropertiesForm.prototype, "hideFieldByOptions", null);
    UIImagePropertiesForm = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_8__/* .component */ .s
    ], UIImagePropertiesForm);
    return UIImagePropertiesForm;
}(jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__/* .UIGroup */ .U));



/***/ }),

/***/ 32013:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1472 930v318q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q63 0 117 25 15 7 18 23 3 17-9 29l-49 49q-10 10-23 10-3 0-9-2-23-6-45-6h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113v-254q0-13 9-22l64-64q10-10 23-10 6 0 12 3 20 8 20 29zm231-489l-814 814q-24 24-57 24t-57-24l-430-430q-24-24-24-57t24-57l110-110q24-24 57-24t57 24l263 263 647-647q24-24 57-24t57 24l110 110q24 24 24 57t-24 57z\"/> </svg>"

/***/ }),

/***/ 32014:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ tryRemoveNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * @private
 */
function tryRemoveNode(jodit, nodeElm, hadEffect, allowTags, denyTags, currentSelectionNode) {
    if (isRemovableNode(jodit, nodeElm, currentSelectionNode, allowTags, denyTags)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(nodeElm);
        return true;
    }
    return hadEffect;
}
/**
 * @private
 */
function isRemovableNode(jodit, node, current, allow, deny) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        if (allow && !allow[node.nodeName]) {
            return true;
        }
        if (!allow && deny && deny[node.nodeName]) {
            return true;
        }
    }
    if (!jodit.o.cleanHTML.removeEmptyElements) {
        return false;
    }
    return (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(node) &&
        node.nodeName.match(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_INLINE) != null &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTemporary(node) &&
        (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(node.innerHTML).length === 0 &&
        (current == null || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(node, current)));
}


/***/ }),

/***/ 32164:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Format de copie'
};


/***/ }),

/***/ 32291:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ loadStyle; },
/* harmony export */   o: function() { return /* binding */ loadExtras; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27301);
/* harmony import */ var jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96134);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var styles = new Set();
/**
 * @private
 */
function loadStyle(jodit, pluginName) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
        var url;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__generator */ .YH)(this, function (_a) {
            url = getFullUrl(jodit, pluginName, false);
            if (styles.has(url)) {
                return [2 /*return*/];
            }
            styles.add(url);
            return [2 /*return*/, (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__/* .appendStyleAsync */ .S5)(jodit, url)];
        });
    });
}
/**
 * Call full url to the script or style file
 * @private
 */
function getFullUrl(jodit, name, js) {
    name = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__/* .kebabCase */ .k)(name);
    return (jodit.basePath +
        'plugins/' +
        name +
        '/' +
        name +
        '.' +
        (js ? 'js' : 'css'));
}
/**
 * @private
 */
function loadExtras(items, jodit, extraList, callback) {
    try {
        var needLoadExtras = extraList.filter(function (extra) { return !items.has((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__/* .normalizeName */ .P)(extra.name)); });
        if (needLoadExtras.length) {
            load(jodit, needLoadExtras, callback);
        }
    }
    catch (e) {
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            throw e;
        }
    }
}
/**
 * Download plugins
 * @private
 */
function load(jodit, pluginList, callback) {
    pluginList.map(function (extra) {
        var url = extra.url || getFullUrl(jodit, extra.name, true);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__/* .appendScriptAsync */ .w4)(jodit, url)
            .then(callback)
            .catch(function () { return null; });
    });
}


/***/ }),

/***/ 32332:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ observable; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_equal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69810);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(25376);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var OBSERVABLE_OBJECT = Symbol('observable-object');
function isObservableObject(obj) {
    return obj[OBSERVABLE_OBJECT] !== undefined;
}
/**
 * Makes any object an observable object
 * @example
 * ```js
 * const obj = {
 *   a: 1,
 *   b: {
 *     c: 5
 *   }
 * }
 *
 * const obsObj = Jodit.modules.observable(obj);
 * console.log(obj === obsObj); // true
 * obsObj.on('change', () => {
 *   console.log('Object changed');
 * });
 * obsObj.on('change.a', () => {
 *   console.log('Key a changed');
 * });
 * obsObj.on('change.b.c', () => {
 *   console.log('Key b.c changed');
 * });
 *
 * obj.a = 6;
 * // Object changed
 * // Key a changed
 *
 * obj.b = {c: 6}
 * // Object changed
 *
 * obj.b.c = 8
 * // Object changed
 * // Key b.c changed
 * ```
 */
function observable(obj) {
    if (isObservableObject(obj)) {
        return obj;
    }
    var __lockEvent = {};
    var __onEvents = {};
    var on = function (event, callback) {
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(event)) {
            event.map(function (e) { return on(e, callback); });
            return obj;
        }
        if (!__onEvents[event]) {
            __onEvents[event] = [];
        }
        __onEvents[event].push(callback);
        return obj;
    };
    var fire = function (event) {
        var attr = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            attr[_i - 1] = arguments[_i];
        }
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(event)) {
            event.map(function (e) { return fire.apply(void 0, (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__spreadArray */ .fX)([e], (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__read */ .zs)(attr), false)); });
            return;
        }
        try {
            if (!__lockEvent[event] && __onEvents[event]) {
                __lockEvent[event] = true;
                __onEvents[event].forEach(function (clb) { return clb.call.apply(clb, (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__spreadArray */ .fX)([obj], (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__read */ .zs)(attr), false)); });
            }
        }
        finally {
            __lockEvent[event] = false;
        }
    };
    var initAccessors = function (dict, prefixes) {
        if (prefixes === void 0) { prefixes = []; }
        var store = {};
        if (isObservableObject(dict)) {
            return;
        }
        Object.defineProperty(dict, OBSERVABLE_OBJECT, {
            enumerable: false,
            value: true
        });
        Object.keys(dict).forEach(function (_key) {
            var key = _key;
            var prefix = prefixes.concat(key).filter(function (a) { return a.length; });
            store[key] = dict[key];
            var descriptor = (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .getPropertyDescriptor */ .N)(dict, key);
            Object.defineProperty(dict, key, {
                set: function (value) {
                    var oldValue = store[key];
                    if (!(0,jodit_core_helpers_checker_is_equal__WEBPACK_IMPORTED_MODULE_3__/* .isFastEqual */ .P)(store[key], value)) {
                        fire([
                            'beforeChange',
                            "beforeChange.".concat(prefix.join('.'))
                        ], key, value);
                        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_4__/* .isPlainObject */ .Q)(value)) {
                            initAccessors(value, prefix);
                        }
                        if (descriptor && descriptor.set) {
                            descriptor.set.call(obj, value);
                        }
                        else {
                            store[key] = value;
                        }
                        var sum_1 = [];
                        fire((0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__spreadArray */ .fX)([
                            'change'
                        ], (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__read */ .zs)(prefix.reduce(function (rs, p) {
                            sum_1.push(p);
                            rs.push("change.".concat(sum_1.join('.')));
                            return rs;
                        }, [])), false), prefix.join('.'), oldValue, (value === null || value === void 0 ? void 0 : value.valueOf)
                            ? value.valueOf()
                            : value);
                    }
                },
                get: function () {
                    if (descriptor && descriptor.get) {
                        return descriptor.get.call(obj);
                    }
                    return store[key];
                },
                enumerable: true,
                configurable: true
            });
            if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_4__/* .isPlainObject */ .Q)(store[key])) {
                initAccessors(store[key], prefix);
            }
        });
        Object.defineProperty(obj, 'on', {
            value: on
        });
    };
    initAccessors(obj);
    return obj;
}


/***/ }),

/***/ 32709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $r: function() { return /* reexport safe */ _to_array__WEBPACK_IMPORTED_MODULE_2__.$; },
/* harmony export */   _j: function() { return /* reexport safe */ _as_array__WEBPACK_IMPORTED_MODULE_0__._; },
/* harmony export */   uM: function() { return /* reexport safe */ _split_array__WEBPACK_IMPORTED_MODULE_1__.u; }
/* harmony export */ });
/* harmony import */ var _as_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82317);
/* harmony import */ var _split_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42589);
/* harmony import */ var _to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42448);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */





/***/ }),

/***/ 32782:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ sanitizeAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * @private
 */
function sanitizeAttributes(jodit, nodeElm, hadEffect) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(nodeElm) &&
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTMLElement)(nodeElm, {
            safeJavaScriptLink: jodit.options.cleanHTML.safeJavaScriptLink,
            removeOnError: jodit.options.cleanHTML.removeOnError
        })) {
        return true;
    }
    return hadEffect;
}


/***/ }),

/***/ 33087:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ persistent; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12041);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function persistent(target, propertyKey) {
    target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, function (component) {
        var jodit = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_1__/* .isViewObject */ .h)(component)
            ? component
            : component.jodit, storageKey = "".concat(jodit.options.namespace).concat(component.componentName, "_prop_").concat(propertyKey), initialValue = component[propertyKey];
        Object.defineProperty(component, propertyKey, {
            get: function () {
                var _a;
                return (_a = jodit.storage.get(storageKey)) !== null && _a !== void 0 ? _a : initialValue;
            },
            set: function (value) {
                jodit.storage.set(storageKey, value);
            }
        });
    });
}


/***/ }),

/***/ 33201:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ readLink; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26150);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/** @private */
function readLink(state, j, values) {
    var a = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(state.sourceImage, 'a', j.editor);
    if (a) {
        values.imageLink = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(a, 'href') || '';
        values.imageLinkOpenInNewTab = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(a, 'target') === '_blank';
    }
    else {
        values.imageLink = '';
        values.imageLinkOpenInNewTab = false;
    }
}


/***/ }),

/***/ 33403:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ UIImageMainTab; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71151);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/** @private */
var UIImageMainTab = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__extends */ .C6)(UIImageMainTab, _super);
    function UIImageMainTab(view, state, handlers) {
        var _this = _super.call(this, view) || this;
        _this.state = state;
        _this.handlers = handlers;
        return _this;
    }
    UIImageMainTab.prototype.className = function () {
        return 'UIImageMainTab';
    };
    UIImageMainTab.prototype.appendChildToContainer = function () {
        // Do nothing
    };
    UIImageMainTab.prototype.render = function () {
        return "<div class=\"jodit-form__group &__editSrc\">\n\t\t\t<label>~Src~</label>\n\t\t\t<div class=\"jodit-input_group\">\n\t\t\t\t<input class=\"jodit-input &__imageSrc\" type=\"text\"/>\n\t\t\t\t<div class=\"jodit-input_group-buttons &__fixImage\">\n\t\t\t\t\t\t<a class=\"jodit-button &__changeImage\">*image*</a>\n\t\t\t\t\t\t<a class=\"jodit-button &__editImage\">*crop*</a>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editTitle\">\n\t\t\t<label>~Title~</label>\n\t\t\t<input type=\"text\" class=\"jodit-input &__imageTitle\"/>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editAlt\">\n\t\t\t<label>~Alternative~</label>\n\t\t\t<input type=\"text\" class=\"jodit-input &__imageAlt\"/>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editLink\">\n\t\t\t<label>~Link~</label>\n\t\t\t<input type=\"text\" class=\"jodit-input &__imageLink\"/>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editLinkTarget\">\n\t\t\t<label class=\"jodit_vertical_middle\">\n\t\t\t\t<input type=\"checkbox\" class=\"jodit-checkbox &__imageLinkOpenInNewTab\"/>\n\t\t\t\t<span>~Open link in new tab~</span>\n\t\t\t</label>\n\t\t</div>";
    };
    UIImageMainTab.prototype.onStateImageSrcChange = function () {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__awaiter */ .sH)(this, void 0, Promise, function () {
            var imageSrc;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__generator */ .YH)(this, function (_a) {
                imageSrc = this.getElm('imageSrc');
                imageSrc.value = this.state.values.imageSrc;
                return [2 /*return*/];
            });
        });
    };
    UIImageMainTab.prototype.onImageSrcChange = function () {
        this.state.values.imageSrc = this.getElm('imageSrc').value;
    };
    /**
     * Open image editor
     */
    UIImageMainTab.prototype.onEditImageClick = function (e) {
        this.handlers.openImageEditor();
        e.stopPropagation();
    };
    /**
     * Open popup with filebrowser/uploader buttons for image
     */
    UIImageMainTab.prototype.onChangeImageClick = function (e) {
        this.handlers.openImagePopup(this.getElm('changeImage'));
        e.stopPropagation();
    };
    UIImageMainTab.prototype.onStateTitleChange = function () {
        var title = this.getElm('imageTitle');
        title.value = this.state.values.imageTitle;
    };
    UIImageMainTab.prototype.onTitleChange = function () {
        this.state.values.imageTitle = this.getElm('imageTitle').value;
    };
    UIImageMainTab.prototype.onStateAltChange = function () {
        var alt = this.getElm('imageAlt');
        alt.value = this.state.values.imageAlt;
    };
    UIImageMainTab.prototype.onAltChange = function () {
        this.state.values.imageAlt = this.getElm('imageAlt').value;
    };
    UIImageMainTab.prototype.onStateImageLinkChange = function () {
        var imageLink = this.getElm('imageLink');
        imageLink.value = this.state.values.imageLink;
    };
    UIImageMainTab.prototype.onImageLinkChange = function () {
        this.state.values.imageLink = this.getElm('imageLink').value;
    };
    UIImageMainTab.prototype.onStateImageLinkOpenInNewTabChange = function () {
        var imageLinkOpenInNewTab = this.getElm('imageLinkOpenInNewTab');
        imageLinkOpenInNewTab.checked = this.state.values.imageLinkOpenInNewTab;
    };
    UIImageMainTab.prototype.onImageLinkOpenInNewTabChange = function () {
        this.state.values.imageLinkOpenInNewTab = this.getElm('imageLinkOpenInNewTab').checked;
    };
    UIImageMainTab.prototype.hideFieldByOptions = function () {
        var _this = this;
        var o = this.j.o;
        var opt = o.image;
        [
            ['editSrc', 'editSrc'],
            ['editTitle', 'editTitle'],
            ['editAlt', 'editAlt'],
            ['editLink', 'editLink'],
            ['editLink', 'editLinkTarget'],
            ['useImageEditor', 'editImage']
        ].forEach(function (_a) {
            var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__read */ .zs)(_a, 2), optKey = _b[0], elmKey = _b[1];
            var elm = _this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
        var changeImage = this.getElm('changeImage');
        var needShowChangeImage = Boolean(o.filebrowser.ajax.url || o.uploader.url);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(changeImage, 'display', needShowChangeImage ? null : 'none');
        var editImage = this.getElm('editImage');
        var needShowEditImage = Boolean(o.filebrowser.ajax.url) && opt.useImageEditor;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(editImage, 'display', needShowEditImage ? null : 'none');
        var fixImage = this.getElm('fixImage');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(fixImage, 'display', needShowChangeImage || needShowEditImage ? null : 'none');
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageSrc')
    ], UIImageMainTab.prototype, "onStateImageSrcChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageSrc:change')
    ], UIImageMainTab.prototype, "onImageSrcChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('editImage:click')
    ], UIImageMainTab.prototype, "onEditImageClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('changeImage:click')
    ], UIImageMainTab.prototype, "onChangeImageClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageTitle')
    ], UIImageMainTab.prototype, "onStateTitleChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageTitle:change')
    ], UIImageMainTab.prototype, "onTitleChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageAlt')
    ], UIImageMainTab.prototype, "onStateAltChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageAlt:change')
    ], UIImageMainTab.prototype, "onAltChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageLink')
    ], UIImageMainTab.prototype, "onStateImageLinkChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageLink:change')
    ], UIImageMainTab.prototype, "onImageLinkChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageLinkOpenInNewTab')
    ], UIImageMainTab.prototype, "onStateImageLinkOpenInNewTabChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageLinkOpenInNewTab:change')
    ], UIImageMainTab.prototype, "onImageLinkOpenInNewTabChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready')
    ], UIImageMainTab.prototype, "hideFieldByOptions", null);
    UIImageMainTab = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_5__/* .component */ .s
    ], UIImageMainTab);
    return UIImageMainTab;
}(jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__/* .UIGroup */ .U));



/***/ }),

/***/ 33733:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   q: function() { return /* binding */ openImagePopup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27594);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80071);
/* harmony import */ var jodit_modules_widget_file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10067);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/** @private */
function openImagePopup(j, dialog, state, button) {
    var _this = this;
    var popup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_0__/* .Popup */ .z(dialog);
    var closePopup = function () {
        popup.close();
        popup.destruct();
    };
    popup
        .setContent((0,jodit_modules_widget_file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__/* .FileSelectorWidget */ .k)(j, {
        upload: function (data) {
            if (data.files && data.files.length) {
                state.values.imageSrc =
                    data.baseurl + data.files[0];
            }
            closePopup();
        },
        filebrowser: function (data) { return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(_this, void 0, void 0, function () {
            return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__generator */ .YH)(this, function (_a) {
                if (data && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .c)(data.files) && data.files.length) {
                    state.values.imageSrc = data.files[0];
                    closePopup();
                }
                return [2 /*return*/];
            });
        }); }
    }, state.image, closePopup))
        .open(function () { return (0,jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_4__/* .position */ .G)(button); });
}


/***/ }),

/***/ 34045:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1664 256v448q0 26-19 45t-45 19h-448q-42 0-59-40-17-39 14-69l138-138q-148-137-349-137-104 0-198.5 40.5t-163.5 109.5-109.5 163.5-40.5 198.5 40.5 198.5 109.5 163.5 163.5 109.5 198.5 40.5q119 0 225-52t179-147q7-10 23-12 14 0 25 9l137 138q9 8 9.5 20.5t-7.5 22.5q-109 132-264 204.5t-327 72.5q-156 0-298-61t-245-164-164-245-61-298 61-298 164-245 245-164 298-61q147 0 284.5 55.5t244.5 156.5l130-129q29-31 70-14 39 17 39 59z\"/> </svg>"

/***/ }),

/***/ 34125:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ej: function() { return /* reexport safe */ _object_size__WEBPACK_IMPORTED_MODULE_3__.E; },
/* harmony export */   G1: function() { return /* reexport safe */ _position__WEBPACK_IMPORTED_MODULE_5__.G; },
/* harmony export */   cY: function() { return /* reexport safe */ _offset__WEBPACK_IMPORTED_MODULE_4__.c; },
/* harmony export */   mH: function() { return /* reexport safe */ _get_scroll_parent__WEBPACK_IMPORTED_MODULE_1__.m; },
/* harmony export */   xM: function() { return /* reexport safe */ _inner_width__WEBPACK_IMPORTED_MODULE_2__.x; },
/* harmony export */   y6: function() { return /* reexport safe */ _get_content_width__WEBPACK_IMPORTED_MODULE_0__.y; }
/* harmony export */ });
/* harmony import */ var _get_content_width__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73780);
/* harmony import */ var _get_scroll_parent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98228);
/* harmony import */ var _inner_width__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49744);
/* harmony import */ var _object_size__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95350);
/* harmony import */ var _offset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91594);
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27594);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/size
 */








/***/ }),

/***/ 34248:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ ContextMenu; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80071);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Module to generate context menu
 */
var ContextMenu = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__extends */ .C6)(ContextMenu, _super);
    function ContextMenu() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @override */
    ContextMenu.prototype.className = function () {
        return 'ContextMenu';
    };
    /**
     * Generate and show context menu
     *
     * @param x - Global coordinate by X
     * @param y - Global coordinate by Y
     * @param actions - Array with plain objects `{icon: 'bin', title: 'Delete', exec: function () {}}`
     * @example
     * ```javascript
     * parent.show(e.clientX, e.clientY, [{icon: 'bin', title: 'Delete', exec: function () { alert(1) }}]);
     * ```
     */
    ContextMenu.prototype.show = function (x, y, actions) {
        var _this = this;
        var self = this;
        self.clear();
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .c)(actions)) {
            return;
        }
        actions.forEach(function (item) {
            if (!item) {
                return;
            }
            var action = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(_this.jodit, item.icon || 'empty', item.title);
            _this.jodit && action.setParentView(_this.jodit);
            action.setMod('context', 'menu');
            action.onAction(function (e) {
                var _a;
                (_a = item.exec) === null || _a === void 0 ? void 0 : _a.call(self, e);
                self.clear();
                self.close();
                return false;
            });
            _this.append(action);
        });
        this.open(function () { return ({ left: x, top: y, width: 0, height: 0 }); }, true);
    };
    ContextMenu = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
    ], ContextMenu);
    return ContextMenu;
}(jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_1__/* .Popup */ .z));



/***/ }),

/***/ 34256:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Fc: function() { return /* reexport safe */ _alert__WEBPACK_IMPORTED_MODULE_0__.F; },
/* harmony export */   XG: function() { return /* reexport safe */ _prompt__WEBPACK_IMPORTED_MODULE_3__.X; },
/* harmony export */   lG: function() { return /* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_2__.l; },
/* harmony export */   pT: function() { return /* reexport safe */ _confirm__WEBPACK_IMPORTED_MODULE_1__.p; }
/* harmony export */ });
/* harmony import */ var _alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5854);
/* harmony import */ var _confirm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23132);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/* harmony import */ var _prompt__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91560);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/dialog/README.md]]
 * @packageDocumentation
 * @module modules/dialog
 */






/***/ }),

/***/ 34446:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ ctrlKey; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
/**
 * CTRL pressed
 * @returns true ctrl key was pressed
 */
var ctrlKey = function (e) {
    if (typeof navigator !== 'undefined' &&
        navigator.userAgent.indexOf('Mac OS X') !== -1) {
        if (e.metaKey && !e.altKey) {
            return true;
        }
    }
    else if (e.ctrlKey && !e.altKey) {
        return true;
    }
    return false;
};


/***/ }),

/***/ 34747:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: '拼字檢查'
};


/***/ }),

/***/ 34796:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: function() { return /* binding */ isNativeFunction; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if function or method was not replaced on some custom implementation
 */
function isNativeFunction(f) {
    return (Boolean(f) &&
        (typeof f).toLowerCase() === 'function' &&
        (f === Function.prototype ||
            /^\s*function\s*(\b[a-z$_][a-z0-9$_]*\b)*\s*\((|([a-z$_][a-z0-9$_]*)(\s*,[a-z$_][a-z0-9$_]*)*)\)\s*{\s*\[native code]\s*}\s*$/i.test(String(f))));
}


/***/ }),

/***/ 34899:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ OptionsError; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module helpers/utils
 */
var OptionsError = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__extends */ .C6)(OptionsError, _super);
    function OptionsError(m) {
        var _this = _super.call(this, m) || this;
        Object.setPrototypeOf(_this, OptionsError.prototype);
        return _this;
    }
    return OptionsError;
}(TypeError));



/***/ }),

/***/ 35265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $n: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.$n; },
/* harmony export */   SB: function() { return /* reexport safe */ _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__.S; },
/* harmony export */   lD: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.lD; },
/* harmony export */   ss: function() { return /* reexport safe */ _group_group__WEBPACK_IMPORTED_MODULE_1__.s; },
/* harmony export */   ue: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.ue; }
/* harmony export */ });
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var _group_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31202);
/* harmony import */ var _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36434);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/ui/button/README.md]]
 * @packageDocumentation
 * @module ui/button
 */





/***/ }),

/***/ 35523:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export select */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53048);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41133);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








/**
 * A utility plugin that allows you to subscribe to a click/mousedown/touchstart/mouseup on an element in DOM order
 *
 * @example
 * ```js
 * const editor = Jodit.make('#editor');
 * editor.e.on('clickImg', (img) => {
 *   console.log(img.src);
 * })
 * ```
 */
var select = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(select, _super);
    function select() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(arguments), false)) || this;
        _this.proxyEventsList = [
            'click',
            'mousedown',
            'touchstart',
            'mouseup',
            'touchend'
        ];
        return _this;
    }
    select.prototype.afterInit = function (jodit) {
        var _this = this;
        this.proxyEventsList.forEach(function (eventName) {
            jodit.e.on(eventName + '.select', _this.onStartSelection);
        });
    };
    select.prototype.beforeDestruct = function (jodit) {
        var _this = this;
        this.proxyEventsList.forEach(function (eventName) {
            jodit.e.on(eventName + '.select', _this.onStartSelection);
        });
    };
    select.prototype.onStartSelection = function (e) {
        var j = this.j;
        var result, target = e.target;
        while (result === undefined && target && target !== j.editor) {
            result = j.e.fire((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_7__/* .camelCase */ .x)(e.type + '_' + target.nodeName.toLowerCase()), target, e);
            target = target.parentElement;
        }
        if (e.type === 'click' && result === undefined && target === j.editor) {
            j.e.fire(e.type + 'Editor', target, e);
        }
    };
    /**
     * @event outsideClick(e) - when user clicked on the outside of editor
     */
    select.prototype.onOutsideClick = function (e) {
        var _this = this;
        var node = e.target;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(node, function (elm) { return elm === _this.j.editor; })) {
            return;
        }
        var box = jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__/* .UIElement */ .D$.closestElement(node, jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__/* .Popup */ .zD);
        if (!box) {
            this.j.e.fire('outsideClick', e);
        }
    };
    select.prototype.beforeCommandCut = function () {
        var s = this.j.s;
        if (!s.isCollapsed()) {
            var current = s.current();
            if (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(this.j.editor, current)) {
                this.onCopyNormalizeSelectionBound();
            }
        }
    };
    select.prototype.beforeCommandSelectAll = function () {
        var s = this.j.s;
        s.focus();
        s.select(this.j.editor, true);
        s.expandSelection();
        return false;
    };
    /**
     * Normalize selection after triple click
     */
    select.prototype.onTripleClickNormalizeSelection = function (e) {
        if (e.detail !== 3 || !this.j.o.select.normalizeTripleClick) {
            return;
        }
        var s = this.j.s;
        var _a = s.range, startContainer = _a.startContainer, startOffset = _a.startOffset;
        if (startOffset === 0 && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(startContainer)) {
            s.select(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(startContainer, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isBlock, this.j.editor) ||
                startContainer, true);
        }
    };
    select.prototype.onCopyNormalizeSelectionBound = function (e) {
        var _a = this.j, s = _a.s, editor = _a.editor, o = _a.o;
        if (!o.select.normalizeSelectionBeforeCutAndCopy || s.isCollapsed()) {
            return;
        }
        if (e &&
            (!e.isTrusted ||
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isNode(e.target) ||
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(editor, e.target))) {
            return;
        }
        this.jodit.s.expandSelection();
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], select.prototype, "onStartSelection", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('ow:click')
    ], select.prototype, "onOutsideClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':beforeCommandCut'])
    ], select.prototype, "beforeCommandCut", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':beforeCommandSelectall'])
    ], select.prototype, "beforeCommandSelectAll", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':click'])
    ], select.prototype, "onTripleClickNormalizeSelection", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':copy', ':cut'])
    ], select.prototype, "onCopyNormalizeSelectionBound", null);
    return select;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('select', select);


/***/ }),

/***/ 35541:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export symbols */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61964);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(84182);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * The plugin inserts characters that are not part of the standard keyboard.
 */
var symbols = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(symbols, _super);
    function symbols(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.buttons = [
            {
                name: 'symbols',
                group: 'insert'
            }
        ];
        _this.__countInRow = 17;
        (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .extendLang */ .JW)(_langs__WEBPACK_IMPORTED_MODULE_6__);
        return _this;
    }
    symbols.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit.e.on('generateSpecialCharactersTable.symbols', function () {
            var container = jodit.c.fromHTML("<div class=\"jodit-symbols__container\">\n\t\t\t\t\t\t<div class=\"jodit-symbols__container_table\">\n\t\t\t\t\t\t\t<table class=\"jodit-symbols__table\"><tbody></tbody></table>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"jodit-symbols__container_preview\">\n\t\t\t\t\t\t\t<div class=\"jodit-symbols__preview\"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>");
            var preview = container.querySelector('.jodit-symbols__preview');
            var table = container.querySelector('table');
            var body = table.tBodies[0];
            var chars = [];
            for (var i = 0; i < jodit.o.specialCharacters.length;) {
                var tr = jodit.c.element('tr');
                for (var j = 0; j < _this.__countInRow &&
                    i < jodit.o.specialCharacters.length; j += 1, i += 1) {
                    var td = jodit.c.element('td'), a = jodit.c.fromHTML("<a\n\t\t\t\t\t\t\t\t\tdata-index=\"".concat(i, "\"\n\t\t\t\t\t\t\t\t\tdata-index-j=\"").concat(j, "\"\n\t\t\t\t\t\t\t\t\trole=\"option\"\n\t\t\t\t\t\t\t\t\ttabindex=\"-1\"\n\t\t\t\t\t\t\t>").concat(jodit.o.specialCharacters[i], "</a>"));
                    chars.push(a);
                    td.appendChild(a);
                    tr.appendChild(td);
                }
                body.appendChild(tr);
            }
            var self = _this;
            jodit.e
                .on(chars, 'focus', function () {
                preview.innerHTML = this.innerHTML;
            })
                .on(chars, 'mousedown', function (e) {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(this, 'a')) {
                    jodit.s.focus();
                    jodit.s.insertHTML(this.innerHTML);
                    if (!(e === null || e === void 0 ? void 0 : e.shiftKey)) {
                        jodit.e.fire(this, 'close_dialog');
                    }
                    e && e.preventDefault();
                    e && e.stopImmediatePropagation();
                }
            })
                .on(chars, 'mouseenter', function () {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(this, 'a')) {
                    this.focus();
                }
            })
                .on(chars, 'keydown', function (e) {
                var target = e.target;
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(target, 'a')) {
                    var index = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(target, '-index') || '0', 10), jIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(target, 'data-index-j') || '0', 10);
                    var newIndex = void 0;
                    switch (e.key) {
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP:
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN:
                            newIndex =
                                e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP
                                    ? index - self.__countInRow
                                    : index + self.__countInRow;
                            if (chars[newIndex] === undefined) {
                                newIndex =
                                    e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP
                                        ? Math.floor(chars.length /
                                            self.__countInRow) *
                                            self.__countInRow +
                                            jIndex
                                        : jIndex;
                                if (newIndex > chars.length - 1) {
                                    newIndex -= self.__countInRow;
                                }
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT:
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT:
                            newIndex =
                                e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT ? index - 1 : index + 1;
                            if (chars[newIndex] === undefined) {
                                newIndex =
                                    e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT
                                        ? chars.length - 1
                                        : 0;
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ENTER:
                            jodit.e.fire(target, 'mousedown');
                            e.stopImmediatePropagation();
                            e.preventDefault();
                            break;
                    }
                }
            });
            return container;
        });
    };
    /** @override */
    symbols.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('generateSpecialCharactersTable.symbols');
    };
    return symbols;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('symbols', symbols);


/***/ }),

/***/ 35642:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ isVoid; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is undefined or null
 */
function isVoid(value) {
    // eslint-disable-next-line eqeqeq
    return value === undefined || value === null;
}


/***/ }),

/***/ 36001:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/resize-cells
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.tableAllowCellResize = true;


/***/ }),

/***/ 36115:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ Config; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Editor options. These can be configured upon the creation of the editor.
 * ```javascript
 * const editor = Jodit.make('#editor', {
 * 	 toolbar: true,
 * 	 buttons: ['bold', 'italic', 'underline']
 * 	 // other options
 * 	 // ...
 * });
 * ```
 * @packageDocumentation
 * @module config
 */


/**
 * Default Editor's Configuration
 */
var Config = /** @class */ (function () {
    function Config() {
        /**
         * Use cache for heavy methods
         */
        this.cache = true;
        /**
         * Timeout of all asynchronous methods
         */
        this.defaultTimeout = 100;
        this.namespace = '';
        /**
         * Editor loads completely without plugins. Useful when debugging your own plugin.
         */
        this.safeMode = false;
        /**
         * Editor's width
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: 'auto', // autosize
         * })
         * ```
         */
        this.width = 'auto';
        /**
         * Editor's height
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: 'auto', // default - autosize
         * })
         * ```
         */
        this.height = 'auto';
        /**
         * List of plugins that will be initialized in safe mode.
         *
         * ```js
         * Jodit.make('#editor', {
         * 	safeMode: true,
         * 	safePluginsList: ['about'],
         * 	extraPlugins: ['yourPluginDev']
         * });
         * ```
         */
        this.safePluginsList = [
            'about',
            'enter',
            'backspace',
            'size',
            'bold',
            'hotkeys'
        ];
        /**
         * Reserved for the paid version of the editor
         */
        this.license = '';
        /**
         * The name of the preset that will be used to initialize the editor.
         * The list of available presets can be found here Jodit.defaultOptions.presets
         * ```javascript
         * Jodit.make('.editor', {
         * 	preset: 'inline'
         * });
         * ```
         */
        this.preset = 'custom';
        this.presets = {
            inline: {
                inline: true,
                toolbar: false,
                toolbarInline: true,
                toolbarInlineForSelection: true,
                showXPathInStatusbar: false,
                showCharsCounter: false,
                showWordsCounter: false,
                showPlaceholder: false
            }
        };
        this.ownerDocument = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument;
        /**
         * Allows you to specify the window in which the editor will be created. Default - window
         * This is necessary if you are creating the editor inside an iframe but the code is running in the parent window
         */
        this.ownerWindow = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow;
        /**
         * Shadow root if Jodit was created in it
         *
         * ```html
         * <div id="editor"></div>
         * ```
         *
         * ```js
         * const app = document.getElementById('editor');
         * app.attachShadow({ mode: 'open' });
         * const root = app.shadowRoot;
         *
         * root.innerHTML = `
         * <link rel="stylesheet" href="./build/jodit.css"/>
         * <h1>Jodit example in Shadow DOM</h1>
         * <div id="edit"></div>
         * `;
         *
         * const editor = Jodit.make(root.getElementById('edit'), {
         * 	globalFullSize: false,
         * 	shadowRoot: root
         * });
         * editor.value = '<p>start</p>';
         * ```
         */
        this.shadowRoot = null;
        /**
         * z-index For editor
         */
        this.zIndex = 0;
        /**
         * Change the read-only state of the editor
         */
        this.readonly = false;
        /**
         * Change the disabled state of the editor
         */
        this.disabled = false;
        /**
         * In readOnly mode, some buttons can still be useful, for example, the button to view source code or print
         */
        this.activeButtonsInReadOnly = [
            'source',
            'fullsize',
            'print',
            'about',
            'dots',
            'selectall'
        ];
        /**
         * When the editor is in read-only mode, some commands can still be executed:
         * ```javascript
         * const editor = Jodit.make('.editor', {
         * 	 allowCommandsInReadOnly: ['selectall', 'preview', 'print']
         * 	 readonly: true
         * });
         * editor.execCommand('selectall');// will be selected all content
         * editor.execCommand('delete');// but content will not be deleted
         * ```
         */
        this.allowCommandsInReadOnly = ['selectall', 'preview', 'print'];
        /**
         * Size of icons in the toolbar (can be "small", "middle", "large")
         *
         * @example
         * ```javascript
         * const editor = Jodit.make(".dark_editor", {
         *      toolbarButtonSize: "small"
         * });
         * ```
         */
        this.toolbarButtonSize = 'middle';
        /**
         * Allow navigation in the toolbar of the editor by Tab key
         */
        this.allowTabNavigation = false;
        /**
         * Inline editing mode
         */
        this.inline = false;
        /**
         * Theme (can be "dark")
         * @example
         * ```javascript
         * const editor = Jodit.make(".dark_editor", {
         *      theme: "dark"
         * });
         * ```
         */
        this.theme = 'default';
        /**
         * if set true, then the current mode is saved in a cookie, and is restored after a reload of the page
         */
        this.saveModeInStorage = false;
        /**
         * Class name that can be appended to the editable area
         *
         * @see [[Config.iframeCSSLinks]]
         * @see [[Config.iframeStyle]]
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    editorClassName: 'some_my_class'
         * });
         * ```
         * ```html
         * <style>
         * .some_my_class p{
         *    line-height: 16px;
         * }
         * </style>
         * ```
         */
        this.editorClassName = false;
        /**
         * Class name that can be appended to the main editor container
         * @example
         * ```javascript
         * const jodit = Jodit.make('#editor', {
         *    className: 'some_my_class'
         * });
         *
         * console.log(jodit.container.classList.contains('some_my_class')); // true
         * ```
         * ```html
         * <style>
         * .some_my_class {
         *    max-width: 600px;
         *    margin: 0 auto;
         * }
         * </style>
         * ```
         */
        this.className = false;
        /**
         * The internal styles of the editable area. They are intended to change
         * not the appearance of the editor, but to change the appearance of the content.
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         * 		style: {
         * 		 font: '12px Arial',
         * 		 color: '#0c0c0c'
         * 		}
         * });
         * ```
         */
        this.style = false;
        /**
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         * 		editorStyle: {
         * 		 font: '12px Arial',
         * 		 color: '#0c0c0c'
         * 		}
         * });
         * ```
         */
        this.containerStyle = false;
        /**
         * Dictionary of variable values in css, a complete list can be found here
         * https://github.com/xdan/jodit/blob/main/src/styles/variables.less#L25
         *
         * @example
         * ```js
         * const editor = Jodit.make('#editor', {
         *   styleValues: {
         *		'color-text': 'red',
         *		colorBorder: 'black',
         *		'color-panel': 'blue'
         *   }
         * });
         * ```
         */
        this.styleValues = {};
        /**
         * After all, changes in editors for textarea will call change trigger
         *
         * @example
         * ```javascript
         * const editor = Jodit.make('#editor');
         * document.getElementById('editor').addEventListener('change', function () {
         *      console.log(this.value);
         * })
         * ```
         */
        this.triggerChangeEvent = true;
        /**
         * The writing direction of the language which is used to create editor content. Allowed values are: ''
         * (an empty string) – Indicates that content direction will be the same as either the editor UI direction or
         * the page element direction. 'ltr' – Indicates a Left-To-Right text direction (like in English).
         * 'rtl' – Indicates a Right-To-Left text direction (like in Arabic).
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    direction: 'rtl'
         * })
         * ```
         */
        this.direction = '';
        /**
         * Language by default. if `auto` language set by document.documentElement.lang ||
         * (navigator.language && navigator.language.substr(0, 2)) ||
         * (navigator.browserLanguage && navigator.browserLanguage.substr(0, 2)) || 'en'
         *
         * @example
         * ```html
         * <!-- include in you page lang file -->
         * <script src="jodit/lang/de.js"></script>
         * <script>
         * var editor = Jodit.make('.editor', {
         *    language: 'de'
         * });
         * </script>
         * ```
         */
        this.language = 'auto';
        /**
         * if true all Lang.i18n(key) return `{key}`
         *
         * @example
         * ```html
         * <script>
         * var editor = Jodit.make('.editor', {
         *    debugLanguage: true
         * });
         *
         * console.log(editor.i18n("Test")); // {Test}
         * </script>
         * ```
         */
        this.debugLanguage = false;
        /**
         * Collection of language pack data `{en: {'Type something': 'Type something', ...}}`
         *
         * @example
         * ```javascript
         * const editor = Jodit.make('#editor', {
         *     language: 'ru',
         *     i18n: {
         *         ru: {
         *            'Type something': 'Начните что-либо вводить'
         *         }
         *     }
         * });
         * console.log(editor.i18n('Type something')) //Начните что-либо вводить
         * ```
         */
        this.i18n = false;
        /**
         * The tabindex global attribute is an integer indicating if the element can take
         * input focus (is focusable), if it should participate to sequential keyboard navigation,
         * and if so, at what position. It can take several values
         */
        this.tabIndex = -1;
        /**
         * Boolean, whether the toolbar should be shown.
         * Alternatively, a valid css-selector-string to use an element as toolbar container.
         */
        this.toolbar = true;
        /**
         * Boolean, whether the statusbar should be shown.
         */
        this.statusbar = true;
        /**
         * Show tooltip after mouse enter on the button
         */
        this.showTooltip = true;
        /**
         * Delay before show tooltip
         */
        this.showTooltipDelay = 200;
        /**
         * Instead of create custop tooltip - use native title tooltips
         */
        this.useNativeTooltip = false;
        /**
         * Default insert method
         * @default insert_as_html
         */
        this.defaultActionOnPaste = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_HTML;
        // TODO
        // autosave: false, // false or url
        // autosaveCallback: false, // function
        // interval: 60, // seconds
        // TODO
        /**
         * Element that will be created when you press Enter
         */
        this.enter = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH;
        /**
         * When this option is enabled, the editor's content will be placed in an iframe and isolated from the rest of the page.
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeStyle: 'html{margin: 0px;}body{padding:10px;background:transparent;color:#000;position:relative;z-index:2;\
         *    user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}';
         * });
         * ```
         */
        this.iframe = false;
        /**
         * Allow editing the entire HTML document(html, head)
         * \> Works together with the iframe option.
         * @example
         * ```js
         * const editor = Jodit.make('#editor', {
         *   iframe: true,
         *   editHTMLDocumentMode: true
         * });
         * editor.value = '<!DOCTYPE html><html lang="en" style="overflow-y:hidden">' +
         * 	'<head><title>Jodit Editor</title></head>' +
         * 	'<body spellcheck="false"><p>Some text</p><p> a </p></body>' +
         * 	'</html>';
         * ```
         */
        this.editHTMLDocumentMode = false;
        /**
         * Use when you need to insert new block element
         * use enter option if not set
         */
        this.enterBlock = this.enter !== 'br' ? this.enter : jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH;
        /**
         * Jodit.MODE_WYSIWYG The HTML editor allows you to write like MSWord,
         * Jodit.MODE_SOURCE syntax highlighting source editor
         * @example
         * ```javascript
         * var editor = Jodit.make('#editor', {
         *     defaultMode: Jodit.MODE_SPLIT
         * });
         * console.log(editor.getRealMode())
         * ```
         */
        this.defaultMode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        /**
         * Use split mode
         */
        this.useSplitMode = false;
        /**
         * The colors in HEX representation to select a color for the background and for the text in colorpicker
         * @example
         * ```javascript
         *  Jodit.make('#editor', {
         *     colors: ['#ff0000', '#00ff00', '#0000ff']
         * })
         * ```
         */
        this.colors = {
            greyscale: [
                '#000000',
                '#434343',
                '#666666',
                '#999999',
                '#B7B7B7',
                '#CCCCCC',
                '#D9D9D9',
                '#EFEFEF',
                '#F3F3F3',
                '#FFFFFF'
            ],
            palette: [
                '#980000',
                '#FF0000',
                '#FF9900',
                '#FFFF00',
                '#00F0F0',
                '#00FFFF',
                '#4A86E8',
                '#0000FF',
                '#9900FF',
                '#FF00FF'
            ],
            full: [
                '#E6B8AF',
                '#F4CCCC',
                '#FCE5CD',
                '#FFF2CC',
                '#D9EAD3',
                '#D0E0E3',
                '#C9DAF8',
                '#CFE2F3',
                '#D9D2E9',
                '#EAD1DC',
                '#DD7E6B',
                '#EA9999',
                '#F9CB9C',
                '#FFE599',
                '#B6D7A8',
                '#A2C4C9',
                '#A4C2F4',
                '#9FC5E8',
                '#B4A7D6',
                '#D5A6BD',
                '#CC4125',
                '#E06666',
                '#F6B26B',
                '#FFD966',
                '#93C47D',
                '#76A5AF',
                '#6D9EEB',
                '#6FA8DC',
                '#8E7CC3',
                '#C27BA0',
                '#A61C00',
                '#CC0000',
                '#E69138',
                '#F1C232',
                '#6AA84F',
                '#45818E',
                '#3C78D8',
                '#3D85C6',
                '#674EA7',
                '#A64D79',
                '#85200C',
                '#990000',
                '#B45F06',
                '#BF9000',
                '#38761D',
                '#134F5C',
                '#1155CC',
                '#0B5394',
                '#351C75',
                '#733554',
                '#5B0F00',
                '#660000',
                '#783F04',
                '#7F6000',
                '#274E13',
                '#0C343D',
                '#1C4587',
                '#073763',
                '#20124D',
                '#4C1130'
            ]
        };
        /**
         * The default tab color picker
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     colorPickerDefaultTab: 'color'
         * })
         * ```
         */
        this.colorPickerDefaultTab = 'background';
        /**
         * Image size defaults to a larger image
         */
        this.imageDefaultWidth = 300;
        /**
         * Do not display these buttons that are on the list
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     removeButtons: ['hr', 'source']
         * });
         * ```
         */
        this.removeButtons = [];
        /**
         * Do not init these plugins
         * @example
         * ```typescript
         * var editor = Jodit.make('.editor', {
         *    disablePlugins: 'table,iframe'
         * });
         * //or
         * var editor = Jodit.make('.editor', {
         *    disablePlugins: ['table', 'iframe']
         * });
         * ```
         */
        this.disablePlugins = [];
        /**
         * Init and download extra plugins
         * @example
         * ```typescript
         * var editor = Jodit.make('.editor', {
         *    extraPlugins: ['emoji']
         * });
         * ```
         * It will try load %SCRIPT_PATH%/plugins/emoji/emoji.js and after load will try init it
         */
        this.extraPlugins = [];
        /**
         * These buttons list will be added to the option. Buttons
         */
        this.extraButtons = [];
        /**
         * By default, you can only install an icon from the Jodit suite.
         * You can add your icon to the set using the `Jodit.modules.Icon.set (name, svg Code)` method.
         * But for a declarative declaration, you can use this option.
         *
         * @example
         * ```js
         * Jodit.modules.Icon.set('someIcon', '<svg><path.../></svg>');
         * const editor = Jodit.make({
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: 'someIcon'
         *   }]
         * });
         *
         * @example
         * const editor = Jodit.make({
         *   extraIcons: {
         *     someIcon: '<svg><path.../></svg>'
         *   },
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: 'someIcon'
         *   }]
         * });
         * ```
         * @example
         * ```js
         * const editor = Jodit.make({
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: '<svg><path.../></svg>'
         *   }]
         * });
         * ```
         */
        this.extraIcons = {};
        /**
         * Default attributes for created inside editor elements
         * @example
         * ```js
         * const editor2 = Jodit.make('#editor', {
         * 	createAttributes: {
         * 		div: {
         * 			class: 'test'
         * 		},
         * 		ul: function (ul) {
         * 			ul.classList.add('ui-test');
         * 		}
         * 	}
         * });
         *
         * const div2 = editor2.createInside.div();
         * expect(div2.className).equals('test');
         *
         * const ul = editor2.createInside.element('ul');
         * expect(ul.className).equals('ui-test');
         * ```
         * Or JSX in React
         * @example
         * ```jsx
         * import React, {useState, useRef} from 'react';
         * import JoditEditor from "jodit-react";
         *
         * const config = {
         * 	createAttributes: {
         * 		div: {
         * 			class: 'align-center'
         * 		}
         * 	}
         * };
         *
         * <JoditEditor config={config}/>
         * ```
         */
        this.createAttributes = {
            table: {
                style: 'border-collapse:collapse;width: 100%;'
            }
        };
        /**
         * The width of the editor, accepted as the biggest. Used to the responsive version of the editor
         */
        this.sizeLG = 900;
        /**
         * The width of the editor, accepted as the medium. Used to the responsive version of the editor
         */
        this.sizeMD = 700;
        /**
         * The width of the editor, accepted as the small. Used to the responsive version of the editor
         */
        this.sizeSM = 400;
        /**
         * The list of buttons that appear in the editor's toolbar on large places (≥ options.sizeLG).
         * Note - this is not the width of the device, the width of the editor
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *     buttons: ['bold', 'italic', 'source'],
         *     buttonsMD: ['bold', 'italic'],
         *     buttonsXS: ['bold', 'fullsize'],
         * });
         * ```
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     buttons: [{
         *         name: 'empty',
         *         icon: 'source',
         *         exec: function (editor) {
         *             const dialog = new Jodit.modules.Dialog({}),
         *                 text = editor.c.element('textarea');
         *
         *             dialog.setHeader('Source code');
         *             dialog.setContent(text);
         *             dialog.setSize(400, 300);
         *
         *             Jodit.modules.Helpers.css(elm, {
         *                 width: '100%',
         *                 height: '100%'
         *             })
    
         *             dialog.open();
         *         }
         *     }]
         * });
         * ```
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     buttons: Jodit.defaultOptions.buttons.concat([{
         *        name: 'listsss',
         *        iconURL: 'stuf/dummy.png',
         *        list: {
         *            h1: 'insert Header 1',
         *            h2: 'insert Header 2',
         *            clear: 'Empty editor',
         *        },
         *        exec: ({originalEvent, control, btn}) => {
         *             var key = control.args[0],
         *                value = control.args[1];
         *             if (key === 'clear') {
         *                 this.val('');
         *                 return;
         *             }
         *             this.s.insertNode(this.c.element(key, ''));
         *             this.message.info('Was inserted ' + value);
         *        },
         *        template: function (key, value) {
         *            return '<div>' + value + '</div>';
         *        }
         *  });
         * ```
         */
        this.buttons = [
            {
                group: 'font-style',
                buttons: []
            },
            {
                group: 'list',
                buttons: []
            },
            {
                group: 'font',
                buttons: []
            },
            '---',
            {
                group: 'script',
                buttons: []
            },
            {
                group: 'media',
                buttons: []
            },
            '\n',
            {
                group: 'state',
                buttons: []
            },
            {
                group: 'clipboard',
                buttons: []
            },
            {
                group: 'insert',
                buttons: []
            },
            {
                group: 'indent',
                buttons: []
            },
            {
                group: 'color',
                buttons: []
            },
            {
                group: 'form',
                buttons: []
            },
            '---',
            {
                group: 'history',
                buttons: []
            },
            {
                group: 'search',
                buttons: []
            },
            {
                group: 'source',
                buttons: []
            },
            {
                group: 'other',
                buttons: []
            },
            {
                group: 'info',
                buttons: []
            }
        ];
        /**
         * Some events are called when the editor is initialized, for example, the `afterInit` event.
         * So this code won't work:
         * ```javascript
         * const editor = Jodit.make('#editor');
         * editor.events.on('afterInit', () => console.log('afterInit'));
         * ```
         * You need to do this:
         * ```javascript
         * Jodit.make('#editor', {
         * 		events: {
         * 	  	afterInit: () => console.log('afterInit')
         * 		}
         * });
         * ```
         * The option can use any Jodit events, for example:
         * ```javascript
         * const editor = Jodit.make('#editor', {
         * 		events: {
         * 			hello: (name) => console.log('Hello', name)
         * 		}
         * });
         * editor.e.fire('hello', 'Mike');
         * ```
         */
        this.events = {};
        /**
         * Buttons in toolbat without SVG - only texts
         */
        this.textIcons = false;
        /**
         * Element for dialog container
         */
        this.popupRoot = null;
        /**
         * shows a INPUT[type=color] to open the browser color picker, on the right bottom of widget color picker
         */
        this.showBrowserColorPicker = true;
    }
    Object.defineProperty(Config, "defaultOptions", {
        get: function () {
            if (!Config.__defaultOptions) {
                Config.__defaultOptions = new Config();
            }
            return Config.__defaultOptions;
        },
        enumerable: false,
        configurable: true
    });
    return Config;
}());
Config.prototype.controls = {};



/***/ }),

/***/ 36133:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var jodit_modules_context_menu_context_menu__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(34248);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8809);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(88850);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










/**
 * Show a path to a current element in status bar
 */
var xpath = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(xpath, _super);
    function xpath() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(arguments), false)) || this;
        _this.onContext = function (bindElement, event) {
            if (!_this.menu) {
                _this.menu = new jodit_modules_context_menu_context_menu__WEBPACK_IMPORTED_MODULE_5__/* .ContextMenu */ .t(_this.j);
            }
            _this.menu.show(event.clientX, event.clientY, [
                {
                    icon: 'bin',
                    title: bindElement === _this.j.editor ? 'Clear' : 'Remove',
                    exec: function () {
                        if (bindElement !== _this.j.editor) {
                            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(bindElement);
                        }
                        else {
                            _this.j.value = '';
                        }
                        _this.j.synchronizeValues();
                    }
                },
                {
                    icon: 'select-all',
                    title: 'Select',
                    exec: function () {
                        _this.j.s.select(bindElement);
                    }
                }
            ]);
            return false;
        };
        _this.onSelectPath = function (bindElement, event) {
            _this.j.s.focus();
            var path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(event.target, '-path') || '/';
            if (path === '/') {
                _this.j.execCommand('selectall');
                return false;
            }
            try {
                var elm = _this.j.ed
                    .evaluate(path, _this.j.editor, null, XPathResult.ANY_TYPE, null)
                    .iterateNext();
                if (elm) {
                    _this.j.s.select(elm);
                    return false;
                }
            }
            catch (_a) { }
            _this.j.s.select(bindElement);
            return false;
        };
        _this.tpl = function (bindElement, path, name, title) {
            var item = _this.j.c.fromHTML("<span class=\"jodit-xpath__item\"><a role=\"button\" data-path=\"".concat(path, "\" title=\"").concat(title, "\" tabindex=\"-1\"'>").concat((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.trim)(name), "</a></span>"));
            var a = item.firstChild;
            _this.j.e
                .on(a, 'click', _this.onSelectPath.bind(_this, bindElement))
                .on(a, 'contextmenu', _this.onContext.bind(_this, bindElement));
            return item;
        };
        _this.removeSelectAll = function () {
            if (_this.selectAllButton) {
                _this.selectAllButton.destruct();
                delete _this.selectAllButton;
            }
        };
        _this.appendSelectAll = function () {
            _this.removeSelectAll();
            _this.selectAllButton = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_6__/* .makeButton */ .BJ)(_this.j, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__assign */ .Cl)({ name: 'selectall' }, _this.j.o.controls.selectall));
            _this.selectAllButton.state.size = 'tiny';
            _this.container &&
                _this.container.insertBefore(_this.selectAllButton.container, _this.container.firstChild);
        };
        _this.calcPathImd = function () {
            if (_this.isDestructed) {
                return;
            }
            var current = _this.j.s.current();
            if (_this.container) {
                _this.container.innerHTML = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE;
            }
            if (current) {
                var name_1, xpth_1, li_1;
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(current, function (elm) {
                    if (elm &&
                        _this.j.editor !== elm &&
                        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(elm) &&
                        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isComment(elm)) {
                        name_1 = elm.nodeName.toLowerCase();
                        xpth_1 = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getXPathByElement)(elm, _this.j.editor).replace(/^\//, '');
                        li_1 = _this.tpl(elm, xpth_1, name_1, _this.j.i18n('Select %s', name_1));
                        _this.container &&
                            _this.container.insertBefore(li_1, _this.container.firstChild);
                    }
                }, _this.j.editor);
            }
            _this.appendSelectAll();
        };
        _this.calcPath = _this.j.async.debounce(_this.calcPathImd, _this.j.defaultTimeout * 2);
        return _this;
    }
    xpath.prototype.afterInit = function () {
        var _this = this;
        if (this.j.o.showXPathInStatusbar) {
            this.container = this.j.c.div('jodit-xpath');
            this.j.e
                .off('.xpath')
                .on('mouseup.xpath change.xpath keydown.xpath changeSelection.xpath', this.calcPath)
                .on('afterSetMode.xpath afterInit.xpath changePlace.xpath', function () {
                if (!_this.j.o.showXPathInStatusbar || !_this.container) {
                    return;
                }
                _this.j.statusbar.append(_this.container);
                if (_this.j.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
                    _this.calcPath();
                }
                else {
                    if (_this.container) {
                        _this.container.innerHTML = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE;
                    }
                    _this.appendSelectAll();
                }
            });
            this.calcPath();
        }
    };
    xpath.prototype.beforeDestruct = function () {
        if (this.j && this.j.events) {
            this.j.e.off('.xpath');
        }
        this.removeSelectAll();
        this.menu && this.menu.destruct();
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.container);
        delete this.menu;
        delete this.container;
    };
    return xpath;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('xpath', xpath);


/***/ }),

/***/ 36291:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ getBlockWrapper; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Finds a suitable parent block container
 * @private
 */
function getBlockWrapper(fake, jodit, tagReg) {
    if (tagReg === void 0) { tagReg = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK; }
    var node = fake;
    var root = jodit.editor;
    do {
        if (!node || node === root) {
            break;
        }
        if (tagReg.test(node.nodeName)) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isLeaf(node)) {
                return node;
            }
            return (getBlockWrapper(node.parentNode, jodit, /^li$/i) ||
                node);
        }
        node = node.parentNode;
    } while (node && node !== root);
    return null;
}


/***/ }),

/***/ 36293:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export color */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39626);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Process commands `background` and `forecolor`
 */
function color(editor) {
    editor.registerButton({
        name: 'brush',
        group: 'color'
    });
    var callback = function (command, second, third) {
        var colorHEX = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeColor)(third);
        switch (command) {
            case 'background':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            backgroundColor: !colorHEX
                                ? ''
                                : colorHEX
                        }
                    }
                });
                break;
            case 'forecolor':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            color: !colorHEX ? '' : colorHEX
                        }
                    }
                });
                break;
        }
        editor.synchronizeValues();
        return false;
    };
    editor
        .registerCommand('forecolor', callback)
        .registerCommand('background', callback);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('color', color);


/***/ }),

/***/ 36327:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M1600 736v192q0 40-28 68t-68 28h-416v416q0 40-28 68t-68 28h-192q-40 0-68-28t-28-68v-416h-416q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h416v-416q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z\"/></svg>"

/***/ }),

/***/ 36339:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 352v1088q0 42-39 59-13 5-25 5-27 0-45-19l-403-403v166q0 119-84.5 203.5t-203.5 84.5h-704q-119 0-203.5-84.5t-84.5-203.5v-704q0-119 84.5-203.5t203.5-84.5h704q119 0 203.5 84.5t84.5 203.5v165l403-402q18-19 45-19 12 0 25 5 39 17 39 59z\"/> </svg>"

/***/ }),

/***/ 36434:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: function() { return /* binding */ UITooltip; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27594);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









var WINDOW_EVENTS_ON_HIDE = [
    'scroll.tooltip',
    'joditCloseDialog',
    'mouseleave.tooltip'
];
var JODIT_EVENTS_ON_HIDE = [
    'escape.tooltip',
    'change.tooltip',
    'changePlace.tooltip',
    'afterOpenPopup.tooltip',
    'hidePopup.tooltip',
    'beforePopupClose.tooltip',
    'closeAllPopups.tooltip'
];
var UITooltip = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(UITooltip, _super);
    function UITooltip(view) {
        var _this = _super.call(this, view) || this;
        _this.__isOpened = false;
        _this.__attachedContainers = new Set();
        _this.__listenClose = false;
        _this.__currentTarget = null;
        _this.__delayShowTimeout = 0;
        _this.__hideTimeout = 0;
        if (!view.o.textIcons &&
            view.o.showTooltip &&
            !view.o.useNativeTooltip) {
            _this.j.e.on('getContainer', function (box) {
                _this.__onAttach(box);
            });
            view.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, function () {
                _this.__onAttach(_this.j.container);
            });
        }
        return _this;
    }
    UITooltip_1 = UITooltip;
    UITooltip.prototype.className = function () {
        return 'UITooltip';
    };
    UITooltip.prototype.render = function () {
        return '<div><div class="&__content"></div></div>';
    };
    UITooltip.prototype.__onAttach = function (container) {
        // TODO Move it inside __show method. Now it is here because testcase failed with capturing
        (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .getContainer */ .My)(this.j, UITooltip_1).appendChild(this.container);
        this.__attachedContainers.add(container);
        this.__attachedContainers.add(this.j.container);
        this.j.e
            .on(container, 'mouseenter.tooltip', this.__onMouseEnter, {
            capture: true
        })
            .on(container, 'mouseleave.tooltip', this.__onMouseLeave, {
            capture: true
        })
            .on(this.j.container, 'mouseleave.tooltip', this.__onMouseLeave, {
            capture: true
        });
    };
    UITooltip.prototype.__addListenersOnEnter = function () {
        if (this.__listenClose) {
            return;
        }
        this.__listenClose = true;
        var view = this.j;
        view.e
            .on(view.ow, WINDOW_EVENTS_ON_HIDE, this.__hide)
            .on(JODIT_EVENTS_ON_HIDE, this.__hide);
    };
    UITooltip.prototype.__removeListenersOnLeave = function () {
        if (!this.__listenClose) {
            return;
        }
        this.__listenClose = false;
        var view = this.j;
        view.e
            .off(view.ow, WINDOW_EVENTS_ON_HIDE, this.__hide)
            .off(JODIT_EVENTS_ON_HIDE, this.__hide);
    };
    UITooltip.prototype.__onMouseLeave = function (e) {
        if (this.__currentTarget === e.target) {
            this.__hideDelay();
            this.__currentTarget = null;
        }
    };
    UITooltip.prototype.__onMouseEnter = function (e) {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(e.target)) {
            return;
        }
        var tooltip = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(e.target, 'aria-label');
        if (!tooltip) {
            return;
        }
        var disabled = Boolean((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(e.target, 'disabled'));
        if (disabled) {
            return;
        }
        var isOwn = e.target.className.includes('jodit');
        if (!isOwn) {
            return;
        }
        this.__currentTarget = e.target;
        var target = e.target;
        this.__open(function () {
            var pos = (0,jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_7__/* .position */ .G)(target);
            return {
                x: pos.left + pos.width / 2,
                y: pos.top + pos.height
            };
        }, tooltip);
    };
    UITooltip.prototype.__open = function (getPoint, content) {
        var _this = this;
        this.__addListenersOnEnter();
        this.__isOpened = true;
        this.j.async.clearTimeout(this.__hideTimeout);
        this.j.async.clearTimeout(this.__delayShowTimeout);
        var to = this.j.o.showTooltipDelay || this.j.defaultTimeout;
        if (!to) {
            this.__show(getPoint, content);
            return;
        }
        this.__delayShowTimeout = this.j.async.setTimeout(function () { return _this.__show(getPoint, content); }, to);
    };
    UITooltip.prototype.__show = function (getPoint, content) {
        this.setMod('visible', true);
        this.getElm('content').innerHTML = content;
        var point = getPoint();
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
            left: point.x,
            top: point.y
        });
    };
    UITooltip.prototype.__hide = function () {
        this.j.async.clearTimeout(this.__delayShowTimeout);
        this.j.async.clearTimeout(this.__hideTimeout);
        this.__removeListenersOnLeave();
        if (this.__isOpened) {
            this.__isOpened = false;
            this.setMod('visible', false);
            this.getElm('content').innerHTML = '';
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
                left: -5000
            });
        }
    };
    UITooltip.prototype.__hideDelay = function () {
        this.j.async.clearTimeout(this.__delayShowTimeout);
        this.j.async.clearTimeout(this.__hideTimeout);
        if (!this.__isOpened) {
            return;
        }
        this.__hideTimeout = this.async.setTimeout(this.__hide, this.j.defaultTimeout);
    };
    UITooltip.prototype.destruct = function () {
        var _this = this;
        this.__attachedContainers.forEach(function (container) {
            _this.j.e
                .off(container, 'mouseenter.tooltip', _this.__onMouseEnter)
                .off(container, 'mouseleave.tooltip', _this.__onMouseLeave);
        });
        this.__hide();
        _super.prototype.destruct.call(this);
    };
    var UITooltip_1;
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], UITooltip.prototype, "__onMouseLeave", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], UITooltip.prototype, "__onMouseEnter", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], UITooltip.prototype, "__hide", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], UITooltip.prototype, "__hideDelay", null);
    UITooltip = UITooltip_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
    ], UITooltip);
    return UITooltip;
}(jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D));



/***/ }),

/***/ 36795:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ required; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Select is required
 */
var required = function (select) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(select.value).length) {
        select.error = 'Please fill out this field';
        return false;
    }
    return true;
};


/***/ }),

/***/ 36969:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export pasteFromWord */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93324);
/* harmony import */ var jodit_plugins_paste_helpers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(90823);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








var pasteFromWord = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(pasteFromWord, _super);
    function pasteFromWord() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    pasteFromWord.prototype.afterInit = function (jodit) { };
    pasteFromWord.prototype.beforeDestruct = function (jodit) { };
    /**
     * Try if text is Word's document fragment and try process this
     */
    pasteFromWord.prototype.processWordHTML = function (e, text, texts) {
        var _this = this;
        var j = this.j, _a = j.o, processPasteFromWord = _a.processPasteFromWord, askBeforePasteFromWord = _a.askBeforePasteFromWord, defaultActionOnPasteFromWord = _a.defaultActionOnPasteFromWord, defaultActionOnPaste = _a.defaultActionOnPaste, pasteFromWordActionList = _a.pasteFromWordActionList;
        if (processPasteFromWord && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isHtmlFromWord)(text)) {
            if (askBeforePasteFromWord) {
                (0,jodit_plugins_paste_helpers__WEBPACK_IMPORTED_MODULE_6__/* .askInsertTypeDialog */ .PU)(j, 'The pasted content is coming from a Microsoft Word/Excel document. ' +
                    'Do you want to keep the format or clean it up?', 'Word Paste Detected', function (insertType) {
                    _this.insertFromWordByType(e, text, insertType, texts);
                }, pasteFromWordActionList);
            }
            else {
                this.insertFromWordByType(e, text, defaultActionOnPasteFromWord || defaultActionOnPaste, texts);
            }
            return true;
        }
        return false;
    };
    /**
     * Clear extra styles and tags from Word's pasted text
     */
    pasteFromWord.prototype.insertFromWordByType = function (e, html, insertType, texts) {
        var _a;
        switch (insertType) {
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_HTML: {
                html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.applyStyles)(html);
                var value = (_a = this.j.events) === null || _a === void 0 ? void 0 : _a.fire('beautifyHTML', html);
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
                    html = value;
                }
                break;
            }
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_TEXT: {
                html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.cleanFromWord)(html);
                break;
            }
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_ONLY_TEXT: {
                html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.stripTags)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.cleanFromWord)(html));
                break;
            }
        }
        (0,jodit_plugins_paste_helpers__WEBPACK_IMPORTED_MODULE_6__/* .pasteInsertHtml */ .sX)(e, this.j, html);
    };
    pasteFromWord.requires = ['paste'];
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':processHTML')
    ], pasteFromWord.prototype, "processWordHTML", null);
    return pasteFromWord;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('pasteFromWord', pasteFromWord);


/***/ }),

/***/ 37075:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: function() { return /* binding */ throttle; },
/* harmony export */   s: function() { return /* binding */ debounce; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




function debounce(timeout, firstCallImmediately, method) {
    if (firstCallImmediately === void 0) { firstCallImmediately = false; }
    if (method === void 0) { method = 'debounce'; }
    return function (target, propertyKey) {
        var fn = target[propertyKey];
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .Tn)(fn)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, function (component) {
            var async = component.async;
            void 0;
            var propTimeout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .Tn)(timeout)
                ? timeout(component)
                : timeout;
            var realTimout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isNumber */ .Et)(propTimeout) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Qd)(propTimeout)
                ? propTimeout
                : component.defaultTimeout;
            Object.defineProperty(component, propertyKey, {
                configurable: true,
                value: async[method](component[propertyKey].bind(component), realTimout, firstCallImmediately)
            });
        });
        return {
            configurable: true,
            get: function () {
                return fn.bind(this);
            }
        };
    };
}
/**
 * Wrap function in throttle wrapper
 */
function throttle(timeout, firstCallImmediately) {
    if (firstCallImmediately === void 0) { firstCallImmediately = false; }
    return debounce(timeout, firstCallImmediately, 'throttle');
}


/***/ }),

/***/ 37107:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 37414:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Rechtschreibprüfung'
};


/***/ }),

/***/ 37424:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ getStrongControlTypes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97369);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _get_control_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57023);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * @private
 */
function getStrongControlTypes(items, controls) {
    var elements = (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .c)(items)
        ? items
        : (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.keys)(items, false).map(function (key) {
            var value = items[key] || {};
            return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.ConfigProto)({ name: key }, value);
        });
    return elements.map(function (item) {
        return (0,_get_control_type__WEBPACK_IMPORTED_MODULE_2__/* .getControlType */ .U)(item, controls || jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.defaultOptions.controls);
    });
}


/***/ }),

/***/ 37435:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ajax: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.d; },
/* harmony export */   Alert: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Fc; },
/* harmony export */   Async: function() { return /* reexport safe */ jodit_core_async__WEBPACK_IMPORTED_MODULE_5__.j; },
/* harmony export */   Button: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.$n; },
/* harmony export */   CommitStyle: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.xk; },
/* harmony export */   Component: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.uA; },
/* harmony export */   Confirm: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.pT; },
/* harmony export */   ContextMenu: function() { return /* reexport safe */ _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__.t; },
/* harmony export */   Create: function() { return /* reexport safe */ jodit_core_create__WEBPACK_IMPORTED_MODULE_6__.X; },
/* harmony export */   Dialog: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.lG; },
/* harmony export */   Dom: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.J; },
/* harmony export */   EventEmitter: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.bk; },
/* harmony export */   EventHandlersStore: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.d$; },
/* harmony export */   Eventify: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.h5; },
/* harmony export */   FileBrowser: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_4__.V; },
/* harmony export */   Helpers: function() { return /* reexport module object */ jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   History: function() { return /* reexport safe */ _history_history__WEBPACK_IMPORTED_MODULE_14__.B; },
/* harmony export */   Icon: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.In; },
/* harmony export */   ImageEditor: function() { return /* reexport safe */ _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__.n; },
/* harmony export */   LazyWalker: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.p; },
/* harmony export */   Plugin: function() { return /* reexport safe */ jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__.k; },
/* harmony export */   PluginSystem: function() { return /* reexport safe */ jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__.$; },
/* harmony export */   Popup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.zD; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.z2; },
/* harmony export */   Prompt: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.XG; },
/* harmony export */   Response: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.Y; },
/* harmony export */   STATUSES: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.f; },
/* harmony export */   Selection: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.LN; },
/* harmony export */   Snapshot: function() { return /* reexport safe */ _history_snapshot__WEBPACK_IMPORTED_MODULE_15__.F; },
/* harmony export */   StatusBar: function() { return /* reexport safe */ _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__.e; },
/* harmony export */   Table: function() { return /* reexport safe */ _table_table__WEBPACK_IMPORTED_MODULE_19__.X; },
/* harmony export */   ToolbarButton: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.IB; },
/* harmony export */   ToolbarCollection: function() { return /* reexport safe */ _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__.Q; },
/* harmony export */   ToolbarContent: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.P1; },
/* harmony export */   ToolbarEditorCollection: function() { return /* reexport safe */ _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__.b; },
/* harmony export */   ToolbarSelect: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.q4; },
/* harmony export */   UIBlock: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Yh; },
/* harmony export */   UIButton: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.lD; },
/* harmony export */   UIButtonGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ss; },
/* harmony export */   UIButtonState: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ue; },
/* harmony export */   UICheckbox: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.cY; },
/* harmony export */   UIElement: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.D$; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.nE; },
/* harmony export */   UIForm: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.XV; },
/* harmony export */   UIGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Ue; },
/* harmony export */   UIInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.tS; },
/* harmony export */   UIList: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.z4; },
/* harmony export */   UIMessages: function() { return /* reexport safe */ _messages_messages__WEBPACK_IMPORTED_MODULE_17__.N; },
/* harmony export */   UISelect: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.$6; },
/* harmony export */   UISeparator: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.CP; },
/* harmony export */   UISpacer: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.bk; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.F0; },
/* harmony export */   UITooltip: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.SB; },
/* harmony export */   Uploader: function() { return /* reexport safe */ _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__.d; },
/* harmony export */   View: function() { return /* reexport safe */ jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__.S; },
/* harmony export */   ViewComponent: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.vG; },
/* harmony export */   ViewWithToolbar: function() { return /* reexport safe */ jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__.T; },
/* harmony export */   defaultNameSpace: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.Xr; },
/* harmony export */   observable: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.sH; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34248);
/* harmony import */ var _dialog___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34256);
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19627);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_create__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40594);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(53883);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(77782);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(14961);
/* harmony import */ var _history_history__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(69996);
/* harmony import */ var _history_snapshot__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(58770);
/* harmony import */ var _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(53804);
/* harmony import */ var _messages_messages__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(91902);
/* harmony import */ var _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(62870);
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(11648);
/* harmony import */ var _toolbar_button__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(5832);
/* harmony import */ var _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(97394);
/* harmony import */ var _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(90428);
/* harmony import */ var _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(26538);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(77402);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(87332);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/README.md]]
 * @packageDocumentation
 * @module modules
 */






























/***/ }),

/***/ 37474:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ Component; }
/* harmony export */ });
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




var StatusListHandlers = new Map();
/**
 * The base class of all Jodit UI components. Provides work with a life cycle.
 */
var Component = /** @class */ (function () {
    function Component() {
        this.async = new jodit_core_async__WEBPACK_IMPORTED_MODULE_0__/* .Async */ .j();
        /**
         * The window in which jodit was created
         */
        this.ownerWindow = window;
        this.__componentStatus = jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeInit;
        this.uid = 'jodit-uid-' + (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .uniqueUid */ .w9)();
    }
    Object.defineProperty(Component.prototype, "componentName", {
        get: function () {
            if (!this.__componentName) {
                this.__componentName =
                    'jodit-' +
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(this.className) ? this.className() : '') ||
                            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getClassName)(this));
            }
            return this.__componentName;
        },
        enumerable: false,
        configurable: true
    });
    Component.prototype.getFullElName = function (elementName, mod, modValue) {
        var result = [this.componentName];
        if (elementName) {
            elementName = elementName.replace(/[^a-z0-9-]/gi, '-');
            result.push("__".concat(elementName));
        }
        if (mod) {
            result.push('_', mod);
            result.push('_', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(modValue) ? 'true' : modValue.toString());
        }
        return result.join('');
    };
    Object.defineProperty(Component.prototype, "ownerDocument", {
        /**
         * The document in which jodit was created
         */
        get: function () {
            return this.ow.document;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "od", {
        /**
         * Shortcut for `this.ownerDocument`
         */
        get: function () {
            return this.ownerDocument;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "ow", {
        get: function () {
            return this.ownerWindow;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Safe get any field
     * @example
     * ```js
     * private a = {
     * 	b: {
     * 		c: {
     * 			e: {
     * 				g: {
     * 					color: 'red'
     * 				}
     * 			}
     * 		}
     * 	}
     * }
     *
     * this.get('a.b.c.e.g.color'); // Safe access to color
     * // instead using optionsl chaining
     * this?.a?.b?.c?.e?.g?.color
     * ```
     *
     * @param chain - the path to be traversed in the obj object
     * @param obj - the object in which the value is searched
     */
    Component.prototype.get = function (chain, obj) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.get)(chain, obj || this);
    };
    Object.defineProperty(Component.prototype, "isReady", {
        /**
         * Component is ready for work
         */
        get: function () {
            return this.componentStatus === jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.ready;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "isDestructed", {
        /**
         * Component was destructed
         */
        get: function () {
            return this.componentStatus === jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "isInDestruct", {
        /**
         * The component is currently undergoing destructuring or has already been destroyed.
         * Those. you should not the app froze new events on him now or do anything else with him.
         */
        get: function () {
            return (jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeDestruct === this.componentStatus ||
                jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed === this.componentStatus);
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Bind destructor to some View
     */
    Component.prototype.bindDestruct = function (component) {
        var _this = this;
        component.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeDestruct, function () { return !_this.isInDestruct && _this.destruct(); });
        return this;
    };
    /**
     * Destruct component method
     */
    Component.prototype.destruct = function () {
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed);
        if (this.async) {
            this.async.destruct();
            // @ts-ignore
            this.async = undefined;
        }
        if (StatusListHandlers.get(this)) {
            StatusListHandlers.delete(this);
        }
        // @ts-ignore
        this.ownerWindow = undefined;
    };
    Object.defineProperty(Component.prototype, "componentStatus", {
        /**
         * Current component status
         */
        get: function () {
            return this.__componentStatus;
        },
        /**
         * Setter for current component status
         */
        set: function (componentStatus) {
            this.setStatus(componentStatus);
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Set component status
     * @param componentStatus - component status
     * @see ComponentStatus
     */
    Component.prototype.setStatus = function (componentStatus) {
        return this.setStatusComponent(componentStatus, this);
    };
    /**
     * Set status recursively on all parents
     */
    Component.prototype.setStatusComponent = function (componentStatus, component) {
        if (componentStatus === this.__componentStatus) {
            return;
        }
        if (component === this) {
            this.__componentStatus = componentStatus;
        }
        var proto = Object.getPrototypeOf(this);
        if (proto && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(proto.setStatusComponent)) {
            proto.setStatusComponent(componentStatus, component);
        }
        var statuses = StatusListHandlers.get(this), list = statuses === null || statuses === void 0 ? void 0 : statuses[componentStatus];
        if (list && list.length) {
            list.forEach(function (cb) { return cb(component); });
        }
    };
    /**
     * Adds a handler for changing the component's status
     *
     * @param status - the status at which the callback is triggered
     * @param callback - a function that will be called when the status is `status`
     */
    Component.prototype.hookStatus = function (status, callback) {
        var list = StatusListHandlers.get(this);
        if (!list) {
            list = {};
            StatusListHandlers.set(this, list);
        }
        if (!list[status]) {
            list[status] = [];
        }
        list[status].push(callback);
    };
    Component.isInstanceOf = function (c, constructorFunc) {
        return c instanceof constructorFunc;
    };
    Component.STATUSES = jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f;
    return Component;
}());



/***/ }),

/***/ 37605:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'رمز'
};


/***/ }),

/***/ 37649:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: function() { return /* binding */ transactions; },
/* harmony export */   x: function() { return /* binding */ states; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87332);
/* harmony import */ var jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97621);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var _a;






var states = {
    START: 'START',
    ELEMENT: 'ELEMENT',
    UNWRAP: 'UNWRAP',
    UNWRAP_CHILDREN: 'UNWRAP_CHILDREN',
    CHANGE: 'CHANGE',
    REPLACE_DEFAULT: 'REPLACE_DEFAULT',
    LIST: 'LIST',
    TOGGLE_LIST: 'TOGGLE_LIST',
    WRAP: 'WRAP',
    EXTRACT: 'EXTRACT',
    END: 'END'
};
var transactions = (_a = {},
    _a[states.START] = {
        exec: function (value) {
            var element = value.element, jodit = value.jodit, style = value.style, mode = value.mode, collapsed = value.collapsed;
            if ((0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .isInsideInvisibleElement */ .iu)(element, jodit.editor) ||
                (!collapsed && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmptyContent(element))) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.END });
            }
            var elm = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .getSuitParent */ .AS)(style, element, jodit.editor) ||
                (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .getSuitChild */ .G6)(style, element);
            if (elm) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.ELEMENT, element: elm });
            }
            var suit = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .suitableClosest */ .$s)(style, element, jodit.editor);
            if (style.elementIsList && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isList(suit)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.LIST });
            }
            if (suit) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.EXTRACT });
            }
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ ? states.UNWRAP_CHILDREN : states.END });
        }
    },
    _a[states.LIST] = {
        exec: function (value) {
            var element = value.element, jodit = value.jodit, mode = value.mode;
            if (mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI && mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ && mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .REPLACE */ .dj) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.END });
            }
            var li = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(element, 'li', jodit.editor);
            if (!li) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.END });
            }
            var list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS, jodit.editor);
            if (list) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { element: li, next: states.TOGGLE_LIST });
            }
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.END });
        }
    },
    _a[states.TOGGLE_LIST] = {
        exec: function (value) {
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { mode: (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleOrderedList */ .ks)(value.style, value.element, value.jodit, value.mode), next: states.END });
        }
    },
    _a[states.EXTRACT] = {
        exec: function (value) {
            var element = value.element, jodit = value.jodit, style = value.style;
            var suit = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .suitableClosest */ .$s)(style, element, jodit.editor);
            void 0;
            if (!style.elementIsBlock) {
                (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .extractSelectedPart */ .yP)(suit, element, jodit);
            }
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { element: suit, next: states.ELEMENT });
        }
    },
    _a[states.UNWRAP_CHILDREN] = {
        exec: function (value) {
            var element = value.element, style = value.style;
            if (!(0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .unwrapChildren */ .tm)(style, element)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.WRAP });
            }
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ, next: states.END });
        }
    },
    _a[states.WRAP] = {
        exec: function (value) {
            var element = value.element, jodit = value.jodit, style = value.style;
            var wrapper = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .wrap */ .LV)(style, element, jodit);
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: style.elementIsList ? states.END : states.CHANGE, mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .WRAP */ .Zk, element: wrapper });
        }
    },
    _a[states.ELEMENT] = {
        exec: function (value) {
            var style = value.style, element = value.element, jodit = value.jodit;
            if ((0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleAttributes */ .Yx)(style, element, jodit, jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI, true) !==
                jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.CHANGE });
            }
            // Apply same color for anchor https://github.com/xdan/jodit/issues/936
            if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(element, style.element)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.END });
            }
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.UNWRAP });
        }
    },
    _a[states.CHANGE] = {
        exec: function (value) {
            var style = value.style, element = value.element, jodit = value.jodit, mode = value.mode;
            var newMode = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleAttributes */ .Yx)(style, element, jodit, value.mode);
            if (mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .WRAP */ .Zk &&
                newMode === jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNSET */ .Ag &&
                !element.attributes.length &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(element, style.element)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.UNWRAP });
            }
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { mode: newMode, next: states.END });
        }
    },
    _a[states.UNWRAP] = {
        exec: function (value) {
            if (value.element.attributes.length &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(value.element, value.style.element)) {
                return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { next: states.REPLACE_DEFAULT });
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(value.element);
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ, next: states.END });
        }
    },
    _a[states.REPLACE_DEFAULT] = {
        exec: function (value) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.replace(value.element, value.style.defaultTag, value.jodit.createInside, true);
            return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__assign */ .Cl)({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .REPLACE */ .dj, next: states.END });
        }
    },
    _a[states.END] = {
        exec: function (value) {
            return value;
        }
    },
    _a);


/***/ }),

/***/ 37923:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ isArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if element is array
 */
function isArray(elm) {
    return Array.isArray(elm);
}


/***/ }),

/***/ 38046:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ isNormalNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Is normal usual element
 * @private
 */
function isNormalNode(elm) {
    return Boolean(elm &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmptyTextNode(elm) &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTemporary(elm) &&
        !(0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(elm));
}


/***/ }),

/***/ 38101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export cleanHtml */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_dom_lazy_walker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8453);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26328);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(74646);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15396);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * Clean HTML after removeFormat and insertHorizontalRule command
 */
var cleanHtml = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(cleanHtml, _super);
    function cleanHtml() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(arguments), false)) || this;
        /** @override */
        _this.buttons = [
            {
                name: 'eraser',
                group: 'font-style'
            }
        ];
        _this.currentSelectionNode = null;
        _this.walker = new jodit_core_dom_lazy_walker__WEBPACK_IMPORTED_MODULE_2__/* .LazyWalker */ .p(_this.j.async, {
            timeout: _this.j.o.cleanHTML.timeout
        });
        return _this;
    }
    /** @override */
    cleanHtml.prototype.afterInit = function (jodit) { };
    Object.defineProperty(cleanHtml.prototype, "isEditMode", {
        get: function () {
            return !(this.j.isInDestruct ||
                !this.j.isEditorMode() ||
                this.j.getReadOnly());
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Clean HTML code on every change
     */
    cleanHtml.prototype.onChangeCleanHTML = function () {
        if (!this.isEditMode) {
            return;
        }
        var editor = this.j;
        this.walker.setWork(editor.editor);
        this.currentSelectionNode = editor.s.current();
    };
    cleanHtml.prototype.startWalker = function () {
        var _this = this;
        var jodit = this.jodit;
        var allow = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getHash */ .Zd)(this.j.o.cleanHTML.allowTags);
        var deny = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getHash */ .Zd)(this.j.o.cleanHTML.denyTags);
        this.walker
            .on('visit', function (node) {
            return (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .visitNodeWalker */ .eZ)(jodit, node, allow, deny, _this.currentSelectionNode);
        })
            .on('end', function (affected) {
            _this.j.e.fire(affected
                ? 'internalChange finishedCleanHTMLWorker'
                : 'finishedCleanHTMLWorker');
        });
    };
    cleanHtml.prototype.beforeCommand = function (command) {
        if (command.toLowerCase() === 'removeformat') {
            if (this.j.s.isCollapsed()) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .removeFormatForCollapsedSelection */ .w5)(this.j);
            }
            else {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .removeFormatForSelection */ .hk)(this.j);
            }
            return false;
        }
    };
    /**
     * Event handler when manually assigning a value to the HTML editor.
     */
    cleanHtml.prototype.onBeforeSetNativeEditorValue = function (data) {
        var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(this.j.o.cleanHTML.useIframeSandbox
            ? this.j.createInside.sandbox()
            : [this.j.createInside.div()], 2), sandBox = _a[0], iframe = _a[1];
        sandBox.innerHTML = data.value;
        this.onSafeHTML(sandBox);
        data.value = sandBox.innerHTML;
        (0,jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_4__/* .safeHTML */ .t)(sandBox, { safeJavaScriptLink: true, removeOnError: true });
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(iframe);
        return false;
    };
    cleanHtml.prototype.onSafeHTML = function (sandBox) {
        (0,jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_4__/* .safeHTML */ .t)(sandBox, this.j.o.cleanHTML);
    };
    /** @override */
    cleanHtml.prototype.beforeDestruct = function () {
        this.walker.destruct();
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':change', ':afterSetMode', ':afterInit', ':mousedown', ':keydown'])
    ], cleanHtml.prototype, "onChangeCleanHTML", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
    ], cleanHtml.prototype, "startWalker", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':beforeCommand')
    ], cleanHtml.prototype, "beforeCommand", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':beforeSetNativeEditorValue')
    ], cleanHtml.prototype, "onBeforeSetNativeEditorValue", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':safeHTML')
    ], cleanHtml.prototype, "onSafeHTML", null);
    return cleanHtml;
}(jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('cleanHtml', cleanHtml);


/***/ }),

/***/ 38271:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ toggleAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(95350);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(72197);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(12043);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











var tak = 'toggleAttributes';
/**
 * Toggles attributes
 * @private
 */
function toggleAttributes(commitStyle, elm, jodit, mode, dry) {
    if (dry === void 0) { dry = false; }
    if (!dry && commitStyle.isApplied(elm, tak)) {
        return mode;
    }
    !dry && commitStyle.setApplied(elm, tak);
    var attributes = commitStyle.options.attributes;
    if (attributes && (0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_4__/* .size */ .E)(attributes) > 0) {
        Object.keys(attributes).forEach(function (key) {
            var value = attributes[key];
            switch (key) {
                case 'style': {
                    mode = toggleStyle(commitStyle, jodit, value, elm, dry, mode);
                    break;
                }
                case 'className':
                case 'class':
                    mode = toggleClass(jodit, value, elm, mode, dry);
                    break;
                default:
                    mode = toggleAttribute(jodit, value, elm, key, dry, mode);
            }
        });
    }
    return mode;
}
function toggleStyle(commitStyle, jodit, style, elm, dry, mode) {
    void 0;
    Object.keys(style).forEach(function (rule) {
        var inlineValue = elm.style.getPropertyValue((0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_7__/* .kebabCase */ .k)(rule));
        var newValue = style[rule];
        if (inlineValue === '' && newValue == null) {
            return;
        }
        if (getNativeCSSValue(jodit, elm, rule) ===
            (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_8__/* .normalizeCssValue */ .iy)(rule, newValue)) {
            if (!inlineValue) {
                return;
            }
            !dry && (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(elm, rule, null);
            mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNSET */ .Ag;
            mode = removeExtraStyleAttribute(commitStyle, elm, mode);
            return;
        }
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .CHANGE */ .PL;
        if (!dry) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(elm, rule, newValue);
            mode = removeExtraStyleAttribute(commitStyle, elm, mode);
        }
    });
    return mode;
}
function toggleClass(jodit, value, elm, mode, dry) {
    void 0;
    var hook = jodit.e.fire.bind(jodit.e, "".concat(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* ._PREFIX */ .ar, "AfterToggleAttribute"));
    if (elm.classList.contains(value.toString())) {
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNSET */ .Ag;
        if (!dry) {
            elm.classList.remove(value);
            if (elm.classList.length === 0) {
                (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, 'class', null);
                hook(mode, elm, 'class', null);
            }
        }
    }
    else {
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .CHANGE */ .PL;
        if (!dry) {
            elm.classList.add(value);
            hook(mode, elm, 'class', value);
        }
    }
    return mode;
}
function toggleAttribute(jodit, value, elm, key, dry, mode) {
    void 0;
    var hook = jodit.e.fire.bind(jodit.e, "".concat(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* ._PREFIX */ .ar, "AfterToggleAttribute"));
    if ((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, key) === value) {
        !dry && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, key, null);
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNSET */ .Ag;
        !dry && hook(mode, elm, key, value);
        return mode;
    }
    mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .CHANGE */ .PL;
    if (!dry) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, key, value);
        hook(mode, elm, key, value);
    }
    return mode;
}
/**
 * If the element has an empty style attribute, it removes the attribute,
 * and if it is default, it removes the element itself
 */
function removeExtraStyleAttribute(commitStyle, elm, mode) {
    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, 'style')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, 'style', null);
        if (elm.tagName.toLowerCase() === commitStyle.defaultTag) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(elm);
            mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNWRAP */ .OJ;
        }
    }
    return mode;
}
/**
 * Creates an iframe into which elements will be inserted to test their default styles in the browser
 */
function getShadowRoot(jodit) {
    var _a;
    if ((0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__/* .dataBind */ .m)(jodit, 'shadowRoot') !== undefined) {
        return (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__/* .dataBind */ .m)(jodit, 'shadowRoot');
    }
    var container = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .getContainer */ .My)(jodit);
    var iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
    (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(iframe, {
        width: 0,
        height: 0,
        position: 'absolute',
        border: 0
    });
    iframe.src = 'about:blank';
    container.appendChild(iframe);
    var doc = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document;
    var shadowRoot = !doc ? jodit.od.body : doc.body;
    (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__/* .dataBind */ .m)(jodit, 'shadowRoot', shadowRoot);
    return shadowRoot;
}
/**
 * `strong -> fontWeight 700`
 */
function getNativeCSSValue(jodit, elm, key) {
    var newElm = jodit.create.element(elm.tagName.toLowerCase());
    newElm.style.cssText = elm.style.cssText;
    var root = getShadowRoot(jodit);
    root.appendChild(newElm);
    var result = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(newElm, key);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(newElm);
    return result;
}


/***/ }),

/***/ 38309:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31686);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function video(editor) {
    editor.registerButton({
        name: 'video',
        group: 'media'
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('video', video);


/***/ }),

/***/ 38322:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ css; },
/* harmony export */   a: function() { return /* binding */ clearCenterAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9810);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(449);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Get the value of a computed style property for the first element in the set of matched elements or set one or
 * more CSS properties for every matched element
 *
 * @param element - HTML element
 * @param key - An object of property-value pairs to set. A CSS property name.
 * @param value - A value to set for the property.
 * @param onlyStyleMode - Get value from style attribute, without calculating
 */
function css(element, key, value, onlyStyleMode) {
    if (onlyStyleMode === void 0) { onlyStyleMode = false; }
    if ((0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_0__/* .isBoolean */ .L)(value)) {
        onlyStyleMode = value;
        value = undefined;
    }
    if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Q)(key) || value !== undefined) {
        var setValue = function (elm, _key, _value) {
            _value = (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssNumericValue */ .n8)(_key, _value);
            if (_value !== undefined &&
                (_value == null ||
                    css(elm, _key, true) !== (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssValue */ .iy)(_key, _value))) {
                elm.style[_key] = _value;
            }
        };
        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Q)(key)) {
            var keys = Object.keys(key);
            for (var j = 0; j < keys.length; j += 1) {
                setValue(element, (0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__/* .camelCase */ .x)(keys[j]), key[keys[j]]);
            }
        }
        else {
            setValue(element, (0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__/* .camelCase */ .x)(key), value);
        }
        return '';
    }
    var key2 = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__/* .kebabCase */ .k)(key), doc = element.ownerDocument || document, win = doc ? doc.defaultView || doc.parentWindow : false;
    var currentValue = element.style[key];
    var result = '';
    if (currentValue !== undefined && currentValue !== '') {
        result = currentValue;
    }
    else if (win && !onlyStyleMode) {
        result = win.getComputedStyle(element).getPropertyValue(key2);
    }
    if (jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .NUMBER_FIELDS_REG */ .b$.test(key) &&
        /^[-+]?[0-9.]+px$/.test(result.toString())) {
        result = parseInt(result.toString(), 10);
    }
    return (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssValue */ .iy)(key, result);
}
/**
 * Clear center align
 */
var clearCenterAlign = function (image) {
    if (css(image, 'display') === 'block') {
        css(image, 'display', '');
    }
    var style = image.style;
    if (style.marginLeft === 'auto' && style.marginRight === 'auto') {
        style.marginLeft = '';
        style.marginRight = '';
    }
};


/***/ }),

/***/ 38373:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export copyFormat */
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var _copy_format_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3843);
/* harmony import */ var _copy_format_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_copy_format_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(94628);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







var pluginKey = 'copy-format';
/**
 * Plug-in copy and paste formatting from one element to another
 */
var copyStyles = [
    'fontWeight',
    'fontStyle',
    'fontSize',
    'color',
    'margin',
    'padding',
    'borderWidth',
    'borderStyle',
    'borderColor',
    'borderRadius',
    'backgroundColor',
    'textDecorationLine',
    'fontFamily'
];
var getStyle = function (editor, key, box, defaultStyles) {
    var result = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__/* .css */ .A)(box, key);
    if (result === defaultStyles[key]) {
        if (box.parentNode &&
            box !== editor.editor &&
            box.parentNode !== editor.editor) {
            result = getStyle(editor, key, box.parentNode, defaultStyles);
        }
        else {
            result = undefined;
        }
    }
    return result;
};
var getStyles = function (editor, box, defaultStyles) {
    var result = {};
    if (box) {
        copyStyles.forEach(function (key) {
            result[key] = getStyle(editor, key, box, defaultStyles);
            if (key.match(/border(Style|Color)/) && !result.borderWidth) {
                result[key] = undefined;
            }
        });
    }
    return result;
};
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.copyformat = {
    exec: function (editor, current, _a) {
        var button = _a.button;
        if (!current) {
            return;
        }
        if (editor.buffer.exists(pluginKey)) {
            editor.buffer.delete(pluginKey);
            editor.e.off(editor.editor, 'mouseup.' + pluginKey);
        }
        else {
            var defaultStyles_1 = {}, box = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(current, function (elm) { return elm && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(elm); }, editor.editor) || editor.editor;
            var ideal_1 = editor.createInside.span();
            editor.editor.appendChild(ideal_1);
            copyStyles.forEach(function (key) {
                defaultStyles_1[key] = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__/* .css */ .A)(ideal_1, key);
            });
            if (ideal_1 !== editor.editor) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(ideal_1);
            }
            var format_1 = getStyles(editor, box, defaultStyles_1);
            var onMouseUp = function () {
                editor.buffer.delete(pluginKey);
                var currentNode = editor.s.current();
                if (currentNode) {
                    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(currentNode, 'img')) {
                        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__/* .css */ .A)(currentNode, format_1);
                    }
                    else {
                        editor.s.commitStyle({
                            attributes: {
                                style: format_1
                            }
                        });
                    }
                }
                editor.e.off(editor.editor, 'mouseup.' + pluginKey);
            };
            editor.e.on(editor.editor, 'mouseup.' + pluginKey, onMouseUp);
            editor.buffer.set(pluginKey, true);
        }
        button.update();
    },
    isActive: function (editor) { return editor.buffer.exists(pluginKey); },
    tooltip: 'Paint format'
};
function copyFormat(editor) {
    editor.registerButton({
        name: 'copyformat',
        group: 'clipboard'
    });
    (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .extendLang */ .JW)(_langs__WEBPACK_IMPORTED_MODULE_5__);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('copyformat', copyFormat);
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.set('copyformat', (_copy_format_svg__WEBPACK_IMPORTED_MODULE_4___default()));


/***/ }),

/***/ 38681:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 18.151 18.151\" xmlns=\"http://www.w3.org/2000/svg\"> <g> <path stroke-width=\"0\" d=\"M6.237,16.546H3.649V1.604h5.916v5.728c0.474-0.122,0.968-0.194,1.479-0.194 c0.042,0,0.083,0.006,0.125,0.006V0H2.044v18.15h5.934C7.295,17.736,6.704,17.19,6.237,16.546z\"/> <path stroke-width=\"0\" d=\"M11.169,8.275c-2.723,0-4.938,2.215-4.938,4.938s2.215,4.938,4.938,4.938s4.938-2.215,4.938-4.938 S13.892,8.275,11.169,8.275z M11.169,16.81c-1.983,0-3.598-1.612-3.598-3.598c0-1.983,1.614-3.597,3.598-3.597 s3.597,1.613,3.597,3.597C14.766,15.198,13.153,16.81,11.169,16.81z\"/> <polygon stroke-width=\"0\" points=\"11.792,11.073 10.502,11.073 10.502,12.578 9.03,12.578 9.03,13.868 10.502,13.868 10.502,15.352 11.792,15.352 11.792,13.868 13.309,13.868 13.309,12.578 11.792,12.578 \"/> </g> </svg>"

/***/ }),

/***/ 39053:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ar: function() { return /* reexport module object */ _ar_js__WEBPACK_IMPORTED_MODULE_0__; },
/* harmony export */   cs_cz: function() { return /* reexport module object */ _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   de: function() { return /* reexport module object */ _de_js__WEBPACK_IMPORTED_MODULE_2__; },
/* harmony export */   es: function() { return /* reexport module object */ _es_js__WEBPACK_IMPORTED_MODULE_3__; },
/* harmony export */   fa: function() { return /* reexport module object */ _fa_js__WEBPACK_IMPORTED_MODULE_4__; },
/* harmony export */   fi: function() { return /* reexport module object */ _fi_js__WEBPACK_IMPORTED_MODULE_5__; },
/* harmony export */   fr: function() { return /* reexport module object */ _fr_js__WEBPACK_IMPORTED_MODULE_6__; },
/* harmony export */   he: function() { return /* reexport module object */ _he_js__WEBPACK_IMPORTED_MODULE_7__; },
/* harmony export */   hu: function() { return /* reexport module object */ _hu_js__WEBPACK_IMPORTED_MODULE_8__; },
/* harmony export */   id: function() { return /* reexport module object */ _id_js__WEBPACK_IMPORTED_MODULE_9__; },
/* harmony export */   it: function() { return /* reexport module object */ _it_js__WEBPACK_IMPORTED_MODULE_10__; },
/* harmony export */   ja: function() { return /* reexport module object */ _ja_js__WEBPACK_IMPORTED_MODULE_11__; },
/* harmony export */   ko: function() { return /* reexport module object */ _ko_js__WEBPACK_IMPORTED_MODULE_12__; },
/* harmony export */   mn: function() { return /* reexport module object */ _mn_js__WEBPACK_IMPORTED_MODULE_13__; },
/* harmony export */   nl: function() { return /* reexport module object */ _nl_js__WEBPACK_IMPORTED_MODULE_14__; },
/* harmony export */   pl: function() { return /* reexport module object */ _pl_js__WEBPACK_IMPORTED_MODULE_15__; },
/* harmony export */   pt_br: function() { return /* reexport module object */ _pt_br_js__WEBPACK_IMPORTED_MODULE_16__; },
/* harmony export */   ru: function() { return /* reexport module object */ _ru_js__WEBPACK_IMPORTED_MODULE_17__; },
/* harmony export */   tr: function() { return /* reexport module object */ _tr_js__WEBPACK_IMPORTED_MODULE_18__; },
/* harmony export */   ua: function() { return /* reexport module object */ _ua_js__WEBPACK_IMPORTED_MODULE_19__; },
/* harmony export */   zh_cn: function() { return /* reexport module object */ _zh_cn_js__WEBPACK_IMPORTED_MODULE_20__; },
/* harmony export */   zh_tw: function() { return /* reexport module object */ _zh_tw_js__WEBPACK_IMPORTED_MODULE_21__; }
/* harmony export */ });
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14100);
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_ar_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10229);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_cs_cz_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10572);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_de_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27671);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_es_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _fa_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(30382);
/* harmony import */ var _fa_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_fa_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _fi_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(14950);
/* harmony import */ var _fi_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_fi_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85051);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_fr_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _he_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2928);
/* harmony import */ var _he_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_he_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(29920);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_hu_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _id_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(65226);
/* harmony import */ var _id_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_id_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(51162);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_it_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(4410);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_ja_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _ko_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(84777);
/* harmony import */ var _ko_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_ko_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _mn_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(25884);
/* harmony import */ var _mn_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_mn_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(46433);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_nl_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(42055);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_pl_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(70846);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_pt_br_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _ru_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15966);
/* harmony import */ var _ru_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_ru_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(41145);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_tr_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _ua_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(71289);
/* harmony import */ var _ua_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_ua_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(76877);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(_zh_cn_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(83289);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(_zh_tw_js__WEBPACK_IMPORTED_MODULE_21__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

























/***/ }),

/***/ 39147:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export resizeCells */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(37435);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36001);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









var key = 'table_processor_observer-resize';
/**
 * Process tables in editor
 */
var resizeCells = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(resizeCells, _super);
    function resizeCells() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__read */ .zs)(arguments), false)) || this;
        _this.selectMode = false;
        _this.resizeDelta = 0;
        _this.createResizeHandle = function () {
            if (!_this.resizeHandler) {
                _this.resizeHandler = _this.j.c.div('jodit-table-resizer');
                _this.j.e
                    .on(_this.resizeHandler, 'mousedown.table touchstart.table', _this.onHandleMouseDown)
                    .on(_this.resizeHandler, 'mouseenter.table', function () {
                    _this.j.async.clearTimeout(_this.hideTimeout);
                });
            }
        };
        _this.hideTimeout = 0;
        _this.drag = false;
        _this.minX = 0;
        _this.maxX = 0;
        _this.startX = 0;
        return _this;
    }
    Object.defineProperty(resizeCells.prototype, "module", {
        /**
         * Shortcut for Table module
         */
        get: function () {
            return this.j.getInstance('Table', this.j.o);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(resizeCells.prototype, "isRTL", {
        /**
         * Now editor has rtl direction
         */
        get: function () {
            return this.j.o.direction === 'rtl';
        },
        enumerable: false,
        configurable: true
    });
    resizeCells.prototype.showResizeHandle = function () {
        this.j.async.clearTimeout(this.hideTimeout);
        this.j.workplace.appendChild(this.resizeHandler);
    };
    resizeCells.prototype.hideResizeHandle = function () {
        var _this = this;
        this.hideTimeout = this.j.async.setTimeout(function () {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(_this.resizeHandler);
        }, {
            timeout: this.j.defaultTimeout,
            label: 'hideResizer'
        });
    };
    /**
     * Click on resize handle
     */
    resizeCells.prototype.onHandleMouseDown = function (event) {
        var _this = this;
        if (this.j.isLocked) {
            return;
        }
        this.drag = true;
        this.j.e
            .on(this.j.ow, 'mouseup.resize-cells touchend.resize-cells', this.onMouseUp)
            .on(this.j.ew, 'mousemove.table touchmove.table', this.onMouseMove);
        this.startX = event.clientX;
        this.j.lock(key);
        this.resizeHandler.classList.add('jodit-table-resizer_moved');
        var box, tableBox = this.workTable.getBoundingClientRect();
        this.minX = 0;
        this.maxX = 1000000;
        if (this.wholeTable != null) {
            tableBox = this.workTable.parentNode.getBoundingClientRect();
            this.minX = tableBox.left;
            this.maxX = this.minX + tableBox.width;
        }
        else {
            // find maximum columns
            var coordinate_1 = this.module.formalCoordinate(this.workTable, this.workCell, true);
            this.module.formalMatrix(this.workTable, function (td, i, j) {
                if (coordinate_1[1] === j) {
                    box = td.getBoundingClientRect();
                    _this.minX = Math.max(box.left + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY / 2, _this.minX);
                }
                if (coordinate_1[1] + (_this.isRTL ? -1 : 1) === j) {
                    box = td.getBoundingClientRect();
                    _this.maxX = Math.min(box.left + box.width - jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY / 2, _this.maxX);
                }
            });
        }
        return false;
    };
    /**
     * Mouse move after click on resize handle
     */
    resizeCells.prototype.onMouseMove = function (event) {
        if (!this.drag) {
            return;
        }
        this.j.e.fire('closeAllPopups');
        var x = event.clientX;
        var workplacePosition = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)((this.resizeHandler.parentNode ||
            this.j.od.documentElement), this.j, this.j.od, true);
        if (x < this.minX) {
            x = this.minX;
        }
        if (x > this.maxX) {
            x = this.maxX;
        }
        this.resizeDelta =
            x - this.startX + (!this.j.o.iframe ? 0 : workplacePosition.left);
        this.resizeHandler.style.left =
            x - (this.j.o.iframe ? 0 : workplacePosition.left) + 'px';
        var sel = this.j.s.sel;
        sel && sel.removeAllRanges();
    };
    /**
     * Mouse up every where after move and click
     */
    resizeCells.prototype.onMouseUp = function (e) {
        if (this.selectMode || this.drag) {
            this.selectMode = false;
            this.j.unlock();
        }
        if (!this.resizeHandler || !this.drag) {
            return;
        }
        this.drag = false;
        this.j.e.off(this.j.ew, 'mousemove.table touchmove.table', this.onMouseMove);
        this.resizeHandler.classList.remove('jodit-table-resizer_moved');
        if (this.startX !== e.clientX) {
            // resize column
            if (this.wholeTable == null) {
                this.resizeColumns();
            }
            else {
                this.resizeTable();
            }
        }
        this.j.synchronizeValues();
        this.j.s.focus();
    };
    /**
     * Resize only one column
     */
    resizeCells.prototype.resizeColumns = function () {
        var delta = this.resizeDelta;
        var marked = [];
        var tableModule = this.module;
        tableModule.setColumnWidthByDelta(this.workTable, tableModule.formalCoordinate(this.workTable, this.workCell, true)[1], delta, true, marked);
        var nextTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next, this.workCell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, this.workCell.parentNode);
        tableModule.setColumnWidthByDelta(this.workTable, tableModule.formalCoordinate(this.workTable, nextTD)[1], -delta, false, marked);
    };
    /**
     * Resize whole table
     */
    resizeCells.prototype.resizeTable = function () {
        var delta = this.resizeDelta * (this.isRTL ? -1 : 1);
        var width = this.workTable.offsetWidth, parentWidth = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.getContentWidth)(this.workTable.parentNode, this.j.ew);
        // for RTL use mirror logic
        var rightSide = !this.wholeTable;
        var needChangeWidth = this.isRTL ? !rightSide : rightSide;
        // right side
        if (needChangeWidth) {
            this.workTable.style.width =
                ((width + delta) / parentWidth) * 100 + '%';
        }
        else {
            var side = this.isRTL ? 'marginRight' : 'marginLeft';
            var margin = parseInt(this.j.ew.getComputedStyle(this.workTable)[side] || '0', 10);
            this.workTable.style.width =
                ((width - delta) / parentWidth) * 100 + '%';
            this.workTable.style[side] =
                ((margin + delta) / parentWidth) * 100 + '%';
        }
    };
    /**
     * Memoize current cell
     *
     * @param wholeTable - resize whole table by left side,
     * false - resize whole table by right side, null - resize column
     */
    resizeCells.prototype.setWorkCell = function (cell, wholeTable) {
        if (wholeTable === void 0) { wholeTable = null; }
        this.wholeTable = wholeTable;
        this.workCell = cell;
        this.workTable = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(cell, function (elm) { return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(elm, 'table'); }, this.j.editor);
    };
    /**
     * Calc helper resize handle position
     */
    resizeCells.prototype.calcHandlePosition = function (table, cell, offsetX, delta) {
        if (offsetX === void 0) { offsetX = 0; }
        if (delta === void 0) { delta = 0; }
        var box = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(cell, this.j, this.j.ed);
        if (offsetX > jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY && offsetX < box.width - jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY) {
            this.hideResizeHandle();
            return;
        }
        var workplacePosition = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(this.j.workplace, this.j, this.j.od, true), parentBox = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(table, this.j, this.j.ed);
        this.resizeHandler.style.left =
            (offsetX <= jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY ? box.left : box.left + box.width) -
                workplacePosition.left +
                delta +
                'px';
        Object.assign(this.resizeHandler.style, {
            height: parentBox.height + 'px',
            top: parentBox.top - workplacePosition.top + 'px'
        });
        this.showResizeHandle();
        if (offsetX <= jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY) {
            var prevTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, cell.parentNode);
            this.setWorkCell(prevTD || cell, prevTD ? null : true);
        }
        else {
            var nextTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(!this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, cell.parentNode);
            this.setWorkCell(cell, !nextTD ? false : null);
        }
    };
    /** @override */
    resizeCells.prototype.afterInit = function (editor) {
        var _this = this;
        if (!editor.o.tableAllowCellResize) {
            return;
        }
        editor.e
            .off(this.j.ow, '.resize-cells')
            .off('.resize-cells')
            .on('change.resize-cells afterCommand.resize-cells afterSetMode.resize-cells', function () {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('table', editor.editor).forEach(_this.observe);
        })
            .on(this.j.ow, 'scroll.resize-cells', function () {
            if (!_this.drag) {
                return;
            }
            var parent = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(_this.workCell, function (elm) { return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(elm, 'table'); }, editor.editor);
            if (parent) {
                var parentBox = parent.getBoundingClientRect();
                _this.resizeHandler.style.top = parentBox.top + 'px';
            }
        })
            .on('beforeSetMode.resize-cells', function () {
            var tableModule = _this.module;
            tableModule.getAllSelectedCells().forEach(function (td) {
                tableModule.removeSelection(td);
                tableModule.normalizeTable(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(td, 'table', editor.editor));
            });
        });
    };
    /**
     * Add to every Table listeners
     */
    resizeCells.prototype.observe = function (table) {
        var _this = this;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(table, key)) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(table, key, true);
        this.j.e
            .on(table, 'mouseleave.resize-cells', function (e) {
            if (_this.resizeHandler &&
                _this.resizeHandler !== e.relatedTarget) {
                _this.hideResizeHandle();
            }
        })
            .on(table, 'mousemove.resize-cells touchmove.resize-cells', this.j.async.throttle(function (event) {
            if (_this.j.isLocked) {
                return;
            }
            var cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(event.target, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, table);
            if (!cell) {
                return;
            }
            _this.calcHandlePosition(table, cell, event.offsetX);
        }, {
            timeout: this.j.defaultTimeout
        }));
        this.createResizeHandle();
    };
    resizeCells.prototype.beforeDestruct = function (jodit) {
        if (jodit.events) {
            jodit.e.off(this.j.ow, '.resize-cells');
            jodit.e.off('.resize-cells');
        }
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizeCells.prototype, "onHandleMouseDown", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizeCells.prototype, "onMouseMove", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizeCells.prototype, "onMouseUp", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], resizeCells.prototype, "observe", null);
    return resizeCells;
}(jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Plugin));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('resizeCells', resizeCells);


/***/ }),

/***/ 39199:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1664 896q0 156-61 298t-164 245-245 164-298 61q-172 0-327-72.5t-264-204.5q-7-10-6.5-22.5t8.5-20.5l137-138q10-9 25-9 16 2 23 12 73 95 179 147t225 52q104 0 198.5-40.5t163.5-109.5 109.5-163.5 40.5-198.5-40.5-198.5-109.5-163.5-163.5-109.5-198.5-40.5q-98 0-188 35.5t-160 101.5l137 138q31 30 14 69-17 40-59 40h-448q-26 0-45-19t-19-45v-448q0-42 40-59 39-17 69 14l130 129q107-101 244.5-156.5t284.5-55.5q156 0 298 61t245 164 164 245 61 298z\"/> </svg>"

/***/ }),

/***/ 39344:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ normalizeUrl; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
var normalizeUrl = function () {
    var urls = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        urls[_i] = arguments[_i];
    }
    return urls
        .filter(function (url) { return url.length; })
        .map(function (url) { return url.replace(/\/$/, ''); })
        .join('/')
        .replace(/([^:])[\\/]+/g, '$1/');
};


/***/ }),

/***/ 39386:
/***/ (function(module) {

module.exports["default"] = ["Escriba algo...","Acerca de Jodit","Jodit Editor","Guía de usuario Jodit","contiene ayuda detallada para el uso.","Para información sobre la licencia, por favor visite nuestro sitio:","Compre la versión completa","Copyright © XDSoft.net - Chupurnov Valeriy. Todos los derechos reservados.","Anclar","Abrir en nueva pestaña","Abrir editor en pantalla completa","Limpiar formato","Color de relleno o de letra","Rehacer","Deshacer","Negrita","Cursiva","Insertar lista no ordenada","Insertar lista ordenada","Alinear Centrado","Alinear Justificado","Alinear Izquierda","Alinear Derecha","Insertar línea horizontal","Insertar imagen","Insertar archivo","Insertar video de Youtube/vimeo","Insertar vínculo","Tamaño de letra","Familia de letra","Insertar bloque","Normal","Encabezado 1","Encabezado 2","Encabezado 3","Encabezado 4","Cita","Código","Insertar","Insertar tabla","Disminuir sangría","Aumentar sangría","Seleccionar caracter especial","Insertar caracter especial","Copiar formato","Cambiar modo","Márgenes","arriba","derecha","abajo","izquierda","Estilos CSS","Clases CSS","Alinear","Derecha","Centrado","Izquierda","--No Establecido--","Fuente","Título","Texto Alternativo","Vínculo","Abrir vínculo en nueva pestaña","Imagen","Archivo","Avanzado","Propiedades de imagen","Cancelar","Aceptar","Buscar archivo","Error al cargar la lista","Error al cargar las carpetas","¿Está seguro?","Entre nombre de carpeta","Crear carpeta","Entre el nombre","Soltar imagen","Soltar archivo","o click","Texto alternativo","Subir","Buscar","Fondo","Texto","Arriba","Centro","Abajo","Insertar columna antes","Interar columna después","Insertar fila arriba","Insertar fila debajo","Borrar tabla","Borrar fila","Borrar columna","Vaciar celda","Caracteres: %d","Palabras: %d","Tachado","Subrayado","superíndice","subíndice","Cortar selección","Seleccionar todo","Pausa","Buscar","Reemplazar con","Reemplazar","Pegar","Seleccionar contenido para pegar","HTML","negrita","cursiva","Brocha","Vínculo","deshacer","rehacer","Tabla","Imagen","Borrar","Párrafo","Tamaño de letra","Video","Letra","Acerca de","Imprimir","subrayar","tachar","sangría","quitar sangría","Tamaño completo","encoger","línea horizontal","lista sin ordenar","lista ordenada","Cortar","Seleccionar todo","Incluir código","Abrir vínculo","Editar vínculo","No seguir","Desvincular","Actualizar","Para editar","Ver","URL","Editar","Alineación horizontal","Filtrar","Ordenar por fecha modificación","Ordenar por nombre","Ordenar por tamaño","Agregar carpeta","Resetear","Guardar","Guardar como...","Redimensionar","Recortar","Ancho","Alto","Mantener relación de aspecto","Si","No","Quitar","Seleccionar","Seleccionar: %s","Alineación vertical","Dividir","Mezclar","Agregar columna","Agregar fila",null,"Borrar","Dividir vertical","Dividir horizontal","Borde","El código es similar a HTML. ¿Mantener como HTML?","Pegar como HTML?","Mantener","Insertar como texto","Insertar solo texto","Solo puedes editar tus propias imágenes. ¿Descargar esta imagen en el servidor?","¡La imagen se ha subido correctamente al servidor!","paleta","No hay archivos en este directorio.","renombrar","Ingresa un nuevo nombre","avance","Descargar","Pegar desde el portapapeles","Su navegador no soporta el acceso directo en el portapapeles.","Selección de copia","copia","Radio frontera","Mostrar todos los","Aplicar","Por favor, rellene este campo","Por favor, introduzca una dirección web","Predeterminado","Círculo","Punto","Cuadro","Encontrar","Buscar Anterior","Buscar Siguiente","El contenido pegado proviene de un documento de Microsoft Word/Excel. ¿Desea mantener el formato o limpiarlo?","Pegado desde Word detectado","Limpiar","Insertar nombre de clase","Presione Alt para cambiar el tamaño personalizado"]

/***/ }),

/***/ 39611:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ flatButtonsSet; },
/* harmony export */   i: function() { return /* binding */ isButtonGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37923);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * @private
 */
var isButtonGroup = function (item) {
    return (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .c)(item.buttons);
};
/**
 * @private
 */
function flatButtonsSet(buttons, jodit) {
    var groups = jodit.getRegisteredButtonGroups();
    return new Set(buttons.reduce(function (acc, item) {
        var _a;
        if (isButtonGroup(item)) {
            acc = acc.concat((0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__spreadArray */ .fX)((0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__read */ .zs)(item.buttons), false), (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__read */ .zs)(((_a = groups[item.group]) !== null && _a !== void 0 ? _a : [])), false));
        }
        else {
            acc.push(item);
        }
        return acc;
    }, []));
}


/***/ }),

/***/ 39626:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16116);
/* harmony import */ var _brush_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45674);
/* harmony import */ var _brush_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_brush_svg__WEBPACK_IMPORTED_MODULE_5__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.set('brush', (_brush_svg__WEBPACK_IMPORTED_MODULE_5___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.brushCell = {
    isVisible: function (editor) {
        return !editor.o.disablePlugins.includes('color');
    },
    icon: 'brush',
    popup: function (editor, _, close) {
        if (!(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isJoditObject)(editor)) {
            return;
        }
        var tableModule = editor.getInstance('Table', editor.o), selected = tableModule.getAllSelectedCells();
        if (!selected.length) {
            return false;
        }
        var makeColorPicker = function (key) {
            return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .ColorPickerWidget */ .Kn)(editor, function (value) {
                selected.forEach(function (cell) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(cell, key, value);
                });
                editor.lock();
                editor.synchronizeValues();
                close();
                editor.unlock();
            }, (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(selected[0], key));
        };
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .TabsWidget */ .Zg)(editor, [
            {
                name: 'Background',
                content: makeColorPicker('background-color')
            },
            { name: 'Text', content: makeColorPicker('color') },
            { name: 'Border', content: makeColorPicker('border-color') }
        ]);
    },
    tooltip: 'Background'
};
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.brush = {
    isVisible: function (editor) {
        return !editor.o.disablePlugins.includes('color');
    },
    update: function (editor, button) {
        var color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
        var update = function (key, value) {
            if (value && value !== (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(editor.editor, key).toString()) {
                button.state.icon.fill = value;
                return;
            }
        };
        if (color) {
            var mode = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
            update(mode === 'color' ? mode : 'background-color', color);
            return;
        }
        var current = editor.s.current();
        if (current && !button.state.disabled) {
            var currentBpx = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement, editor.editor) || editor.editor;
            update('color', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(currentBpx, 'color').toString());
            update('background-color', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(currentBpx, 'background-color').toString());
        }
        button.state.icon.fill = '';
        button.state.activated = false;
    },
    popup: function (editor, current, close, button) {
        var colorHEX = '', bg_color = '', tabs = [], currentElement = null;
        if (current && current !== editor.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(current)) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(current) &&
                editor.s.isCollapsed() &&
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(current, new Set(['br', 'hr']))) {
                currentElement = current;
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(current, function (node) {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(node)) {
                    var color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(node, 'color', true), background = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(node, 'background-color', true);
                    if (color) {
                        colorHEX = color.toString();
                        return true;
                    }
                    if (background) {
                        bg_color = background.toString();
                        return true;
                    }
                }
            }, editor.editor);
        }
        var backgroundTag = (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .ColorPickerWidget */ .Kn)(editor, function (value) {
            if (!currentElement) {
                editor.execCommand('background', false, value);
            }
            else {
                currentElement.style.backgroundColor = value;
            }
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color', value);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode', 'background');
            close();
        }, bg_color);
        var colorTab = (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .ColorPickerWidget */ .Kn)(editor, function (value) {
            if (!currentElement) {
                editor.execCommand('forecolor', false, value);
            }
            else {
                currentElement.style.color = value;
            }
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color', value);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode', 'color');
            close();
        }, colorHEX);
        tabs = [
            {
                name: 'Background',
                content: backgroundTag
            },
            {
                name: 'Text',
                content: colorTab
            }
        ];
        if (editor.o.colorPickerDefaultTab !== 'background') {
            tabs = tabs.reverse();
        }
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .TabsWidget */ .Zg)(editor, tabs, currentElement);
    },
    exec: function (jodit, current, _a) {
        var button = _a.button;
        var mode = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode'), color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
        if (!mode) {
            return false;
        }
        if (current &&
            current !== jodit.editor &&
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(current) &&
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(current)) {
            switch (mode) {
                case 'color':
                    current.style.color = color;
                    break;
                case 'background':
                    current.style.backgroundColor = color;
                    break;
            }
        }
        else {
            jodit.execCommand(mode === 'background' ? mode : 'forecolor', false, color);
        }
    },
    tooltip: 'Fill color or set the text color'
};


/***/ }),

/***/ 39858:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z\"/> </svg>"

/***/ }),

/***/ 40037:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path stroke-width=\"0\" d=\"M381 1620q0 80-54.5 126t-135.5 46q-106 0-172-66l57-88q49 45 106 45 29 0 50.5-14.5t21.5-42.5q0-64-105-56l-26-56q8-10 32.5-43.5t42.5-54 37-38.5v-1q-16 0-48.5 1t-48.5 1v53h-106v-152h333v88l-95 115q51 12 81 49t30 88zm2-627v159h-362q-6-36-6-54 0-51 23.5-93t56.5-68 66-47.5 56.5-43.5 23.5-45q0-25-14.5-38.5t-39.5-13.5q-46 0-81 58l-85-59q24-51 71.5-79.5t105.5-28.5q73 0 123 41.5t50 112.5q0 50-34 91.5t-75 64.5-75.5 50.5-35.5 52.5h127v-60h105zm1409 319v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm-1408-899v99h-335v-99h107q0-41 .5-122t.5-121v-12h-2q-8 17-50 54l-71-76 136-127h106v404h108zm1408 387v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm0-512v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5z\"/> </svg>"

/***/ }),

/***/ 40080:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mr: function() { return /* binding */ hAlignElement; },
/* harmony export */   Op: function() { return /* binding */ alignElement; },
/* harmony export */   Xm: function() { return /* binding */ clearAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Align image
 */
function hAlignElement(image, align) {
    if (align && align !== 'normal') {
        if (align !== 'center') {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float', align);
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .clearCenterAlign */ .a)(image);
        }
        else {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, {
                float: '',
                display: 'block',
                marginLeft: 'auto',
                marginRight: 'auto'
            });
        }
    }
    else {
        if ((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float') &&
            ['right', 'left'].indexOf((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float').toString().toLowerCase()) !== -1) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float', '');
        }
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .clearCenterAlign */ .a)(image);
    }
}
/**
 * Remove text-align style for all selected children
 */
function clearAlign(node) {
    jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.each(node, function (elm) {
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm)) {
            if (elm.style.textAlign) {
                elm.style.textAlign = '';
                if (!elm.style.cssText.trim().length) {
                    elm.removeAttribute('style');
                }
            }
        }
    });
}
/**
 * Apply align for element
 */
function alignElement(command, box) {
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(box) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(box)) {
        clearAlign(box);
        switch (command.toLowerCase()) {
            case 'justifyfull':
                box.style.textAlign = 'justify';
                break;
            case 'justifyright':
                box.style.textAlign = 'right';
                break;
            case 'justifyleft':
                box.style.textAlign = 'left';
                break;
            case 'justifycenter':
                box.style.textAlign = 'center';
                break;
        }
    }
}


/***/ }),

/***/ 40119:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Spellingcontrole'
};


/***/ }),

/***/ 40594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* reexport safe */ _create__WEBPACK_IMPORTED_MODULE_0__.X; }
/* harmony export */ });
/* harmony import */ var _create__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92852);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module create
 */



/***/ }),

/***/ 40677:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ set; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const a = {}, b = {};
 * Jodit.modules.Helpers.set('a.b.c.d.e', 1, a);
 * console.log(a);// {a: {b: {c: {d: {e: 1}}}}}
 *
 * Jodit.modules.Helpers.set('a.0.e', 1, b);
 * console.log(b);// {a: [{e: 1}]}
 * ```
 */
function set(chain, value, obj) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(chain) || !chain.length) {
        return;
    }
    var parts = chain.split('.');
    var result = obj, key = parts[0];
    for (var i = 0; i < parts.length - 1; i += 1) {
        key = parts[i];
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(result[key]) && !(0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__/* .isPlainObject */ .Q)(result[key])) {
            result[key] = (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__/* .isNumeric */ .k)(parts[i + 1]) ? [] : {};
        }
        result = result[key];
    }
    if (result) {
        result[parts[parts.length - 1]] = value;
    }
}


/***/ }),

/***/ 41111:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M384 1662l17-85q6-2 81.5-21.5t111.5-37.5q28-35 41-101 1-7 62-289t114-543.5 52-296.5v-25q-24-13-54.5-18.5t-69.5-8-58-5.5l19-103q33 2 120 6.5t149.5 7 120.5 2.5q48 0 98.5-2.5t121-7 98.5-6.5q-5 39-19 89-30 10-101.5 28.5t-108.5 33.5q-8 19-14 42.5t-9 40-7.5 45.5-6.5 42q-27 148-87.5 419.5t-77.5 355.5q-2 9-13 58t-20 90-16 83.5-6 57.5l1 18q17 4 185 31-3 44-16 99-11 0-32.5 1.5t-32.5 1.5q-29 0-87-10t-86-10q-138-2-206-2-51 0-143 9t-121 11z\"/> </svg>"

/***/ }),

/***/ 41133:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/select
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.select = {
    normalizeSelectionBeforeCutAndCopy: false,
    normalizeTripleClick: true
};


/***/ }),

/***/ 41145:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Çizgi yüksekliği'
};


/***/ }),

/***/ 41159:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ insertParagraph; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(641);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Insert default paragraph
 * @private
 */
function insertParagraph(fake, editor, wrapperTag, style) {
    var isBR = wrapperTag.toLowerCase() === 'br', createInside = editor.createInside, p = createInside.element(wrapperTag), br = createInside.element('br');
    if (!isBR) {
        p.appendChild(br);
    }
    if (style && style.cssText) {
        p.setAttribute('style', style.cssText);
    }
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(fake, p);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(isBR ? p : br, fake);
    (0,jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_1__/* .scrollIntoViewIfNeeded */ .$)(p, editor.editor, editor.ed);
    return p;
}


/***/ }),

/***/ 42055:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Wysokość linii'
};


/***/ }),

/***/ 42448:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ toArray; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_native_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34796);
/* harmony import */ var jodit_core_helpers_utils_reset__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44210);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */


/**
 * Always return Array. It's a safe polyfill for [Array.from](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from) method
 * In certain scenarios (such as with Joomla Mootools), Array.from may be substituted with a less optimal implementation
 * ```javascript
 * Jodit.modules.Helpers.toArray('123') // ['1', '2', '3']
 * Jodit.modules.Helpers.toArray(['test']) // ['test']
 * Jodit.modules.Helpers.toArray(1) // []
 * ```
 */
var toArray = function toArray() {
    var _a;
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var func = (0,jodit_core_helpers_checker_is_native_function__WEBPACK_IMPORTED_MODULE_1__/* .isNativeFunction */ .a)(Array.from)
        ? Array.from
        : ((_a = (0,jodit_core_helpers_utils_reset__WEBPACK_IMPORTED_MODULE_0__/* .reset */ .c)('Array.from')) !== null && _a !== void 0 ? _a : Array.from);
    return func.apply(Array, args);
};


/***/ }),

/***/ 42589:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ splitArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Return an array from string or array
 * ```javascript
 * Jodit.modules.Helpers.splitArray('1,2,3') // ['1', '2', '3']
 * Jodit.modules.Helpers.splitArray(['1', '2', '3']) // ['1', '2', '3']
 * ```
 */
function splitArray(a) {
    return Array.isArray(a) ? a : a.split(/[,\s]+/);
}


/***/ }),

/***/ 42898:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ checkRemoveEmptyParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var _check_join_two_lists__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(72874);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check if the current empty item can be removed
 *
 * @example
 * ```html
 * <p>first stop</p><p>|<br></p>
 * ```
 * result
 * ```html
 * <p>first stop|</p>
 * ```
 *
 * @private
 */
function checkRemoveEmptyParent(jodit, fakeNode, backspace) {
    var found = false;
    var _a = jodit.s, setCursorBefore = _a.setCursorBefore, setCursorIn = _a.setCursorIn;
    var prn = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(fakeNode, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement, jodit.editor);
    if (!prn || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(prn)) {
        return false;
    }
    var neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptyNeighbor(fakeNode, backspace, jodit.editor);
    do {
        if (prn && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(prn) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell(prn)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(prn, fakeNode);
            var tmp = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(prn, function (n) { return jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(n) && n !== prn; }, jodit.editor);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(prn);
            found = true;
            prn = tmp;
        }
        else {
            break;
        }
    } while (prn);
    if (found && (0,_check_join_two_lists__WEBPACK_IMPORTED_MODULE_2__/* .checkJoinTwoLists */ .a)(jodit, fakeNode, backspace)) {
        return true;
    }
    if (neighbor &&
        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(neighbor) &&
        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(neighbor, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
        setCursorIn(neighbor, !backspace);
    }
    else {
        setCursorBefore(fakeNode);
    }
    return found;
}


/***/ }),

/***/ 43218:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68z\"/> </svg>"

/***/ }),

/***/ 43268:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Controllo ortografico'
};


/***/ }),

/***/ 43327:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ checkJoinNeighbors; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81779);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check if two separate elements can be connected
 * @private
 */
function checkJoinNeighbors(jodit, fakeNode, backspace) {
    var nextBox = fakeNode, mainClosestBox = nextBox;
    // Find the main big closest element
    while (nextBox &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(nextBox, backspace) &&
        nextBox.parentElement !== jodit.editor) {
        nextBox = nextBox.parentElement;
        mainClosestBox = nextBox;
    }
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(mainClosestBox) &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isContentEditable(mainClosestBox, jodit.editor)) {
        var sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(mainClosestBox, backspace);
        if (sibling &&
            (checkMoveListContent(jodit, mainClosestBox, sibling, backspace) ||
                moveContentAndRemoveEmpty(jodit, mainClosestBox, sibling, backspace))) {
            jodit.s.setCursorBefore(fakeNode);
            return true;
        }
    }
    return false;
}
function checkMoveListContent(jodit, mainClosestBox, sibling, backspace) {
    // Process UL/LI/OL cases
    var siblingIsList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sibling, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    var boxIsList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(mainClosestBox, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    var elementChild = function (elm, side) {
        return side ? elm.firstElementChild : elm.lastElementChild;
    };
    if (boxIsList) {
        sibling = jodit.createInside.element(jodit.o.enterBlock);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(mainClosestBox, sibling);
        return moveContentAndRemoveEmpty(jodit, elementChild(mainClosestBox, backspace), sibling, backspace);
    }
    if (sibling && siblingIsList && !boxIsList) {
        return moveContentAndRemoveEmpty(jodit, mainClosestBox, elementChild(sibling, !backspace), backspace);
    }
    return false;
}
function moveContentAndRemoveEmpty(jodit, mainClosestBox, sibling, backspace) {
    // Move content and remove empty nodes
    if (mainClosestBox && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sibling)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.moveContent(mainClosestBox, sibling, !backspace, (0,jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_2__/* .getMoveFilter */ .g)(jodit));
        var remove = mainClosestBox;
        while (remove && remove !== jodit.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(remove)) {
            var parent = remove.parentElement;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(remove);
            remove = parent;
        }
        return true;
    }
    return false;
}


/***/ }),

/***/ 43431:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ Eventify; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Class for adding event handling capability
 *
 * ```ts
 * class SomeClass extends Eventify<{ start: (node: Node) => boolean; }> {
 * 	constructor() {
 * 		super();
 * 		setTimeout(() => {
 * 			if (this.emit('start', document.body)) {
 * 				console.log('yes');
 * 			};
 * 		}, 100);
 * 	}
 * }
 *
 * const sm = new SomeClass();
 * sm.on('start', (node) => {
 * 	console.log(node);
 * 	return true;
 * })
 * ```
 */
var Eventify = /** @class */ (function () {
    function Eventify() {
        this.__map = new Map();
    }
    Eventify.prototype.on = function (name, func) {
        var _a;
        if (!this.__map.has(name)) {
            this.__map.set(name, new Set());
        }
        (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.add(func);
        return this;
    };
    Eventify.prototype.off = function (name, func) {
        var _a;
        if (this.__map.has(name)) {
            (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.delete(func);
        }
        return this;
    };
    Eventify.prototype.destruct = function () {
        this.__map.clear();
    };
    Eventify.prototype.emit = function (name) {
        var _a;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var result;
        if (this.__map.has(name)) {
            (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.forEach(function (cb) {
                result = cb.apply(void 0, (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__read */ .zs)(args), false));
            });
        }
        return result;
    };
    return Eventify;
}());



/***/ }),

/***/ 43655:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.dtd = {
    removeExtraBr: true,
    checkBlockNesting: true,
    blockLimits: {
        article: 1,
        aside: 1,
        audio: 1,
        body: 1,
        caption: 1,
        details: 1,
        dir: 1,
        div: 1,
        dl: 1,
        fieldset: 1,
        figcaption: 1,
        figure: 1,
        footer: 1,
        form: 1,
        header: 1,
        hgroup: 1,
        main: 1,
        menu: 1,
        nav: 1,
        ol: 1,
        section: 1,
        table: 1,
        td: 1,
        th: 1,
        tr: 1,
        ul: 1,
        video: 1
    }
};


/***/ }),

/***/ 44210:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ reset; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var _get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16841);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



var map = {};
/**
 * Reset Vanilla JS native function
 * @example
 * ```js
 * reset('Array.from')(Set([1,2,3])) // [1, 2, 3]
 * ```
 * You must use the function derived from the method immediately as its iframe is being removed
 */
function reset(key) {
    var _a, _b;
    if (!(key in map)) {
        var iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
        try {
            iframe.src = 'about:blank';
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.body.appendChild(iframe);
            if (!iframe.contentWindow) {
                return null;
            }
            var func = (0,_get__WEBPACK_IMPORTED_MODULE_1__/* .get */ .J)(key, iframe.contentWindow), bind = (0,_get__WEBPACK_IMPORTED_MODULE_1__/* .get */ .J)(key.split('.').slice(0, -1).join('.'), iframe.contentWindow);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(func)) {
                map[key] = func.bind(bind);
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        }
        finally {
            (_a = iframe.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(iframe);
        }
    }
    return (_b = map[key]) !== null && _b !== void 0 ? _b : null;
}


/***/ }),

/***/ 44636:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z\"/></svg>"

/***/ }),

/***/ 44906:
/***/ (function(module) {

module.exports["default"] = ["輸入一些內容","關於Jodit","Jodit Editor","開發者指南","使用幫助","相關授權條款資訊，請造訪我們的網站：","購買完整版本","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","錨點","在新分頁開啟","全螢幕編輯","清除樣式","顏色","取消復原","復原","粗體","斜體","項目符號清單","編號清單","置中","文字對齊","靠左","靠右","分割線","圖片","檔案","插入 youtube/vimeo 影片","插入連結","文字大小","字型","格式化區塊","內文","標題1","標題2","標題3","標題4","引文","程式碼","插入","表格","減少縮排","增加縮排","選擇特殊符號","特殊符號","格式複製","檢視原始碼","邊距","上","右","下","左","樣式","Classes","對齊方式","靠右","置中","靠左","無","Src","Title","替代","Link","在新分頁開啟連結","圖片","檔案","進階","圖片屬性","取消","確定","檔案瀏覽","清單載入錯誤","資料夾載入錯誤","您確定嗎？","輸入路徑","創建路徑","type name","拖曳圖片至此","拖曳檔案至此","或點擊","替代文字","上傳","瀏覽","背景色","文字","頂部","中間","底部","插入左方欄","插入右方欄","插入上方列","插入下方列","刪除表格","刪除整列","刪除整欄","清除內容","字元數: %d","單字數: %d","刪除線","底線","上標","下標","剪下","全選","斷行","尋找","取代為","取代","貼上","選擇內容並貼上","原始碼","粗體","斜體","顏色","連結","復原","取消復原","表格","圖片","橡皮擦","段落","文字大小","影片","字型","關於","列印","底線","刪除線","增加縮排","減少縮排","全螢幕","縮減","分隔線","項目符號清單","編號清單","剪下","全選","嵌入程式碼","打開連結","編輯連結","No follow","取消連結","更新","鉛筆","查看","URL",null,"水平對齊","篩選","修改時間排序","名稱排序","大小排序","新增資料夾","重設","儲存","另存為...","調整大小","裁切","寬","高","維持長寬比","是","否","移除","選擇","選擇: %s","垂直對齊","分割","合併","新增欄","新增列",null,"刪除","垂直分割","水平分割","邊框","您的程式碼與 HTML 類似，是否貼上 HTML 格式？","貼上 HTML","保留原始格式","以純文字貼上","僅貼上內文","您只能編輯您自己的圖片。是否下載此圖片?","圖片上傳成功","調色盤","沒有檔案","重新命名","輸入新名稱","預覽","下載","從剪貼簿貼上","瀏覽器無法存取剪貼簿。","複製已選取項目","複製","邊框圓角","顯示全部","應用","請輸入此欄位","請輸入網址","預設","圓圈","點","方形","尋找","尋找上一個","尋找下一個","正在貼上 Word/Excel 文件的內容，是否保留原始格式？","貼上 Word 格式","清除格式","插入 class 名稱","按住 Alt 以調整自訂大小"]

/***/ }),

/***/ 44921:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export preview */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils_print__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98434);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.preview = {
    icon: 'eye',
    command: 'preview',
    mode: jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
    tooltip: 'Preview'
};
function preview(editor) {
    editor.registerButton({
        name: 'preview'
    });
    editor.registerCommand('preview', function (_, _1, defaultValue) {
        var dialog = editor.dlg();
        dialog
            .setSize(1024, 600)
            .open('', editor.i18n('Preview'))
            .setModal(true);
        var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__read */ .zs)((0,jodit_core_helpers_utils_print__WEBPACK_IMPORTED_MODULE_2__/* .previewBox */ .u)(editor, defaultValue, 'px', dialog.getElm('content')), 2), onDestrcut = _a[1];
        dialog.e.on(dialog, 'afterClose', onDestrcut);
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('preview', preview);


/***/ }),

/***/ 45062:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm639 217v206h-514l-4-27q-3-45-3-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 80-65 188-65 110 0 178 59.5t68 158.5q0 66-34.5 118.5t-84 86-99.5 62.5-87 63-41 73h232v-80h126z\"/> </svg>"

/***/ }),

/***/ 45244:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1639 1056q0 5-1 7-64 268-268 434.5t-478 166.5q-146 0-282.5-55t-243.5-157l-129 129q-19 19-45 19t-45-19-19-45v-448q0-26 19-45t45-19h448q26 0 45 19t19 45-19 45l-137 137q71 66 161 102t187 36q134 0 250-65t186-179q11-17 53-117 8-23 30-23h192q13 0 22.5 9.5t9.5 22.5zm25-800v448q0 26-19 45t-45 19h-448q-26 0-45-19t-19-45 19-45l138-138q-148-137-349-137-134 0-250 65t-186 179q-11 17-53 117-8 23-30 23h-199q-13 0-22.5-9.5t-9.5-22.5v-7q65-268 270-434.5t480-166.5q146 0 284 55.5t245 156.5l130-129q19-19 45-19t45 19 19 45z\"/> </svg>"

/***/ }),

/***/ 45512:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 10 10\"> <path d=\"M.941 4.523a.75.75 0 1 1 1.06-1.06l3.006 3.005 3.005-3.005a.75.75 0 1 1 1.06 1.06l-3.549 3.55a.75.75 0 0 1-1.168-.136L.941 4.523z\"/> </svg>"

/***/ }),

/***/ 45674:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M896 1152q0-36-20-69-1-1-15.5-22.5t-25.5-38-25-44-21-50.5q-4-16-21-16t-21 16q-7 23-21 50.5t-25 44-25.5 38-15.5 22.5q-20 33-20 69 0 53 37.5 90.5t90.5 37.5 90.5-37.5 37.5-90.5zm512-128q0 212-150 362t-362 150-362-150-150-362q0-145 81-275 6-9 62.5-90.5t101-151 99.5-178 83-201.5q9-30 34-47t51-17 51.5 17 33.5 47q28 93 83 201.5t99.5 178 101 151 62.5 90.5q81 127 81 275z\"/> </svg>"

/***/ }),

/***/ 45698:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    Spellcheck: 'Дүрмийн алдаа шалгах'
};


/***/ }),

/***/ 46079:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export indent */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97767);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3392);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






var applyIndentToBox = function (processedElements, currentBox, editor, command) {
    if (!currentBox) {
        return;
    }
    if (processedElements.has(currentBox)) {
        return;
    }
    var key = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .getKey */ .i)(editor.o.direction, currentBox);
    processedElements.add(currentBox);
    var value = currentBox.style[key] ? parseInt(currentBox.style[key], 10) : 0;
    value += editor.o.indentMargin * (command === 'outdent' ? -1 : 1);
    currentBox.style[key] = value > 0 ? value + 'px' : '';
    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(currentBox, 'style')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(currentBox, 'style', null);
    }
};
/**
 * Indents the line containing the selection or insertion point.
 */
function indent(editor) {
    editor
        .registerButton({
        name: 'indent',
        group: 'indent'
    })
        .registerButton({
        name: 'outdent',
        group: 'indent'
    });
    var indentCommand = function (command) {
        var processedElements = new Set();
        var _a = editor.o, enter = _a.enter, enterBlock = _a.enterBlock;
        var isBrMode = enter.toLowerCase() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR;
        var current = editor.s.current();
        if (isBrMode && editor.s.isCollapsed()) {
            if (current) {
                var box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrapNextInline(current, enterBlock, editor);
                applyIndentToBox(processedElements, box, editor, command);
                return false;
            }
        }
        editor.s.eachSelection(function (current) {
            editor.s.save();
            var currentBox = current
                ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(current, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isBlock, editor.editor)
                : false;
            if (!currentBox && current) {
                currentBox = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.call)(!isBrMode ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrapInline : jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrapNextInline, current, !isBrMode ? enter.toLowerCase() : enterBlock, editor);
            }
            if (!currentBox) {
                editor.s.restore();
                return false;
            }
            applyIndentToBox(processedElements, currentBox, editor, command);
            editor.s.restore();
        });
        editor.synchronizeValues();
        return false;
    };
    editor.registerCommand('indent', {
        exec: indentCommand,
        hotkeys: ['ctrl+]', 'cmd+]']
    });
    editor.registerCommand('outdent', {
        exec: indentCommand,
        hotkeys: ['ctrl+[', 'cmd+[']
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('indent', indent);


/***/ }),

/***/ 46173:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ Jodit; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53883);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(58597);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(37435);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










var __defaultStyleDisplayKey = 'data-jodit-default-style-display';
var __defaultClassesKey = 'data-jodit-default-classes';
var Jodit = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(Jodit, _super);
    /**
     * Create instance of Jodit
     *
     * @param element - Selector or HTMLElement
     * @param options - Editor's options
     */
    function Jodit(element, options) {
        var _this = _super.call(this, options, true) || this;
        /**
         * Define if object is Jodit
         */
        _this.isJodit = true;
        _this.commands = new Map();
        _this.__selectionLocked = null;
        _this.__wasReadOnly = false;
        /**
         * Editor has focus in this time
         */
        _this.editorIsActive = false;
        _this.__mode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        _this.__callChangeCount = 0;
        /**
         * Don't raise a change event
         */
        _this.__isSilentChange = false;
        _this.__elementToPlace = new Map();
        try {
            var elementSource = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(element, _this.o.shadowRoot || _this.od);
            if (Jodit_1.isJoditAssigned(elementSource)) {
                // @ts-ignore
                return elementSource.component;
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
            _this.destruct();
            throw e;
        }
        _this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.beforeInit);
        _this.id =
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(element, _this.o.shadowRoot || _this.od), 'id') ||
                new Date().getTime().toString();
        jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[_this.id] = _this;
        _this.attachEvents(options);
        _this.e.on(_this.ow, 'resize', function () {
            if (_this.e) {
                _this.e.fire('resize');
            }
        });
        _this.e.on('prepareWYSIWYGEditor', _this.__prepareWYSIWYGEditor);
        _this.selection = new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Selection(_this);
        var beforeInitHookResult = _this.beforeInitHook();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(beforeInitHookResult, function () {
            if (_this.isInDestruct) {
                return;
            }
            _this.e.fire('beforeInit', _this);
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.__init(_this);
            _this.e.fire('afterPluginSystemInit', _this);
            _this.e.on('changePlace', function () {
                _this.setReadOnly(_this.o.readonly);
                _this.setDisabled(_this.o.disabled);
            });
            _this.places.length = 0;
            var addPlaceResult = _this.addPlace(element, options);
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[_this.id] = _this;
            var init = function () {
                if (_this.isInDestruct) {
                    return;
                }
                if (_this.e) {
                    _this.e.fire('afterInit', _this);
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(_this.afterInitHook());
                _this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.ready);
                _this.e.fire('afterConstructor', _this);
            };
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(addPlaceResult, init);
        });
        return _this;
    }
    Jodit_1 = Jodit;
    /** @override */
    Jodit.prototype.className = function () {
        return 'Jodit';
    };
    /**
     * Return promise for ready actions
     * @example
     * ```js
     * const jodit = Jodit.make('#editor');
     * await jodit.waitForReady();
     * jodit.e.fire('someAsyncLoadedPluginEvent', (test) => {
     *   alert(test);
     * });
     * ```
     */
    Jodit.prototype.waitForReady = function () {
        var _this = this;
        if (this.isReady) {
            return Promise.resolve(this);
        }
        return this.async.promise(function (resolve) {
            _this.hookStatus('ready', function () { return resolve(_this); });
        });
    };
    Object.defineProperty(Jodit, "ready", {
        /**
         * @deprecated I don't know why I wrote itp
         */
        get: function () {
            return new Promise(function (resolve) {
                jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .eventEmitter */ .RR.on('joditready', resolve);
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "text", {
        /**
         * Plain text editor's value
         */
        get: function () {
            if (this.editor) {
                return this.editor.innerText || '';
            }
            var div = this.createInside.div();
            div.innerHTML = this.getElementValue();
            return div.innerText || '';
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "defaultTimeout", {
        /**
         * Return a default timeout period in milliseconds for some debounce or throttle functions.
         * By default, `{history.timeout}` options
         */
        get: function () {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isNumber)(this.o.defaultTimeout)
                ? this.o.defaultTimeout
                : jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions.defaultTimeout;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Method wrap usual object in Object helper for prevent deep object merging in options*
     * ```js
     * const editor = Jodit.make('#editor', {
     * 	controls: {
     * 		fontsize: {
     * 			list: Jodit.atom([8, 9, 10])
     * 		}
     * 	}
     * });
     * ```
     * In this case, the array [8, 9, 10] will not be combined with other arrays, but will replace them
     */
    Jodit.atom = function (object) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.markAsAtomic)(object);
    };
    /**
     * Factory for creating Jodit instance
     */
    Jodit.make = function (element, options) {
        return new this(element, options);
    };
    /**
     * Checks if the element has already been initialized when for Jodit
     */
    Jodit.isJoditAssigned = function (element) {
        return (element &&
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(element.component) &&
            !element.component.isInDestruct);
    };
    Object.defineProperty(Jodit, "defaultOptions", {
        /**
         * Default settings
         */
        get: function () {
            return jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "createInside", {
        get: function () {
            var _this = this;
            return new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Create(function () { return _this.ed; }, this.o.createAttributes);
        },
        enumerable: false,
        configurable: true
    });
    Jodit.prototype.__setPlaceField = function (field, value) {
        if (!this.currentPlace) {
            this.currentPlace = {};
            this.places = [this.currentPlace];
        }
        this.currentPlace[field] = value;
    };
    Object.defineProperty(Jodit.prototype, "element", {
        /**
         * element It contains source element
         */
        get: function () {
            return this.currentPlace.element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "editor", {
        /**
         * editor It contains the root element editor
         */
        get: function () {
            return this.currentPlace.editor;
        },
        set: function (editor) {
            this.__setPlaceField('editor', editor);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "container", {
        /**
         * Container for all staff
         */
        get: function () {
            return this.currentPlace.container;
        },
        set: function (container) {
            this.__setPlaceField('container', container);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "workplace", {
        /**
         * workplace It contains source and wysiwyg editors
         */
        get: function () {
            return this.currentPlace.workplace;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "message", {
        get: function () {
            return this.getMessageModule(this.workplace);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "statusbar", {
        /**
         * Statusbar module
         */
        get: function () {
            return this.currentPlace.statusbar;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "iframe", {
        /**
         * iframe Iframe for iframe mode
         */
        get: function () {
            return this.currentPlace.iframe;
        },
        set: function (iframe) {
            this.__setPlaceField('iframe', iframe);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "history", {
        get: function () {
            return this.currentPlace.history;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "editorWindow", {
        /**
         * In iframe mode editor's window can be different by owner
         */
        get: function () {
            return this.currentPlace.editorWindow;
        },
        set: function (win) {
            this.__setPlaceField('editorWindow', win);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "ew", {
        /**
         * Alias for this.ew
         */
        get: function () {
            return this.editorWindow;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "editorDocument", {
        /**
         * In iframe mode editor's window can be different by owner
         */
        get: function () {
            return this.currentPlace.editorWindow.document;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "ed", {
        /**
         * Alias for this.ew
         */
        get: function () {
            return this.editorDocument;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "options", {
        /**
         * options All Jodit settings default + second arguments of constructor
         */
        get: function () {
            return this.currentPlace.options;
        },
        set: function (opt) {
            this.__setPlaceField('options', opt);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "s", {
        /**
         * Alias for this.selection
         */
        get: function () {
            return this.selection;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "uploader", {
        get: function () {
            return this.getInstance('Uploader', this.o.uploader);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "filebrowser", {
        get: function () {
            var jodit = this;
            var options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)({
                defaultTimeout: jodit.defaultTimeout,
                uploader: jodit.o.uploader,
                language: jodit.o.language,
                license: jodit.o.license,
                theme: jodit.o.theme,
                shadowRoot: jodit.o.shadowRoot,
                defaultCallback: function (data) {
                    if (data.files && data.files.length) {
                        data.files.forEach(function (file, i) {
                            var url = data.baseurl + file;
                            var isImage = data.isImages
                                ? data.isImages[i]
                                : false;
                            if (isImage) {
                                jodit.s.insertImage(url, null, jodit.o.imageDefaultWidth);
                            }
                            else {
                                jodit.s.insertNode(jodit.createInside.fromHTML("<a href='".concat(url, "' title='").concat(url, "'>").concat(url, "</a>")));
                            }
                        });
                    }
                }
            }, this.o.filebrowser);
            return jodit.getInstance('FileBrowser', options);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "mode", {
        /**
         * Editor's mode
         */
        get: function () {
            return this.__mode;
        },
        set: function (mode) {
            this.setMode(mode);
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Return real HTML value from WYSIWYG editor.
     * @internal
     */
    Jodit.prototype.getNativeEditorValue = function () {
        var value = this.e.fire('beforeGetNativeEditorValue');
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
            return value;
        }
        if (this.editor) {
            return this.editor.innerHTML;
        }
        return this.getElementValue();
    };
    /**
     * Set value to native editor
     */
    Jodit.prototype.setNativeEditorValue = function (value) {
        var data = {
            value: value
        };
        if (this.e.fire('beforeSetNativeEditorValue', data)) {
            return;
        }
        if (this.editor) {
            this.editor.innerHTML = data.value;
        }
    };
    Object.defineProperty(Jodit.prototype, "value", {
        /**
         * HTML value
         */
        get: function () {
            return this.getEditorValue();
        },
        set: function (html) {
            this.setEditorValue(html);
            // @ts-ignore Internal method
            this.history.__processChanges();
        },
        enumerable: false,
        configurable: true
    });
    Jodit.prototype.synchronizeValues = function () {
        this.__imdSynchronizeValues();
    };
    /**
     * This is an internal method, do not use it in your applications.
     * @private
     * @internal
     */
    Jodit.prototype.__imdSynchronizeValues = function () {
        this.setEditorValue();
    };
    /**
     * Return editor value
     */
    Jodit.prototype.getEditorValue = function (removeSelectionMarkers, consumer) {
        if (removeSelectionMarkers === void 0) { removeSelectionMarkers = true; }
        /**
         * Triggered before getEditorValue executed.
         * If returned not undefined, getEditorValue will return this value
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeGetValueFromEditor', function () {
         *     return editor.editor.innerHTML.replace(/a/g, 'b');
         * });
         * ```
         */
        var value;
        value = this.e.fire('beforeGetValueFromEditor', consumer);
        if (value !== undefined) {
            return value;
        }
        value = this.getNativeEditorValue().replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP(), '');
        if (removeSelectionMarkers) {
            value = value.replace(/<span[^>]+id="jodit-selection_marker_[^>]+><\/span>/g, '');
        }
        if (value === '<br>') {
            value = '';
        }
        /**
         * Triggered after getEditorValue got value from wysiwyg.
         * It can change new_value.value
         *
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterGetValueFromEditor', function (new_value) {
         *     new_value.value = new_value.value.replace('a', 'b');
         * });
         * ```
         */
        var new_value = { value: value };
        this.e.fire('afterGetValueFromEditor', new_value, consumer);
        return new_value.value;
    };
    /**
     * Set editor html value and if set sync fill source element value
     * When method was called without arguments - it is a simple way to synchronize editor to element
     */
    Jodit.prototype.setEditorValue = function (value) {
        /**
         * Triggered before getEditorValue set value to wysiwyg.
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeSetValueToEditor', function (old_value) {
         *     return old_value.value.replace('a', 'b');
         * });
         * editor.e.on('beforeSetValueToEditor', function () {
         *     return false; // disable setEditorValue method
         * });
         * ```
         */
        var newValue = this.e.fire('beforeSetValueToEditor', value);
        if (newValue === false) {
            return;
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(newValue)) {
            value = newValue;
        }
        if (!this.editor) {
            if (value !== undefined) {
                this.__setElementValue(value);
            }
            return; // try change value before init or after destruct
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value) && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(value)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('value must be string');
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(value) && this.getNativeEditorValue() !== value) {
            this.setNativeEditorValue(value);
        }
        this.e.fire('postProcessSetEditorValue');
        var old_value = this.getElementValue(), new_value = this.getEditorValue();
        if (!this.__isSilentChange &&
            old_value !== new_value &&
            this.__callChangeCount < jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SAFE_COUNT_CHANGE_CALL) {
            this.__setElementValue(new_value);
            this.__callChangeCount += 1;
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && this.__callChangeCount > 4) {
                console.warn('Too many recursive changes', new_value, old_value);
            }
            try {
                // @ts-ignore Internal method
                this.history.__upTick();
                this.e.fire('change', new_value, old_value);
                this.e.fire(this.history, 'change', new_value, old_value);
            }
            finally {
                this.__callChangeCount = 0;
            }
        }
    };
    /**
     * If some plugin changes the DOM directly, then you need to update the content of the original element
     */
    Jodit.prototype.updateElementValue = function () {
        this.__setElementValue(this.getEditorValue());
    };
    /**
     * Return source element value
     */
    Jodit.prototype.getElementValue = function () {
        return this.element.value !== undefined
            ? this.element.value
            : this.element.innerHTML;
    };
    Jodit.prototype.__setElementValue = function (value) {
        var _this = this;
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('value must be string');
        }
        if (this.element !== this.container &&
            value !== this.getElementValue()) {
            var data_1 = { value: value };
            var res = this.e.fire('beforeSetElementValue', data_1);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(res, function () {
                if (_this.element.value !== undefined) {
                    _this.element.value = data_1.value;
                }
                else {
                    _this.element.innerHTML = data_1.value;
                }
                _this.e.fire('afterSetElementValue', data_1);
            });
        }
    };
    /**
     * Register custom handler for command
     *
     * @example
     * ```javascript
     * var jodit = Jodit.make('#editor);
     *
     * jodit.setEditorValue('test test test');
     *
     * jodit.registerCommand('replaceString', function (command, needle, replace) {
     *      var value = this.getEditorValue();
     *      this.setEditorValue(value.replace(needle, replace));
     *      return false; // stop execute native command
     * });
     *
     * jodit.execCommand('replaceString', 'test', 'stop');
     *
     * console.log(jodit.value); // stop test
     *
     * // and you can add hotkeys for command
     * jodit.registerCommand('replaceString', {
     *    hotkeys: 'ctrl+r',
     *    exec: function (command, needle, replace) {
     *     var value = this.getEditorValue();
     *     this.setEditorValue(value.replace(needle, replace));
     *    }
     * });
     *
     * ```
     */
    Jodit.prototype.registerCommand = function (commandNameOriginal, command, options) {
        var commandName = commandNameOriginal.toLowerCase();
        var commands = this.commands.get(commandName);
        if (commands === undefined) {
            commands = [];
            this.commands.set(commandName, commands);
        }
        commands.push(command);
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(command)) {
            var hotkeys = this.o.commandToHotkeys[commandName] ||
                this.o.commandToHotkeys[commandNameOriginal] ||
                command.hotkeys;
            if (hotkeys) {
                this.registerHotkeyToCommand(hotkeys, commandName, options === null || options === void 0 ? void 0 : options.stopPropagation);
            }
        }
        return this;
    };
    /**
     * Register hotkey for command
     */
    Jodit.prototype.registerHotkeyToCommand = function (hotkeys, commandName, shouldStop) {
        var _this = this;
        if (shouldStop === void 0) { shouldStop = true; }
        var shortcuts = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.asArray)(hotkeys)
            .map(jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.normalizeKeyAliases)
            .map(function (hotkey) { return hotkey + '.hotkey'; })
            .join(' ');
        this.e
            .off(shortcuts)
            .on(shortcuts, function (type, stop) {
            if (stop) {
                stop.shouldStop = shouldStop !== null && shouldStop !== void 0 ? shouldStop : true;
            }
            return _this.execCommand(commandName); // because need `beforeCommand`
        });
    };
    /**
     * Execute command editor
     *
     * @param command - command. It supports all the
     * @see https://developer.mozilla.org/ru/docs/Web/API/Document/execCommand#commands and a number of its own
     * for example applyStyleProperty. Comand fontSize receives the second parameter px,
     * formatBlock and can take several options
     * @example
     * ```javascript
     * this.execCommand('fontSize', 12); // sets the size of 12 px
     * this.execCommand('underline');
     * this.execCommand('formatBlock', 'p'); // will be inserted paragraph
     * ```
     */
    Jodit.prototype.execCommand = function (command, showUI, value) {
        var _a, _b;
        var args = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            args[_i - 3] = arguments[_i];
        }
        if (!this.s.isFocused()) {
            this.s.focus();
        }
        if (this.o.readonly &&
            !this.o.allowCommandsInReadOnly.includes(command)) {
            return;
        }
        var result;
        command = command.toLowerCase();
        /**
         * Called before any command
         * @param command - Command name in lowercase
         * @param second - The second parameter for the command
         * @param third - The third option is for the team
         * @example
         * ```javascript
         * parent.e.on('beforeCommand', function (command) {
         *  if (command === 'justifyCenter') {
         *      var p = parent.c.element('p')
         *      parent.s.insertNode(p)
         *      parent.s.setCursorIn(p);
         *      p.style.textAlign = 'justyfy';
         *      return false; // break executes native command
         *  }
         * })
         * ```
         */
        result = (_a = this.e).fire.apply(_a, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)(["beforeCommand".concat((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ucfirst)(command)), showUI,
            value], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(args), false));
        if (result !== false) {
            result = (_b = this.e).fire.apply(_b, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)(['beforeCommand',
                command,
                showUI,
                value], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(args), false));
        }
        if (result !== false) {
            result = this.__execCustomCommands.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([command, showUI, value], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(args), false));
        }
        if (result !== false) {
            this.s.focus();
            try {
                result = this.nativeExecCommand(command, showUI, value);
            }
            catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
        }
        /**
         * It called after any command
         * @param command - name command
         * @param second - The second parameter for the command
         * @param third - The third option is for the team
         */
        this.e.fire('afterCommand', command, showUI, value);
        this.__imdSynchronizeValues(); // synchrony
        return result;
    };
    /**
     * Exec native command
     */
    Jodit.prototype.nativeExecCommand = function (command, showUI, value) {
        this.__isSilentChange = true;
        try {
            return this.ed.execCommand(command, showUI, value);
        }
        finally {
            this.__isSilentChange = false;
        }
    };
    Jodit.prototype.__execCustomCommands = function (commandName, second, third) {
        var _this = this;
        var args = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            args[_i - 3] = arguments[_i];
        }
        commandName = commandName.toLowerCase();
        var commands = this.commands.get(commandName);
        if (commands !== undefined) {
            var result_1;
            commands.forEach(function (command) {
                var callback;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(command)) {
                    callback = command;
                }
                else {
                    callback = command.exec;
                }
                var resultCurrent = callback.call.apply(callback, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([_this,
                    commandName,
                    second,
                    third], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(args), false));
                if (resultCurrent !== undefined) {
                    result_1 = resultCurrent;
                }
            });
            return result_1;
        }
    };
    /**
     * Disable selecting
     */
    Jodit.prototype.lock = function (name) {
        if (name === void 0) { name = 'any'; }
        if (_super.prototype.lock.call(this, name)) {
            this.__selectionLocked = this.s.save();
            this.s.clear();
            this.editor.classList.add('jodit_lock');
            this.e.fire('lock', true);
            return true;
        }
        return false;
    };
    /**
     * Enable selecting
     */
    Jodit.prototype.unlock = function () {
        if (_super.prototype.unlock.call(this)) {
            this.editor.classList.remove('jodit_lock');
            if (this.__selectionLocked) {
                this.s.restore();
            }
            this.e.fire('lock', false);
            return true;
        }
        return false;
    };
    /**
     * Return current editor mode: Jodit.MODE_WYSIWYG, Jodit.MODE_SOURCE or Jodit.MODE_SPLIT
     */
    Jodit.prototype.getMode = function () {
        return this.mode;
    };
    Jodit.prototype.isEditorMode = function () {
        return this.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
    };
    /**
     * Return current real work mode. When editor in MODE_SOURCE or MODE_WYSIWYG it will
     * return them, but then editor in MODE_SPLIT it will return MODE_SOURCE if
     * Textarea(CodeMirror) focused or MODE_WYSIWYG otherwise
     *
     * @example
     * ```javascript
     * var editor = Jodit.make('#editor');
     * console.log(editor.getRealMode());
     * ```
     */
    Jodit.prototype.getRealMode = function () {
        if (this.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT) {
            return this.getMode();
        }
        var active = this.od.activeElement;
        if (active &&
            (active === this.iframe ||
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.isOrContains(this.editor, active) ||
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.isOrContains(this.toolbar.container, active))) {
            return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        }
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE;
    };
    /**
     * Set current mode
     */
    Jodit.prototype.setMode = function (mode) {
        var _this = this;
        var oldMode = this.getMode();
        var data = {
            mode: parseInt(mode.toString(), 10)
        }, modeClasses = [
            'jodit-wysiwyg_mode',
            'jodit-source__mode',
            'jodit_split_mode'
        ];
        /**
         * Triggered before setMode executed. If returned false method stopped
         * @param data - PlainObject `{mode: {string}}` In handler you can change data.mode
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeSetMode', function (data) {
         *     data.mode = Jodit.MODE_SOURCE; // not respond to the mode change. Always make the source code mode
         * });
         * ```
         */
        if (this.e.fire('beforeSetMode', data) === false) {
            return;
        }
        this.__mode = [
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT
        ].includes(data.mode)
            ? data.mode
            : jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        if (this.o.saveModeInStorage) {
            this.storage.set('jodit_default_mode', this.mode);
        }
        modeClasses.forEach(function (className) {
            _this.container.classList.remove(className);
        });
        this.container.classList.add(modeClasses[this.mode - 1]);
        /**
         * Triggered after setMode executed
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterSetMode', function () {
         *     editor.setEditorValue(''); // clear editor's value after change mode
         * });
         * ```
         */
        if (oldMode !== this.getMode()) {
            this.e.fire('afterSetMode');
        }
    };
    /**
     * Toggle editor mode WYSIWYG to TEXTAREA(CodeMirror) to SPLIT(WYSIWYG and TEXTAREA) to again WYSIWYG
     *
     * @example
     * ```javascript
     * var editor = Jodit.make('#editor');
     * editor.toggleMode();
     * ```
     */
    Jodit.prototype.toggleMode = function () {
        var mode = this.getMode();
        if ([
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
            this.o.useSplitMode ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT : 9
        ].includes(mode + 1)) {
            mode += 1;
        }
        else {
            mode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        }
        this.setMode(mode);
    };
    /**
     * Switch on/off the editor into the disabled state.
     * When disabled, the user is not able to change the editor content
     * This function firing the `disabled` event.
     */
    Jodit.prototype.setDisabled = function (isDisabled) {
        this.o.disabled = isDisabled;
        var readOnly = this.__wasReadOnly;
        this.setReadOnly(isDisabled || readOnly);
        this.__wasReadOnly = readOnly;
        if (this.editor) {
            this.editor.setAttribute('aria-disabled', isDisabled.toString());
            this.container.classList.toggle('jodit_disabled', isDisabled);
            this.e.fire('disabled', isDisabled);
        }
    };
    /**
     * Return true if editor in disabled mode
     */
    Jodit.prototype.getDisabled = function () {
        return this.o.disabled;
    };
    /**
     * Switch on/off the editor into the read-only state.
     * When in readonly, the user is not able to change the editor content, but can still
     * use some editor functions (show source code, print content, or seach).
     * This function firing the `readonly` event.
     */
    Jodit.prototype.setReadOnly = function (isReadOnly) {
        if (this.__wasReadOnly === isReadOnly) {
            return;
        }
        this.__wasReadOnly = isReadOnly;
        this.o.readonly = isReadOnly;
        if (isReadOnly) {
            this.editor && this.editor.removeAttribute('contenteditable');
        }
        else {
            this.editor && this.editor.setAttribute('contenteditable', 'true');
        }
        this.e && this.e.fire('readonly', isReadOnly);
    };
    /**
     * Return true if editor in read-only mode
     */
    Jodit.prototype.getReadOnly = function () {
        return this.o.readonly;
    };
    Jodit.prototype.focus = function () {
        if (this.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE) {
            this.s.focus();
        }
    };
    Object.defineProperty(Jodit.prototype, "isFocused", {
        get: function () {
            return this.s.isFocused();
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Hook before init
     */
    Jodit.prototype.beforeInitHook = function () {
        // do nothing
    };
    /**
     * Hook after init
     */
    Jodit.prototype.afterInitHook = function () {
        // do nothing
    };
    /** @override **/
    Jodit.prototype.initOptions = function (options) {
        this.options = ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions));
    };
    /** @override **/
    Jodit.prototype.initOwners = function () {
        // in iframe, it can be changed
        this.editorWindow = this.o.ownerWindow;
        this.ownerWindow = this.o.ownerWindow;
    };
    /**
     * Create and init current editable place
     */
    Jodit.prototype.addPlace = function (source, options) {
        var _this = this;
        var element = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(source, this.o.shadowRoot || this.od);
        this.attachEvents(options);
        if (element.attributes) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(element.attributes).forEach(function (attr) {
                var name = attr.name;
                var value = attr.value;
                if (jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions[name] !== undefined &&
                    (!options || options[name] === undefined)) {
                    if (['readonly', 'disabled'].indexOf(name) !== -1) {
                        value = value === '' || value === 'true';
                    }
                    if (/^[0-9]+(\.)?([0-9]+)?$/.test(value.toString())) {
                        value = Number(value);
                    }
                    _this.options[name] = value;
                }
            });
        }
        var container = this.c.div('jodit-container');
        container.classList.add('jodit');
        container.classList.add('jodit-container');
        container.classList.add("jodit_theme_".concat(this.o.theme || 'default'));
        addClassNames(this.o.className, container);
        if (this.o.containerStyle) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(container, this.o.containerStyle);
        }
        var styleValues = this.o.styleValues;
        Object.keys(styleValues).forEach(function (key) {
            var property = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(key);
            container.style.setProperty("--jd-".concat(property), styleValues[key]);
        });
        container.setAttribute('contenteditable', 'false');
        var buffer = null;
        if (this.o.inline) {
            if (['TEXTAREA', 'INPUT'].indexOf(element.nodeName) === -1) {
                container = element;
                element.setAttribute(__defaultClassesKey, element.className.toString());
                buffer = container.innerHTML;
                container.innerHTML = '';
            }
            container.classList.add('jodit_inline');
            container.classList.add('jodit-container');
        }
        // actual for inline mode
        if (element !== container) {
            // hide source element
            if (element.style.display) {
                element.setAttribute(__defaultStyleDisplayKey, element.style.display);
            }
            element.style.display = 'none';
        }
        var workplace = this.c.div('jodit-workplace', {
            contenteditable: false
        });
        container.appendChild(workplace);
        if (element.parentNode && element !== container) {
            element.parentNode.insertBefore(container, element);
        }
        Object.defineProperty(element, 'component', {
            enumerable: false,
            configurable: true,
            value: this
        });
        var editor = this.c.div('jodit-wysiwyg', {
            contenteditable: true,
            'aria-disabled': false,
            tabindex: this.o.tabIndex
        });
        workplace.appendChild(editor);
        var currentPlace = {
            editor: editor,
            element: element,
            container: container,
            workplace: workplace,
            statusbar: new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.StatusBar(this, container),
            options: this.isReady
                ? (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions)
                : this.options,
            history: new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.History(this),
            editorWindow: this.ow
        };
        this.__elementToPlace.set(editor, currentPlace);
        this.setCurrentPlace(currentPlace);
        this.places.push(currentPlace);
        this.setNativeEditorValue(this.getElementValue()); // Init value
        var initResult = this.__initEditor(buffer);
        var opt = this.options;
        var init = function () {
            if (opt.enableDragAndDropFileToEditor &&
                opt.uploader &&
                (opt.uploader.url || opt.uploader.insertImageAsBase64URI)) {
                _this.uploader.bind(_this.editor);
            }
            // in initEditor - the editor could change
            if (!_this.__elementToPlace.get(_this.editor)) {
                _this.__elementToPlace.set(_this.editor, currentPlace);
            }
            _this.e.fire('afterAddPlace', currentPlace);
        };
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(initResult, init);
    };
    Jodit.prototype.addDisclaimer = function (elm) {
        this.workplace.appendChild(elm);
    };
    /**
     * Set current place object
     */
    Jodit.prototype.setCurrentPlace = function (place) {
        if (this.currentPlace === place) {
            return;
        }
        if (!this.isEditorMode()) {
            this.setMode(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG);
        }
        this.currentPlace = place;
        this.buildToolbar();
        if (this.isReady) {
            this.e.fire('changePlace', place);
        }
    };
    Jodit.prototype.__initEditor = function (buffer) {
        var _this = this;
        var result = this.__createEditor();
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(result, function () {
            if (_this.isInDestruct) {
                return;
            }
            // syncro
            if (_this.element !== _this.container) {
                var value = _this.getElementValue();
                if (value !== _this.getEditorValue()) {
                    _this.setEditorValue(value);
                }
            }
            else {
                buffer != null && _this.setEditorValue(buffer); // inline mode
            }
            var mode = _this.o.defaultMode;
            if (_this.o.saveModeInStorage) {
                var localMode = _this.storage.get('jodit_default_mode');
                if (typeof localMode === 'string') {
                    mode = parseInt(localMode, 10);
                }
            }
            _this.setMode(mode);
            if (_this.o.readonly) {
                _this.__wasReadOnly = false;
                _this.setReadOnly(true);
            }
            if (_this.o.disabled) {
                _this.setDisabled(true);
            }
            // if enter plugin isn't installed
            try {
                _this.ed.execCommand('defaultParagraphSeparator', false, _this.o.enter.toLowerCase());
            }
            catch (_a) { }
        });
    };
    /**
     * Create main DIV element and replace source textarea
     */
    Jodit.prototype.__createEditor = function () {
        var _this = this;
        var defaultEditorArea = this.editor;
        var stayDefault = this.e.fire('createEditor', this);
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(stayDefault, function () {
            if (_this.isInDestruct) {
                return;
            }
            if (stayDefault === false || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isPromise)(stayDefault)) {
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(defaultEditorArea);
            }
            addClassNames(_this.o.editorClassName, _this.editor);
            if (_this.o.style) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(_this.editor, _this.o.style);
            }
            _this.e
                .on('synchro', function () {
                _this.setEditorValue();
            })
                .on('focus', function () {
                _this.editorIsActive = true;
            })
                .on('blur', function () { return (_this.editorIsActive = false); });
            _this.__prepareWYSIWYGEditor();
            if (_this.o.triggerChangeEvent) {
                _this.e.on('change', _this.async.debounce(function () {
                    _this.e && _this.e.fire(_this.element, 'change');
                }, _this.defaultTimeout));
            }
        });
    };
    /**
     * Attach some native event listeners
     */
    Jodit.prototype.__prepareWYSIWYGEditor = function () {
        var _this = this;
        var editor = this.editor;
        // direction
        if (this.o.direction) {
            var direction = this.o.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
            this.editor.style.direction = direction;
            this.editor.setAttribute('dir', direction);
            this.container.style.direction = direction;
            this.container.setAttribute('dir', direction);
            this.toolbar.setDirection(direction);
        }
        // proxy events
        this.e
            .on(editor, 'mousedown touchstart focus', function () {
            var place = _this.__elementToPlace.get(editor);
            if (place) {
                _this.setCurrentPlace(place);
            }
        })
            .on(editor, 'compositionend', this.synchronizeValues)
            .on(editor, 'selectionchange selectionstart keydown keyup input keypress dblclick mousedown mouseup ' +
            'click copy cut dragstart drop dragover paste resize touchstart touchend focus blur', function (event) {
            if (_this.o.readonly || _this.__isSilentChange) {
                return;
            }
            var w = _this.ew;
            if (event instanceof w.KeyboardEvent &&
                event.isComposing) {
                return;
            }
            if (_this.e && _this.e.fire) {
                if (_this.e.fire(event.type, event) === false) {
                    return false;
                }
                _this.synchronizeValues();
            }
        });
    };
    Jodit.prototype.fetch = function (url, options) {
        var _this = this;
        var ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_4__/* .Ajax */ .d((0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__assign */ .Cl)({ url: url }, options), this.o.defaultAjaxOptions);
        var destroy = function () {
            _this.e.off('beforeDestruct', destroy);
            _this.progressbar.progress(100).hide();
            ajax.destruct();
        };
        this.e.one('beforeDestruct', destroy);
        this.progressbar.show().progress(30);
        var promise = ajax.send();
        promise.finally(destroy).catch(function () { return null; });
        return promise;
    };
    /**
     * Jodit's Destructor. Remove editor, and return source input
     */
    Jodit.prototype.destruct = function () {
        var _this = this;
        var _a, _b;
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.beforeDestruct);
        this.__elementToPlace.clear();
        (_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cached)(this, 'storage')) === null || _a === void 0 ? void 0 : _a.clear();
        (_b = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cached)(this, 'buffer')) === null || _b === void 0 ? void 0 : _b.clear();
        this.commands.clear();
        this.__selectionLocked = null;
        this.e.off(this.ow, 'resize');
        this.e.off(this.ow);
        this.e.off(this.od);
        this.e.off(this.od.body);
        var tmpValue = this.editor ? this.getEditorValue() : '';
        this.places.forEach(function (_a) {
            var container = _a.container, workplace = _a.workplace, statusbar = _a.statusbar, element = _a.element, iframe = _a.iframe, editor = _a.editor, history = _a.history;
            if (!element) {
                return;
            }
            if (element !== container) {
                if (element.hasAttribute(__defaultStyleDisplayKey)) {
                    var display = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, __defaultStyleDisplayKey);
                    if (display) {
                        element.style.display = display;
                        element.removeAttribute(__defaultStyleDisplayKey);
                    }
                }
                else {
                    element.style.display = '';
                }
            }
            else {
                if (element.hasAttribute(__defaultClassesKey)) {
                    element.className =
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, __defaultClassesKey) || '';
                    element.removeAttribute(__defaultClassesKey);
                }
            }
            if (element.hasAttribute('style') && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, 'style')) {
                element.removeAttribute('style');
            }
            statusbar.destruct();
            _this.e.off(container);
            _this.e.off(element);
            _this.e.off(editor);
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(workplace);
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(editor);
            if (container !== element) {
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(container);
            }
            Object.defineProperty(element, 'component', {
                enumerable: false,
                configurable: true,
                value: null
            });
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(iframe);
            // inline mode
            if (container === element) {
                element.innerHTML = tmpValue;
            }
            history.destruct();
        });
        this.places.length = 0;
        this.currentPlace = {};
        delete jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id];
        _super.prototype.destruct.call(this);
    };
    var Jodit_1;
    Jodit.fatMode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.FAT_MODE;
    Jodit.plugins = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg;
    Jodit.modules = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .modules */ .av;
    Jodit.ns = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .modules */ .av;
    Jodit.decorators = {};
    Jodit.constants = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__;
    Jodit.instances = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF;
    Jodit.lang = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang;
    Jodit.core = {
        Plugin: jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Plugin
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
    ], Jodit.prototype, "createInside", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
    ], Jodit.prototype, "message", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
    ], Jodit.prototype, "s", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
    ], Jodit.prototype, "uploader", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
    ], Jodit.prototype, "filebrowser", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)()
    ], Jodit.prototype, "synchronizeValues", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':internalChange')
    ], Jodit.prototype, "updateElementValue", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], Jodit.prototype, "__prepareWYSIWYGEditor", null);
    Jodit = Jodit_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_5__/* .Dlgs */ .z)
    ], Jodit);
    return Jodit;
}(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.ViewWithToolbar));

function addClassNames(className, elm) {
    if (className) {
        className.split(/\s+/).forEach(function (cn) { return elm.classList.add(cn); });
    }
}


/***/ }),

/***/ 46433:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Line height': 'Lijnhoogte'
};


/***/ }),

/***/ 46602:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Qe: function() { return /* binding */ cursorInTheEdgeOfString; },
/* harmony export */   W8: function() { return /* reexport safe */ _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__.W; },
/* harmony export */   dY: function() { return /* binding */ findCorrectCurrentNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5298);
/* harmony import */ var _move_the_node_along_the_edge_outward__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83541);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */




/**
 * Check if the cursor is at the edge of the string
 * @private
 */
function cursorInTheEdgeOfString(container, offset, start, end) {
    var _a;
    var text = ((_a = container.nodeValue) === null || _a === void 0 ? void 0 : _a.length) ? container.nodeValue : '';
    if (end && text.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '').length > offset) {
        return true;
    }
    var inv = (0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)().exec(text);
    return start && ((inv && inv[0].length < offset) || (!inv && offset > 0));
}
function findCorrectCurrentNode(node, range, rightMode, isCollapsed, checkChild, child) {
    node = range.startContainer.childNodes[range.startOffset];
    if (!node) {
        node = range.startContainer.childNodes[range.startOffset - 1];
        rightMode = true;
    }
    if (node && isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        // test Current method - Cursor in the left of some SPAN
        if (!rightMode && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node.previousSibling)) {
            node = node.previousSibling;
        }
        else if (checkChild) {
            var current = child(node);
            while (current) {
                if (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current)) {
                    node = current;
                    break;
                }
                current = child(current);
            }
        }
    }
    if (node && !isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        var leftChild = node, rightChild = node;
        do {
            leftChild = leftChild.firstChild;
            rightChild = rightChild.lastChild;
        } while (leftChild && rightChild && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(leftChild));
        if (leftChild === rightChild && leftChild && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(leftChild)) {
            node = leftChild;
        }
    }
    return { node: node, rightMode: rightMode };
}


/***/ }),

/***/ 46681:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ UIImagePositionTab; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71151);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29780);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(931);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9645);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










/** @private */
var UIImagePositionTab = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__extends */ .C6)(UIImagePositionTab, _super);
    function UIImagePositionTab(jodit, state, handlers) {
        var _this = _super.call(this, jodit, {
            availableClasses: jodit.o.image.availableClasses
        }) || this;
        _this.state = state;
        _this.handlers = handlers;
        return _this;
    }
    UIImagePositionTab.prototype.className = function () {
        return 'UIImagePositionTab';
    };
    UIImagePositionTab.prototype.render = function (_a) {
        var availableClasses = _a.availableClasses;
        return "<div class=\"jodit-form__group &__editMargins\">\n\t\t\t<label>~Margins~</label>\n\t\t\t<div class=\"jodit-grid jodit_vertical_middle\">\n\t\t\t\t<input class=\"jodit_col-lg-1-5 jodit-input &__marginTop\" type=\"text\" placeholder=\"~top~\"/>\n\t\t\t\t<a style=\"text-align: center;\" class=\"jodit-properties__lock jodit_col-lg-1-5 &__lockMargin\">*lock*</a>\n\t\t\t\t<input disabled=\"disabled\" class=\"jodit_col-lg-1-5 jodit-input &__marginRight\" type=\"text\" placeholder=\"~right~\"/>\n\t\t\t\t<input disabled=\"disabled\" class=\"jodit_col-lg-1-5 jodit-input &__marginBottom\" type=\"text\" placeholder=\"~bottom~\"/>\n\t\t\t\t<input disabled=\"disabled\" class=\"jodit_col-lg-1-5 jodit-input &__marginLeft\" type=\"text\" placeholder=\"~left~\"/>\n\t\t\t</div>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editAlign\">\n\t\t\t<label>~Align~</label>\n\t\t\t<select class=\"jodit-select &__align\">\n\t\t\t\t<option value=\"\">~--Not Set--~</option>\n\t\t\t\t<option value=\"left\">~Left~</option>\n\t\t\t\t<option value=\"center\">~Center~</option>\n\t\t\t\t<option value=\"right\">~Right~</option>\n\t\t\t</select>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editStyle\">\n\t\t\t<label>~Styles~</label>\n\t\t\t<input type=\"text\" class=\"jodit-input &__style\"/>\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editClass\">\n\t\t\t<label>~Classes~</label>\n\t\t\t".concat((function () {
            var classInput = [];
            if (availableClasses && availableClasses.length > 0) {
                classInput.push('<select class="jodit-input jodit-select &__classes">');
                availableClasses.forEach(function (item) {
                    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_8__/* .isString */ .K)(item)) {
                        classInput.push("<option value=\"".concat(item, "\">").concat(item, "</option>"));
                    }
                    else {
                        classInput.push("<option value=\"".concat(item[0], "\">").concat(item[1], "</option>"));
                    }
                });
                classInput.push('</select>');
            }
            else {
                classInput.push('<input type="text" class="jodit-input &__classes"/>');
            }
            return classInput.join('');
        })(), "\n\t\t</div>\n\t\t<div class=\"jodit-form__group &__editId\">\n\t\t\t<label>Id</label>\n\t\t\t<input type=\"text\" class=\"jodit-input &__id\"/>\n\t\t</div>\n\t\t<div\n\t\t\tclass=\"jodit-form__group &__editBorderRadius\"\n\t\t>\n\t\t\t<label>~Border radius~</label>\n\t\t\t<input type=\"number\" class=\"jodit-input &__borderRadius\"/>\n\t\t</div>");
    };
    UIImagePositionTab.prototype.onStateAlignChange = function () {
        var align = this.getElm('align');
        align.value = this.state.values.align;
    };
    UIImagePositionTab.prototype.onChangeAlign = function () {
        var align = this.getElm('align');
        this.state.values.align = align.value;
    };
    UIImagePositionTab.prototype.onStateValuesBorderRadiusChange = function () {
        var borderRadius = this.getElm('borderRadius');
        borderRadius.value = this.state.values.borderRadius.toString();
    };
    UIImagePositionTab.prototype.onChangeBorderRadius = function () {
        var borderRadius = this.getElm('borderRadius');
        this.state.values.borderRadius = parseFloat(borderRadius.value);
    };
    UIImagePositionTab.prototype.onStateValuesIdChange = function () {
        var id = this.getElm('id');
        id.value = this.state.values.id;
    };
    UIImagePositionTab.prototype.onChangeId = function () {
        var id = this.getElm('id');
        this.state.values.id = id.value;
    };
    UIImagePositionTab.prototype.onStateValuesStyleChange = function () {
        var style = this.getElm('style');
        style.value = this.state.values.style;
    };
    UIImagePositionTab.prototype.onChangeStyle = function () {
        var style = this.getElm('style');
        this.state.values.style = style.value;
    };
    UIImagePositionTab.prototype.onStateValuesClassesChange = function () {
        var classes = this.getElm('classes');
        classes.value = this.state.values.classes;
    };
    UIImagePositionTab.prototype.onChangClasses = function () {
        var classes = this.getElm('classes');
        this.state.values.classes = classes.value;
    };
    UIImagePositionTab.prototype.onLockMarginClick = function (e) {
        this.state.marginIsLocked = !this.state.marginIsLocked;
        e.preventDefault();
    };
    UIImagePositionTab.prototype.onChangeMarginIsLocked = function () {
        var _this = this;
        var marginBottom = this.getElm('marginBottom');
        var marginRight = this.getElm('marginRight');
        var marginLeft = this.getElm('marginLeft');
        var lockMargin = this.getElm('lockMargin');
        [marginRight, marginBottom, marginLeft].forEach(function (elm) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_3__/* .attr */ .C)(elm, 'disabled', _this.state.marginIsLocked || null);
        });
        lockMargin.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__/* .Icon */ .I.get(this.state.marginIsLocked ? 'lock' : 'unlock');
        if (this.state.marginIsLocked) {
            var marginTop = this.state.values.marginTop;
            this.state.values.marginRight = marginTop;
            this.state.values.marginBottom = marginTop;
            this.state.values.marginLeft = marginTop;
        }
    };
    UIImagePositionTab.prototype.onStateValuesMarginChange = function () {
        var marginTop = this.getElm('marginTop');
        var marginRight = this.getElm('marginRight');
        var marginBottom = this.getElm('marginBottom');
        var marginLeft = this.getElm('marginLeft');
        marginTop.value = this.state.values.marginTop.toString();
        marginRight.value = this.state.values.marginRight.toString();
        marginBottom.value = this.state.values.marginBottom.toString();
        marginLeft.value = this.state.values.marginLeft.toString();
    };
    UIImagePositionTab.prototype.onChangeMargin = function () {
        var marginTop = this.getElm('marginTop');
        var marginRight = this.getElm('marginRight');
        var marginBottom = this.getElm('marginBottom');
        var marginLeft = this.getElm('marginLeft');
        this.state.values.marginTop = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginTop.value);
        if (this.state.marginIsLocked) {
            this.state.values.marginRight = this.state.values.marginTop;
            this.state.values.marginBottom = this.state.values.marginTop;
            this.state.values.marginLeft = this.state.values.marginTop;
        }
        else {
            this.state.values.marginRight = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginRight.value);
            this.state.values.marginBottom = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginBottom.value);
            this.state.values.marginLeft = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginLeft.value);
        }
    };
    UIImagePositionTab.prototype.hideFieldByOptions = function () {
        var _this = this;
        var opt = this.j.o.image;
        [
            ['editMargins', 'editMargins'],
            ['editAlign', 'editAlign'],
            ['editStyle', 'editStyle'],
            ['editClass', 'editClass'],
            ['editId', 'editId'],
            ['editBorderRadius', 'editBorderRadius']
        ].forEach(function (_a) {
            var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__read */ .zs)(_a, 2), optKey = _b[0], elmKey = _b[1];
            var elm = _this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.align')
    ], UIImagePositionTab.prototype, "onStateAlignChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('align:change')
    ], UIImagePositionTab.prototype, "onChangeAlign", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.borderRadius')
    ], UIImagePositionTab.prototype, "onStateValuesBorderRadiusChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('borderRadius:change')
    ], UIImagePositionTab.prototype, "onChangeBorderRadius", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.id')
    ], UIImagePositionTab.prototype, "onStateValuesIdChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('id:change')
    ], UIImagePositionTab.prototype, "onChangeId", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.style')
    ], UIImagePositionTab.prototype, "onStateValuesStyleChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('style:change')
    ], UIImagePositionTab.prototype, "onChangeStyle", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.classes')
    ], UIImagePositionTab.prototype, "onStateValuesClassesChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('classes:change')
    ], UIImagePositionTab.prototype, "onChangClasses", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('lockMargin:click')
    ], UIImagePositionTab.prototype, "onLockMarginClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.marginIsLocked')
    ], UIImagePositionTab.prototype, "onChangeMarginIsLocked", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)([
            'state.values.marginTop',
            'state.values.marginRight',
            'state.values.marginBottom',
            'state.values.marginLeft'
        ])
    ], UIImagePositionTab.prototype, "onStateValuesMarginChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)([
            'marginTop:change',
            'marginRight:change',
            'marginBottom:change',
            'marginLeft:change'
        ])
    ], UIImagePositionTab.prototype, "onChangeMargin", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready')
    ], UIImagePositionTab.prototype, "hideFieldByOptions", null);
    UIImagePositionTab = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_9__/* .component */ .s
    ], UIImagePositionTab);
    return UIImagePositionTab;
}(jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__/* .UIElement */ .D));



/***/ }),

/***/ 46939:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export selectCells */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71005);
/* harmony import */ var jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11648);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29581);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









var key = 'table_processor_observer';
var MOUSE_MOVE_LABEL = 'onMoveTableSelectCell';
var selectCells = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(selectCells, _super);
    function selectCells() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(arguments), false)) || this;
        /**
         * First selected cell
         */
        _this.__selectedCell = null;
        /**
         * User is selecting cells now
         */
        _this.__isSelectionMode = false;
        return _this;
    }
    Object.defineProperty(selectCells.prototype, "__tableModule", {
        /**
         * Shortcut for Jodit.modules.Table
         */
        get: function () {
            return this.j.getInstance(jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_6__/* .Table */ .X, this.j.o);
        },
        enumerable: false,
        configurable: true
    });
    selectCells.prototype.afterInit = function (jodit) {
        var _this = this;
        if (!jodit.o.tableAllowCellSelection) {
            return;
        }
        jodit.e
            .on('keydown.select-cells', function (event) {
            if (event.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB) {
                _this.unselectCells();
            }
        })
            .on('beforeCommand.select-cells', this.onExecCommand)
            .on('afterCommand.select-cells', this.onAfterCommand)
            // see `plugins/select.ts`
            .on([
            'clickEditor',
            'mousedownTd',
            'mousedownTh',
            'touchstartTd',
            'touchstartTh'
        ]
            .map(function (e) { return e + '.select-cells'; })
            .join(' '), this.onStartSelection)
            // For `clickEditor` correct working. Because `mousedown` on first cell
            // and mouseup on another cell call `click` only for `TR` element.
            .on('clickTr clickTbody', function () {
            var _a;
            var cellsCount = _this.__tableModule.getAllSelectedCells().length;
            if (cellsCount) {
                if (cellsCount > 1) {
                    (_a = _this.j.s.sel) === null || _a === void 0 ? void 0 : _a.removeAllRanges();
                }
                return false;
            }
        });
    };
    /**
     * Mouse click inside the table
     */
    selectCells.prototype.onStartSelection = function (cell) {
        if (this.j.o.readonly) {
            return;
        }
        this.unselectCells();
        if (cell === this.j.editor) {
            return;
        }
        var table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(cell, 'table', this.j.editor);
        if (!cell || !table) {
            return;
        }
        if (!cell.firstChild) {
            cell.appendChild(this.j.createInside.element('br'));
        }
        this.__isSelectionMode = true;
        this.__selectedCell = cell;
        this.__tableModule.addSelection(cell);
        this.j.e
            .on(table, 'mousemove.select-cells touchmove.select-cells', 
        // Don't use decorator because need clear label on mouseup
        this.j.async.throttle(this.__onMove.bind(this, table), {
            label: MOUSE_MOVE_LABEL,
            timeout: this.j.defaultTimeout / 2
        }))
            .on(table, 'mouseup.select-cells touchend.select-cells', this.__onStopSelection.bind(this, table));
        return false;
    };
    selectCells.prototype.onOutsideClick = function () {
        this.__selectedCell = null;
        this.__onRemoveSelection();
    };
    selectCells.prototype.onChange = function () {
        if (!this.j.isLocked && !this.__isSelectionMode) {
            this.__onRemoveSelection();
        }
    };
    /**
     * Mouse move inside the table
     */
    selectCells.prototype.__onMove = function (table, e) {
        var _this = this;
        var _a;
        if (this.j.o.readonly && !this.j.isLocked) {
            return;
        }
        if (this.j.isLockedNotBy(key)) {
            return;
        }
        var node = this.j.ed.elementFromPoint(e.clientX, e.clientY);
        if (!node) {
            return;
        }
        var cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(node, ['td', 'th'], table);
        if (!cell || !this.__selectedCell) {
            return;
        }
        if (cell !== this.__selectedCell) {
            this.j.lock(key);
        }
        this.unselectCells();
        var bound = this.__tableModule.getSelectedBound(table, [
            cell,
            this.__selectedCell
        ]), box = this.__tableModule.formalMatrix(table);
        for (var i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (var j = bound[0][1]; j <= bound[1][1]; j += 1) {
                this.__tableModule.addSelection(box[i][j]);
            }
        }
        var cellsCount = this.__tableModule.getAllSelectedCells().length;
        if (cellsCount > 1) {
            (_a = this.j.s.sel) === null || _a === void 0 ? void 0 : _a.removeAllRanges();
        }
        this.j.e.fire('hidePopup');
        e.stopPropagation();
        // Hack for FireFox for force redraw selection
        (function () {
            var n = _this.j.createInside.fromHTML('<div style="color:rgba(0,0,0,0.01);width:0;height:0">&nbsp;</div>');
            cell.appendChild(n);
            _this.j.async.setTimeout(function () {
                var _a;
                (_a = n.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(n);
            }, _this.j.defaultTimeout / 5);
        })();
    };
    /**
     * On click in outside - remove selection
     */
    selectCells.prototype.__onRemoveSelection = function (e) {
        var _a;
        if (!((_a = e === null || e === void 0 ? void 0 : e.buffer) === null || _a === void 0 ? void 0 : _a.actionTrigger) &&
            !this.__selectedCell &&
            this.__tableModule.getAllSelectedCells().length) {
            this.j.unlock();
            this.unselectCells();
            this.j.e.fire('hidePopup', 'cells');
            return;
        }
        this.__isSelectionMode = false;
        this.__selectedCell = null;
    };
    /**
     * Stop a selection process
     */
    selectCells.prototype.__onStopSelection = function (table, e) {
        var _this = this;
        if (!this.__selectedCell) {
            return;
        }
        this.__isSelectionMode = false;
        this.j.unlock();
        var node = this.j.ed.elementFromPoint(e.clientX, e.clientY);
        if (!node) {
            return;
        }
        var cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(node, ['td', 'th'], table);
        if (!cell) {
            return;
        }
        var ownTable = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(cell, 'table', table);
        if (ownTable && ownTable !== table) {
            return; // Nested tables
        }
        var bound = this.__tableModule.getSelectedBound(table, [
            cell,
            this.__selectedCell
        ]), box = this.__tableModule.formalMatrix(table);
        var max = box[bound[1][0]][bound[1][1]], min = box[bound[0][0]][bound[0][1]];
        this.j.e.fire('showPopup', table, function () {
            var minOffset = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(min, _this.j), maxOffset = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(max, _this.j);
            return {
                left: minOffset.left,
                top: minOffset.top,
                width: maxOffset.left - minOffset.left + maxOffset.width,
                height: maxOffset.top - minOffset.top + maxOffset.height
            };
        }, 'cells');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('table', this.j.editor).forEach(function (table) {
            _this.j.e.off(table, 'mousemove.select-cells touchmove.select-cells mouseup.select-cells touchend.select-cells');
        });
        this.j.async.clearTimeout(MOUSE_MOVE_LABEL);
    };
    /**
     * Remove selection for all cells
     */
    selectCells.prototype.unselectCells = function (currentCell) {
        var module = this.__tableModule;
        var cells = module.getAllSelectedCells();
        if (cells.length) {
            cells.forEach(function (cell) {
                if (!currentCell || currentCell !== cell) {
                    module.removeSelection(cell);
                }
            });
        }
    };
    /**
     * Execute custom commands for table
     */
    selectCells.prototype.onExecCommand = function (command) {
        var _this = this;
        if (/table(splitv|splitg|merge|empty|bin|binrow|bincolumn|addcolumn|addrow)/.test(command)) {
            command = command.replace('table', '');
            var cells = this.__tableModule.getAllSelectedCells();
            if (cells.length) {
                var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(cells, 1), cell = _a[0];
                if (!cell) {
                    return;
                }
                var table_1 = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(cell, 'table', this.j.editor);
                if (!table_1) {
                    return;
                }
                switch (command) {
                    case 'splitv':
                        this.__tableModule.splitVertical(table_1);
                        break;
                    case 'splitg':
                        this.__tableModule.splitHorizontal(table_1);
                        break;
                    case 'merge':
                        this.__tableModule.mergeSelected(table_1);
                        break;
                    case 'empty':
                        cells.forEach(function (td) { return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.detach(td); });
                        break;
                    case 'bin':
                        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(table_1);
                        break;
                    case 'binrow':
                        new Set(cells.map(function (td) { return td.parentNode; })).forEach(function (row) {
                            _this.__tableModule.removeRow(table_1, row.rowIndex);
                        });
                        break;
                    case 'bincolumn':
                        {
                            var columnsSet_1 = new Set(), columns = cells.reduce(function (acc, td) {
                                if (!columnsSet_1.has(td.cellIndex)) {
                                    acc.push(td);
                                    columnsSet_1.add(td.cellIndex);
                                }
                                return acc;
                            }, []);
                            columns.forEach(function (td) {
                                _this.__tableModule.removeColumn(table_1, td.cellIndex);
                            });
                        }
                        break;
                    case 'addcolumnafter':
                    case 'addcolumnbefore':
                        this.__tableModule.appendColumn(table_1, cell, command === 'addcolumnafter');
                        break;
                    case 'addrowafter':
                    case 'addrowbefore':
                        this.__tableModule.appendRow(table_1, cell.parentNode, command === 'addrowafter');
                        break;
                }
            }
            return false;
        }
    };
    /**
     * Add some align after native command
     */
    selectCells.prototype.onAfterCommand = function (command) {
        if (/^justify/.test(command)) {
            this.__tableModule
                .getAllSelectedCells()
                .forEach(function (elm) { return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.alignElement)(command, elm); });
        }
    };
    /** @override */
    selectCells.prototype.beforeDestruct = function (jodit) {
        this.__onRemoveSelection();
        jodit.e.off('.select-cells');
    };
    selectCells.requires = ['select'];
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], selectCells.prototype, "onStartSelection", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':outsideClick')
    ], selectCells.prototype, "onOutsideClick", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':change')
    ], selectCells.prototype, "onChange", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], selectCells.prototype, "__onRemoveSelection", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], selectCells.prototype, "__onStopSelection", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], selectCells.prototype, "onExecCommand", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
    ], selectCells.prototype, "onAfterCommand", null);
    return selectCells;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('selectCells', selectCells);


/***/ }),

/***/ 47165:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_4__.$; },
/* harmony export */   F0: function() { return /* reexport safe */ _area_area__WEBPACK_IMPORTED_MODULE_0__.F; },
/* harmony export */   cY: function() { return /* reexport safe */ _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__.c; },
/* harmony export */   nE: function() { return /* reexport safe */ _file_file__WEBPACK_IMPORTED_MODULE_2__.n; },
/* harmony export */   tS: function() { return /* reexport safe */ _input_input__WEBPACK_IMPORTED_MODULE_3__.t; }
/* harmony export */ });
/* harmony import */ var _area_area__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5454);
/* harmony import */ var _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3006);
/* harmony import */ var _file_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47964);
/* harmony import */ var _input_input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69198);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1540);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */







/***/ }),

/***/ 47238:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: '符号'
};


/***/ }),

/***/ 47317:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ checkUnsplittableBox; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Inside quote/tables cell, etc. you can't split so just add br
 * @private
 */
function checkUnsplittableBox(fake, jodit, currentBox) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.canSplitBlock(currentBox)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(fake, jodit.createInside.element('br'));
        return false;
    }
    return true;
}


/***/ }),

/***/ 47321:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'Símbolo'
};


/***/ }),

/***/ 47791:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export link */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64953);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * Process link. Insert, dblclick or remove format
 */
var link = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__extends */ .C6)(link, _super);
    function link() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__read */ .zs)(arguments), false)) || this;
        /** @override */
        _this.buttons = [
            {
                name: 'link',
                group: 'insert'
            }
        ];
        return _this;
    }
    /** @override */
    link.prototype.afterInit = function (jodit) {
        var _this = this;
        if (jodit.o.link.followOnDblClick) {
            jodit.e.on('dblclick.link', this.onDblClickOnLink);
        }
        if (jodit.o.link.processPastedLink) {
            jodit.e.on('processPaste.link', this.onProcessPasteLink);
        }
        jodit.e.on('generateLinkForm.link', this.__generateForm);
        jodit.registerCommand('openLinkDialog', {
            exec: function () {
                var dialog = jodit.dlg({
                    resizable: false
                });
                var htmlForm = _this.__generateForm(jodit.s.current(), function () {
                    dialog.close();
                });
                htmlForm.container.classList.add('jodit-dialog_alert');
                dialog.setContent(htmlForm);
                dialog.open();
                jodit.async.requestIdleCallback(function () {
                    var url_input = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(htmlForm.container).url_input;
                    url_input === null || url_input === void 0 ? void 0 : url_input.focus();
                });
            },
            hotkeys: jodit.o.link.hotkeys
        });
    };
    link.prototype.onDblClickOnLink = function (e) {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(e.target, 'a')) {
            return;
        }
        var href = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(e.target, 'href');
        if (href) {
            location.href = href;
            e.preventDefault();
        }
    };
    link.prototype.onProcessPasteLink = function (ignore, html) {
        var _a, _b, _c, _d;
        var jodit = this.jodit;
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isURL)(html) || !jodit.o.link.processPastedLink) {
            return;
        }
        jodit.e.stopPropagation('processPaste');
        if (jodit.o.link.processVideoLink) {
            var embed = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)((_b = (_a = jodit.o.video) === null || _a === void 0 ? void 0 : _a.parseUrlToVideoEmbed) !== null && _b !== void 0 ? _b : jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.convertMediaUrlToVideoEmbed, html, {
                width: (_c = jodit.o.video) === null || _c === void 0 ? void 0 : _c.defaultWidth,
                height: (_d = jodit.o.video) === null || _d === void 0 ? void 0 : _d.defaultHeight
            });
            if (embed !== html) {
                return jodit.createInside.fromHTML(embed);
            }
        }
        if (jodit.s.isCollapsed()) {
            var a = jodit.createInside.element('a');
            a.setAttribute('href', html);
            a.textContent = html;
            jodit.e.fire('applyLink', jodit, a, null);
            return a;
        }
        jodit.s.commitStyle({
            element: 'a',
            attributes: {
                href: html
            }
        });
        return true;
    };
    link.prototype.__generateForm = function (current, close) {
        var jodit = this.jodit;
        var i18n = jodit.i18n.bind(jodit), _a = jodit.o.link, openInNewTabCheckbox = _a.openInNewTabCheckbox, noFollowCheckbox = _a.noFollowCheckbox, formTemplate = _a.formTemplate, formClassName = _a.formClassName, modeClassName = _a.modeClassName;
        var html = formTemplate(jodit);
        var form = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(html)
            ? jodit.c.fromHTML(html, {
                target_checkbox_box: openInNewTabCheckbox,
                nofollow_checkbox_box: noFollowCheckbox
            })
            : html;
        var htmlForm = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(form) ? form : form.container;
        var elements = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(htmlForm);
        var insert = elements.insert, unlink = elements.unlink, content_input_box = elements.content_input_box;
        var _b = elements, target_checkbox = _b.target_checkbox, nofollow_checkbox = _b.nofollow_checkbox, url_input = _b.url_input;
        var currentElement = current;
        var isImageContent = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isImage(currentElement);
        var content_input = elements.content_input;
        var className_input = elements.className_input, className_select = elements.className_select;
        if (!content_input) {
            content_input = jodit.c.element('input', {
                type: 'hidden',
                ref: 'content_input'
            });
        }
        if (formClassName) {
            htmlForm.classList.add(formClassName);
        }
        if (isImageContent) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.hide(content_input_box);
        }
        var link;
        var getSelectionText = function () {
            return link
                ? link.innerText
                : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.stripTags)(jodit.s.range.cloneContents(), jodit.ed);
        };
        if (current && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(current, 'a', jodit.editor)) {
            link = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(current, 'a', jodit.editor);
        }
        else {
            link = false;
        }
        if (!isImageContent && current) {
            content_input.value = getSelectionText();
        }
        if (link) {
            url_input.value = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'href') || '';
            if (modeClassName) {
                readClassnames(modeClassName, className_input, link, className_select);
            }
            if (openInNewTabCheckbox && target_checkbox) {
                target_checkbox.checked = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'target') === '_blank';
            }
            if (noFollowCheckbox && nofollow_checkbox) {
                nofollow_checkbox.checked = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'rel') === 'nofollow';
            }
            insert.textContent = i18n('Update');
        }
        else {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.hide(unlink);
        }
        jodit.editor.normalize();
        var snapshot = jodit.history.snapshot.make();
        if (unlink) {
            jodit.e.on(unlink, 'click', function (e) {
                jodit.s.restore();
                jodit.history.snapshot.restore(snapshot);
                if (link) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(link);
                }
                jodit.synchronizeValues();
                close();
                e.preventDefault();
            });
        }
        var onSubmit = function () {
            if (!url_input.value.trim().length) {
                url_input.focus();
                url_input.classList.add('jodit_error');
                return false;
            }
            var links;
            jodit.s.restore();
            jodit.s.removeMarkers();
            jodit.editor.normalize();
            jodit.history.snapshot.restore(snapshot);
            var textWasChanged = getSelectionText() !== content_input.value.trim();
            var ci = jodit.createInside;
            if (!link || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(jodit.editor, link)) {
                if (!jodit.s.isCollapsed()) {
                    var node = jodit.s.current();
                    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(node, 'img')) {
                        links = [jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrap(node, 'a', ci)];
                    }
                    else {
                        links = jodit.s.wrapInTag('a');
                    }
                }
                else {
                    var a = ci.element('a');
                    jodit.s.insertNode(a, false, false);
                    links = [a];
                }
                links.forEach(function (link) { return jodit.s.select(link); });
            }
            else {
                links = [link];
            }
            links.forEach(function (a) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'href', url_input.value);
                writeClasses(modeClassName, className_input, className_select, a);
                if (!isImageContent) {
                    writeImage(a, content_input, textWasChanged, url_input);
                }
                if (openInNewTabCheckbox && target_checkbox) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'target', target_checkbox.checked ? '_blank' : null);
                }
                if (noFollowCheckbox && nofollow_checkbox) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'rel', nofollow_checkbox.checked ? 'nofollow' : null);
                }
                jodit.e.fire('applyLink', jodit, a, form);
            });
            jodit.synchronizeValues();
            close();
            return false;
        };
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(form)) {
            jodit.e.on(form, 'submit', function (event) {
                event.preventDefault();
                event.stopImmediatePropagation();
                onSubmit();
                return false;
            });
        }
        else {
            form.onSubmit(onSubmit);
        }
        return form;
    };
    /** @override */
    link.prototype.beforeDestruct = function (jodit) {
        jodit.e
            .off('generateLinkForm.link', this.__generateForm)
            .off('dblclick.link', this.onDblClickOnLink)
            .off('processPaste.link', this.onProcessPasteLink);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], link.prototype, "onDblClickOnLink", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], link.prototype, "onProcessPasteLink", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], link.prototype, "__generateForm", null);
    return link;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('link', link);
function writeClasses(modeClassName, className_input, className_select, a) {
    var _a;
    if (modeClassName && (className_input !== null && className_input !== void 0 ? className_input : className_select)) {
        if (modeClassName === 'input') {
            if (className_input.value === '' && a.hasAttribute('class')) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'class', null);
            }
            if (className_input.value !== '') {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'class', className_input.value);
            }
        }
        else if (modeClassName === 'select') {
            if (a.hasAttribute('class')) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'class', null);
            }
            for (var i = 0; i < className_select.selectedOptions.length; i++) {
                var className = (_a = className_select.selectedOptions.item(i)) === null || _a === void 0 ? void 0 : _a.value;
                if (className) {
                    a.classList.add(className);
                }
            }
        }
    }
}
function readClassnames(modeClassName, className_input, link, className_select) {
    switch (modeClassName) {
        case 'input':
            if (className_input) {
                className_input.value = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'class') || '';
            }
            break;
        case 'select':
            if (className_select) {
                for (var i = 0; i < className_select.selectedOptions.length; i++) {
                    var option = className_select.options.item(i);
                    if (option) {
                        option.selected = false;
                    }
                }
                var classNames = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'class') || '';
                classNames.split(' ').forEach(function (className) {
                    if (className) {
                        for (var i = 0; i < className_select.options.length; i++) {
                            var option = className_select.options.item(i);
                            if ((option === null || option === void 0 ? void 0 : option.value) && option.value === className) {
                                option.selected = true;
                            }
                        }
                    }
                });
            }
            break;
    }
}
function writeImage(a, content_input, textWasChanged, url_input) {
    var newContent = a.textContent;
    if (content_input.value.trim().length) {
        if (textWasChanged) {
            newContent = content_input.value;
        }
    }
    else {
        newContent = url_input.value;
    }
    var content = a.textContent;
    if (newContent !== content) {
        a.textContent = newContent;
    }
}


/***/ }),

/***/ 47964:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: function() { return /* binding */ UIFileInput; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var UIFileInput = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__extends */ .C6)(UIFileInput, _super);
    function UIFileInput(jodit, options) {
        var _this = _super.call(this, jodit, (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__assign */ .Cl)({ type: 'file' }, options)) || this;
        _this.state = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__assign */ .Cl)((0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__assign */ .Cl)({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { type: 'file', onlyImages: true });
        return _this;
    }
    /** @override */
    UIFileInput.prototype.className = function () {
        return 'UIFileInput';
    };
    UIFileInput.prototype.createContainer = function (options) {
        this.button = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(this.j, {
            tooltip: options.tooltip,
            icon: {
                name: 'plus'
            }
        });
        var container = this.button.container;
        if (!this.nativeInput) {
            this.nativeInput = this.createNativeInput(options);
        }
        var nativeInput = this.nativeInput;
        nativeInput.classList.add(this.getFullElName('input'));
        container.classList.add(this.componentName);
        container.appendChild(nativeInput);
        return container;
    };
    UIFileInput.prototype.createNativeInput = function (options) {
        return this.j.create.fromHTML("<input\n\t\t\ttype=\"file\"\n\t\t\taccept=\"".concat(options.onlyImages ? 'image/*' : '*', "\"\n\t\t\ttabindex=\"-1\"\n\t\t\tdir=\"auto\"\n\t\t\tmultiple=\"\"\n\t\t/>"));
    };
    UIFileInput = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
        jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
    ], UIFileInput);
    return UIFileInput;
}(jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t));



/***/ }),

/***/ 48007:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm-1280-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68