/*!
 * jodit - Jodit is an awesome and useful wysiwyg editor with filebrowser
 * Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/jodit/)
 * Version: v4.5.16
 * Url: https://xdsoft.net/jodit/
 * License(s): MIT
 */
	
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function() {
return (self["webpackChunkjodit"] = self["webpackChunkjodit"] || []).push([[882],{

/***/ 3424:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'regel',
    delete: 'verwijderen',
    space: 'ruimte',
    'Speech Recognize': 'Spraak Herkennen',
    Sound: 'Geluid',
    'Interim Results': 'Tussentijdse Resultaten'
};


/***/ }),

/***/ 13958:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'nouvelle ligne',
    delete: 'supprimer',
    space: 'espace',
    'Speech Recognize': 'Reconnaissance Vocale',
    Sound: 'Son',
    'Interim Results': 'Résultats Intermédiaires'
};


/***/ }),

/***/ 14765:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'újsor',
    delete: 'törlés',
    space: 'tér',
    'Speech Recognize': 'A Beszéd Felismeri',
    Sound: 'Hang',
    'Interim Results': 'Időközi Eredmények'
};


/***/ }),

/***/ 15603:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'خط جدید',
    delete: 'حذف',
    space: 'فضا',
    'Speech Recognize': 'گفتار را تشخیص دهید',
    Sound: 'صدا',
    'Interim Results': 'نتایج موقت'
};


/***/ }),

/***/ 16491:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'новая строка|перенос|энтер',
    delete: 'удалить',
    space: 'пробел',
    'Speech Recognize': 'Распознавание речи',
    Sound: 'Звук',
    'Interim Results': 'Промежуточные результаты'
};


/***/ }),

/***/ 18717:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'חדשות',
    delete: 'מחק',
    space: 'שטח',
    'Speech Recognize': 'דיבור מזהה',
    Sound: 'קול',
    'Interim Results': 'תוצאות ביניים'
};


/***/ }),

/***/ 22227:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 16 16\" xml:space=\"preserve\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M8,11c1.657,0,3-1.343,3-3V3c0-1.657-1.343-3-3-3S5,1.343,5,3v5C5,9.657,6.343,11,8,11z\"/> <path d=\"M13,8V6h-1l0,1.844c0,1.92-1.282,3.688-3.164,4.071C6.266,12.438,4,10.479,4,8V6H3v2c0,2.414,1.721,4.434,4,4.899V15H5v1h6 v-1H9v-2.101C11.279,12.434,13,10.414,13,8z\"/> </svg>"

/***/ }),

/***/ 25202:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ar: function() { return /* reexport module object */ _ar_js__WEBPACK_IMPORTED_MODULE_0__; },
/* harmony export */   cs_cz: function() { return /* reexport module object */ _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   de: function() { return /* reexport module object */ _de_js__WEBPACK_IMPORTED_MODULE_2__; },
/* harmony export */   es: function() { return /* reexport module object */ _es_js__WEBPACK_IMPORTED_MODULE_3__; },
/* harmony export */   fa: function() { return /* reexport module object */ _fa_js__WEBPACK_IMPORTED_MODULE_4__; },
/* harmony export */   fi: function() { return /* reexport module object */ _fi_js__WEBPACK_IMPORTED_MODULE_5__; },
/* harmony export */   fr: function() { return /* reexport module object */ _fr_js__WEBPACK_IMPORTED_MODULE_6__; },
/* harmony export */   he: function() { return /* reexport module object */ _he_js__WEBPACK_IMPORTED_MODULE_7__; },
/* harmony export */   hu: function() { return /* reexport module object */ _hu_js__WEBPACK_IMPORTED_MODULE_8__; },
/* harmony export */   id: function() { return /* reexport module object */ _id_js__WEBPACK_IMPORTED_MODULE_9__; },
/* harmony export */   it: function() { return /* reexport module object */ _it_js__WEBPACK_IMPORTED_MODULE_10__; },
/* harmony export */   ja: function() { return /* reexport module object */ _ja_js__WEBPACK_IMPORTED_MODULE_11__; },
/* harmony export */   ko: function() { return /* reexport module object */ _ko_js__WEBPACK_IMPORTED_MODULE_12__; },
/* harmony export */   mn: function() { return /* reexport module object */ _mn_js__WEBPACK_IMPORTED_MODULE_13__; },
/* harmony export */   nl: function() { return /* reexport module object */ _nl_js__WEBPACK_IMPORTED_MODULE_14__; },
/* harmony export */   pl: function() { return /* reexport module object */ _pl_js__WEBPACK_IMPORTED_MODULE_15__; },
/* harmony export */   pt_br: function() { return /* reexport module object */ _pt_br_js__WEBPACK_IMPORTED_MODULE_16__; },
/* harmony export */   ru: function() { return /* reexport module object */ _ru_js__WEBPACK_IMPORTED_MODULE_17__; },
/* harmony export */   tr: function() { return /* reexport module object */ _tr_js__WEBPACK_IMPORTED_MODULE_18__; },
/* harmony export */   ua: function() { return /* reexport module object */ _ua_js__WEBPACK_IMPORTED_MODULE_19__; },
/* harmony export */   zh_cn: function() { return /* reexport module object */ _zh_cn_js__WEBPACK_IMPORTED_MODULE_20__; },
/* harmony export */   zh_tw: function() { return /* reexport module object */ _zh_tw_js__WEBPACK_IMPORTED_MODULE_21__; }
/* harmony export */ });
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61593);
/* harmony import */ var _ar_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_ar_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64458);
/* harmony import */ var _cs_cz_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_cs_cz_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89601);
/* harmony import */ var _de_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_de_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87710);
/* harmony import */ var _es_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_es_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _fa_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(15603);
/* harmony import */ var _fa_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_fa_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _fi_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(84059);
/* harmony import */ var _fi_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_fi_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13958);
/* harmony import */ var _fr_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_fr_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _he_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(18717);
/* harmony import */ var _he_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_he_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14765);
/* harmony import */ var _hu_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_hu_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _id_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(77995);
/* harmony import */ var _id_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_id_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(92315);
/* harmony import */ var _it_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_it_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(54711);
/* harmony import */ var _ja_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_ja_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _ko_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(68632);
/* harmony import */ var _ko_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_ko_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _mn_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(76769);
/* harmony import */ var _mn_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_mn_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(3424);
/* harmony import */ var _nl_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_nl_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(85454);
/* harmony import */ var _pl_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_pl_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(64149);
/* harmony import */ var _pt_br_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_pt_br_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _ru_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(16491);
/* harmony import */ var _ru_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_ru_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(48948);
/* harmony import */ var _tr_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_tr_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _ua_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(95700);
/* harmony import */ var _ua_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_ua_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(84370);
/* harmony import */ var _zh_cn_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(_zh_cn_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(56646);
/* harmony import */ var _zh_tw_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(_zh_tw_js__WEBPACK_IMPORTED_MODULE_21__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
// @ts-nocheck

























/***/ }),

/***/ 37873:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SpeechRecognizeNative: function() { return /* binding */ SpeechRecognizeNative; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84976);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71096);
/* harmony import */ var _jodit__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46173);
/* harmony import */ var _helpers_exec_spell_command__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(50834);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(25202);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











var SpeechRecognizeNative = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__extends */ .C6)(SpeechRecognizeNative, _super);
    function SpeechRecognizeNative() {
        var _this = _super.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__spreadArray */ .fX)([], (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__read */ .zs)(arguments), false)) || this;
        _this.buttons = [
            {
                group: 'state',
                name: 'speechRecognize'
            }
        ];
        _this._commandToWord = {};
        return _this;
    }
    SpeechRecognizeNative.prototype.afterInit = function (jodit) {
        var _this = this;
        var commands = jodit.o.speechRecognize.commands;
        if (commands) {
            (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .extendLang */ .JW)(_langs__WEBPACK_IMPORTED_MODULE_7__);
            (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__/* .keys */ .HP)(commands, false).forEach(function (words) {
                var keys = words.split('|');
                keys.forEach(function (key) {
                    key = key.trim().toLowerCase();
                    _this._commandToWord[key] = commands[words];
                    var translatedKeys = jodit.i18n(key);
                    if (translatedKeys !== key) {
                        translatedKeys.split('|').forEach(function (translatedKey) {
                            _this._commandToWord[translatedKey.trim().toLowerCase()] = commands[words].trim();
                        });
                    }
                });
            });
        }
    };
    SpeechRecognizeNative.prototype.beforeDestruct = function (jodit) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.messagePopup);
    };
    SpeechRecognizeNative.prototype.onSpeechRecognizeProgressResult = function (text) {
        var _this = this;
        if (!this.messagePopup) {
            this.messagePopup = this.j.create.div('jodit-speech-recognize__popup');
        }
        this.j.workplace.appendChild(this.messagePopup);
        this.j.async.clearTimeout(this.__hidePopupTimeout);
        this.__hidePopupTimeout = this.j.async.setTimeout(function () {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(_this.messagePopup);
        }, 1000);
        this.messagePopup.innerText = text + '|';
    };
    SpeechRecognizeNative.prototype.onSpeechRecognizeResult = function (text) {
        this.j.async.clearTimeout(this.__hidePopupTimeout);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.messagePopup);
        var j = this.j;
        var s = j.s;
        if (!this._checkCommand(text)) {
            var range = s.range, node = s.current();
            if (s.isCollapsed() &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node) &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(j.editor, node) &&
                node.nodeValue) {
                var sentence = node.nodeValue;
                node.nodeValue =
                    sentence +
                        (/[\u00A0 ]\uFEFF*$/.test(sentence) ? '' : ' ') +
                        text;
                range.setStartAfter(node);
                s.selectRange(range);
                j.synchronizeValues();
            }
            else {
                s.insertHTML(text);
            }
        }
    };
    SpeechRecognizeNative.prototype._checkCommand = function (command) {
        command = command.toLowerCase().replace(/\./g, '');
        if (this._commandToWord[command]) {
            (0,_helpers_exec_spell_command__WEBPACK_IMPORTED_MODULE_9__/* .execSpellCommand */ .F)(this.j, this._commandToWord[command]);
            return true;
        }
        return false;
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .watch */ .w)(':speechRecognizeProgressResult')
    ], SpeechRecognizeNative.prototype, "onSpeechRecognizeProgressResult", null);
    (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
        (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .watch */ .w)(':speechRecognizeResult')
    ], SpeechRecognizeNative.prototype, "onSpeechRecognizeResult", null);
    return SpeechRecognizeNative;
}(jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k));

_jodit__WEBPACK_IMPORTED_MODULE_6__/* .Jodit */ .x.plugins.add('speech-recognize', SpeechRecognizeNative);


/***/ }),

/***/ 48948:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'yeni satır',
    delete: 'silmek',
    space: 'uzay',
    'Speech Recognize': 'Konuşma Tanıma',
    Sound: 'Ses',
    'Interim Results': 'Ara Sonuçlar'
};


/***/ }),

/***/ 50834:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ execSpellCommand; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

function execSpellCommand(jodit, commandSentence) {
    var _a = (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__read */ .zs)(commandSentence.split('::'), 2), command = _a[0], value = _a[1];
    jodit.execCommand(command, null, value);
}


/***/ }),

/***/ 54711:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: '改行',
    delete: '削除',
    space: 'スペース',
    'Speech Recognize': '音声認識',
    Sound: '音',
    'Interim Results': '中間結果'
};


/***/ }),

/***/ 56646:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: '換行',
    delete: '刪除',
    space: '空白',
    'Speech Recognize': '語音辨識',
    Sound: '聲音',
    'Interim Results': '階段性辨識結果'
};


/***/ }),

/***/ 61593:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'الخط الجديد',
    delete: 'حذف',
    space: 'الفضاء',
    'Speech Recognize': 'التعرف على الكلام',
    Sound: 'الصوت',
    'Interim Results': 'النتائج المؤقتة'
};


/***/ }),

/***/ 64149:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'linha',
    delete: 'excluir',
    space: 'espaco',
    'Speech Recognize': 'Discurso Reconhecer',
    Sound: 'Som',
    'Interim Results': 'Resultados Provisórios'
};


/***/ }),

/***/ 64458:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'řádek',
    delete: 'odstranit',
    space: 'prostora',
    'Speech Recognize': 'Rozpoznání Řeči',
    Sound: 'Zvuk',
    'Interim Results': 'Průběžné Výsledky'
};


/***/ }),

/***/ 68632:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: '줄 바꿈',
    delete: '삭제',
    space: '공간',
    'Speech Recognize': '음성 인식',
    Sound: '소리',
    'Interim Results': '중간 결과'
};


/***/ }),

/***/ 71096:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(9810);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(72197);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var _helpers_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71722);
/* harmony import */ var _helpers_recognize_manager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93676);
/* harmony import */ var _speech_recognize_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22227);
/* harmony import */ var _speech_recognize_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_speech_recognize_svg__WEBPACK_IMPORTED_MODULE_6__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.speechRecognize = {
    api: typeof _helpers_api__WEBPACK_IMPORTED_MODULE_4__/* .SpeechRecognition */ .o !== 'undefined' ? _helpers_api__WEBPACK_IMPORTED_MODULE_4__/* .SpeechRecognition */ .o : null,
    sound: true,
    continuous: false,
    interimResults: true,
    commands: {
        'newline|enter': 'enter',
        'delete|remove word|delete word': 'backspaceWordButton',
        comma: 'inserthtml::,',
        underline: 'inserthtml::_',
        hyphen: 'inserthtml::-',
        space: 'inserthtml:: ',
        question: 'inserthtml::?',
        dot: 'inserthtml::.',
        'quote|quotes|open quote': "inserthtml::'",
        'header|header h1': 'formatblock::h1',
        'select all': 'selectall'
    }
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.set('speech-recognize', (_speech_recognize_svg__WEBPACK_IMPORTED_MODULE_6___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.speechRecognize = {
    isVisible: function (j) {
        return Boolean(j.o.speechRecognize.api);
    },
    isActive: function (jodit, _) {
        var api = (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(jodit, 'speech');
        return Boolean(api === null || api === void 0 ? void 0 : api.isEnabled);
    },
    isDisabled: function (jodit) {
        return !jodit.o.speechRecognize.api;
    },
    exec: function (jodit, current, _a) {
        var _b;
        var button = _a.button, control = _a.control;
        var _c = jodit.o.speechRecognize, ApiConstructor = _c.api, lang = _c.lang, continuous = _c.continuous, interimResults = _c.interimResults, sound = _c.sound;
        if (!ApiConstructor) {
            jodit.alert('Speech recognize API unsupported in your browser');
            return;
        }
        var api = (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(jodit, 'speech');
        if (!api) {
            var nativeApi = new ApiConstructor();
            api = new _helpers_recognize_manager__WEBPACK_IMPORTED_MODULE_5__/* .RecognizeManager */ .g(jodit.async, nativeApi);
            api.lang = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__/* .isString */ .K)(lang)
                ? lang
                : ((_b = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(jodit.od.documentElement, 'lang')) !== null && _b !== void 0 ? _b : undefined);
            api.continuous = continuous;
            api.interimResults = interimResults;
            api.sound = sound;
            (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(jodit, 'speech', api);
            api.on('pulse', function (enable) {
                button.setMod('pulse', enable);
            });
            api.on('result', function (text) {
                return jodit.e.fire('speechRecognizeResult', text);
            });
            api.on('progress', function (text) {
                return jodit.e.fire('speechRecognizeProgressResult', text);
            });
            api.on('error', function (text) { return jodit.message.error(text); });
            button.hookStatus('beforeDestruct', function () {
                (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(jodit, 'speech', null);
                api.destruct();
            });
        }
        if (control.args) {
            var key = control.args[0];
            if ((0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_8__/* .isBoolean */ .L)(api[key])) {
                api[key] = !api[key];
                if (api.isEnabled) {
                    api.restart();
                }
                return;
            }
        }
        api.toggle();
        if (api.isEnabled) {
            button.setMod('pulse', true);
        }
        button.state.activated = api.isEnabled;
    },
    name: 'speechRecognize',
    command: 'toggleSpeechRecognize',
    tooltip: 'Speech Recognize',
    list: {
        sound: 'Sound',
        interimResults: 'Interim Results'
    },
    childTemplate: function (jodit, key, value) {
        var _a;
        var api = (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(jodit, 'speech'), checked = (_a = api === null || api === void 0 ? void 0 : api[key]) !== null && _a !== void 0 ? _a : jodit.o.speechRecognize[key];
        return "<span class='jodit-speech-recognize__list-item'><input ".concat(checked ? 'checked' : '', " class='jodit-checkbox' type='checkbox'>&nbsp;").concat(value, "</span>");
    },
    mods: {
        stroke: false
    }
};


/***/ }),

/***/ 71722:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   o: function() { return /* binding */ SpeechRecognition; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

var SpeechRecognition = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow
    ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.SpeechRecognition ||
        jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.webkitSpeechRecognition
    : undefined;


/***/ }),

/***/ 76769:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'Шинэ мөр',
    delete: 'Устгах',
    space: 'Зай',
    'Speech Recognize': 'Дуу хоолой таних',
    Sound: 'Дуу',
    'Interim Results': 'Түр зуурын үр дүн'
};


/***/ }),

/***/ 77995:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'newline',
    delete: 'Hapus',
    space: 'ruang',
    'Speech Recognize': 'Pidato Mengenali',
    Sound: 'Suara',
    'Interim Results': 'Hasil Sementara'
};


/***/ }),

/***/ 81629:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ PII; },
/* harmony export */   Z: function() { return /* binding */ WARN; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/speech-recognize
 * @internal
 */
var PII = 440;
var WARN = 940;


/***/ }),

/***/ 84059:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'Speech Recognize': 'Puheentunnistus',
    newline: 'uusi rivi',
    delete: 'poistaa',
    space: 'tilaa',
    Sound: 'Ääni',
    'Interim Results': 'Välitulokset'
};


/***/ }),

/***/ 84370:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: '新行',
    delete: '删除',
    space: '空间',
    'Speech Recognize': '言语识别',
    Sound: '声音',
    'Interim Results': '中期业绩'
};


/***/ }),

/***/ 85454:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'newline',
    delete: 'usunąć',
    space: 'przestrzeń',
    'Speech Recognize': 'Rozpoznawanie Mowy',
    Sound: 'Dźwięk',
    'Interim Results': 'Wyniki Okresowe'
};


/***/ }),

/***/ 87710:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'nueva línea',
    delete: 'eliminar',
    space: 'espacio',
    'Speech Recognize': 'Reconocimiento de Voz',
    Sound: 'Sonido',
    'Interim Results': 'Resultados Provisionales'
};


/***/ }),

/***/ 89601:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'Zeilenumbruch',
    delete: 'löschen',
    space: 'Raum',
    'Speech Recognize': 'Sprache Erkennen',
    Sound: 'Sound',
    'Interim Results': 'Zwischenergebnis'
};


/***/ }),

/***/ 92315:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'nuova riga',
    delete: 'eliminare',
    space: 'spazio',
    'Speech Recognize': 'Discorso Riconoscere',
    Sound: 'Suono',
    'Interim Results': 'Risultati intermedi'
};


/***/ }),

/***/ 93676:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: function() { return /* binding */ RecognizeManager; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43431);
/* harmony import */ var _sound__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95473);
/* harmony import */ var jodit_plugins_speech_recognize_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81629);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





var RecognizeManager = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__extends */ .C6)(RecognizeManager, _super);
    function RecognizeManager(async, api) {
        var _this = _super.call(this) || this;
        _this.async = async;
        _this._continuous = false;
        _this._interimResults = false;
        _this.sound = true;
        _this._isEnabled = false;
        _this._restartTimeout = 0;
        _this._onSpeechStart = function (e) {
            if (!_this._isEnabled) {
                return;
            }
            _this.async.clearTimeout(_this._restartTimeout);
            _this._restartTimeout = _this.async.setTimeout(function () {
                _this.restart();
                _this.emit('pulse', false);
                _this._makeSound(jodit_plugins_speech_recognize_constants__WEBPACK_IMPORTED_MODULE_4__/* .WARN */ .Z);
            }, 5000);
            _this.emit('pulse', true);
        };
        _this.__interimResults = '';
        _this._api = api;
        RecognizeManager_1._instances.add(_this);
        return _this;
    }
    RecognizeManager_1 = RecognizeManager;
    Object.defineProperty(RecognizeManager.prototype, "lang", {
        get: function () {
            return this._lang;
        },
        set: function (v) {
            this._lang = v;
            this._api.lang = v;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RecognizeManager.prototype, "continuous", {
        get: function () {
            return this._continuous;
        },
        set: function (v) {
            this._continuous = v;
            this._api.continuous = v;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RecognizeManager.prototype, "interimResults", {
        get: function () {
            return this._interimResults;
        },
        set: function (v) {
            this._interimResults = v;
            this._api.interimResults = v;
        },
        enumerable: false,
        configurable: true
    });
    RecognizeManager.prototype.destruct = function () {
        this.stop();
        RecognizeManager_1._instances.delete(this);
        _super.prototype.destruct.call(this);
    };
    Object.defineProperty(RecognizeManager.prototype, "isEnabled", {
        get: function () {
            return this._isEnabled;
        },
        enumerable: false,
        configurable: true
    });
    RecognizeManager.prototype.start = function () {
        var _this = this;
        if (this._isEnabled) {
            return;
        }
        this._isEnabled = true;
        RecognizeManager_1._instances.forEach(function (instance) {
            if (instance !== _this) {
                instance.stop();
            }
        });
        try {
            this._api.start();
        }
        catch (e) {
            this._onError(e);
            this.stop();
            return;
        }
        this.__on('speechstart', this._onSpeechStart)
            .__on('error', this._onError)
            .__on('result', this._onProgress)
            .__on('end', this._onResults);
    };
    RecognizeManager.prototype.stop = function () {
        if (!this._isEnabled) {
            return;
        }
        this._api.abort();
        this._api.stop();
        this.__off('speechstart', this._onSpeechStart)
            .__off('error', this._onError)
            .__off('result', this._onProgress)
            .__off('end', this._onResults);
        this.async.clearTimeout(this._restartTimeout);
        this._isEnabled = false;
        this.emit('pulse', false);
    };
    RecognizeManager.prototype.toggle = function () {
        if (!this._isEnabled) {
            this.start();
        }
        else {
            this.stop();
        }
    };
    RecognizeManager.prototype.restart = function () {
        this.stop();
        this.start();
    };
    RecognizeManager.prototype.__on = function (event, callback) {
        this._api.addEventListener(event, callback);
        return this;
    };
    RecognizeManager.prototype.__off = function (event, callback) {
        this._api.removeEventListener(event, callback);
        return this;
    };
    RecognizeManager.prototype._onResults = function (e) {
        this.emit('pulse', false);
        this.emit('result', this.__interimResults);
        this.__interimResults = '';
        this._makeSound(jodit_plugins_speech_recognize_constants__WEBPACK_IMPORTED_MODULE_4__/* .PII */ .N);
        this.restart();
    };
    RecognizeManager.prototype._onProgress = function (e) {
        if (!this._isEnabled) {
            return;
        }
        this.__interimResults = '';
        if (!e.results) {
            return;
        }
        for (var i = 0; i < e.results.length; i++) {
            var resultItem = e.results.item(i);
            if (resultItem.length) {
                var transcript = resultItem.item(0).transcript;
                this.__interimResults += transcript;
            }
        }
        if (this.__interimResults) {
            this.emit('progress', this.__interimResults);
        }
    };
    RecognizeManager.prototype._onError = function (e) {
        if (e.error === 'voice-unavailable') {
            this.emit('error', 'Voice unavailable');
        }
        if (e.error === 'not-allowed') {
            this.emit('error', 'Not allowed');
        }
        if (e.error === 'language-unavailable' ||
            // @ts-ignore
            e.error === 'language-not-supported') {
            this.emit('error', 'Language unavailable');
        }
        this._makeSound(jodit_plugins_speech_recognize_constants__WEBPACK_IMPORTED_MODULE_4__/* .WARN */ .Z);
        this.emit('pulse', false);
        this.stop();
    };
    RecognizeManager.prototype._makeSound = function (frequency) {
        if (this.sound) {
            (0,_sound__WEBPACK_IMPORTED_MODULE_2__/* .sound */ .s)({ frequency: frequency });
        }
    };
    var RecognizeManager_1;
    RecognizeManager._instances = new Set();
    RecognizeManager = RecognizeManager_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
        jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
    ], RecognizeManager);
    return RecognizeManager;
}(jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_1__/* .Eventify */ .h));



/***/ }),

/***/ 95473:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ sound; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_plugins_speech_recognize_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81629);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/speech-recognize
 */


/**
 * @internal
 */
function sound(_a) {
    var _b = _a === void 0 ? {} : _a, _c = _b.sec, sec = _c === void 0 ? 0.1 : _c, _d = _b.frequency, frequency = _d === void 0 ? jodit_plugins_speech_recognize_constants__WEBPACK_IMPORTED_MODULE_1__/* .PII */ .N : _d, _e = _b.gain, gain = _e === void 0 ? 0.1 : _e, _f = _b.type, type = _f === void 0 ? 'sine' : _f;
    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow ||
        (typeof jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.AudioContext === 'undefined' &&
            typeof jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.webkitAudioContext === 'undefined')) {
        return;
    }
    // one context per document
    var context = new (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.AudioContext ||
        jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.webkitAudioContext)();
    var vol = context.createGain();
    var osc = context.createOscillator();
    osc.type = type;
    osc.frequency.value = frequency; // Hz
    osc.connect(vol);
    vol.connect(context.destination);
    osc.start(); // start the oscillator
    osc.stop(context.currentTime + sec);
    vol.gain.value = gain;
}


/***/ }),

/***/ 95700:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    newline: 'новая строка|перенос|ентер',
    delete: 'видалити',
    space: 'пробел',
    'Speech Recognize': 'Распознавание речи',
    Sound: 'Звук',
    'Interim Results': 'Проміжні результати'
};


/***/ })

},
/******/ function(__webpack_require__) { // webpackRuntimeModules
/******/ var __webpack_exec__ = function(moduleId) { return __webpack_require__(__webpack_require__.s = moduleId); }
/******/ var __webpack_exports__ = (__webpack_exec__(37873));
/******/ return __webpack_exports__;
/******/ }
]);
});