/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module dom
 */
import type { IAsync, IDestructible } from "../../types/index";
import { Eventify } from "../event-emitter/eventify";
export declare class LazyWalker extends Eventify<{
    visit: (node: Node) => boolean;
    break: (reason?: string) => void;
    end: (affect: boolean) => void;
}> implements IDestructible {
    private readonly async;
    private readonly options;
    private workNodes;
    setWork(root: Node): this;
    private hadAffect;
    private isWorked;
    private isFinished;
    constructor(async: IAsync, options?: {
        readonly whatToShow?: number;
        readonly reverse?: boolean;
        readonly timeoutChunkSize?: number;
        readonly timeout?: number;
    });
    private idleId;
    private __schedulerController;
    private _requestStarting;
    break(reason?: string): void;
    end(): void;
    private stop;
    destruct(): void;
    private __workPerform;
    private visitNode;
}
