/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
declare module 'jodit/config' {
    interface Config {
        /**
         * You can redefine default page
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeDefaultSrc: 'https://xdsoft.net/jodit/docs/',
         * });
         * ```
         */
        iframeDefaultSrc: string;
        /**
         * Base URL where the root directory for [[Config.iframe]] mode
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeBaseUrl: 'https://xdsoft.net/jodit/docs/',
         * });
         * ```
         */
        iframeBaseUrl: string;
        /**
         * Iframe title's content
         */
        iframeTitle: string;
        /**
         * Iframe's DOCTYPE
         */
        iframeDoctype: string;
        /**
         * Custom style to be used inside the iframe to display content.
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeStyle: 'html{margin: 0px;}',
         * })
         * ```
         */
        iframeStyle: string;
        /**
         * Custom stylesheet files to be used inside the iframe to display content.
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeCSSLinks: ['styles/default.css'],
         * })
         * ```
         */
        iframeCSSLinks: string[];
        /**
         * Custom sandbox attribute for the iframe.
         * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox
         * ```javascript
         * Jodit.make('#editor', {
         * 		iframe: true,
         * 		iframeSandbox: 'allow-same-origin allow-scripts'
         * });
         * ```
         * Empty string value means that all restrictions are enabled.
         */
        iframeSandbox: string | null;
    }
}
export {};
