/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
import { Dom } from "../../../core/dom/dom.js";
import { attr } from "../../../core/helpers/utils/attr.js";
/** @private */
export function applyLink(j, image, imageLink, imageLinkOpenInNewTab) {
    // Link
    let link = Dom.closest(image, 'a', j.editor);
    if (imageLink) {
        if (!link) {
            link = Dom.wrap(image, 'a', j.createInside);
        }
        attr(link, 'href', imageLink);
        attr(link, 'target', imageLinkOpenInNewTab ? '_blank' : null);
    }
    else {
        if (link && link.parentNode) {
            link.parentNode.replaceChild(image, link);
        }
    }
}
