import { Config } from './types';
export declare type ConfigUtils = ReturnType<typeof createConfigUtils>;
export declare function createConfigUtils(config: Config): {
    getClassGroupId: (className: string) => string | undefined;
    getConflictingClassGroupIds: (classGroupId: string) => readonly string[];
    cache: import("./lru-cache").LruCache<string, string>;
    splitModifiers: (className: string) => {
        modifiers: string[];
        hasImportantModifier: boolean;
        baseClassName: string;
    };
};
