import React from 'react'


const DashboardCard = ({className='',title = "Dashboard",children}) => {
  return (
      <div className={`${className} relative flex flex-col bg-white shadow-sm border border-slate-200 rounded-lg w-full hover:border-slate-300 hover:shadow-md rounded-[12px] transition-all cursor-pointer px-4 py-7`}>
              <h5 className="mb-2 text-gray-700 text-md font-semibold">
                  {title}
              </h5>
              <p className="text-gray-900 leading-normal text-[45px]">
                    {children}
              </p>
      </div>
  )
}

export default DashboardCard