import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../../Components/Button';

import { toast } from 'react-toastify';

import { useSelector } from 'react-redux'


const HeaderMenusForm = ({ onSubmit = (data) => { }, DefaultData, menus,languages , label="Add Header Menu" , disabled}) => {

    //state variables
    const [language, setLanguage] = useState(DefaultData?.lang_id ?? null);
    const [headerMenu, setHeaderMenu] = useState(DefaultData?.menu_id ?? null);


    //ref variables


    const roles = useSelector(state => state.user.roles)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        if(!language || !headerMenu) {
            toast.error('Please select both language and header menu');
            return;
        }

        onSubmit({
            id: DefaultData?.id ?? null,
            language: languages?.find(lang => lang.id == language) ?? '',
            menu: menus?.find(menu => menu.id == headerMenu) ?? '',
        });
    }

    const isFormDisabled = () => {
        if (DefaultData?.id) {
            return roles?.socialE == false
        }

        return roles?.socialA == false
    }

    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>

            <h1 class="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>
            <section className='flex flex-col md:flex-row gap-2 md:gap-5 mb-2'>
                <Input disabled={disabled} DefaultValue={DefaultData?.menu?.id ?? null} setState={setHeaderMenu} className="w-full" type={'Select'} label={'Header Menu'}>
                    <option value={null}>Select A HeaderMenu</option>
                    {menus?.length > 0 ?
                        menus?.map(menu => {
                            return (
                                <option value={menu?.id ?? 0} >{menu?.title ?? ''}</option>
                            )
                        })
                        : ''}
                </Input>
                <Input disabled={disabled || DefaultData?.id} type="Select" DefaultValue={DefaultData?.language?.id ?? null} setState={setLanguage} placeholder={'Language'} className="w-full" label={'Language'}>
                    <option value={null}>Select A Language</option>
                    {languages?.map(language => {
                        return (<option value={language?.id}>{language?.name}</option>)
                    }
                    )}
                </Input>
                </section>
            

            <Button disabled={disabled} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>{DefaultData ? 'Edit Header Menu' : 'Add Header Menu'}</Button>

        </section>
    )
}

export default HeaderMenusForm