import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../Button';

import { useSelector } from 'react-redux'

//fontawesome
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faFacebook } from '@fortawesome/free-brands-svg-icons'
import { toast } from 'react-toastify';
import { Switch } from '@mui/material';
import ToggleSwitch from '../ToggleSwitch';


const LanguagesForm = ({ onSubmit = (data) => { }, DefaultData, label = 'Add New Language' }) => {

    //ref variables
    const nameRef = useRef(DefaultData?.name ?? null)
    const localeRef = useRef(DefaultData?.locale ?? null)

    const [status, setStatus] = useState(DefaultData?.status ?? 1)
    const [flag, setFlag] = useState(DefaultData?.flag ?? null);
    const [rtl, setRtl] = useState(DefaultData?.is_rtl ?? false);

    const roles = useSelector(state => state.user.roles)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        onSubmit({
            name: nameRef.current.value,
            locale: localeRef.current.value,
            status: status,
            flag:flag,
            is_rtl: rtl,
        });
    }

    const isFormDisabled = () => {
        if (DefaultData?.id) {
            return roles?.languagesE == false
        }

        return roles?.languagesA == false
    }
    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>
            <h1 className="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>
            {flag ? <>
                <h1 className="font-bold text-[14px] mx-auto w-fit text-gray-900">Flag Preview</h1>
                <div className='max-w-5 max-h-5 w-full h-full m-auto flex items-center overflow-hidden' dangerouslySetInnerHTML={{ __html: flag ?? '' }}></div>
            </> : ''}
            <section className='flex gap-5 mb-2'>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.name ?? null} ref={nameRef} placeholder={'English'} className="w-full" label={'Name'}></Input>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.locale ?? null} ref={localeRef} placeholder={'En / Ar'} className="w-full" label={'Locale'}></Input>
            </section>
            <section className='flex gap-5 mb-2'>
                <Input disabled={isFormDisabled()} type="Select" DefaultValue={status ?? null} setState={setStatus} placeholder={'Status'} className="w-full " label={'Status'}>
                    <option value={0}>Unpublished</option>
                    <option value={1}>Published</option>
                </Input>
                
            </section>
            <ToggleSwitch DefaultChecked={rtl ?? false} setState={setRtl} className='mb-2'>Is RTL</ToggleSwitch>
            <FileInput className='w-full mb-2' disabled={isFormDisabled()} onChange={(e) => {
                const file = e.target.files[0];
                if (file) {
                    if (file.type !== 'image/svg+xml') {
                        // Assuming you have a toast library like react-toastify
                        toast.error('Only SVG files are allowed.');
                        return;
                    }
                    const reader = new FileReader();
                    reader.onload = (event) => {
                        setFlag(event.target.result);
                    };
                    reader.readAsText(file);
                }
            }}>Flag</FileInput>
            <Button disabled={isFormDisabled()} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>
        </section>
    )
}

export default LanguagesForm