import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../Button';

import TabControl from '../TabControl';
import Tab from '../Tab';
import Table from '../TableLayout/Table';
import TableHead from '../TableLayout/TableHead';
import TableRow from '../TableLayout/TableRow';
import TableColumn from '../TableLayout/TableColumn';
import ToggleSwitch from '../ToggleSwitch';

import useGetFormattedDate from '../hooks/useGetFormattedDate';
import RichTextEditor from '../RichTextEditor';

import { toast } from 'react-toastify';

import { useSelector } from 'react-redux'

const
    SettingsForm = ({ onSubmit = (data) => { }, DefaultData,languages, label = 'Manage Settings' ,references}) => {

        const roles = useSelector(state => state.user.roles)

        //variables
        const appnameRef = useRef(null);
        const googleTagRef = useRef(null);
        const facebookPixelRef = useRef(null);
        const reference1 = useRef(null);
        const reference2 = useRef(null);
        const [favicon, setFavicon] = useState(DefaultData?.favicon ?? null);
        const [language, setLanguage] = useState(DefaultData?.lang_id ?? null);
        const isFormDisabled = () => {
            if (DefaultData?.id) {
                return roles?.settingsE == false
            }

            return roles?.settingsE == false
        }



        const handleFormSubmit = (e) => {

            e.preventDefault()


            onSubmit({
                app_name: appnameRef.current.value,
                favicon: favicon,
                reference1: reference1.current.value ?? '',
                reference2: reference2.current.value ?? '',
                google_tag_id: googleTagRef.current.value ?? null,
                facebook_pixel_id: facebookPixelRef.current.value ?? null,
                lang_id: language ?? null,
            });
           
        }

        

        return (
            <section className='bg-white rounded-[10px] p-5 mt-10'>
                <h1 class="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>
                <TabControl className={'min-h-[230px]'}>

                    <Tab name="General Info">
                        <section className='flex gap-5 mb-2'>
                            <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.app_name ?? null} ref={appnameRef} placeholder={'App Name'} className="w-full" label={'App Name'}></Input>
                            <Input disabled={isFormDisabled()} type="Select" DefaultValue={language ?? null} setState={setLanguage} placeholder={'Language'} className="w-full " label={'Language'}>
                                {languages?.map(lang => {
                                    return(
                                        <option selected={lang?.id == language} value={lang?.id ?? null}>{lang?.name}</option>
                                    )
                                }
                                )}
                            </Input>
                        </section>
                        <section className='flex gap-5 mb-2'>
                            <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.google_tag_id ?? null} ref={googleTagRef} placeholder={'Google Tag Id'} className="w-full " label={'Google Tag Id'}></Input>
                            <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.facebook_pixel_id ?? null} ref={facebookPixelRef} placeholder={'Facebook Pixel Id'} className="w-full " label={'Facebook Pixel Id'}></Input>
                        </section>

                        
                        <section className='flex flex-col md:flex-row gap-2 md:gap-5 mb-2'>
                            <FileInput disabled={isFormDisabled()} isPreview={true} image={favicon} className='w-full' setState={setFavicon} >Favicon</FileInput>
                        </section>
                    </Tab>
                    <Tab name="Contacts">
                        <section className='flex gap-5 mb-2'>
                            <Input disabled={isFormDisabled()} label={"Reference 1 Header"} ref={reference1} className="w-full mb-2" DefaultValue={references?.reference1}></Input>
                            <Input disabled={isFormDisabled()} label={"Reference 2 Header"} ref={reference2} className="w-full mb-2" DefaultValue={references?.reference2}></Input>

                        </section>
                    </Tab>

                </TabControl>

                <section className="mt-2 gap-2 md:gap-5 flex flex-col md:flex-row items-center justify-center">
                    <Button disabled={isFormDisabled()} onClick={handleFormSubmit} className=' bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>
                </section>
            </section>
        )
    }

export default SettingsForm