import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../../Components/Button';

import { useSelector } from 'react-redux'

//fontawesome
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faFacebook } from '@fortawesome/free-brands-svg-icons'


const SocialTypesForm = ({ onSubmit = (data) => { }, DefaultData, label = 'Add Social Type' }) => {

    //state variables
    const [color, setColor] = useState(DefaultData?.color ?? '#000000');
    const [icon, setIcon] = useState(DefaultData?.icon ?? null);

    //ref variables
    const typeRef = useRef(DefaultData?.type ?? null)
    const baseUrlRef = useRef(DefaultData?.base_url ?? null)
    const endUrlRef = useRef(DefaultData?.end_url ?? null)

    const roles = useSelector(state => state.user.roles)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        onSubmit({
            type: typeRef.current.value,
            color: color,
            icon: icon,
            base_url: baseUrlRef.current.value,
            end_url: endUrlRef.current.value
        });
    }

    const isFormDisabled = () => {
        if (DefaultData?.id) {
            return roles?.socialE == false
        }

        return roles?.socialA == false
    }
    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>
            <h1 class="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>
            <h1 class="font-bold text-[14px] mx-auto w-fit text-gray-900">Icon Preview</h1>
            <div style={{ backgroundColor: color ?? '#000000' }} class="text-white col-auto mx-auto fill-white p-1 shadow-lg rounded-full flex items-center justify-center h-9 w-9" mx-auto>
                {icon ? <div className='max-w-5 max-h-5 w-full h-full flex items-center overflow-hidden' dangerouslySetInnerHTML={{ __html: icon ?? '' }}></div> : null}
            </div>

            <section className='flex gap-5 mb-2'>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.type ?? null} ref={typeRef} placeholder={'Facebook'} className="w-full" label={'Social Type'}></Input>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.color ?? '#000000'} setState={setColor} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'Color'}></Input>
            </section>
            <section className='flex gap-5 mb-2'>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.base_url ?? null} ref={baseUrlRef} placeholder={'https://facebook.com/'} className="w-full" label={'Base Url'}></Input>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.end_url ?? null} ref={endUrlRef} placeholder={'.../facebbok'} className="w-full" label={'End Url'}></Input>                        </section>
            <FileInput disabled={isFormDisabled()} onChange={(e) => {
                const file = e.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = (event) => {
                        setIcon(event.target.result);
                    };
                    reader.readAsText(file);
                }
            }
            }  >Icon</FileInput>
            <Button disabled={isFormDisabled()} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>

        </section>
    )
}

export default SocialTypesForm