import React, { useState, useEffect, useRef } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../../Components/Button';
import RichTextEditor from '../RichTextEditor';


const TestimonialsForm = ({ data, isFormDisabled, onSubmit, onCancelTestimonial }) => {
    const [formData, setFormData] = useState(data ?? {
        name: '',
        description: '',
        image: '',
        order: 0,
    });

    const orderRef = useRef(data?.order ?? '');

    useEffect(() => {
        setFormData(data);
        orderRef.current.value = data?.order ?? '';
    }, [data])

    const handleSubmit = () => {
        onSubmit({ ...formData, order: orderRef.current.value });
        setFormData({
            name: '',
            description: '',
            button: '',
            order: 0,
        })
    }

    return (
        <section className='mt-5'>
            <h3 class="font-bold text-[18px] mb-2 text-gray-900 text-center md:text-start">{data?.name ? `Edit Block (${data?.name.replace(/<[^>]*>/g, "").slice(0, 20)})` : 'Add New Testimonial'}</h3>
            <section className='flex grid grid-cols-2 md:grid-cols-3 gap-x-5 gap-y-2 md:w-max'>
                <RichTextEditor
                    disabled={isFormDisabled()}
                    data={{
                        state: formData?.name,
                    }}
                    onBlur={(newContent) => setFormData((prevState) => ({ ...prevState, name: newContent }))}
                    className="w-full row-span-2 md:max-w-[300px]"
                    label={'Name'}
                />
                <RichTextEditor
                    disabled={isFormDisabled()}
                    data={{
                        state: formData?.description,
                    }}
                    onBlur={(newContent) => setFormData((prevState) => ({ ...prevState, description: newContent }))}
                    className="w-full row-span-2 md:max-w-[300px]"
                    label={'Description'}
                />

                <FileInput
                    disabled={isFormDisabled()}
                    isPreview={true}
                    image={formData?.image}
                    className='w-full max-md:col-span-2'
                    setState={(image) => setFormData((prevState) => ({ ...prevState, image: image }))}
                >
                    Image
                </FileInput>
                <Input
                    ref={orderRef}
                    label="Order"
                    disabled={isFormDisabled()}
                    type="number"
                    defaultValue={data?.order ?? 0}
                    className="w-full"
                />



            </section>
            <section className='flex gap-5 mt-5'>
                <Button
                    onClick={handleSubmit}
                    className='bg-gray-900 hover:bg-[#000000] max-w-fit'
                >
                    {data?.name ? 'Edit Testimonial' : 'Add Testimonial'}
                </Button>
                {data?.name ? <Button
                    onClick={
                        onCancelTestimonial
                    }
                    className='bg-gray-900 hover:bg-[#000000] max-w-fit'
                >
                    Cancel
                </Button> : ''}
            </section>

        </section>
    )
}

export default TestimonialsForm