import { Link } from '@inertiajs/react'
import React from 'react'

const ProfileCard = ({profile,isView}) => {
  return (
      <Link href={`/${profile?.code}`} style={{ backgroundImage: `url('${profile?.cover_pic}')` }} className="relative overflow-hidden bg-white bg-cover font-semibold rounded-3xl border shadow-lg p-5 relative w-full aspect-[16/9] flex flex-col group justify-center hover:-translate-y-[20px] cursor-pointer duration-[300ms]">
          
          <section className="flex gap-5">
              <section className='z-[99]'>
                  <h1 className="text-lg text-gray-700">{profile?.code}</h1>
                  <h3 className="text-sm text-gray-400 max-w-[200px] mb-5"> {profile?.name ? profile.name.replace(/<[^>]*>/g, "").slice(0, 30) : ''} </h3>
                  {!isView ? <Link href={`/admin/profiles/${profile?.id}/edit`} className="bg-[#297EC0] px-4 text-[14px] py-2 rounded-[12px] text-gray-100 font-semibold tracking-wide mx-auto w-fit">Edit Details</Link> : ''}

              </section>
              {profile?.profile_pic && <img loading='lazy' className="w-20 h-20 rounded-full object-cover shadow-lg mx-auto  top-1 right-1 z-[99] border border-solid border-gray-900" src={profile?.profile_pic} />}
          </section>
          <section  className='absolute group-hover:opacity-[70%] top-0 left-0 right-0 left-0 bg-white z-[9] w-full h-full opacity-[50%] duration-[300ms] min-w-max'></section>
      </Link>
  )
}

export default ProfileCard