import React from 'react'

import JoditEditor from 'jodit-react';

import Label from './Label';

const RichTextEditor = ({ labelClassName = 'ml-2',required=false, className = '', onBlur = null, disabled = false, label, data = { state: null, setState: null } }) => {
    return (
        <div className={className}>
            <Label labelClassName={labelClassName}>{label}</Label>

            <JoditEditor
                value={data.state}
                tabIndex={1}
                required={required}
                onBlur={onBlur ? (newContent => onBlur(newContent)) : (newContent => data.setState(newContent))}
                config={{ readonly: disabled }}
            />
        </div>
    )
}

export default RichTextEditor