import React,{useState} from 'react'
import Tab from './Tab';

const TabControl = ({children,className = ''}) => {

    const [active,setActive] = useState(0);

    const childArray = React.Children.toArray(children);
    const tabNames = childArray.map((child) => child?.props?.name);
 

  return (
      <section className={`${className} bg-gray-100`}>
        <div className='flex w-full overflow-auto border-b border-solid border-gray-100'>
            {tabNames.map((tab,index)=> {
                return (
                    <Tab key={index} active={active == index} onClick={()=> {setActive(index)}} >{tab}</Tab>
                )
            })}
        </div>
          <div className='bg-gray-100 p-2 overflow-auto min-h-[300px]'>
              {children?.length>1 ? children?.map((tab, index) => {
                  return (
                      <div  key={index}>
                        
                          <div className={`${index === active ? '' :'hidden'}`}> {tab?.props?.children}</div>
                      </div>
                  );
              }) : <div>
                 {children?.props?.children }
              </div>}
          </div>
    </section>
  )
}

export default TabControl