import React from "react";
import TableHead from "./TableHead";

const Table = ({ children, headers, className }) => {

    return (
        <table className={`${className} max-w-full`}>
            <thead className="bg-gray-100 border-b">
                <tr>
               {headers.map((header,index)=> {
                   return <TableHead key={index}>{header}</TableHead>
               })} </tr>
            </thead>
            <tbody>{children}</tbody>
        </table>
    );
};

export default Table;
