import React,{useState} from 'react'

import TableColumn from './TableColumn'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faBars, faX } from '@fortawesome/free-solid-svg-icons'

const TableDropdownActions = ({children}) => {
    const [isClosed , setIsClosed] = useState(true) 

    const handleToggleMenu = () => {
        setIsClosed( closed=> {return (!closed)});
    }
    return (
        <TableColumn>
            <button
            onClick={handleToggleMenu}

                className="text-gray-800"
            >
                <FontAwesomeIcon className={`${isClosed ? '' : 'rotate-90'} duration-[300ms]`} icon={isClosed ? faBars : faX} />
            </button>
            {!isClosed ? <ul
                className="absolute z-10 min-w-[180px] overflow-auto rounded-md border border-blue-gray-50 bg-white p-1.5 font-sans text-sm font-normal text-blue-gray-500 shadow-lg shadow-blue-gray-500/10 focus:outline-none"
            >
                {children}
            </ul> : ''}
            
        </TableColumn>
    )
}

export default TableDropdownActions