import React from 'react'

const ToggleSwitch = ({className = '',children, setState = () => {} , DefaultChecked = false}) => {
  return (
      <div className={className}>
          {children ?<span className="text-[13px] font-semibold block">{children}</span> : ''}
          <label className="relative inline-flex items-center cursor-pointer">
              <input defaultChecked={DefaultChecked} onChange={(e)=>{setState(e.target.checked)}} type="checkbox" className="sr-only peer"/>
                  <div className="w-11 h-6 bg-gray-300 peer-focus:outline-none peer-focus:ring-2 peer-focus:ring-gray-500 rounded-full peer dark:bg-gray-700 peer-checked:bg-black"></div>
                  <div className="absolute left-0.5 top-0.5 w-5 h-5 bg-white border border-gray-300 rounded-full transition-transform peer-checked:translate-x-full"></div>
          </label>
      </div>
  )
}

export default ToggleSwitch