const useGetFormattedDate = ({
    add = { year: 0, month: 0, day: 0 },
    subtract = { year: 0, month: 0, day: 0 }
}) => {
    const newDate = new Date();

    newDate.setFullYear(newDate.getFullYear() + add.year - subtract.year);
    newDate.setMonth(newDate.getMonth() + add.month - subtract.month);
    newDate.setDate(newDate.getDate() + add.day - subtract.day);

    const year = newDate.getFullYear();
    const month = String(newDate.getMonth() + 1).padStart(2, "0"); // Ensures two digits (01-12)
    const day = String(newDate.getDate()).padStart(2, "0"); // Ensures two digits (01-31)

    return `${year}-${month}-${day}`;
};

export default useGetFormattedDate;