import React,{useState} from 'react'

const ServicesCard = ({service: {
    background = "#FFFFFF",
    image = '',
    title = "Title",
    description = "Description",
    button = "Button",
    link = "#",
}}) => {

    const [isReadMore,setIsReadMore] = useState(true);

    const toggleReadMore = () => {
        setIsReadMore(!isReadMore);
    }
  return (
      <div className=" mx-auto min-w-full">

          <div style={{ backgroundColor: background ?? 'white' }} className="relative flex flex-col justify-between overflow-hidden   text-gray-700 shadow-lg p-4 h-full w-full border border-solid border-gray-900 rounded-[10px]">
              <section>
              <div className="relative m-0 overflow-hidden text-gray-700 rounded-full overlow-hodden p-3 shadow-lg w-fit mx-auto max-md:max-w-[75px]">
                  <img
                      className="md:w-14 md:h-14 w-full aspect-square object-cover"
                      loading="lazy"
                      src={`${image}`}
                  />
              </div>
              <div className="mt-3 ">
                  <h4 dangerouslySetInnerHTML={{ __html: title ?? '' }} className=" text-[18px] md:text-[22px] font-semibold  text-blue-gray-900 text-center">
                    
                  </h4>
                  
                  <p dangerouslySetInnerHTML={{ __html: (description.length > 150 && isReadMore) ? `${description.slice(0, 150)}...` : description ?? '' }} className="text-center mt-2 font-normaltext-gray-700 text-[12px] md:text-[16px]">
                  </p>
                  {description.length > 150 ? <span onClick={toggleReadMore} className="text-center mt-2 font-normal text-gray-700 text-[12px] md:text-[16px] cursor-pointer">{isReadMore ? 'Read More...' : 'Show Less...'}</span> : '' }
              </div>
              </section>
              {button ? <div className="flex items-center">
                  <a target="_blank" dangerouslySetInnerHTML={{ __html: button ?? '' }} className="mt-5 mx-auto rounded-[8px] px-5 py-2 text-white bg-gray-900 text-[12px] md:text-[16px]" href={`${link}`}></a>
              </div> : '' }
          </div>
      </div>
  )
}

export default ServicesCard