import React from 'react'

const IconButton = ({children,active,className="",link="",text="",onClick=()=>{}}) => {
  return (
    <section className="flex flex-col justify-center items-center">
      {link ? 
        <a href={link} className={`${className} ${active ? 'bg-gray-900' : 'bg-white'} duration-[300ms] group rounded-full shadow-lg min-w-10 min-h-10 flex items-center justify-center`}>{children}</a>
        : 
        <div onClick={onClick} className={`${className} ${active ? 'bg-gray-900' : 'bg-white'} duration-[300ms] group rounded-full shadow-lg  min-w-10 min-h-10 flex items-center justify-center cursor-pointer`}>{children}</div>}
    {text ? <p style={{fontFamily:'poppins'}} className="text-white text-center text-[12px]">{text}</p> : ''}
      </section>
  )
}

export default IconButton