import React from 'react'

import {faTableCells,faMobileScreen, faIdCard,faIcons, faPeopleGroup, faGear, faPerson, faUsers, faBook, faThList, faThLarge, faHeading, faWindowMaximize, faDiagramNext, faLanguage, faDownload } from '@fortawesome/free-solid-svg-icons'

const SideBarItems = {
    sections: [
        {
            name: "Main",
            items: [
                {
                    name: "Visit Site",
                    icon: faMobileScreen,
                    url: '/',
                    target: "_blank"
                },
                {
                    name: "Dashboard",
                    icon: faTableCells,
                    url: '/admin/dashboard'
                },
                {
                    name: "Managed Profiles",
                    icon: faIdCard,
                    url: '/admin/profiles'
                },
                {
                    name: "Contacts",
                    icon: faPeopleGroup,
                    url: '/admin/contacts',
                    role: "contactsF"
                }
                ,
                {
                    name: "Backup",
                    icon: faDownload,
                    url: '/admin/backup/download',
                    role: "backup"
                }
            ]
        },
        {
            name: "Content Management",
            items: [
                {
                    name: "Templates",
                    icon: faTableCells,
                    url: '/admin/templates',
                    role: "templatesF"
                },
                {
                    name: "Pages",
                    icon: faThLarge,
                    url: '/admin/pages',
                    role: "pageF"
                },
                {
                    name: "Menus",
                    icon: faThList,
                    url: '/admin/menus',
                    role: "menuF"
                },
                {
                    name: "Header",
                    icon: faWindowMaximize,
                    url: '/admin/header',
                    role: "headerF"
                },
                {
                    name: "Footer",
                    icon: faDiagramNext,
                    url: '/admin/footer',
                    role: "footerF"
                }
            ]
        },
        {
            name: "Configurations",
            items: [
                {
                    name: "Languages",
                    icon: faLanguage,
                    url: '/admin/languages',
                    role: "languagesF"
                },
                {
                    name: "Social Links",
                    icon: faIcons,
                    url: '/admin/social-links',
                    role: "socialF"
                },
                {
                    name: "Users",
                    icon: faUsers,
                    url: '/admin/users',
                    role: "usersF"
                },
                {
                    name:"Settings",
                    icon: faGear,
                    url: '/admin/settings',
                    role: "settingsF"
                }
            ]
        },
        
    ]

}
export default SideBarItems