import React, { useState, useRef } from 'react'
import SideBar from '../../Components/SideBar'
import Table from '../../Components/TableLayout/Table';
import { router } from "@inertiajs/react";



//table layout
import TableHead from '../../Components/TableLayout/TableHead'
import TableRow from '../../Components/TableLayout/TableRow'
import TableColumn from '../../Components/TableLayout/TableColumn'
import ContactsForm from '../../Components/Forms/ContactsForm';
import MobileBar from '../../Components/MobileBar';

import TablePagination from '@mui/material/TablePagination';
import SearchBar from '../../Components/SearchBar';
import TableDropdownActions from '../../Components/TableLayout/TableDropdownActions';
import TableDropdownMenuItem from '../../Components/TableLayout/TableDropdownMenuItem';

import { useSelector } from 'react-redux';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';

export default function Index({ apps, social_types, messages, references }) {
    useHandleToastMessages(messages);

    //state variables
    const [currentPage, setCurrentPage] = useState(0)
    const [rowsPerPage, setRowsPerPage] = useState(25);
    const [filter, setFilter] = useState(null);

    //ref variables
    const searchRef = useRef(null);


    const handleAddContact = (data) => {
        router.post('/admin/contacts', data)
    }

    const handleFilterApps = (data) => {
        setCurrentPage(0);
        setFilter(data ?? null);
    }

    const filteredApps = filter
        ? apps?.filter(app =>
            app?.name?.toLowerCase().includes(filter.toLowerCase()) ||
            app?.address?.toLowerCase().includes(filter.toLowerCase()) ||
            app?.number?.toLowerCase().includes(filter.toLowerCase()) ||
            app?.mobile?.toLowerCase().includes(filter.toLowerCase()) ||
            app?.code?.toLowerCase().includes(filter.toLowerCase())
        )
        : apps;

    const roles = useSelector(state => state.user.roles);

    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full p-4 md:p-10 flex max-md:flex-col gap-10 bg-gray-200 '>
                <section className="md:w-2/3">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Contacts</h1>

                    <h3 class="font-semibold text-gray-500 text-[12px] md:text-[16px] max-md:text-justify">Contacts in an app allow users to store and manage personal or business connections. They typically include details like names, phone numbers, emails, and social links.</h3>

                    <ContactsForm references={references} social_types={social_types ?? null} onSubmit={handleAddContact} />

                </section>

                <section className="md:w-1/3 max-w-[100%] h-fit">
                    <SearchBar ref={searchRef} onSearch={handleFilterApps} className='ml-auto' />

                    <section className='w-full overflow-auto'>
                        <Table headers={["", "Code", "Published", "Name", "Phone", "Mobile", references?.reference1 ?? 'Reference 1', references?.reference2 ?? "Reference 2", "Created By", "Updated By"]}>

                            {filteredApps?.slice(currentPage * rowsPerPage, (currentPage + 1) * rowsPerPage)?.map(app => {
                                return (
                                    <TableRow key={app?.id}>
                                        {roles?.contactsA || roles.contactsE || roles.contactsD ?
                                            <TableDropdownActions>

                                                {roles?.contactsE ?
                                                    <TableDropdownMenuItem>
                                                        <div onClick={() => { router.get(`/admin/contacts/${app?.id}/edit`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit</div>
                                                    </TableDropdownMenuItem>
                                                    : ''}
                                                {roles?.contactsA ?
                                                    <TableDropdownMenuItem>
                                                        <div onClick={() => { router.get(`/admin/contacts/${app?.id}/duplicate`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Duplicate</div>
                                                    </TableDropdownMenuItem>
                                                    : ''}
                                                {roles?.contactsP ?
                                                    <TableDropdownMenuItem>
                                                        <div onClick={() => { router.get(`/admin/contacts/${app?.id}/toggle-publish`) }} className={`text-[11px]  font-bold cursor-pointer ${app?.published ? 'text-red-500' : 'text-blue-500'}`}>{app?.published ? 'Unpublish' : 'Publish'}</div>
                                                    </TableDropdownMenuItem>
                                                    : ''}
                                                {roles?.contactsD ?
                                                    <TableDropdownMenuItem>
                                                        <div onClick={() => { router.delete(`/admin/contacts/${app?.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div>
                                                    </TableDropdownMenuItem>
                                                    : ''}

                                            </TableDropdownActions>
                                            : <TableColumn></TableColumn>}
                                        <TableColumn className={'font-semibold'}><a target='_blank' href={app?.code ? `/${app.code}` : ''}>{app?.code}</a></TableColumn>
                                        <TableColumn className='flex items-center justify-center'>
                                            {app?.published == true ? <div className='text-[11px] text-blue-500 font-bold'>Published</div> : <div className='text-[11px] text-red-500 font-bold'>Draft</div>}
                                        </TableColumn>
                                        <TableColumn>{app?.name ? app.name.replace(/<[^>]*>/g, "").slice(0, 20) : ''}</TableColumn>
                                        <TableColumn>{app?.number}</TableColumn>
                                        <TableColumn>{app?.mobile}</TableColumn>
                                        <TableColumn>{app?.reference1}</TableColumn>
                                        <TableColumn>{app?.reference2}</TableColumn>
                                        <TableColumn>{app?.created_by ?? ''}</TableColumn>
                                        <TableColumn>{app?.updated_by ?? ''}</TableColumn>
                                    </TableRow>
                                )
                            })}

                        </Table>
                    </section>


                    <TablePagination
                        component="div"
                        count={filteredApps?.length ?? 0}
                        page={currentPage}
                        onPageChange={(event, newPage) => { setCurrentPage(newPage) }}
                        rowsPerPage={rowsPerPage}
                        onRowsPerPageChange={(event) => { setRowsPerPage(parseInt(event.target.value, 10)); setCurrentPage(0) }}
                    />
                </section>
            </section>
        </div >
    );
}
