
import React, { useState } from 'react'
import IconButton from '../../../Components/template2/IconButton'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faDownload, faHome, faPhone, faTable, faQrcode, faPen } from '@fortawesome/free-solid-svg-icons'

import ServicesCard from '../../../Components/template1/ServicesCard'
import BlocksCard from '../../../Components/template1/BlocksCard'

import { Splide,SplideSlide } from '@splidejs/react-splide'

import { useSelector } from 'react-redux'

const Template2 = ({ app }) => {

    const roles = useSelector(state => state.user.roles);
    const [page, setPage] = useState('home');

    return (
        <>
            <link href="https://fonts.googleapis.com/css2?family=Battambang:wght@100;300;400;700;900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet" />
            <section className='relative min-h-[100dvh] bg-[#E8FBFC] flex flex-col items-center justify-center p-5 md:p-10'>

                <div className="max-w-[1140px] mx-auto rounded-[32px] overflow-hidden bg-white w-full h-full min-h-[600px] flex max-md:flex-col shadow-lg">
                    <div className='bg-[#4C99CF] py-5 md:py-10 w-full md:min-w-[80px] md:w-[80px] max-h-[600px]  max-md:items-start md:flex-col items-center'>
                        <section className='md:mb-10 text-center'>
                            <img className="min-w-[50px] max-w-[50px] mx-auto hidden md:block h-auto aspect-square border-[4px] fit-cover border-solid border-white rounded-full" src={`${app.profile_pic != '' ? app.profile_pic : (app?.gender == 'Female' ? '/storage/app/public/assets/profile-Female.png' : '/storage/app/public/assets/profile.png')}`} alt=""></img>

                        </section>
                        <section className='grid max-md:gap-y-0 grid-cols-4 md:flex flex-col gap-5 items-start md:items-center'>
                            <IconButton active={page == 'home'} text="Home" onClick={() => { setPage('home') }}><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faHome}></FontAwesomeIcon></IconButton>
                            <IconButton text='Call Me' link={`tel:${app?.mobile}`}><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faPhone}></FontAwesomeIcon></IconButton>
                            <IconButton active={page == 'services'} onClick={() => { setPage('services') }} text="Services"><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faTable}></FontAwesomeIcon></IconButton>
                            <IconButton text="Save Contact" link={`/${app?.code}/vcard`}><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faDownload}></FontAwesomeIcon></IconButton>
                            <IconButton text='Qr Code' link={`https://api.qrserver.com/v1/create-qr-code/?data=${window.location.href}&size=150x150`}><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faQrcode}></FontAwesomeIcon></IconButton>
                            {roles?.contactsE == true ? <IconButton text='Edit' link={`/admin/contacts/${app?.id}/edit`} ><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faPen}></FontAwesomeIcon></IconButton> : (app?.can_edit == true ? <IconButton text='Edit' link={`/admin/profiles/${app?.id}/edit`} ><FontAwesomeIcon className='text-gray-400 group-hover:text-[#4C99CF] duration-[300ms]' icon={faPen}></FontAwesomeIcon></IconButton> : '')}

                        </section>
                    </div>



                    {page == 'home' ?
                        <div
                            className="w-full max-md:bg-none flex items-center justify-center p-5 md:p-10 h-[600px] overflow-y-auto bg-cover"
                            style={{ backgroundImage: `url('${app.cover_pic ? app.cover_pic : "/storage/app/public/assets/cover.png"}')` }}>
                                <div className="flex md:fx-row flex-col gap-10 md:gap-20 items-center justify-between">
                                <section className="text-[#03004E ]">
                                    <div className="relative md:hidden mb-5 ">
                                        <img onError={(e) => { e.target.src = (app?.gender == 'Female' ? '/storage/app/public/assets/profile-Female.png' : '/storage/app/public/assets/profile.png') }} loading="lazy" className="w-[100px] border border-solid border-gray-900 z-[10] absolute left-1/2 top-1/2  -translate-x-[50%] -translate-y-[50%] block  md:w-[64px] h-auto aspect-square  rounded-full " src={`${app.profile_pic != '' ? app.profile_pic : (app?.gender == 'Female' ? '/storage/app/public/assets/profile-Female.png' : '/storage/app/public/assets/profile.png')}`} alt=""></img>

                                        <img onError={(e) => { e.target.src ="/storage/app/public/assets/cover.png"}} loading="lazy" className='w-full  z-0   h-[150px] object-cover' src={`${app.cover_pic != '' ? app.cover_pic : '/storage/app/public/assets/cover.png'}`}></img>
                                    </div>
                                    <h1 style={{ fontFamily: "poppins" }} className="text-[20px] md:text-[32px] text-[#03004E] text-center md:text-left font-bold" dangerouslySetInnerHTML={{ __html: app?.name ?? '' }} ></h1>
                                    <p style={{ fontFamily: "poppins" }} className="text-[12px] md:text-[15px] text-[#03004E] text-center md:text-left mt-5 font-semibold" dangerouslySetInnerHTML={{ __html: app?.address ?? '' }} ></p>
                                    <p style={{ fontFamily: "poppins" }} className="text-[12px] md:text-[15px] text-[#03004E] text-center md:text-left mt-2" dangerouslySetInnerHTML={{ __html: app?.description ?? '' }} ></p>

                                    <section className="flex flex-row gap-2 mt-5 max-md:mx-auto flex-wrap">
                                        {app.social_links ? app.social_links.map((social_link, index) => {
                                            return <a href={`${social_link?.social_type?.base_url ?? ''}${social_link?.link ?? ''}${social_link?.social_type?.enc_url ?? ''}`} style={{ backgroundColor: social_link?.social_type?.color ?? '#000000' }} class="text-white col-auto fill-white p-1  rounded-full flex items-center justify-center h-10 w-10 *:w-full *:h-full text-[]"
                                                dangerouslySetInnerHTML={{ __html: social_link?.social_type?.icon ?? '' }}
                                            >

                                            </a>
                                        }) : ''}
                                    </section>
                                </section>

                            </div>
                        </div> : ''}

                    {page == 'services' ?
                        <div className="w-full inline-grid  items-center justify-center p-5 md:p-10 ">
                            <div className="flex md:fx-row flex-col gap-10 md:gap-20 items-center justify-between h-[500px] overflow-y-auto">

                                <section className="flex flex-col gap-3 md:gap-7 text-[#03004E]">
                                    {app?.services_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.services_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                                    {app?.services?.length > 0 ? <div class="flex flex-col sm:grid  sm:grid-cols-2 md:grid-cols-3 gap-5  w-full place-content-center mx-auto">
                                        {app?.services?.map((service) => {
                                            return (
                                                <ServicesCard service={service} ></ServicesCard>
                                            )
                                        })}

                                    </div> : ''}
                                </section>

                                <section className="flex flex-col gap-3 md:gap-7 mt-14 text-[#03004E]">
                                    {app?.blocks_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.blocks_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                                    {app?.blocks?.length > 0 ? <div class="flex flex-col sm:grid  sm:grid-cols-2 md:grid-cols-3 gap-5  w-full place-content-center mx-auto">
                                        {app?.blocks?.map((block) => {
                                            return (
                                                <BlocksCard block={block} ></BlocksCard>
                                            )
                                        })}

                                    </div> : ''}
                                </section>

                                <section className="flex flex-col gap-3 md:gap-7 mt-14 text-[#03004E] w-full">
                                    {app?.testimonials_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.testimonials_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                                    {app?.testimonials?.length > 0 && (
                                        <Splide
                                            options={{
                                                perPage: 2,
                                                type: 'loop',
                                                autoplay: true,
                                                gap: '1.25rem',
                                                interval: 3000,
                                                pauseOnHover: true,
                                                pagination: false,
                                                breakpoints: {

                                                    640: {
                                                        perPage: 1, // small screens / mobile
                                                    },
                                                },
                                            }}
                                            className='w-full mx-auto'
                                            aria-label="Testimonials"
                                        >
                                            {app.testimonials.map((testimonial) => (
                                                <SplideSlide key={testimonial?.id}>

                                                    <div className="rounded-3xl p-10 bg-white shadow-lg max-w-md border border-soild border-gray-900 md:min-w-[448px] min-h-full mx-auto">
                                                        <div className="flex gap-4 items-center">
                                                            <img
                                                                className="fit-cover w-[75px] aspect-square rounded-full border border-solid border-gray-900"
                                                                src={testimonial?.image}
                                                                alt=""
                                                            />
                                                            <div>
                                                                <h3
                                                                    dangerouslySetInnerHTML={{ __html: testimonial?.name ?? '' }}
                                                                    className="text-start text-lg font-medium text-gray-700"
                                                                ></h3>
                                                            </div>
                                                        </div>
                                                        <p
                                                            className="text-gray-700 mt-5 max-w-full"
                                                            dangerouslySetInnerHTML={{ __html: testimonial?.description ?? '' }}
                                                        ></p>
                                                    </div>

                                                </SplideSlide>
                                            ))}
                                        </Splide>
                                    )}
                                </section>


                                <section className="flex flex-col gap-3 md:gap-7 mt-14 text-[#03004E] w-full">
                                    {app?.embeds_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.embeds_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                                    {app?.embeds?.length > 0 ? <Splide
                                        options={{
                                            perPage: 3,
                                            type: 'loop',
                                            gap: '1.25rem',
                                            autoplay: true,
                                            interval: 3000,
                                            pauseOnHover: true,
                                            pagination: false,
                                            breakpoints: {

                                                640: {
                                                    perPage: 1, // small screens / mobile
                                                },
                                            },
                                        }}
                                        className='w-full max-w-full mx-auto'
                                        aria-label="My React Splide Carousel">


                                        {app?.embeds?.map((videoEmbed, index) => {
                                            return (<SplideSlide key={index}><div dangerouslySetInnerHTML={{ __html: videoEmbed.embed ?? '' }} className="rounded-lg overflow-hidden min-w-[250px] h-[180px]   *:h-full *:w-full">

                                            </div></SplideSlide>)
                                        })}
                                    </Splide> : ''}
                                </section>

                            </div>
                        </div> : ''}

                </div>
                {app?.powered_by ? <section className="mt-5 text-[18px]">Powered By: <b>{app?.powered_by}</b></section> : ''}


            </section>
        </>
    )
}

export default Template2