import React from 'react'
import { Link, router } from "@inertiajs/react";

import { useSelector } from 'react-redux';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';
import BlockEditorGrape from '../../Components/BlockEditorGrape';
import BasicModal from '../../Components/BasicModal';

export default function Index({  messages, footer,languages }) {

    useHandleToastMessages(messages);

    //state variables

    const roles = useSelector(state => state.user.roles);

    const handleEditFooter = (data) => {
        data.lang_id = footer?.lang_id;.3
        router.post('/admin/footer', data)
    }

    return (
        <>
        {languages?.length > 0 ?
                <BasicModal
                    open={true}
                    title='Select a Language'
                >
                        <section className='flex gap-3 mt-10 flex-wrap'>
                        {languages?.map(language => {
                            return (
                                <Link 
                                    className='rounded-[5px] bg-black text-white px-5 py-1.5 flex gap-2 items-center' 
                                    key={language?.id} 
                                    href={`/admin/footer?lang_id=${language?.id}`}
                                >
                                    {language?.name ?? null} 
                                    <span 
                                        className='w-5' 
                                        dangerouslySetInnerHTML={{ __html: language?.flag }} 
                                    ></span>
                                </Link>
                            );
                        })}
                        </section>
                </BasicModal>
        : ''}
        <BlockEditorGrape
        onSubmit={handleEditFooter}
        page={{
            component: footer?.component ?? '',
            styles: footer?.styles ?? ''
        }} />
        </>
    );
}
