import React from 'react'
import { BlockEditor } from '../Components/BlockEditor'
import BlockEditorGrape from '../Components/BlockEditorGrape'

import {router} from "@inertiajs/react";
import axios from 'axios';
import { toast } from 'react-toastify';


const PageBuilder = ({ page = null, csrf_token, redirect  = 'pages',grape_key}) => {
  const handleSubmit = async (data) => {
    if(data?.id){
      await axios.put(`/admin/${redirect}/${data.id}`, data);
      toast.success('Page updated successfully');
      return
    }
    await axios.post(`/admin/${redirect}`, data)
    toast.success('Page created successfully');
    return
  }
  return (
    <BlockEditorGrape grape_key={grape_key} csrf_token={csrf_token} onSubmit={handleSubmit} page={page}></BlockEditorGrape>
  )
}

export default PageBuilder