import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import Table from '../../Components/TableLayout/Table';
import { router } from "@inertiajs/react";


//table layout
import TableHead from '../../Components/TableLayout/TableHead'
import TableRow from '../../Components/TableLayout/TableRow'
import TableColumn from '../../Components/TableLayout/TableColumn'
import SocialTypesForm from '../../Components/Forms/SocialTypesForm';
import MobileBar from '../../Components/MobileBar';

import { TablePagination } from '@mui/material';
import TableDropdownMenuItem from '../../Components/TableLayout/TableDropdownMenuItem';
import TableDropdownActions from '../../Components/TableLayout/TableDropdownActions';
import UsersForm from '../../Components/Forms/UsersForm';

import { useSelector } from 'react-redux';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';
import ProfileCard from '../../Components/ProfileCard';

export default function Index({ profiles, messages }) {
    useHandleToastMessages(messages)



    const roles = useSelector(state => state.user.roles)

    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
                <section className="w-full">
                    <h1 className="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Manage Profiles</h1>


                    <section className="grid md:grid-cols-3 sm:grid-cols-2 lg:grid-cols-4 gap-5 w-full">
                        {profiles?.map(profile => {
                            return (
                                <ProfileCard profile = {profile} key={profile.id}/>
                            )
                        })}
                    </section>
                </section>
            </section>
        </div >
    );
}
