import React from 'react'
import SideBar from '../../Components/SideBar'
import { Link, router } from "@inertiajs/react";



//table layout
import ContactsForm from '../../Components/Forms/ContactsForm';
import MobileBar from '../../Components/MobileBar';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';

export default function Update({  social_types, selected_contact, messages, references }) {
    useHandleToastMessages(messages);

    const handleUpdateContact = (data) => {
        router.post(`/admin/contacts/${selected_contact.id}`, data)
    }


    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full p-4 md:p-10 flex max-md:flex-col gap-10 bg-gray-200 '>
                <section className="md:w-2/3">
                    <ContactsForm restricted={true}  label={`Edit Profile (${selected_contact?.code ?? ''})`} DefaultData={selected_contact} social_types={social_types ?? null} onSubmit={handleUpdateContact} />

                </section>
            </section>
        </div >
    );
}
