import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import Table from '../../Components/TableLayout/Table';
import { router } from "@inertiajs/react";


//table layout
import TableHead from '../../Components/TableLayout/TableHead'
import TableRow from '../../Components/TableLayout/TableRow'
import TableColumn from '../../Components/TableLayout/TableColumn'
import SocialTypesForm from '../../Components/Forms/SocialTypesForm';
import MobileBar from '../../Components/MobileBar';

import { TablePagination } from '@mui/material';
import TableDropdownMenuItem from '../../Components/TableLayout/TableDropdownMenuItem';
import TableDropdownActions from '../../Components/TableLayout/TableDropdownActions';

import { useSelector } from 'react-redux';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';

export default function Index({ social_types, messages }) {

    useHandleToastMessages(messages);

    //state variables
    const [currentPage, setCurrentPage] = useState(0)
    const [rowsPerPage, setRowsPerPage] = useState(25);

    const roles = useSelector(state => state.user.roles);

    const handleAddSocialType = (data) => {

        router.post('/admin/social-links', data)
    }

    return (
        <div className='md:flex bg-gray-200'>
            <MobileBar />
            <SideBar />
            <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
                <section className="md:w-1/2">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Social Types</h1>

                    <h3 class="font-semibold text-[12px] md:text-[16px] max-md:text-justify text-gray-500">This process involves setting up different social platforms as predefined options, making it easier to categorize and manage social links efficiently.</h3>

                    <SocialTypesForm onSubmit={handleAddSocialType} />

                </section>

                <section className="md:w-1/2 max-w-[100%] overflow-auto">
                    <Table headers={["", "Type", "Icon", "Base_Url", "End_Url"]}>
                        {social_types?.slice(currentPage * rowsPerPage, (currentPage + 1) * rowsPerPage)?.map(social_type => {
                            return (
                                <TableRow key={social_type.id}>
                                    {roles?.socialE || roles.socialD ?
                                        <TableDropdownActions>
                                            {roles?.socialE ?
                                                <TableDropdownMenuItem>
                                                    <div onClick={() => { router.get(`/admin/social-links/${social_type.id}/edit`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit</div>
                                                </TableDropdownMenuItem>
                                                : ''}
                                            {roles?.socialD ?
                                                <TableDropdownMenuItem>
                                                    <div onClick={() => { router.delete(`/admin/social-links/${social_type.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div>
                                                </TableDropdownMenuItem>
                                                : ''}

                                        </TableDropdownActions>
                                        : <TableColumn></TableColumn>}
                                    <TableColumn>{social_type.type ?? ''}</TableColumn>
                                    <TableColumn>
                                        <div style={{ backgroundColor: social_type?.color ?? '#000000' }} class="text-white col-auto fill-white p-1 shadow-lg rounded-full flex items-center justify-center h-7 w-7" dangerouslySetInnerHTML={{ __html: social_type?.icon ?? '' }}
                                        >

                                        </div>
                                    </TableColumn>
                                    <TableColumn>{social_type.base_url ?? ''}</TableColumn>
                                    <TableColumn>{social_type.end_url ?? ''}</TableColumn>

                                </TableRow>
                            )
                        })}

                    </Table>
                    <TablePagination

                        component="div"
                        count={social_types?.length ?? 0}
                        page={currentPage}
                        onPageChange={(event, newPage) => { setCurrentPage(newPage) }}
                        rowsPerPage={rowsPerPage}
                        onRowsPerPageChange={(event) => { setRowsPerPage(parseInt(event.target.value, 10)); setCurrentPage(0) }}
                    />
                </section>
            </section>
        </div >
    );
}
