import React, { useState,useRef } from 'react'
import SideBar from '../../Components/SideBar'
import MobileBar from '../../Components/MobileBar';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';
import DashboardCard from '../../Components/Dashboard/DashboardCard';

import Table from '../../Components/TableLayout/Table';
import TableRow from '../../Components/TableLayout/TableRow';
import TableColumn from '../../Components/TableLayout/TableColumn';

import { useSelector } from 'react-redux';

import Button from '../../Components/Button';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faPlus, faSpinner } from '@fortawesome/free-solid-svg-icons';
import BasicModal from '../../Components/BasicModal';
import Input from '../../Components/Input';
import { Link, router } from '@inertiajs/react';

export default function Index({ messages, templates}) {
    useHandleToastMessages(messages);

    const [isModalOpen,setIsModalOpen] = useState(false);
    const [edit, setEdit] = useState({
        modalOpened: false,
        selectedTemplate : null
    });
    const [loading,setLoading] = useState(false)

    const openEditModal = (template) => {
        setEdit({modalOpened:true,selectedTemplate:template})
    }

    const promptRef= useRef(null);
    const pagesRef = useRef(null);
    const selectedTemplateRef = useRef(null)

    const roles = useSelector(state => state.user.roles)
    
    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
                <section className="w-full">
                    <h1 className="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900 flex items-center gap-5">Templates {roles?.templatesA ? <Button onClick={() => { setIsModalOpen(true) }} className='bg-gray-900 rounded-[12px] max-w-fit text-[12px]  py-1.5 h-fit flex gap-2 items-center'>Generate Template<FontAwesomeIcon icon={faPlus} ></FontAwesomeIcon></Button> : ''}</h1>
                    <BasicModal onBackdropClick={()=>{setIsModalOpen(false)}} open={isModalOpen} title="Generate Template">
                        <section className='mt-10'>
                            <Input label={'Prompt'} ref={promptRef} placeholder={'Enter Your Prompt'} className="w-full mb-5"></Input>
                            <Input label={'Pages (Comma Separated)'} ref={pagesRef} placeholder={'Pages (Comma Separated)'} className="w-full mb-5"></Input>
                            <Button disabled={loading} onClick={() => {
                                setLoading(true);
                                router.post('/admin/templates', { prompt: promptRef.current.value, pages: pagesRef.current.value });
                                
                            }} className='bg-gray-900 hover:bg-[#000000]'>{loading ? <section className="flex items-center justify-center gap-2" >Please Wait <FontAwesomeIcon className='animate-spin' icon={faSpinner}> </FontAwesomeIcon></section> : 'Generate'}</Button>
                        </section>
                    </BasicModal>
                    <BasicModal onBackdropClick={() => { setEdit(prevState => {return({modalOpened:false , selectedTemplate: null})}) }} open={edit.modalOpened} title={`Edit Template (${edit?.selectedTemplate?.title})`}>
                        <section className='mt-10'>
                            <Input label={'Template Name'} ref={selectedTemplateRef} placeholder={'Template Name'} className="w-full mb-5"></Input>
                            <Button disabled={loading} onClick={() => {
                                setLoading(true);
                                router.post(`/admin/templates/${edit?.selectedTemplate?.id ?? null}/quickEdit`, { title: selectedTemplateRef.current.value});

                            }} className='bg-gray-900 hover:bg-[#000000]'>{loading ? <section className="flex items-center justify-center gap-2" >Please Wait <FontAwesomeIcon className='animate-spin' icon={faSpinner}> </FontAwesomeIcon></section> : 'Edit'}</Button>
                        </section>
                    </BasicModal>

                    <section className='w-fit overflow-auto'>
                        <Table className={'min-w-[300px]'} headers={["Title", "Actions"]}>

                            {templates?.map(template => {
                                return (
                                    <TableRow key={template?.id}>
                                        <TableColumn>{template?.title ?? ''}</TableColumn>
                                        <TableColumn>
                                            <section className='flex gap-5'>
                                                {roles?.templatesD == true ? <div onClick={() => { router.delete(`/admin/templates/${template?.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div> : ''}
                                                {roles?.templatesE == true ? <div onClick={()=>{openEditModal(template)}} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Quick Edit</div> : ''}
                                                {roles?.templatesE == true ? <Link href={`/admin/templates/${template?.id}`} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit With Editor</Link> : ''}
                                            </section>
                                        </TableColumn>


                                    </TableRow>
                                )
                            })}

                        </Table>
                    </section>

                </section>

            </section>
        </div >
    );
}
