import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import Table from '../../Components/TableLayout/Table';
import { router } from "@inertiajs/react";


//table layout
import TableHead from '../../Components/TableLayout/TableHead'
import TableRow from '../../Components/TableLayout/TableRow'
import TableColumn from '../../Components/TableLayout/TableColumn'
import SocialTypesForm from '../../Components/Forms/SocialTypesForm';
import MobileBar from '../../Components/MobileBar';

import { TablePagination } from '@mui/material';
import TableDropdownMenuItem from '../../Components/TableLayout/TableDropdownMenuItem';
import TableDropdownActions from '../../Components/TableLayout/TableDropdownActions';
import UsersForm from '../../Components/Forms/UsersForm';

import { useSelector } from 'react-redux';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';

export default function Index({ users, messages,profiles }) {
    useHandleToastMessages(messages)

    //state variables
    const [currentPage, setCurrentPage] = useState(0)
    const [rowsPerPage, setRowsPerPage] = useState(25);

    const handleAddUser = (data) => {

        router.post('/admin/users', data)
    }

    const roles = useSelector(state => state.user.roles)

    return (
        <div className='md:flex bg-gray-200'>
            <MobileBar />
            <SideBar />
            <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
                <section className="md:w-2/3">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Users</h1>

                    <h3 class="font-semibold text-[12px] md:text-[16px] max-md:text-justify text-gray-500">Users are individuals who have access to the system with specific roles and permissions. Adding users allows administrators to manage access and ensure proper functionality.</h3>

                    <UsersForm profiles={profiles} onSubmit={handleAddUser} />

                </section>

                <section className="md:w-1/3 max-w-[100%] overflow-auto">
                    <Table headers={["", "Email", "Name"]}>
                        {users?.slice(currentPage * rowsPerPage, (currentPage + 1) * rowsPerPage)?.map(user => {
                            return (
                                <TableRow key={user.id}>
                                    {roles?.usersE || roles.userD ?
                                        <TableDropdownActions>{roles?.usersE ?
                                            <TableDropdownMenuItem>
                                                <div onClick={() => { router.get(`/admin/users/${user.id}/edit`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit</div>
                                            </TableDropdownMenuItem>
                                            : ''}
                                            {roles?.usersD ?
                                                <TableDropdownMenuItem>
                                                    <div onClick={() => { router.delete(`/admin/users/${user.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div>
                                                </TableDropdownMenuItem>
                                                : ''}

                                        </TableDropdownActions>
                                        : <TableColumn></TableColumn>}
                                    <TableColumn className={'font-semibold'}>{user?.email ?? ''}</TableColumn>
                                    <TableColumn >{user?.name ?? ''}</TableColumn>

                                </TableRow>
                            )
                        })}

                    </Table>
                    <TablePagination

                        component="div"
                        count={users?.length ?? 0}
                        page={currentPage}
                        onPageChange={(event, newPage) => { setCurrentPage(newPage) }}
                        rowsPerPage={rowsPerPage}
                        onRowsPerPageChange={(event) => { setRowsPerPage(parseInt(event.target.value, 10)); setCurrentPage(0) }}
                    />
                </section>
            </section>
        </div >
    );
}
