import { createInertiaApp } from '@inertiajs/react'
import { createRoot } from 'react-dom/client'
import React from 'react';

import { Provider } from 'react-redux';
import { PersistGate } from 'redux-persist/integration/react';
import store,{persistor} from './store/store';

import { ToastContainer } from 'react-toastify';



createInertiaApp({
  resolve: name => {
    const pages = import.meta.glob('./Pages/**/*.jsx', { eager: true })
    return pages[`./Pages/${name}.jsx`]
  },
  setup({ el, App, props }) {

    createRoot(el).render(

      <Provider store={store}>
        <PersistGate loading={null} persistor={persistor}>
          <ToastContainer/>
          <App {...props} />
        </PersistGate >
      </Provider >

    );
  },
})