import { createSlice } from '@reduxjs/toolkit';

const sidebarSlice = createSlice({
    name: 'global',
    initialState: { email: '' },
    reducers: {
        setData: (state, action) => {
            state.email = action.payload.email ?? state.email;
        }
    },
});

export const { setSidebarVisibility, toggleSidebarVisibility } = sidebarSlice.actions;
export default sidebarSlice.reducer;