import { createSlice } from '@reduxjs/toolkit';

const sidebarSlice = createSlice({
    name: 'sidebar',
    initialState: { visibility: true },
    reducers: {
        setSidebarVisibility: (state, actions) => { state.visibility = actions.visibility; },
        toggleSidebarVisibility: (state) => { state.visibility = !state.visibility }
    },
});

export const { setSidebarVisibility,toggleSidebarVisibility} = sidebarSlice.actions;
export default sidebarSlice.reducer;