
import { createSlice } from "@reduxjs/toolkit";

const initialState = {
    email: '',
    roles: {
        contactsF: false,
        contactsA: false,
        contactsE: false,
        contactsD: false,
        contactsP: false,
        socialF: false,
        socialA: false,
        socialE: false,
        socialD: false,
        settingsF: false,
        settingsE: false,
        usersF: false,
        usersA: false,
        usersE: false,
        usersD: false,
        pageF:false,
        pageA:false,
        pageE:false,
        pageD:false,
        pageP:false,
        menuF:false,
        menuA:false,
        menuE:false,
        menuD:false,
        footerF:false,
        headerF:false,
        headerE:false,
        languagesF:false,
        languagesE:false,
        languagesA:false,
        languagesD:false,
        templatesF:false,
        templatesA:false,
        templatesE:false,
        templatesD:false,
        dashboard:false,
        backup:false
    },

};

const user = createSlice({
    name: "user",
    initialState,
    reducers: {
        updateUser: (state, action) => {
            const {
                contactsF,
                contactsA,
                contactsE,
                contactsD,
                contactsP,
                socialF,
                socialA,
                socialE,
                socialD,
                settingsF,
                settingsE,
                usersF,
                usersA,
                usersE,
                usersD,
                dashboard,
                pageF,
                pageA,
                pageE,
                pageD,
                pageP,
                menuF,
                menuA,
                menuE,
                menuD,
                footerF,
                headerF,
                headerE,
                languagesF,
                languagesE,
                languagesA,
                languagesD,
                templatesF,
                templatesA,
                templatesE,
                templatesD,
                backup
            } = action.payload.roles;

            const email = action.payload.email;

            // Update state directly with action payload values
            state.email = email;

            state.roles.backup = backup
            state.roles.contactsF = contactsF
            state.roles.contactsA = contactsA
            state.roles.contactsE = contactsE
            state.roles.contactsD = contactsD
            state.roles.contactsP = contactsP
            state.roles.socialF = socialF
            state.roles.socialA = socialA
            state.roles.socialE = socialE
            state.roles.socialD = socialD
            state.roles.settingsF = settingsF
            state.roles.settingsE = settingsE
            state.roles.usersF = usersF
            state.roles.usersA = usersA
            state.roles.usersE = usersE
            state.roles.usersD = usersD
            state.roles.dashboard = dashboard
            state.roles.pageF = pageF
            state.roles.pageA = pageA
            state.roles.pageE = pageE
            state.roles.pageD = pageD
            state.roles.pageP = pageP
            state.roles.menuF = menuF
            state.roles.menuA = menuA
            state.roles.menuE = menuE
            state.roles.menuD = menuD
            state.roles.footerF = footerF
            state.roles.headerF = headerF
            state.roles.headerE = headerE
            state.roles.languagesF = languagesF
            state.roles.languagesE = languagesE
            state.roles.languagesA = languagesA
            state.roles.languagesD = languagesD;
            state.roles.templatesF = templatesF
            state.roles.templatesA = templatesA
            state.roles.templatesE = templatesE
            state.roles.templatesD = templatesD
        },
    },
});

export const { updateUser } = user.actions;
export default user.reducer;

