<?php

use App\Http\Controllers\AssetsController;
use App\Http\Controllers\FooterController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\PagesController;
use App\Http\Controllers\TemplateController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

use App\Http\Controllers\HeaderController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\AppController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SocialTypeController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\UsersController;

use Illuminate\Support\Facades\Storage;
use Spatie\DbDumper\Databases\MySql;
use Symfony\Component\HttpFoundation\StreamedResponse;



Route::get('/admin',  [AuthController::class, 'Index'])->name('login');
Route::post('/admin/login',  [AuthController::class, 'Login']);

Route::get('/password-forget', [AuthController::class, 'ForgetPasswordIndex'])->name('password.request');
Route::post('/password-forget', [AuthController::class, 'ForgetPasswordSendMail'])->name('password.email');
Route::get('/reset-password/{token}', [AuthController::class, 'ResetPasswordIndex'])->name('password.reset');
Route::post('/password-reset', [AuthController::class, 'ResetPassword'])->name('password.update');

/*Route::middleware("auth")->group(function () {
   Route::get('/',  [HomeController::class, 'Index'])->name('home');
});*/
Route::prefix('admin')->middleware('auth')->group(function () {

   Route::get('/backup/download', function () {
      $appName = config('app.name');

      // Backup folder
      $backupPath = storage_path("app/private/{$appName}");
      if (!file_exists($backupPath)) {
         mkdir($backupPath, 0777, true);
      }

      $fileName = "{$backupPath}/backup.sql";

      // Dump database
      MySql::create()
         ->setDbName(env('DB_DATABASE'))
         ->setUserName(env('DB_USERNAME'))
         ->setPassword(env('DB_PASSWORD'))
         // Force host to '127.0.0.1' to avoid socket issues
         ->setHost('127.0.0.1')
         ->setDumpBinaryPath(env('DB_DUMP_PATH', ''))
         ->setPort(env('DB_PORT', 3306))
         ->dumpToFile($fileName);

      return response()->download($fileName);
   });


   Route::post('/logout', [AuthController::class, 'Logout'])->name('logout');
   
    Route::get('/dashboard', [DashboardController::class, 'Index'])->name('dashboard');
   Route::get('/page-builder', [PagesController::class, 'PageBuilder'])->name('pagebuilder');


   Route::post('/assets', [AssetsController::class, 'Store'])->name('assets.store');


   Route::get('/users/roles', [UsersController::class, 'GetRoles'])->name('GetRoles');

   Route::get('/settings', [SettingsController::class, 'Index'])->name('settings.index')->middleware('CheckPermission:settingsF');
   Route::post('/settings', [SettingsController::class, 'Store'])->name('settings.store')->middleware('CheckPermission:settingsE');

   Route::resource('/users', UsersController::class)->middleware('CheckPermission:usersF');

   Route::put('/pages/{id}/quickUpdate', [PagesController::class, 'quickUpdate'])->name('pages.quickUpdate')->middleware('CheckPermission:pageE');;
   Route::resource('/pages', PagesController::class)->middleware('CheckPermission:pageF');
   ;;
   Route::get('/pages/{id}/duplicate', [PagesController::class, 'duplicate'])->name('pages.duplicate')->middleware('CheckPermission:pageA');;

   Route::get('/header', [HeaderController::class, 'Index'])->name('header.index')->middleware('CheckPermission:headerF');
   Route::post('/header', [HeaderController::class, 'Store'])->name('header.store')->middleware('CheckPermission:headerE');;

   Route::get('/footer', [FooterController::class, 'Index'])->name('footer.index')->middleware('CheckPermission:footerF');
   Route::post('/footer', [FooterController::class, 'Store'])->name('footer.store')->middleware('CheckPermission:footerF');

   Route::resource('/menus', MenuController::class)->middleware('CheckPermission:menuF');;
   Route::resource('/languages', LanguageController::class)->middleware('CheckPermission:languagesF');

   Route::resource('/templates', TemplateController::class)->middleware('CheckPermission:templatesF');
   Route::post('/templates/{id}/quickEdit', [TemplateController::class, 'quickUpdate'])->name('templates.quickUpdate')->middleware('CheckPermission:templatesE');
   

   Route::resource('/social-links', SocialTypeController::class)->middleware('CheckPermission:socialF');;

   Route::get('/profiles', [AppController::class, 'Profiles'])->name('profiles.index');
   Route::get('/profiles/{id}/edit', [AppController::class, 'EditProfile'])->name('profiles.edit');


   Route::resource('/contacts', AppController::class)->middleware('CheckPermission:contactsF');
    Route::get('/contacts/{id}/duplicate', [AppController::class, 'duplicate'])->name('contacts.duplicate')->middleware('CheckPermission:contactsF');
   Route::get('/contacts/{id}/toggle-publish', [AppController::class, 'togglePublish'])->name('contacts.togglePublish')->middleware('CheckPermission:contactsP');
   


   //Route::get('/social-links/{id}/delete', [SocialTypeController::class, 'destroy'])->name('social-links.delete')->middleware('auth');
   Route::post('/contacts/{id}', [AppController::class, 'update'])->name('contacts.update');

});

Route::get('/{first?}/{second?}', [PagesController::class, 'showPage']);

Route::get('/{code}',  [AppController::class, 'showApp'])->name('App');
Route::get('/{code}/vcard',  [AppController::class, 'generateVCard'])->name('VCard');

Route::fallback(function () {
   return Inertia::render('Fallback');
});