import { defineConfig } from 'vite';
import tailwindcss from '@tailwindcss/vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
  plugins: [
    laravel({
      input: ['resources/css/app.css', 'resources/js/app.jsx'],
      refresh: true,
    })
  ],
  css: {
    postcss: './postcss.config.js',
  },
  /*server: {
    host: '192.168.1.119',
    port: 5137,
    strictPort: true,
    https: false,
    cors: {
      origin: '*',
    },
  },*/
  optimizeDeps: {
    include: ['@measured/puck','@grapesjs/studio-sdk'], // <- ADD HERE
  },
});
