<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class AssetsController extends Controller
{
    public function Store(Request $request)
    {
        $validated = $request->validate([
            'files.*' => 'required|file|mimes:jpg,jpeg,png,gif,svg,webp|max:2048', // Validate each file in the array
        ]);


        $fileResponse = [];

        foreach ($validated['files'] as $file) {
            
            // Process each file
            if (!$file->isValid()) {
                return response()->json(['error' => 'Invalid file upload'], 422);
            }


            $fileName = time() . '_' . $file->getClientOriginalName(); // Generate a unique file name
            $filePath = $file->storeAs('assets', $fileName, 'public'); // Store the file in the 'public/assets' directory
            if (env('APP_ENV') == 'local') {
                $fileResponse[] = ['src' => "/storage/assets/$fileName"]; // Return the path for local environment
            } else {
                $fileResponse[] = ['src' => "/storage/app/public/assets/$fileName"]; // Return the full URL for production
            }
        }


        return response()->json(['files' => $fileResponse]);
    }
}
