<?php

namespace App\Http\Controllers;

use App\Models\Header;
use App\Models\Language;
use App\Models\MenuItem;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Menu;

class HeaderController extends Controller
{
    public function Index()
    {
        $menus = Menu::all();
        $header = Header::with('menu.children',"menus.language",'menus.menu')->first();
        $languages = Language::where('status', 1)->get();

        $messages = [
            'errors' => session('errors'),
            'message' => session('message'),
            'success' => session('success'),
        ];


        return Inertia::render('Header/Index')->with([
            'menus' => $menus,
            'header' => $header,
            'languages' => $languages,
            'messages' => $messages,
        ]);
    }

    

    public function Store(Request $request){
        try {
            $validated = request()->validate([
                'menu_id' => 'required|exists:menus,id',
                'menus' => 'nullable|array',
                'text_color' => 'nullable|string|max:7', // Hex color code
                'bg_color' => 'nullable|string|max:7', // Hex color code
                'sub_text_color' => 'nullable|string|max:7', // Hex color code
                'sub_bg_color' => 'nullable|string|max:7', // Hex color code
                'secondary_color' => 'nullable|string|max:7', // Hex color code
                'sub_secondary_color' => 'nullable|string|max:7', // Hex color code
            ]);

            $header = Header::first();

            if (!$header) {
                $header = new Header();
            }
            $header->menu_id = $validated['menu_id'];

            
            if ($request->hasFile('logo')) {
                // Handle file upload
                $fileName = time() . '_' . $request->file('logo')->getClientOriginalName(); // Generate a unique file name
                $filePath = $request->file('logo')->storeAs('assets', $fileName, 'public'); // Store the file in the 'public/assets' directory

                if (env('APP_ENV') == 'local') {
                    $header->logo = "/storage/assets/$fileName";
                } else {
                    $header->logo = "/storage/app/public/assets/$fileName";
                }
            } else {
                $header->logo = $request->get('logo') ?? '';
            }


            if ($request->hasFile('mobile_logo')) {
                // Handle file upload
                $fileName = time() . '_' . $request->file('mobile_logo')->getClientOriginalName(); // Generate a unique file name
                $filePath = $request->file('mobile_logo')->storeAs('assets', $fileName, 'public'); // Store the file in the 'public/assets' directory

                if (env('APP_ENV') == 'local') {
                    $header->mobile_logo = "/storage/assets/$fileName";
                } else {
                    $header->mobile_logo = "/storage/app/public/assets/$fileName";
                }
            } else {
                $header->mobile_logo = $request->get('logo') ?? '';
            }

            foreach($header->menus as $menu) {
                $menu->delete();
            }

            foreach($validated['menus'] as $menu) {
                $header->menus()->create([
                    'menu_id' => $menu['menu']['id'] ?? null,
                    'header_id' => $header['id'] ?? null,
                    'lang_id' => $menu['language']['id'] ?? null,
                ]);
            }

            $header->text_color = $validated['text_color'] ?? '#FFFFFF';
            $header->bg_color = $validated['bg_color'] ?? '#FFFFFF';
            $header->bg_color = $validated['bg_color'] ?? '#FFFFFF';
            $header->sub_text_color = $validated['sub_text_color'] ?? '#FFFFFF';
            $header->sub_bg_color = $validated['sub_bg_color'] ?? '#FFFFFF';
            $header->secondary_color = $validated['secondary_color'] ?? '#FFFFFF';
            $header->sub_secondary_color = $validated['sub_secondary_color'] ?? '#FFFFFF';

            $header->save();

            session()->flash('success', 'Header updated successfully!');

            return Inertia::location('/admin/dashboard');
        
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'An error occurred while updating the page.',
                'message' => $e->getMessage()
            ], 500);        }
    }
}
