<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Exception;
use Illuminate\Http\Request;
use Inertia\Inertia;

class UnderConstructionController extends Controller
{
    public function PageBuilder(Request $request)
    {

        $page = Page::where('status', 1)->where('type', 'under-construction')->first();
        $grape_key = env('VITE_GRAPESJS_LICENSE_KEY', null);

        if (!$page) {
            $page = new Page();
            $page->component = '<h1>Under Construction<h1>';
            $page->styles = '';
            $page->type = 'under-construction';
            $page->title = 'Under Construction';
        }

        return Inertia::render('PageBuilder', ['page' => $page, 'grape_key' => $grape_key]);



    }

    public function update(Request $request)
    {
        try {
            $validated = $request->validate([
                'title' => 'required|string|max:255',
                'component' => 'nullable|string',
                'styles' => 'nullable|string',
            ]);

            $page = Page::where('type', 'under-construction')->first();

            if (!$page) {
                $page = new Page();
                $page->type = 'under-construction';
            }

            $page->title = 'Under Construction';

            $page->component = $validated['component'] ?? '';
            $page->styles = $validated['styles'] ?? '';
            $page->published = true;

            $page->save();

            return response()->json([
                'message' => 'Page updated successfully!',
                'redirect' => route('dashboard')
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'error' => 'An error occurred while updating the page.',
                'message' => $e->getMessage()
            ], 500);
        }

    }

}
