<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    public function items()
    {
        return $this->hasMany(MenuItem::class)->orderBy('parent_id')->orderBy('order');
    }

    public function children(){
        return $this->hasMany(MenuItem::class)
            ->where('parent_id', null)
            ->with('page')
            ->with('children.page')
            ->orderBy('order');
    }

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
    
}
